local STRINGS = GLOBAL.STRINGS
local SW_INSTALLED = GLOBAL.rawget(GLOBAL, "CAPY_DLC") and GLOBAL.IsDLCInstalled(GLOBAL.CAPY_DLC)
local SW_ENABLED = GLOBAL.rawget(GLOBAL, "CAPY_DLC") and GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC)

PrefabFiles = 
{
	"bunny_queen",
	"bunny_chest",
}

Assets = 
{
	Asset("ATLAS", "images/bunny_queen.xml"),	
}

AddMinimapAtlas("images/bunny_queen.xml")

GLOBAL.TUNING.BONUSCHANCE = 3

if GetModConfigData("Gem Chance") == "0" then
	GLOBAL.TUNING.GEMCHANCE = 0
end

if GetModConfigData("Gem Chance") == "default" then
	GLOBAL.TUNING.GEMCHANCE = 5
end

if GetModConfigData("Gem Chance") == "10" then
	GLOBAL.TUNING.GEMCHANCE = 10
end

if GetModConfigData("Gem Chance") == "15" then
	GLOBAL.TUNING.GEMCHANCE = 15
end

if GetModConfigData("Gem Chance") == "20" then
	GLOBAL.TUNING.GEMCHANCE = 20
end

if GetModConfigData("Gem Chance") == "25" then
	GLOBAL.TUNING.GEMCHANCE = 25
end

STRINGS.NAMES.BUNNY_QUEEN = "Bunny Queen"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BUNNY_QUEEN = "Her Royal Majesty, the Queen of Bunnies!"

STRINGS.NAMES.BUNNY_CHEST = "Chest"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BUNNY_CHEST = "Treasures of her Royal Majesty the Queen of Bunnies!"

function TraderPostInit(inst)
	inst.gemvalue = 0
end

function TradablePostInit(inst)
	inst.gemvalue = 0
end

AddComponentPostInit("trader", TraderPostInit)
AddComponentPostInit("tradable", TradablePostInit)


local cooked_common = 
{
	"butterflymuffin",
	"stuffedeggplant",
	"ratatouille",
	"jammypreserves",
	"fruitmedley",
	"icecream",
	"watermelonicle",
}

local coocked_rare = 
{
	"flowersalad",
	"trailmix",
	"powcake",
	"taffy",
	"pumpkincookie",
	"waffles",
	"dragonpie",
	"mandrakesoup",
}

function cooked_common_fn(inst)
	inst.components.tradable.gemvalue = 3
end

function cooked_rare_fn(inst)
	inst.components.tradable.gemvalue = 4
end

for i,v in ipairs(cooked_common) do AddPrefabPostInit(v, cooked_common_fn) end
for i,v in ipairs(coocked_rare) do AddPrefabPostInit(v, cooked_rare_fn) end


if SW_INSTALLED and SW_ENABLED then	
	local sw_cooked = 
	{	
		"bananapop",
		"coffee",
	}
	
	for i,v in ipairs(sw_cooked) do AddPrefabPostInit(v, cooked_rare_fn) end
end