GLOBAL.require("map/level")
GLOBAL.require("constants")
local GROUND = GLOBAL.GROUND
local Layouts = GLOBAL.require("map/layouts").Layouts
local StaticLayout = GLOBAL.require("map/static_layout")
GLOBAL.require("map/lockandkey")
local LOCKS = GLOBAL.LOCKS
local KEYS = GLOBAL.KEYS
 
Layouts["bunny_queen_layout"] = StaticLayout.Get("map/static_layouts/bunny_queen_layout")
 
AddRoom("RabbitQueenCity", {
					colour={r=0.1,g=.7,b=.2,a=.50},
					value = GROUND.FUNGUS,
					contents =  {
									countstaticlayouts=
									{
										["bunny_queen_layout"] = 1,
									},
									 countprefabs = {
					                    rabbithouse = 5,
										flower_cave = 3,
					                }
					            }
					})
					
AddTask("FungalRabitQueenCityPlain", {
		locks={LOCKS.LIGHT},
		keys_given=KEYS.NONE,
		room_choices={
			["RabbitQueenCity"] = 1,
		},
		room_bg=GROUND.FUNGUS,
		background_room="BGFungusRoom",
		colour={r=0.2,g=0,b=0.6,a=1},
	})

local function CaveLevelInit(level)
	table.insert(level.tasks, "FungalRabitQueenCityPlain")
	if level.ordered_story_setpieces == nil then
		level.ordered_story_setpieces = {}
	end
	if level.required_prefabs == nil then
		level.required_prefabs = {}
	end
	table.insert(level.ordered_story_setpieces, "bunny_queen_layout")
	table.insert(level.required_prefabs, "bunny_queen")
end

AddLevelPreInit("CAVE_LEVEL_1", CaveLevelInit)