local assets=
{
	Asset("ANIM", "anim/pandoras_chest.zip"),
}

local prefabs =
{
	"collapse_small",
}

local function onopen(inst) 
	if not inst:HasTag("burnt") then
		inst.AnimState:PlayAnimation("open")
		inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")
	end
end

local function onclose(inst)
	if not inst:HasTag("burnt") then
		inst.AnimState:PlayAnimation("close")
		inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")
		
		if not inst.components.container:IsEmpty() then
			inst.AnimState:PushAnimation("closed", true)
			return
		else
			inst.AnimState:PlayAnimation("hit")
	
			SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
			inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	
			inst:ListenForEvent("animqueueover", function (inst)
				inst:Remove()
			end)
		end
	end
end

local slotpos = {}

for y = 2, 0, -1 do
	for x = 0, 2 do
		table.insert(slotpos, Vector3(80*x-80*2+80, 80*y-80*2+80,0))
	end
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
	inst:AddTag("structure")
	inst:AddTag("chest")
	inst.AnimState:SetBank("pandoras_chest")
	inst.AnimState:SetBuild("pandoras_chest")
	inst.AnimState:PlayAnimation("closed", true)
	
	inst:AddComponent("inspectable")
	inst:AddComponent("container")
	inst.components.container:SetNumSlots(#slotpos)
		
	inst.components.container.onopenfn = onopen
	inst.components.container.onclosefn = onclose
		
	inst.components.container.widgetslotpos = slotpos
	inst.components.container.widgetanimbank = "ui_chest_3x3"
	inst.components.container.widgetanimbuild = "ui_chest_3x3"
	inst.components.container.widgetpos = Vector3(0,200,0)
	inst.components.container.side_align_tip = 160
	
	MakeInventoryPhysics(inst)
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.canbepickedup = false
	inst.components.inventoryitem.cangoincontainer = false
	inst.components.inventoryitem.nobounce = true
	
	return inst
end

return Prefab("common/objects/bunny_chest", fn, assets, prefabs)