local assets=
{
	Asset("ANIM", "anim/Bunny_Queen.zip"),
	Asset("SOUND", "sound/pig.fsb"),
	Asset("SOUND", "sound/bunnyman.fsb"),
}

local prefabs = 
{
	"thulecite_pieces",
	"bluegem",
	"redgem",
	"purplegem",
	"yellowgem",
	"greengem",
	"orangegem",
	"goldnugget",
	"marble",
	"nitre",
	"slurtle_shellpieces",
	"slurtleslime",
	"lightbulb",
	"foliage",
	"armorsnurtleshell",
	"slurtlehat",
}

local chestloot = 
{
	butterflymuffin = "purplegem",
	stuffedeggplant = "purplegem",
	ratatouille = "redgem",
	jammypreserves = "redgem",
	fruitmedley = "redgem",
	icecream = "bluegem",
	watermelonicle = "bluegem",
	flowersalad = "greemgem",
	trailmix = "greengem",
	powcake = "yellowgem",
	taffy = "orangegem",
	pumpkincookie = "orangegem",
	waffles = "yellowgem",
	dragonpie = "orangegem",
	mandrakesoup = "yellowgem",
	bananapop = "yellowgem",
	coffee = "greengem",
}

local randomloot = 
{
	"goldnugget",
	"marble",
	"nitre",
	"slurtle_shellpieces",
	"slurtleslime",
	"lightbulb",
	"foliage",
}

local bonus_reward = 
{
	"armorsnurtleshell",
	"slurtlehat",
}

local function StartTrading(inst)
	if not inst.components.trader.enabled then
		inst.components.trader:Enable()
		inst.AnimState:PlayAnimation("sleep_pst_90s")
		inst.AnimState:PushAnimation("idle_90s", true)

		inst:RemoveEventCallback("animover", inst.sleepfn)
	end
end

local function FinishedTrading(inst)
	inst.components.trader:Disable()
	inst.AnimState:PlayAnimation("sleep_pre_90s")
  
	if inst.sleepfn then
		inst:RemoveEventCallback("animover", inst.sleepfn)
	end
	
	inst.sleepfn = function(inst)
        inst.AnimState:PushAnimation("sleep_loop_90s")  
	end

	inst:ListenForEvent("animover", inst.sleepfn)
end

local function OnGetItemFromPlayer(inst, giver, item)
	inst.components.trader:Disable()
    if item.components.tradable.gemvalue > 0 then
		inst.SoundEmitter:PlaySound("dontstarve/creatures/bunnyman/eat")
        inst.AnimState:PlayAnimation("happy_90s")
        inst.AnimState:PushAnimation("idle_90s", true)
		
        inst:DoTaskInTime(20/30, function(inst) 
            inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingThrowGold")
			local down = TheCamera:GetDownVec()
			local angle = math.atan2(down.z, down.x) + (math.random()*60-30)*DEGREES
			local sp = math.random()*4+2	
			local chest = SpawnPrefab("bunny_chest")
			local pt = Vector3(inst.Transform:GetWorldPosition()) + Vector3(0,4.5,0)
			chest.Transform:SetPosition(pt:Get())
			chest.Physics:SetVel(sp*math.cos(angle), math.random()*2+8, sp*math.sin(angle))
			
			if math.random(100) <= TUNING.GEMCHANCE then
				if chestloot[item.prefab] then
					local goodreward = SpawnPrefab(chestloot[item.prefab])
					chest.components.container:GiveItem(goodreward, nil, nil, true, false)
				end
			end
			
			local thulecite_pieces = math.random(2,4)
			for i = 1, thulecite_pieces do
				local loot = SpawnPrefab("thulecite_pieces")
				chest.components.container:GiveItem(loot, nil, nil, true, false)
			end
			
			if item.components.tradable.gemvalue == 4 then
				for i = 1, 6 do
					local loot = SpawnPrefab(randomloot[math.random(1, #randomloot)])
					chest.components.container:GiveItem(loot, nil, nil, true, false)
				end
				
				if math.random(100) <= TUNING.BONUSCHANCE then
					local bonus = SpawnPrefab(bonus_reward[math.random(1, #bonus_reward)])
					chest.components.container:GiveItem(bonus, nil, nil, true, false)
				end		
			else
				for i = 1, 4 do
					local loot = SpawnPrefab(randomloot[math.random(1, #randomloot)])
					chest.components.container:GiveItem(loot, nil, nil, true, false)
				end
			end
			
		end)
		
        inst:DoTaskInTime(0.9, function() 
            inst.SoundEmitter:PlaySound("dontstarve/creatures/bunnyman/happy")
        end)
		
        inst.happy = true
        if inst.endhappytask then
            inst.endhappytask:Cancel()
        end
		
        inst.endhappytask = inst:DoTaskInTime(5, function()
            inst.happy = false
            inst.endhappytask = nil
			FinishedTrading(inst)
        end)
		
    end
end

local function OnRefuseItem(inst, giver, item)
	inst.SoundEmitter:PlaySound("dontstarve/creatures/bunnyman/angry_idle")
    inst.AnimState:PlayAnimation("unimpressed_90s")
	inst.AnimState:PushAnimation("idle_90s", true)
	inst.happy = false
end

local function OnLoad(inst,data)
	if not inst.components.trader.enabled then
		FinishedTrading(inst)
	end
end

local function fn(Sim)
    
	local inst = CreateEntity()
	
	inst.OnLoad = OnLoad
	
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon("bunny_queen.tex")
	minimap:SetPriority(1)
	
	inst:AddTag("king")
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize(10, 5)
    
    MakeObstaclePhysics(inst, 2, .5)
    
    inst.AnimState:SetBank("bunny_queen")
    inst.AnimState:SetBuild("Bunny_Queen")
    inst.AnimState:PlayAnimation("idle_90s", true)
    
    inst:AddComponent("inspectable")

    inst:AddComponent("trader")

	inst.components.trader:SetAcceptTest(
		function(inst, item)
			return item.components.tradable.gemvalue > 0
		end)

    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader.onrefuse = OnRefuseItem
	
	inst:ListenForEvent( "nighttime", function(global, data)  
		StartTrading(inst)
	end, GetWorld())
	
	inst:ListenForEvent( "daytime", function(global, data)
		FinishedTrading(inst)
	end, GetWorld())
	
    return inst
end

return Prefab("common/objects/bunny_queen", fn, assets, prefabs)