var APIFactory = new APIFactory_Sim();
var VDiskAPI = APIFactory.getVDiskAPI();
var AccountAPI = APIFactory.getAccountAPI();
var FacilityAPI = APIFactory.getFacilityAPI();

var curAccount = '';
var lastUserConfig = {};

$(document).ready(function(){
	$("#prestep").hide();
	$("#diskpassword").keydown(function(event) {
		if(13 == event.which) {
			$("#next").click();
		}
	});
	var paramsString=FacilityAPI.getViewParam();
	var params=JSON.parse(paramsString);
	//var params = {account:'18900000000@189.cn'};
	if(!params) {
		params = {account:''};
	}
	curAccount = AccountAPI.getLoggedInAccount();
	if(curAccount == '') {
		curAccount = params.account;
		if(!curAccount) {
			curAccount = '';
		}
	}
	var title =  document.getElementById('title');
	title.innerText = "请输入" + curAccount + "用户的虚拟盘密码";
	var config = AccountAPI.getUserConfig(curAccount);
	lastUserConfig = JSON.parse(config);
	if(lastUserConfig) {
		if(lastUserConfig.autoMountVDisk == 1 && lastUserConfig.cachedVDiskPassword.length > 0 ) {
			$("#diskpassword").val(lastUserConfig.cachedVDiskPassword);
			$("#autoload_chkbox")[0].checked = true;
		}
	}
});

document.getElementById('next').onclick = function() {
	try{
		var password= document.getElementById('diskpassword');
		if(password.value == '') {
			uiShowBlockMsg('请输入密码', undefined, 1500);
			return;
		}
		var josnString=FacilityAPI.getViewParam();
		var arg = JSON.parse(josnString);
		
		var autoload = $("#autoload_chkbox")[0].checked;
		var config = {};
		if(autoload) {
			// 保存记录
			config = {
				cachedVDiskPassword:password.value,
				autoMountVDisk:1
			};
		} else {
			config = {
				cachedVDiskPassword:'',
				autoMountVDisk:0
			};
		}
		
		uiShowBlockMsg("正在挂载虚拟加密磁盘，请稍候");
		//挂载虚拟加密磁盘
		VDiskAPI.tryMountVDisk(arg.cryptFile, password.value, 'onMountVDisk', JSON.stringify(config));

	}catch(e){
		uiDismissBlockMsg();
	}
}



function onMountVDisk(errCode, result, tag){
	uiDismissBlockMsg();
	try{
		if(0==errCode){
			AccountAPI.changeUserConfig(curAccount, tag);
			//要先判定是不是用户已经登录
			var loginaccount=AccountAPI.getLoggedInAccount();
			if(loginaccount!=null && loginaccount.length > 0) {
				//关闭
				FacilityAPI.manageView(1);
			} else{
				var pagejsonString=FacilityAPI.getViewParam();
				var error=FacilityAPI.redirectToView('wizard/login.html',-1,-1,-1,-1,pagejsonString);
				if(error!=0){
					var description=getDescription(error);
					uiShowBlockMsg('错误信息提示:'+description, undefined, 1500);
					return false;
				}
			}
		}else{
			var description=getDescription(errCode);
			uiShowBlockMsg('错误信息提示:'+description, undefined, 1500);
			return false;
		}

	}catch(e){
		alert(e);
		}

	}

	document.getElementById('prestep').onclick = function(){
		try{
			//页面跳转
			var pagejsonString=FacilityAPI.getViewParam();
			var errorcode=FacilityAPI.redirectToView('wizard/choose_account.html',0,0,0,0,pagejsonString);
			if(errorcode!=0){
				var description=getDescription(errorcode);
				uiShowBlockMsg('错误信息提示:'+description, undefined, 1500);
				return false;
			}

		}catch(e){

		}

	}