/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.jaxme.xs.XSContentHandler;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.impl.XSLogicalParser;
import org.apache.ws.jaxme.xs.parser.XSContext;
import org.apache.ws.jaxme.xs.parser.XsSAXParser;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.xml.XsESchema;
import org.apache.ws.jaxme.xs.xml.XsObjectFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class XSContentHandlerImpl
implements XSContentHandler {
    private final XSLogicalParser parser;
    private final XsSAXParser xsSAXParser;
    private boolean finished;
    private int level = 0;
    private final String systemId;

    XSContentHandlerImpl(XSLogicalParser pParser, String pSystemId) throws SAXException {
        this.parser = pParser;
        this.systemId = pSystemId;
        XSContext data = this.parser.getData();
        data.setXSLogicalParser(this.parser);
        this.parser.clearSyntaxSchemas();
        XsObjectFactory factory = data.getXsObjectFactory();
        XsESchema mySchema = factory.newXsESchema();
        this.parser.setSchema(data.getXSObjectFactory().newXSSchema(data, mySchema));
        this.xsSAXParser = factory.newXsSAXParser(mySchema);
        this.parser.addSyntaxSchema(mySchema);
        data.setCurrentContentHandler(this.xsSAXParser);
    }

    public XSSchema getXSSchema() {
        if (!this.finished) {
            throw new IllegalStateException("The endDocument() method has not yet been invoked.");
        }
        return this.parser.getSchema();
    }

    public void startDocument() throws SAXException {
        this.xsSAXParser.startDocument();
    }

    public void endDocument() throws SAXException {
        this.xsSAXParser.endDocument();
        XsESchema syntaxSchema = (XsESchema)this.xsSAXParser.getBean();
        this.parser.removeSyntaxSchema();
        XSContext data = this.parser.getData();
        data.setCurrentContentHandler(null);
        try {
            this.parser.parse(syntaxSchema, this.systemId);
            XSSchema mySchema = this.parser.getSchema();
            this.parser.createSubstitutionGroups(mySchema);
            mySchema.validate();
            this.finished = true;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        catch (RuntimeException e) {
            Exception ex;
            block8: {
                Throwable t;
                UndeclaredThrowableException te;
                ex = e;
                while (true) {
                    te = null;
                    if (ex instanceof UndeclaredThrowableException) {
                        te = (UndeclaredThrowableException)ex;
                        t = te.getUndeclaredThrowable();
                    } else {
                        if (!(ex instanceof InvocationTargetException)) break block8;
                        t = ((InvocationTargetException)ex).getTargetException();
                    }
                    if (!(t instanceof Exception)) break;
                    ex = (Exception)t;
                }
                if (te == null) {
                    te = new UndeclaredThrowableException(t);
                }
                t.printStackTrace();
                throw te;
            }
            throw new LocSAXException(ex.getClass().getName() + ": " + ex.getMessage(), this.parser.getData().getLocator(), ex);
        }
    }

    public void characters(char[] pChars, int pStart, int pLen) throws SAXException {
        this.xsSAXParser.characters(pChars, pStart, pLen);
    }

    public void ignorableWhitespace(char[] pChars, int pStart, int pLen) throws SAXException {
        this.xsSAXParser.ignorableWhitespace(pChars, pStart, pLen);
    }

    public void endPrefixMapping(String pPrefix) throws SAXException {
        this.xsSAXParser.endPrefixMapping(pPrefix);
    }

    public void skippedEntity(String pEntity) throws SAXException {
        this.xsSAXParser.skippedEntity(pEntity);
    }

    public void setDocumentLocator(Locator pLocator) {
        this.xsSAXParser.setDocumentLocator(pLocator);
    }

    public void processingInstruction(String pTarget, String pData) throws SAXException {
        this.xsSAXParser.processingInstruction(pTarget, pData);
    }

    public void startPrefixMapping(String pPrefix, String pURI) throws SAXException {
        this.xsSAXParser.startPrefixMapping(pPrefix, pURI);
    }

    public void endElement(String pNamespaceURI, String pLocalName, String pQName) throws SAXException {
        this.xsSAXParser.endElement(pNamespaceURI, pLocalName, pQName);
        --this.level;
    }

    public void startElement(String pNamespaceURI, String pLocalName, String pQName, Attributes pAttrs) throws SAXException {
        this.xsSAXParser.startElement(pNamespaceURI, pLocalName, pQName, pAttrs);
    }
}

