/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.junit;

import org.apache.ws.jaxme.xs.XSAttributable;
import org.apache.ws.jaxme.xs.XSAttribute;
import org.apache.ws.jaxme.xs.XSComplexType;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSElementOrAttrRef;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSIdentityConstraint;
import org.apache.ws.jaxme.xs.XSKeyRef;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.XSType;
import org.xml.sax.SAXException;

public class DumpUtils {
    private static void dumpElements(XSElement[] elements, String prefix) throws SAXException {
        int numElements = elements.length;
        for (int i = 0; i < numElements; ++i) {
            DumpUtils.dumpElement(elements[i], prefix);
        }
    }

    private static void dumpElement(XSElement element, String prefix) throws SAXException {
        String indented = "  " + prefix;
        System.out.println(prefix + "Element " + System.identityHashCode(element) + ": " + element.getName());
        DumpUtils.dumpType(element.getType(), indented);
        DumpUtils.dumpIdentityConstraints(element.getIdentityConstraints(), indented);
        DumpUtils.dumpKeyRefs(element.getKeyRefs(), indented);
    }

    private static void dumpType(XSType type, String prefix) throws SAXException {
        String indented = "  " + prefix;
        System.out.print(prefix + "Type: ");
        if (type.isSimple()) {
            System.out.println("simple - " + type.getName());
        } else {
            System.out.println("complex - " + type.getName());
            DumpUtils.dumpComplexType(type.getComplexType(), indented);
        }
    }

    private static void dumpComplexType(XSComplexType type, String prefix) throws SAXException {
        String indented = prefix;
        XSAttributable[] attributables = type.getAttributes();
        int numAttribables = attributables.length;
        for (int i = 0; i < numAttribables; ++i) {
            DumpUtils.dumpAttributable(attributables[i], indented);
        }
        if (!type.isEmpty()) {
            DumpUtils.dumpParticle(type.getParticle(), indented);
        }
    }

    private static void dumpIdentityConstraints(XSIdentityConstraint[] constraints, String prefix) {
        int numConstraints = constraints.length;
        for (int i = 0; i < numConstraints; ++i) {
            DumpUtils.dumpIdentityConstraint(constraints[i], prefix);
        }
    }

    private static void dumpKeyRefs(XSKeyRef[] keyRefs, String prefix) {
        int numKeyRefs = keyRefs == null ? 0 : keyRefs.length;
        for (int i = 0; i < numKeyRefs; ++i) {
            DumpUtils.dumpKeyRef(keyRefs[i], prefix);
        }
    }

    private static void dumpIdentityConstraint(XSIdentityConstraint constraint, String prefix) {
        System.out.println(prefix + "constraint: " + constraint.getName() + (constraint.isUnique() ? " (unique)" : ""));
        DumpUtils.dumpMatchCriteria(constraint.getMatchCriteria(), prefix + "  ");
    }

    private static void dumpKeyRef(XSKeyRef keyRef, String prefix) {
        System.out.println(prefix + "keyref: " + keyRef.getName() + ": refers " + keyRef.getIdentityConstraint());
        DumpUtils.dumpMatchCriteria(keyRef.getMatchCriteria(), prefix + "  ");
    }

    private static void dumpMatchCriteria(XSElementOrAttrRef[][] criteria, String prefix) {
        int numKeyParts = criteria.length;
        for (int i = 0; i < numKeyParts; ++i) {
            XSElementOrAttrRef[] keys = criteria[i];
            int numOptions = keys.length;
            for (int j = 0; j < numOptions; ++j) {
                DumpUtils.dumpElementOrAttrRef(keys[j], i + ": ");
            }
        }
    }

    private static void dumpElementOrAttrRef(XSElementOrAttrRef ref, String prefix) {
        if (ref.isAttributeRef()) {
            System.out.println(prefix + ref.getAttribute().getName() + " (attr) ");
        } else {
            System.out.println(prefix + ref.getElement().getName() + " (ele) ");
        }
    }

    private static void dumpAttributable(XSAttributable attributable, String prefix) throws SAXException {
        if (attributable instanceof XSAttribute) {
            XSAttribute attr = (XSAttribute)attributable;
            System.out.println(prefix + "attribute " + System.identityHashCode(attr) + ": " + attr.getName() + " " + (attr.getType().isSimple() ? "simple" : "complex!!!") + (attr.isOptional() ? " optional" : " required"));
        } else {
            System.out.println(prefix + "??? attrributable " + attributable);
        }
    }

    private static void dumpParticle(XSParticle particle, String prefix) throws SAXException {
        String indented = "  " + prefix;
        System.out.print(prefix + " particle: min=" + particle.getMinOccurs() + " max=" + particle.getMaxOccurs() + " particle_type=" + particle.getType());
        if (particle.isElement()) {
            System.out.println(" element");
            DumpUtils.dumpElement(particle.getElement(), indented);
        } else if (particle.isGroup()) {
            System.out.println(" group");
            DumpUtils.dumpGroup(particle.getGroup(), indented);
        } else if (particle.isWildcard()) {
            System.out.println(" wildcard");
        }
    }

    private static void dumpGroup(XSGroup group, String prefix) throws SAXException {
        String indented = "  " + prefix;
        System.out.println(prefix + "group: name=" + group.getName());
        XSParticle[] particles = group.getParticles();
        int numParticles = particles.length;
        for (int i = 0; i < numParticles; ++i) {
            DumpUtils.dumpParticle(particles[i], indented);
        }
    }
}

