/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.junit;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.jaxme.xs.XSAnnotation;
import org.apache.ws.jaxme.xs.XSAppinfo;
import org.apache.ws.jaxme.xs.XSAttributable;
import org.apache.ws.jaxme.xs.XSAttribute;
import org.apache.ws.jaxme.xs.XSAttributeGroup;
import org.apache.ws.jaxme.xs.XSComplexType;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSElementOrAttrRef;
import org.apache.ws.jaxme.xs.XSEnumeration;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSIdentityConstraint;
import org.apache.ws.jaxme.xs.XSKeyRef;
import org.apache.ws.jaxme.xs.XSListType;
import org.apache.ws.jaxme.xs.XSModelGroup;
import org.apache.ws.jaxme.xs.XSParser;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.XSSimpleType;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.XSUnionType;
import org.apache.ws.jaxme.xs.XSWildcard;
import org.apache.ws.jaxme.xs.jaxb.JAXBGlobalBindings;
import org.apache.ws.jaxme.xs.jaxb.JAXBSchema;
import org.apache.ws.jaxme.xs.jaxb.JAXBXsObjectFactory;
import org.apache.ws.jaxme.xs.jaxb.impl.JAXBParser;
import org.apache.ws.jaxme.xs.junit.ParserTestBase;
import org.apache.ws.jaxme.xs.types.XSBoolean;
import org.apache.ws.jaxme.xs.types.XSDate;
import org.apache.ws.jaxme.xs.types.XSDateTime;
import org.apache.ws.jaxme.xs.types.XSDecimal;
import org.apache.ws.jaxme.xs.types.XSDouble;
import org.apache.ws.jaxme.xs.types.XSFloat;
import org.apache.ws.jaxme.xs.types.XSID;
import org.apache.ws.jaxme.xs.types.XSInt;
import org.apache.ws.jaxme.xs.types.XSNMToken;
import org.apache.ws.jaxme.xs.types.XSPositiveInteger;
import org.apache.ws.jaxme.xs.types.XSString;
import org.apache.ws.jaxme.xs.xml.XsNamespaceList;
import org.apache.ws.jaxme.xs.xml.XsObjectFactory;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ParserTest
extends ParserTestBase {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$apache$ws$jaxme$xs$jaxb$JAXBXsObjectFactory;
    static /* synthetic */ Class class$org$apache$ws$jaxme$xs$xml$XsObjectFactory;

    public ParserTest(String pName) {
        super(pName);
    }

    protected void testSimpleTypes(XSParser pParser) throws SAXException, IOException, ParserConfigurationException {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:simpleType name='a'>\n    <xs:restriction base='xs:string'>\n      <xs:minLength value='3'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:simpleType name='b'>\n    <xs:list itemType='xs:int'/>\n  </xs:simpleType>\n\n  <xs:simpleType name='c'>\n    <xs:union memberTypes='a b'/>\n  </xs:simpleType>\n</xs:schema>\n";
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:simpleType name='a'>\n    <xs:restriction base='xs:string'>\n      <xs:minLength value='3'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:simpleType name='b'>\n    <xs:list itemType='xs:int'/>\n  </xs:simpleType>\n\n  <xs:simpleType name='c'>\n    <xs:union memberTypes='a b'/>\n  </xs:simpleType>\n</xs:schema>\n"));
        isource.setSystemId("testSimpleTypes.xsd");
        XSSchema schema = pParser.parse(isource);
        XSType[] types = schema.getTypes();
        ParserTest.assertEquals((int)3, (int)types.length);
        XSType t1 = types[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "a"), (Object)t1.getName());
        XSSimpleType st1 = this.assertSimpleType(t1);
        this.assertAtomicType(st1);
        XSType t1_1 = this.assertRestriction(st1);
        ParserTest.assertEquals((Object)XSString.getInstance(), (Object)t1_1);
        XSType t2 = types[1];
        ParserTest.assertEquals((Object)new XsQName((String)null, "b"), (Object)t2.getName());
        XSSimpleType st2 = this.assertSimpleType(t2);
        XSListType lt = this.assertListType(st2);
        XSType it = lt.getItemType();
        ParserTest.assertNotNull((Object)it);
        ParserTest.assertEquals((Object)XSInt.getInstance(), (Object)it);
        XSSimpleType it2 = this.assertSimpleType(it);
        this.assertAtomicType(it2);
        XSType t3 = types[2];
        ParserTest.assertEquals((Object)new XsQName((String)null, "c"), (Object)t3.getName());
        XSSimpleType st3 = this.assertSimpleType(t3);
        XSUnionType ut3 = this.assertUnionType(st3);
        XSType[] memberTypes = ut3.getMemberTypes();
        ParserTest.assertEquals((int)2, (int)memberTypes.length);
        XSType mt3_1 = memberTypes[0];
        ParserTest.assertEquals((Object)mt3_1, (Object)t1);
        XSType mt3_2 = memberTypes[1];
        ParserTest.assertEquals((Object)mt3_2, (Object)t2);
    }

    public void testSimpleTypes() throws Exception {
        XSParser xsParser = this.newXSParser();
        this.testSimpleTypes(xsParser);
        JAXBParser jaxbParser = this.newJAXBParser();
        this.testSimpleTypes(jaxbParser);
    }

    protected void testAttributes(XSParser pParser) throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:attribute name='a' type='xs:string'/>\n\n  <xs:attribute name='b'>\n    <xs:simpleType>\n      <xs:restriction base='xs:int'/>\n    </xs:simpleType>\n  </xs:attribute>\n\n  <xs:attribute name='c' type='xs:int'/>\n</xs:schema>\n";
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:attribute name='a' type='xs:string'/>\n\n  <xs:attribute name='b'>\n    <xs:simpleType>\n      <xs:restriction base='xs:int'/>\n    </xs:simpleType>\n  </xs:attribute>\n\n  <xs:attribute name='c' type='xs:int'/>\n</xs:schema>\n"));
        isource.setSystemId("testAttributes.xsd");
        XSSchema schema = pParser.parse(isource);
        XSAttribute[] attr = schema.getAttributes();
        ParserTest.assertEquals((int)3, (int)attr.length);
        XSAttribute attr1 = attr[0];
        ParserTest.assertTrue((boolean)attr1.isGlobal());
        ParserTest.assertEquals((Object)new XsQName((String)null, "a"), (Object)attr1.getName());
        XSType t1 = attr1.getType();
        ParserTest.assertEquals((Object)XSString.getInstance(), (Object)t1);
        XSSimpleType st1 = this.assertSimpleType(attr1.getType());
        this.assertAtomicType(st1);
        XSAttribute attr2 = attr[1];
        ParserTest.assertTrue((boolean)attr2.isGlobal());
        ParserTest.assertEquals((Object)new XsQName((String)null, "b"), (Object)attr2.getName());
        XSType t2 = attr2.getType();
        ParserTest.assertTrue((!XSInt.getInstance().equals(t2) ? 1 : 0) != 0);
        XSType t2_1 = this.assertRestriction(this.assertSimpleType(t2));
        ParserTest.assertEquals((Object)XSInt.getInstance(), (Object)t2_1);
        XSSimpleType st2 = this.assertSimpleType(t2);
        this.assertAtomicType(st2);
        XSAttribute attr3 = attr[2];
        ParserTest.assertTrue((boolean)attr3.isGlobal());
        ParserTest.assertEquals((Object)new XsQName((String)null, "c"), (Object)attr3.getName());
        XSType t3 = attr3.getType();
        ParserTest.assertEquals((Object)XSInt.getInstance(), (Object)t3);
        XSSimpleType st3 = this.assertSimpleType(t3);
        this.assertAtomicType(st3);
    }

    public void testAttributes() throws Exception {
        XSParser xsParser = this.newXSParser();
        this.testAttributes(xsParser);
        JAXBParser jaxbParser = this.newJAXBParser();
        this.testAttributes(jaxbParser);
    }

    protected void testAttributeGroups(XSParser pParser) throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:attribute name='a' type='xs:string'/>\n  <xs:attribute name='b' type='xs:int'/>\n\n  <xs:attributeGroup name='c'>\n    <xs:attribute name='d' type='xs:dateTime'/>\n    <xs:attribute name='e' type='xs:float'/>\n    <xs:attribute ref='a'/>\n  </xs:attributeGroup>\n\n  <xs:attributeGroup name='f'>\n    <xs:attribute name='g' type='xs:double'/>\n    <xs:attributeGroup ref='c'/>\n    <xs:attribute ref='b'/>\n  </xs:attributeGroup>\n</xs:schema>\n";
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:attribute name='a' type='xs:string'/>\n  <xs:attribute name='b' type='xs:int'/>\n\n  <xs:attributeGroup name='c'>\n    <xs:attribute name='d' type='xs:dateTime'/>\n    <xs:attribute name='e' type='xs:float'/>\n    <xs:attribute ref='a'/>\n  </xs:attributeGroup>\n\n  <xs:attributeGroup name='f'>\n    <xs:attribute name='g' type='xs:double'/>\n    <xs:attributeGroup ref='c'/>\n    <xs:attribute ref='b'/>\n  </xs:attributeGroup>\n</xs:schema>\n"));
        isource.setSystemId("testAttributeGroups.xsd");
        XSSchema schema = pParser.parse(isource);
        XSAttributeGroup[] groups = schema.getAttributeGroups();
        ParserTest.assertNotNull((Object)groups);
        ParserTest.assertEquals((int)2, (int)groups.length);
        XSAttributeGroup ag1 = groups[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "c"), (Object)ag1.getName());
        XSAttributable[] attr1 = ag1.getAttributes();
        ParserTest.assertEquals((int)3, (int)attr1.length);
        XSAttribute attr1_1 = (XSAttribute)attr1[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "d"), (Object)attr1_1.getName());
        ParserTest.assertEquals((Object)XSDateTime.getInstance(), (Object)attr1_1.getType());
        XSAttribute attr1_2 = (XSAttribute)attr1[1];
        ParserTest.assertEquals((Object)new XsQName((String)null, "e"), (Object)attr1_2.getName());
        ParserTest.assertEquals((Object)XSFloat.getInstance(), (Object)attr1_2.getType());
        XSAttribute attr1_3 = (XSAttribute)attr1[2];
        ParserTest.assertEquals((Object)new XsQName((String)null, "a"), (Object)attr1_3.getName());
        ParserTest.assertEquals((Object)XSString.getInstance(), (Object)attr1_3.getType());
        XSAttributeGroup ag2 = groups[1];
        ParserTest.assertEquals((Object)new XsQName((String)null, "f"), (Object)ag2.getName());
        XSAttributable[] attr2 = ag2.getAttributes();
        ParserTest.assertEquals((int)5, (int)attr2.length);
        XSAttribute attr2_1 = (XSAttribute)attr2[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "g"), (Object)attr2_1.getName());
        ParserTest.assertEquals((Object)XSDouble.getInstance(), (Object)attr2_1.getType());
        XSAttribute attr2_2 = (XSAttribute)attr2[1];
        ParserTest.assertEquals((Object)new XsQName((String)null, "d"), (Object)attr2_2.getName());
        ParserTest.assertEquals((Object)XSDateTime.getInstance(), (Object)attr2_2.getType());
        XSAttribute attr2_3 = (XSAttribute)attr2[2];
        ParserTest.assertEquals((Object)new XsQName((String)null, "e"), (Object)attr2_3.getName());
        ParserTest.assertEquals((Object)XSFloat.getInstance(), (Object)attr2_3.getType());
        XSAttribute attr2_4 = (XSAttribute)attr2[3];
        ParserTest.assertEquals((Object)new XsQName((String)null, "a"), (Object)attr2_4.getName());
        ParserTest.assertEquals((Object)XSString.getInstance(), (Object)attr2_4.getType());
        XSAttribute attr2_5 = (XSAttribute)attr2[4];
        ParserTest.assertEquals((Object)new XsQName((String)null, "b"), (Object)attr2_5.getName());
        ParserTest.assertEquals((Object)XSInt.getInstance(), (Object)attr2_5.getType());
    }

    public void testAttributeGroups() throws Exception {
        XSParser xsParser = this.newXSParser();
        this.testAttributeGroups(xsParser);
        JAXBParser jaxbParser = this.newJAXBParser();
        this.testAttributeGroups(jaxbParser);
    }

    protected void testElements(XSParser pParser) throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:attribute name='id' type='xs:ID'/>\n\n  <xs:element name='a' type='xs:string'/>\n\n  <xs:element name='b'>\n    <xs:simpleType>\n      <xs:restriction base='xs:float'/>\n    </xs:simpleType>\n  </xs:element>\n\n  <xs:element name='c'>\n    <xs:complexType>\n      <xs:annotation>\n        <xs:documentation>\n          The type of 'c'.\n        </xs:documentation>\n      </xs:annotation>\n      <xs:sequence>\n        <xs:element ref='a'/>\n        <xs:element name='d' type='xs:double' minOccurs='0'>\n          <xs:annotation>\n            <xs:documentation>\n              The element 'd'.\n            </xs:documentation>\n          </xs:annotation>\n        </xs:element>\n      </xs:sequence>\n      <xs:attribute name='e' type='xs:int'>\n        <xs:annotation>\n          <xs:documentation>\n            The attribute 'e'.\n          </xs:documentation>\n        </xs:annotation>\n      </xs:attribute>\n    </xs:complexType>\n  </xs:element>\n\n  <xs:element name='f'>\n    <xs:complexType>\n      <xs:simpleContent>\n        <xs:extension base='xs:int'>\n          <xs:attribute name='g' type='xs:boolean'/>\n          <xs:attribute ref='id'/>\n        </xs:extension>\n      </xs:simpleContent>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>\n";
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:attribute name='id' type='xs:ID'/>\n\n  <xs:element name='a' type='xs:string'/>\n\n  <xs:element name='b'>\n    <xs:simpleType>\n      <xs:restriction base='xs:float'/>\n    </xs:simpleType>\n  </xs:element>\n\n  <xs:element name='c'>\n    <xs:complexType>\n      <xs:annotation>\n        <xs:documentation>\n          The type of 'c'.\n        </xs:documentation>\n      </xs:annotation>\n      <xs:sequence>\n        <xs:element ref='a'/>\n        <xs:element name='d' type='xs:double' minOccurs='0'>\n          <xs:annotation>\n            <xs:documentation>\n              The element 'd'.\n            </xs:documentation>\n          </xs:annotation>\n        </xs:element>\n      </xs:sequence>\n      <xs:attribute name='e' type='xs:int'>\n        <xs:annotation>\n          <xs:documentation>\n            The attribute 'e'.\n          </xs:documentation>\n        </xs:annotation>\n      </xs:attribute>\n    </xs:complexType>\n  </xs:element>\n\n  <xs:element name='f'>\n    <xs:complexType>\n      <xs:simpleContent>\n        <xs:extension base='xs:int'>\n          <xs:attribute name='g' type='xs:boolean'/>\n          <xs:attribute ref='id'/>\n        </xs:extension>\n      </xs:simpleContent>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>\n"));
        isource.setSystemId("testElements.xsd");
        XSSchema schema = pParser.parse(isource);
        XSElement[] elements = schema.getElements();
        ParserTest.assertEquals((int)4, (int)elements.length);
        XSElement e1 = elements[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "a"), (Object)e1.getName());
        XSType t1 = e1.getType();
        ParserTest.assertEquals((Object)XSString.getInstance(), (Object)t1);
        XSElement e2 = elements[1];
        ParserTest.assertEquals((Object)new XsQName((String)null, "b"), (Object)e2.getName());
        XSType t2 = e2.getType();
        ParserTest.assertEquals((Object)XSFloat.getInstance(), (Object)this.assertRestriction(this.assertSimpleType(t2)));
        XSElement e3 = elements[2];
        ParserTest.assertEquals((Object)new XsQName((String)null, "c"), (Object)e3.getName());
        XSComplexType ct3 = this.assertComplexType(e3.getType());
        XSParticle p3 = this.assertComplexContent(ct3);
        XSGroup g3 = this.assertGroup(p3);
        XSParticle[] particles3 = g3.getParticles();
        ParserTest.assertEquals((int)2, (int)particles3.length);
        XSElement e3_1 = this.assertElement(particles3[0]);
        ParserTest.assertEquals((Object)new XsQName((String)null, "a"), (Object)e3_1.getName());
        ParserTest.assertEquals((Object)e1.getType(), (Object)e3_1.getType());
        XSParticle p3_2 = particles3[1];
        ParserTest.assertEquals((int)0, (int)p3_2.getMinOccurs());
        XSElement e3_2 = this.assertElement(p3_2);
        ParserTest.assertEquals((Object)new XsQName((String)null, "d"), (Object)e3_2.getName());
        ParserTest.assertEquals((Object)XSDouble.getInstance(), (Object)e3_2.getType());
        XSAttributable[] a3 = ct3.getAttributes();
        ParserTest.assertEquals((int)1, (int)a3.length);
        XSAttribute a3_1 = (XSAttribute)a3[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "e"), (Object)a3_1.getName());
        ParserTest.assertEquals((Object)XSInt.getInstance(), (Object)a3_1.getType());
        XSElement e4 = elements[3];
        ParserTest.assertEquals((Object)new XsQName((String)null, "f"), (Object)e4.getName());
        XSComplexType ct4 = this.assertComplexType(e4.getType());
        XSType t4 = this.assertSimpleContent(ct4).getType();
        this.assertSimpleType(t4);
        ParserTest.assertEquals((Object)XSInt.getInstance(), (Object)t4);
        XSAttributable[] a4 = ct4.getAttributes();
        ParserTest.assertEquals((int)2, (int)a4.length);
        XSAttribute a4_1 = (XSAttribute)a4[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "g"), (Object)a4_1.getName());
        ParserTest.assertEquals((Object)XSBoolean.getInstance(), (Object)a4_1.getType());
        XSAttribute a4_2 = (XSAttribute)a4[1];
        ParserTest.assertEquals((Object)new XsQName((String)null, "id"), (Object)a4_2.getName());
        ParserTest.assertEquals((Object)XSID.getInstance(), (Object)a4_2.getType());
    }

    public void testElements() throws Exception {
        XSParser xsParser = this.newXSParser();
        this.testElements(xsParser);
        JAXBParser jaxbParser = this.newJAXBParser();
        this.testElements(jaxbParser);
    }

    protected void testFacets(XSParser pParser) throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:simpleType name='USState'>\n    <xs:restriction base='xs:string'>\n      <xs:enumeration value='AK'/>\n      <xs:enumeration value='AL'/>\n      <xs:enumeration value='AR'/>\n      <!-- and so on ... -->\n    </xs:restriction>\n  </xs:simpleType>\n  <xs:element name='a' type='USState'/>\n</xs:schema>\n";
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:simpleType name='USState'>\n    <xs:restriction base='xs:string'>\n      <xs:enumeration value='AK'/>\n      <xs:enumeration value='AL'/>\n      <xs:enumeration value='AR'/>\n      <!-- and so on ... -->\n    </xs:restriction>\n  </xs:simpleType>\n  <xs:element name='a' type='USState'/>\n</xs:schema>\n"));
        isource.setSystemId("testFacets.xsd");
        XSSchema schema = pParser.parse(isource);
        XSElement[] elements = schema.getElements();
        ParserTest.assertEquals((int)1, (int)elements.length);
        XSElement e1 = elements[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "a"), (Object)e1.getName());
        XSSimpleType st1 = this.assertSimpleType(e1.getType());
        ParserTest.assertEquals((Object)XSString.getInstance(), (Object)this.assertRestriction(st1));
        XSEnumeration[] enumerations = st1.getEnumerations();
        ParserTest.assertNotNull((Object)enumerations);
        ParserTest.assertEquals((int)3, (int)enumerations.length);
        ParserTest.assertEquals((int)3, (int)enumerations.length);
        ParserTest.assertEquals((String)"AK", (String)enumerations[0].getValue());
        ParserTest.assertEquals((String)"AL", (String)enumerations[1].getValue());
        ParserTest.assertEquals((String)"AR", (String)enumerations[2].getValue());
    }

    public void testFacets() throws Exception {
        XSParser xsParser = this.newXSParser();
        this.testFacets(xsParser);
        JAXBParser jaxbParser = this.newJAXBParser();
        this.testFacets(jaxbParser);
    }

    public void testPurchaseOrder() throws Exception {
        String schemaSource = "<xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema'>\n\n  <xsd:annotation>\n    <xsd:documentation xml:lang='en'>\n      Purchase order schema for Example.com.\n      Copyright 2000 Example.com. All rights reserved.\n    </xsd:documentation>\n  </xsd:annotation>\n\n  <xsd:element name='purchaseOrder' type='PurchaseOrderType'/>\n\n  <xsd:element name='comment' type='xsd:string'/>\n\n  <xsd:complexType name='PurchaseOrderType'>\n    <xsd:sequence>\n      <xsd:element name='shipTo' type='USAddress'/>\n      <xsd:element name='billTo' type='USAddress'/>\n      <xsd:element ref='comment' minOccurs='0'/>\n      <xsd:element name='items'  type='Items'/>\n    </xsd:sequence>\n    <xsd:attribute name='orderDate' type='xsd:date'/>\n  </xsd:complexType>\n\n  <xsd:complexType name='USAddress'>\n    <xsd:sequence>\n      <xsd:element name='name'   type='xsd:string'/>\n      <xsd:element name='street' type='xsd:string'/>\n      <xsd:element name='city'   type='xsd:string'/>\n      <xsd:element name='state'  type='xsd:string'/>\n      <xsd:element name='zip'    type='xsd:decimal'/>\n    </xsd:sequence>\n    <xsd:attribute name='country' type='xsd:NMTOKEN'\n        fixed='US'/>\n  </xsd:complexType>\n\n  <xsd:complexType name='Items'>\n    <xsd:sequence>\n      <xsd:element name='item' minOccurs='0' maxOccurs='unbounded'>\n        <xsd:complexType>\n          <xsd:sequence>\n            <xsd:element name='productName' type='xsd:string'/>\n            <xsd:element name='quantity'>\n              <xsd:simpleType>\n                <xsd:restriction base='xsd:positiveInteger'>\n                  <xsd:maxExclusive value='100'/>\n                </xsd:restriction>\n              </xsd:simpleType>\n            </xsd:element>\n            <xsd:element name='USPrice'  type='xsd:decimal'/>\n            <xsd:element ref='comment'   minOccurs='0'/>\n            <xsd:element name='shipDate' type='xsd:date' minOccurs='0'/>\n          </xsd:sequence>\n          <xsd:attribute name='partNum' type='SKU' use='required'/>\n        </xsd:complexType>\n      </xsd:element>\n    </xsd:sequence>\n  </xsd:complexType>\n\n  <!-- Stock Keeping Unit, a code for identifying products -->\n  <xsd:simpleType name='SKU'>\n    <xsd:restriction base='xsd:string'>\n      <xsd:pattern value='\\d{3}-[A-Z]{2}'/>\n    </xsd:restriction>\n  </xsd:simpleType>\n</xsd:schema>\n";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema'>\n\n  <xsd:annotation>\n    <xsd:documentation xml:lang='en'>\n      Purchase order schema for Example.com.\n      Copyright 2000 Example.com. All rights reserved.\n    </xsd:documentation>\n  </xsd:annotation>\n\n  <xsd:element name='purchaseOrder' type='PurchaseOrderType'/>\n\n  <xsd:element name='comment' type='xsd:string'/>\n\n  <xsd:complexType name='PurchaseOrderType'>\n    <xsd:sequence>\n      <xsd:element name='shipTo' type='USAddress'/>\n      <xsd:element name='billTo' type='USAddress'/>\n      <xsd:element ref='comment' minOccurs='0'/>\n      <xsd:element name='items'  type='Items'/>\n    </xsd:sequence>\n    <xsd:attribute name='orderDate' type='xsd:date'/>\n  </xsd:complexType>\n\n  <xsd:complexType name='USAddress'>\n    <xsd:sequence>\n      <xsd:element name='name'   type='xsd:string'/>\n      <xsd:element name='street' type='xsd:string'/>\n      <xsd:element name='city'   type='xsd:string'/>\n      <xsd:element name='state'  type='xsd:string'/>\n      <xsd:element name='zip'    type='xsd:decimal'/>\n    </xsd:sequence>\n    <xsd:attribute name='country' type='xsd:NMTOKEN'\n        fixed='US'/>\n  </xsd:complexType>\n\n  <xsd:complexType name='Items'>\n    <xsd:sequence>\n      <xsd:element name='item' minOccurs='0' maxOccurs='unbounded'>\n        <xsd:complexType>\n          <xsd:sequence>\n            <xsd:element name='productName' type='xsd:string'/>\n            <xsd:element name='quantity'>\n              <xsd:simpleType>\n                <xsd:restriction base='xsd:positiveInteger'>\n                  <xsd:maxExclusive value='100'/>\n                </xsd:restriction>\n              </xsd:simpleType>\n            </xsd:element>\n            <xsd:element name='USPrice'  type='xsd:decimal'/>\n            <xsd:element ref='comment'   minOccurs='0'/>\n            <xsd:element name='shipDate' type='xsd:date' minOccurs='0'/>\n          </xsd:sequence>\n          <xsd:attribute name='partNum' type='SKU' use='required'/>\n        </xsd:complexType>\n      </xsd:element>\n    </xsd:sequence>\n  </xsd:complexType>\n\n  <!-- Stock Keeping Unit, a code for identifying products -->\n  <xsd:simpleType name='SKU'>\n    <xsd:restriction base='xsd:string'>\n      <xsd:pattern value='\\d{3}-[A-Z]{2}'/>\n    </xsd:restriction>\n  </xsd:simpleType>\n</xsd:schema>\n"));
        isource.setSystemId("testPurchaseOrder.xsd");
        JAXBSchema schema = (JAXBSchema)parser.parse(isource);
        JAXBGlobalBindings globalBindings = schema.getJAXBGlobalBindings();
        ParserTest.assertNotNull((Object)globalBindings);
        XSType[] schemaTypes = schema.getTypes();
        ParserTest.assertNotNull((Object)schemaTypes);
        ParserTest.assertEquals((int)4, (int)schemaTypes.length);
        XSType items = schemaTypes[2];
        ParserTest.assertEquals((Object)new XsQName((String)null, "Items"), (Object)items.getName());
        ParserTest.assertTrue((boolean)items.isGlobal());
        XSComplexType itemsComplexType = this.assertComplexType(items);
        XSParticle itemsParticle = this.assertComplexContent(itemsComplexType);
        XSGroup itemsGroup = this.assertGroup(itemsParticle);
        this.assertSequence(itemsGroup);
        XSParticle[] itemsChildren = itemsGroup.getParticles();
        ParserTest.assertEquals((int)1, (int)itemsChildren.length);
        XSParticle item = itemsChildren[0];
        XSElement itemElement = this.assertElement(item);
        ParserTest.assertEquals((Object)new XsQName((String)null, "item"), (Object)itemElement.getName());
        ParserTest.assertTrue((!itemElement.isGlobal() ? 1 : 0) != 0);
        XSComplexType itemComplexType = this.assertComplexType(itemElement.getType());
        ParserTest.assertEquals((int)0, (int)item.getMinOccurs());
        ParserTest.assertEquals((int)-1, (int)item.getMaxOccurs());
        XSParticle itemParticle = this.assertComplexContent(itemComplexType);
        XSGroup itemGroup = this.assertGroup(itemParticle);
        this.assertSequence(itemGroup);
        XSAttributable[] itemAttributes = itemComplexType.getAttributes();
        ParserTest.assertEquals((int)1, (int)itemAttributes.length);
        XSAttribute partNum = (XSAttribute)itemAttributes[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "partNum"), (Object)partNum.getName());
        ParserTest.assertTrue((!partNum.isOptional() ? 1 : 0) != 0);
        XSType partNumType = partNum.getType();
        ParserTest.assertEquals((Object)new XsQName((String)null, "SKU"), (Object)partNumType.getName());
        ParserTest.assertTrue((boolean)partNumType.isGlobal());
        XSParticle[] itemGroupParticles = itemGroup.getParticles();
        ParserTest.assertEquals((int)5, (int)itemGroupParticles.length);
        XSParticle productName = itemGroupParticles[0];
        ParserTest.assertEquals((int)1, (int)productName.getMinOccurs());
        ParserTest.assertEquals((int)1, (int)productName.getMaxOccurs());
        XSElement productNameElement = this.assertElement(productName);
        ParserTest.assertEquals((Object)new XsQName((String)null, "productName"), (Object)productNameElement.getName());
        this.assertSimpleType(productNameElement.getType());
        ParserTest.assertEquals((Object)XSString.getInstance(), (Object)productNameElement.getType());
        XSParticle quantity = itemGroupParticles[1];
        ParserTest.assertEquals((int)1, (int)quantity.getMinOccurs());
        ParserTest.assertEquals((int)1, (int)quantity.getMaxOccurs());
        XSElement quantityElement = this.assertElement(quantity);
        ParserTest.assertEquals((Object)new XsQName((String)null, "quantity"), (Object)quantityElement.getName());
        XSSimpleType quantitySimpleType = this.assertSimpleType(quantityElement.getType());
        ParserTest.assertEquals((Object)XSPositiveInteger.getInstance(), (Object)this.assertRestriction(quantitySimpleType));
        XSParticle usPrice = itemGroupParticles[2];
        ParserTest.assertEquals((int)1, (int)usPrice.getMinOccurs());
        ParserTest.assertEquals((int)1, (int)usPrice.getMaxOccurs());
        XSElement usPriceElement = this.assertElement(usPrice);
        ParserTest.assertEquals((Object)new XsQName((String)null, "USPrice"), (Object)usPriceElement.getName());
        ParserTest.assertEquals((Object)XSDecimal.getInstance(), (Object)usPriceElement.getType());
        XSParticle comment = itemGroupParticles[3];
        ParserTest.assertEquals((int)comment.getMinOccurs(), (int)0);
        ParserTest.assertEquals((int)comment.getMaxOccurs(), (int)1);
        XSElement commentElement = this.assertElement(comment);
        ParserTest.assertEquals((Object)new XsQName((String)null, "comment"), (Object)commentElement.getName());
        ParserTest.assertEquals((Object)XSString.getInstance(), (Object)commentElement.getType());
        XSParticle shipDate = itemGroupParticles[4];
        ParserTest.assertEquals((int)shipDate.getMinOccurs(), (int)0);
        ParserTest.assertEquals((int)shipDate.getMaxOccurs(), (int)1);
        XSElement shipDateElement = this.assertElement(shipDate);
        ParserTest.assertEquals((Object)XSDate.getInstance(), (Object)shipDateElement.getType());
        XSType purchaseOrderType = schemaTypes[0];
        ParserTest.assertTrue((boolean)purchaseOrderType.isGlobal());
        ParserTest.assertEquals((Object)new XsQName((String)null, "PurchaseOrderType"), (Object)purchaseOrderType.getName());
        XSComplexType purchaseOrderTypeComplexType = this.assertComplexType(purchaseOrderType);
        XSParticle purchaseOrderTypeParticle = this.assertComplexContent(purchaseOrderTypeComplexType);
        XSGroup purchaseOrderTypeGroup = this.assertGroup(purchaseOrderTypeParticle);
        this.assertSequence(purchaseOrderTypeGroup);
        XSAttributable[] potAttributes = purchaseOrderTypeComplexType.getAttributes();
        ParserTest.assertEquals((int)1, (int)potAttributes.length);
        XSAttribute orderDate = (XSAttribute)potAttributes[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "orderDate"), (Object)orderDate.getName());
        ParserTest.assertEquals((Object)XSDate.getInstance(), (Object)orderDate.getType());
        XSParticle[] potChildren = purchaseOrderTypeGroup.getParticles();
        ParserTest.assertEquals((int)4, (int)potChildren.length);
        XSParticle shipTo = potChildren[0];
        ParserTest.assertEquals((int)1, (int)shipTo.getMinOccurs());
        ParserTest.assertEquals((int)1, (int)shipTo.getMaxOccurs());
        XSElement shipToElement = this.assertElement(shipTo);
        ParserTest.assertEquals((Object)new XsQName((String)null, "shipTo"), (Object)shipToElement.getName());
        XSType shipToType = shipToElement.getType();
        ParserTest.assertTrue((boolean)shipToType.isGlobal());
        ParserTest.assertEquals((Object)new XsQName((String)null, "USAddress"), (Object)shipToType.getName());
        XSParticle billTo = potChildren[1];
        ParserTest.assertEquals((int)1, (int)billTo.getMinOccurs());
        ParserTest.assertEquals((int)1, (int)billTo.getMaxOccurs());
        XSElement billToElement = this.assertElement(billTo);
        ParserTest.assertEquals((Object)new XsQName((String)null, "billTo"), (Object)billToElement.getName());
        XSType billToType = billToElement.getType();
        ParserTest.assertEquals((Object)shipToType, (Object)billToType);
        XSParticle potComment = potChildren[2];
        ParserTest.assertEquals((int)0, (int)potComment.getMinOccurs());
        ParserTest.assertEquals((int)1, (int)potComment.getMaxOccurs());
        XSElement potCommentElement = this.assertElement(potComment);
        ParserTest.assertEquals((Object)new XsQName((String)null, "comment"), (Object)potCommentElement.getName());
        ParserTest.assertEquals((Object)potCommentElement.getType(), (Object)commentElement.getType());
        XSParticle potItems = potChildren[3];
        ParserTest.assertEquals((int)1, (int)potItems.getMinOccurs());
        ParserTest.assertEquals((int)1, (int)potItems.getMaxOccurs());
        XSElement potItemsElement = this.assertElement(potItems);
        ParserTest.assertEquals((Object)new XsQName((String)null, "items"), (Object)potItemsElement.getName());
        ParserTest.assertEquals((Object)items, (Object)potItemsElement.getType());
        XSType sku = schemaTypes[3];
        ParserTest.assertTrue((boolean)sku.isGlobal());
        ParserTest.assertEquals((Object)new XsQName((String)null, "SKU"), (Object)sku.getName());
        XSSimpleType skuSimpleType = this.assertSimpleType(sku);
        ParserTest.assertEquals((Object)XSString.getInstance(), (Object)this.assertRestriction(skuSimpleType));
        ParserTest.assertEquals((Object)sku, (Object)partNumType);
        XSType usAddress = schemaTypes[1];
        ParserTest.assertTrue((boolean)usAddress.isGlobal());
        ParserTest.assertEquals((Object)new XsQName((String)null, "USAddress"), (Object)usAddress.getName());
        ParserTest.assertTrue((boolean)usAddress.isGlobal());
        XSComplexType usAddressComplexType = this.assertComplexType(usAddress);
        XSParticle usAddressParticle = this.assertComplexContent(usAddressComplexType);
        XSGroup usAddressGroup = this.assertGroup(usAddressParticle);
        this.assertSequence(usAddressGroup);
        XSAttributable[] usAddressAttributes = usAddressComplexType.getAttributes();
        ParserTest.assertEquals((int)1, (int)usAddressAttributes.length);
        XSAttribute country = (XSAttribute)usAddressAttributes[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "country"), (Object)country.getName());
        ParserTest.assertEquals((Object)XSNMToken.getInstance(), (Object)country.getType());
        String[] nameShouldBe = new String[]{"name", "street", "city", "state", "zip"};
        XSParticle[] usAddressChildren = usAddressGroup.getParticles();
        ParserTest.assertEquals((int)5, (int)usAddressChildren.length);
        for (int i = 0; i < usAddressChildren.length; ++i) {
            XSParticle child = usAddressChildren[i];
            ParserTest.assertEquals((int)1, (int)child.getMinOccurs());
            ParserTest.assertEquals((int)1, (int)child.getMaxOccurs());
            XSElement element = this.assertElement(child);
            ParserTest.assertEquals((Object)new XsQName((String)null, nameShouldBe[i]), (Object)element.getName());
            ParserTest.assertEquals((Object)(i == 4 ? XSDecimal.getInstance() : XSString.getInstance()), (Object)element.getType());
        }
        XSElement[] schemaElements = schema.getElements();
        ParserTest.assertEquals((int)2, (int)schemaElements.length);
        XSElement purchaseOrder = schemaElements[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "purchaseOrder"), (Object)purchaseOrder.getName());
        ParserTest.assertEquals((Object)purchaseOrderType, (Object)purchaseOrder.getType());
        ParserTest.assertEquals((Object)new XsQName((String)null, "comment"), (Object)schemaElements[1].getName());
    }

    public void testRestrictionMaxExclusive() throws Exception {
        String schemaSource = "<xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema'>\n <xsd:element name='quantity'> \n  <xsd:simpleType> \n   <xsd:restriction base='xsd:decimal'> \n    <xsd:maxExclusive value='100'/> \n   </xsd:restriction> \n  </xsd:simpleType> \n </xsd:element> \n</xsd:schema> \n";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema'>\n <xsd:element name='quantity'> \n  <xsd:simpleType> \n   <xsd:restriction base='xsd:decimal'> \n    <xsd:maxExclusive value='100'/> \n   </xsd:restriction> \n  </xsd:simpleType> \n </xsd:element> \n</xsd:schema> \n"));
        isource.setSystemId("testRestrictionMaxExclusive.xsd");
        parser.parse(isource);
    }

    private void verifyLocalNamespaces(String pSchema, boolean pQualified) throws Exception {
        XsQName fooQualified = new XsQName("http://test.com/namespaces", "foo");
        XsQName fooUnQualified = new XsQName((String)null, "foo");
        XsQName barQualified = new XsQName("http://test.com/namespaces", "bar");
        XsQName barUnQualified = new XsQName((String)null, "bar");
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader(pSchema));
        XSSchema schema = parser.parse(isource);
        XSElement[] schemaElements = schema.getElements();
        ParserTest.assertEquals((int)1, (int)schemaElements.length);
        ParserTest.assertEquals((Object)fooQualified, (Object)schemaElements[0].getName());
        XSAttribute[] schemaAttributes = schema.getAttributes();
        ParserTest.assertEquals((int)1, (int)schemaAttributes.length);
        ParserTest.assertEquals((Object)barQualified, (Object)schemaAttributes[0].getName());
        XSType[] types = schema.getTypes();
        ParserTest.assertEquals((int)1, (int)types.length);
        XSComplexType complexType = this.assertComplexType(types[0]);
        XSAttributable[] typeAttributes = complexType.getAttributes();
        ParserTest.assertEquals((int)1, (int)typeAttributes.length);
        ParserTest.assertEquals((Object)(pQualified ? barQualified : barUnQualified), (Object)((XSAttribute)typeAttributes[0]).getName());
        XSGroup group = this.assertGroup(this.assertComplexContent(complexType));
        XSParticle[] particles = group.getParticles();
        ParserTest.assertEquals((int)1, (int)particles.length);
        XSElement typeElement = this.assertElement(particles[0]);
        ParserTest.assertEquals((Object)(pQualified ? fooQualified : fooUnQualified), (Object)typeElement.getName());
    }

    public void testTargetNamespace() throws Exception {
        String schemaSource1 = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' targetNamespace='http://test.com/namespaces'>\n  <xs:element name='foo' type='xs:string'/>\n</xs:schema>\n";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' targetNamespace='http://test.com/namespaces'>\n  <xs:element name='foo' type='xs:string'/>\n</xs:schema>\n"));
        isource.setSystemId("testTargetNamespace1.xsd");
        XSSchema schema = parser.parse(isource);
        XSElement[] schemaElements = schema.getElements();
        ParserTest.assertEquals((int)1, (int)schemaElements.length);
        ParserTest.assertEquals((Object)new XsQName("http://test.com/namespaces", "foo"), (Object)schemaElements[0].getName());
        ParserTest.assertNull((Object)schemaElements[0].getName().getPrefix());
        String schemaSource2 = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' xmlns:test='http://test.com/namespaces' targetNamespace='http://test.com/namespaces'>\n  <xs:element name='foo' type='xs:string'/>\n</xs:schema>\n";
        parser = this.newJAXBParser();
        isource = new InputSource(new StringReader("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' xmlns:test='http://test.com/namespaces' targetNamespace='http://test.com/namespaces'>\n  <xs:element name='foo' type='xs:string'/>\n</xs:schema>\n"));
        isource.setSystemId("testTargetNamespace1.xsd");
        schema = parser.parse(isource);
        schemaElements = schema.getElements();
        ParserTest.assertEquals((int)1, (int)schemaElements.length);
        ParserTest.assertEquals((Object)new XsQName("http://test.com/namespaces", "foo"), (Object)schemaElements[0].getName());
        ParserTest.assertEquals((String)"test", (String)schemaElements[0].getName().getPrefix());
        String namespaceSchemaHeader = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' xmlns:test='http://test.com/namespaces'    targetNamespace='http://test.com/namespaces'";
        String namespaceSchemaFooter = "  <xs:complexType name='cType'>\n    <xs:sequence>\n      <xs:element name='foo' type='xs:string'/>\n    </xs:sequence>\n    <xs:attribute name='bar'/>\n   </xs:complexType>\n   <xs:element name='foo' type='xs:string'/>\n   <xs:attribute name='bar'/>\n</xs:schema>\n";
        this.verifyLocalNamespaces("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' xmlns:test='http://test.com/namespaces'    targetNamespace='http://test.com/namespaces'  >\n  <xs:complexType name='cType'>\n    <xs:sequence>\n      <xs:element name='foo' type='xs:string'/>\n    </xs:sequence>\n    <xs:attribute name='bar'/>\n   </xs:complexType>\n   <xs:element name='foo' type='xs:string'/>\n   <xs:attribute name='bar'/>\n</xs:schema>\n", false);
        this.verifyLocalNamespaces("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' xmlns:test='http://test.com/namespaces'    targetNamespace='http://test.com/namespaces'  elementFormDefault='unqualified'\n  attributeFormDefault='unqualified'>\n  <xs:complexType name='cType'>\n    <xs:sequence>\n      <xs:element name='foo' type='xs:string'/>\n    </xs:sequence>\n    <xs:attribute name='bar'/>\n   </xs:complexType>\n   <xs:element name='foo' type='xs:string'/>\n   <xs:attribute name='bar'/>\n</xs:schema>\n", false);
        this.verifyLocalNamespaces("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' xmlns:test='http://test.com/namespaces'    targetNamespace='http://test.com/namespaces'  elementFormDefault='qualified'\n  attributeFormDefault='qualified'>\n  <xs:complexType name='cType'>\n    <xs:sequence>\n      <xs:element name='foo' type='xs:string'/>\n    </xs:sequence>\n    <xs:attribute name='bar'/>\n   </xs:complexType>\n   <xs:element name='foo' type='xs:string'/>\n   <xs:attribute name='bar'/>\n</xs:schema>\n", true);
    }

    public void testSubstitutionGroups() throws Exception {
        String schemaSource1 = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'\n    targetNamespace='http://test.com/namespaces'\n    xmlns:ns='http://test.com/namespaces'>\n  <xs:element name='head' type='xs:string'/>\n  <xs:element name='subst1' type='xs:int' substitutionGroup='ns:head'/>\n  <xs:element name='subst2' type='xs:float' substitutionGroup='ns:head'/>\n  <xs:complexType name='test'>\n    <xs:sequence>\n      <xs:element ref='ns:head'/>\n    </xs:sequence>\n  </xs:complexType>\n</xs:schema>\n";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'\n    targetNamespace='http://test.com/namespaces'\n    xmlns:ns='http://test.com/namespaces'>\n  <xs:element name='head' type='xs:string'/>\n  <xs:element name='subst1' type='xs:int' substitutionGroup='ns:head'/>\n  <xs:element name='subst2' type='xs:float' substitutionGroup='ns:head'/>\n  <xs:complexType name='test'>\n    <xs:sequence>\n      <xs:element ref='ns:head'/>\n    </xs:sequence>\n  </xs:complexType>\n</xs:schema>\n"));
        isource.setSystemId("testTargetNamespace1.xsd");
        XSSchema schema = parser.parse(isource);
        XSElement[] elements = schema.getElements();
        ParserTest.assertEquals((int)3, (int)elements.length);
        XsQName headName = new XsQName("http://test.com/namespaces", "head");
        XsQName subst1Name = new XsQName("http://test.com/namespaces", "subst1");
        XsQName subst2Name = new XsQName("http://test.com/namespaces", "subst2");
        ParserTest.assertEquals((Object)headName, (Object)elements[0].getName());
        ParserTest.assertNotNull((Object)elements[0].getSubstitutionGroup());
        ParserTest.assertNull((Object)elements[0].getSubstitutionGroupName());
        ParserTest.assertEquals((Object)subst1Name, (Object)elements[1].getName());
        ParserTest.assertNull((Object)elements[1].getSubstitutionGroup());
        ParserTest.assertEquals((Object)headName, (Object)elements[1].getSubstitutionGroupName());
        ParserTest.assertEquals((Object)subst2Name, (Object)elements[2].getName());
        ParserTest.assertNull((Object)elements[2].getSubstitutionGroup());
        ParserTest.assertEquals((Object)headName, (Object)elements[2].getSubstitutionGroupName());
        XSType[] types = schema.getTypes();
        ParserTest.assertEquals((int)1, (int)types.length);
        XSGroup group = this.assertGroup(this.assertComplexContent(this.assertComplexType(types[0])));
        XSParticle[] particles = group.getParticles();
        ParserTest.assertEquals((int)1, (int)particles.length);
        XSGroup substitutedGroup = this.assertGroup(particles[0]);
        ParserTest.assertEquals((Object)XSModelGroup.CHOICE, (Object)substitutedGroup.getCompositor());
        XSParticle[] substParticles = substitutedGroup.getParticles();
        ParserTest.assertEquals((int)3, (int)substParticles.length);
        ParserTest.assertEquals((Object)headName, (Object)this.assertElement(substParticles[0]).getName());
        ParserTest.assertEquals((Object)subst1Name, (Object)this.assertElement(substParticles[1]).getName());
        ParserTest.assertEquals((Object)subst2Name, (Object)this.assertElement(substParticles[2]).getName());
    }

    public void testExtensions() throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:complexType name='a'>\n    <xs:sequence>\n      <xs:element name='ae1' type='xs:int'/>\n      <xs:element name='ae2' type='xs:dateTime'/>\n    </xs:sequence>\n    <xs:attribute name='aa1' type='xs:boolean'/>\n  </xs:complexType>\n\n  <xs:complexType name='b'>\n    <xs:complexContent>\n      <xs:extension base='a'>\n        <xs:choice>\n          <xs:element name='be1' type='xs:anyURI'/>\n          <xs:element name='be2' type='xs:double'/>\n        </xs:choice>\n        <xs:attribute name='ba1'/>\n      </xs:extension>\n    </xs:complexContent>\n  </xs:complexType>\n</xs:schema>\n";
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:complexType name='a'>\n    <xs:sequence>\n      <xs:element name='ae1' type='xs:int'/>\n      <xs:element name='ae2' type='xs:dateTime'/>\n    </xs:sequence>\n    <xs:attribute name='aa1' type='xs:boolean'/>\n  </xs:complexType>\n\n  <xs:complexType name='b'>\n    <xs:complexContent>\n      <xs:extension base='a'>\n        <xs:choice>\n          <xs:element name='be1' type='xs:anyURI'/>\n          <xs:element name='be2' type='xs:double'/>\n        </xs:choice>\n        <xs:attribute name='ba1'/>\n      </xs:extension>\n    </xs:complexContent>\n  </xs:complexType>\n</xs:schema>\n"));
        isource.setSystemId("testElements.xsd");
        XSParser xsParser = this.newXSParser();
        XSSchema schema = xsParser.parse(isource);
        XSType[] types = schema.getTypes();
        ParserTest.assertEquals((int)2, (int)types.length);
        XSType a = types[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "a"), (Object)a.getName());
        XSComplexType aComplexType = this.assertComplexType(a);
        XSAttributable[] aAttributes = aComplexType.getAttributes();
        ParserTest.assertEquals((int)1, (int)aAttributes.length);
        XSAttribute aa1 = (XSAttribute)aAttributes[0];
        ParserTest.assertEquals((Object)new XsQName((String)null, "aa1"), (Object)aa1.getName());
        XSType b = types[1];
        ParserTest.assertEquals((Object)new XsQName((String)null, "b"), (Object)b.getName());
        XSComplexType bComplexType = this.assertComplexType(b);
        ParserTest.assertTrue((boolean)bComplexType.isExtension());
        ParserTest.assertEquals((Object)bComplexType.getExtendedType(), (Object)a);
        XSAttributable[] bAttributes = bComplexType.getAttributes();
        ParserTest.assertEquals((int)2, (int)bAttributes.length);
        ParserTest.assertEquals((Object)aa1, (Object)bAttributes[0]);
        XSAttribute ba1 = (XSAttribute)bAttributes[1];
        ParserTest.assertEquals((Object)new XsQName((String)null, "ba1"), (Object)ba1.getName());
    }

    public void testAdditionalAttributes() throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' xmlns:foo='x' foo:a='y'>\n  <xs:element name='test' type='xs:string' foo:b='z'/>\n</xs:schema>\n";
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' xmlns:foo='x' foo:a='y'>\n  <xs:element name='test' type='xs:string' foo:b='z'/>\n</xs:schema>\n"));
        isource.setSystemId("testElements.xsd");
        XSParser xsParser = this.newXSParser();
        XSSchema schema = xsParser.parse(isource);
        Attributes schemaOpenAttrs = schema.getOpenAttributes();
        ParserTest.assertNotNull((Object)schemaOpenAttrs);
        ParserTest.assertEquals((int)1, (int)schemaOpenAttrs.getLength());
        ParserTest.assertEquals((String)"x", (String)schemaOpenAttrs.getURI(0));
        ParserTest.assertEquals((String)"a", (String)schemaOpenAttrs.getLocalName(0));
        ParserTest.assertEquals((String)"y", (String)schemaOpenAttrs.getValue(0));
        XSElement[] elements = schema.getElements();
        ParserTest.assertEquals((int)1, (int)elements.length);
        Attributes elementOpenAttrs = elements[0].getOpenAttributes();
        ParserTest.assertNotNull((Object)elementOpenAttrs);
        ParserTest.assertEquals((int)1, (int)elementOpenAttrs.getLength());
        ParserTest.assertEquals((String)"x", (String)elementOpenAttrs.getURI(0));
        ParserTest.assertEquals((String)"b", (String)elementOpenAttrs.getLocalName(0));
        ParserTest.assertEquals((String)"z", (String)elementOpenAttrs.getValue(0));
    }

    public void testSimpleTypeRestriction() throws Exception {
        String schemaSource = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'\n    xmlns='http://teamconnect.com'\n    targetNamespace='http://teamconnect.com'>\n  <xs:simpleType name='ZNSecurityTypeIID'>\n    <xs:annotation>\n      <xs:documentation/>\n    </xs:annotation>\n    <xs:restriction base='xs:int'>\n      <xs:enumeration value='0'/>\n      <xs:enumeration value='2'/>\n    </xs:restriction>\n  </xs:simpleType>\n</xs:schema>\n";
        InputSource isource = new InputSource(new StringReader("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'\n    xmlns='http://teamconnect.com'\n    targetNamespace='http://teamconnect.com'>\n  <xs:simpleType name='ZNSecurityTypeIID'>\n    <xs:annotation>\n      <xs:documentation/>\n    </xs:annotation>\n    <xs:restriction base='xs:int'>\n      <xs:enumeration value='0'/>\n      <xs:enumeration value='2'/>\n    </xs:restriction>\n  </xs:simpleType>\n</xs:schema>\n"));
        isource.setSystemId("testSimpleTypeRestriction.xsd");
        XSParser xsParser = this.newXSParser();
        XSSchema schema = xsParser.parse(isource);
        XSType[] types = schema.getTypes();
        ParserTest.assertEquals((int)1, (int)types.length);
        XSSimpleType simpleType = this.assertSimpleType(types[0]);
        this.assertAtomicType(simpleType);
        XSEnumeration[] enumerations = simpleType.getEnumerations();
        ParserTest.assertEquals((int)2, (int)enumerations.length);
        ParserTest.assertEquals((String)"0", (String)enumerations[0].getValue());
        ParserTest.assertEquals((String)"2", (String)enumerations[1].getValue());
    }

    private void testSimpleKey(XSParser parser) throws Exception {
        String schemaSource = "<?xml version='1.0' encoding='UTF-8'?><xs:schema targetNamespace='http://www.teamconnect.com' xmlns:xs='http://www.w3.org/2001/XMLSchema' xmlns='http://www.teamconnect.com'>  <xs:element name='library'>          <xs:complexType>            <xs:sequence>              <xs:element name='book' minOccurs='0' maxOccurs='unbounded'>                <xs:complexType>                  <xs:attribute name='id' type='xs:int' use='optional'/>                  <xs:attribute name='title' type='xs:string' use='required'/>                  <xs:attribute name='author' type='xs:string' use='optional'/>                </xs:complexType>              </xs:element>            </xs:sequence>          </xs:complexType>          <xs:key name='book-key'>            <xs:selector xpath='./book'/>            <xs:field xpath='@id'/>            <xs:field xpath='.'/>          </xs:key>          <xs:keyref name='book-key-ref' refer='book-key'>            <xs:selector xpath='./book'/>            <xs:field xpath='@title'/>            <xs:field xpath='.'/>          </xs:keyref>  </xs:element></xs:schema>";
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0' encoding='UTF-8'?><xs:schema targetNamespace='http://www.teamconnect.com' xmlns:xs='http://www.w3.org/2001/XMLSchema' xmlns='http://www.teamconnect.com'>  <xs:element name='library'>          <xs:complexType>            <xs:sequence>              <xs:element name='book' minOccurs='0' maxOccurs='unbounded'>                <xs:complexType>                  <xs:attribute name='id' type='xs:int' use='optional'/>                  <xs:attribute name='title' type='xs:string' use='required'/>                  <xs:attribute name='author' type='xs:string' use='optional'/>                </xs:complexType>              </xs:element>            </xs:sequence>          </xs:complexType>          <xs:key name='book-key'>            <xs:selector xpath='./book'/>            <xs:field xpath='@id'/>            <xs:field xpath='.'/>          </xs:key>          <xs:keyref name='book-key-ref' refer='book-key'>            <xs:selector xpath='./book'/>            <xs:field xpath='@title'/>            <xs:field xpath='.'/>          </xs:keyref>  </xs:element></xs:schema>"));
        isource.setSystemId("testSimpleKey.xsd");
        XSSchema schema = parser.parse(isource);
        XSElement[] elements = schema.getElements();
        ParserTest.assertEquals((int)1, (int)elements.length);
        XSElement libraryElement = elements[0];
        XSIdentityConstraint[] ics = libraryElement.getIdentityConstraints();
        ParserTest.assertEquals((int)1, (int)ics.length);
        XSIdentityConstraint ic = ics[0];
        ParserTest.assertEquals((String)"book-key", (String)ic.getName());
        XSElementOrAttrRef[][] icMatchCriteria = ic.getMatchCriteria();
        ParserTest.assertEquals((int)2, (int)icMatchCriteria.length);
        ParserTest.assertEquals((int)1, (int)icMatchCriteria[0].length);
        ParserTest.assertEquals((int)1, (int)icMatchCriteria[1].length);
        ParserTest.assertEquals((String)"id", (String)icMatchCriteria[0][0].getAttribute().getName().getLocalName());
        ParserTest.assertEquals((String)"book", (String)icMatchCriteria[1][0].getElement().getName().getLocalName());
        XSKeyRef[] rfs = libraryElement.getKeyRefs();
        ParserTest.assertEquals((int)1, (int)rfs.length);
        XSKeyRef rf = rfs[0];
        ParserTest.assertEquals((String)"book-key-ref", (String)rf.getName());
        XSElementOrAttrRef[][] rfMatchCriteria = rf.getMatchCriteria();
        ParserTest.assertEquals((int)2, (int)rfMatchCriteria.length);
        ParserTest.assertEquals((int)1, (int)rfMatchCriteria[0].length);
        ParserTest.assertEquals((int)1, (int)rfMatchCriteria[1].length);
        ParserTest.assertEquals((String)"title", (String)rfMatchCriteria[0][0].getAttribute().getName().getLocalName());
        ParserTest.assertEquals((String)"book", (String)rfMatchCriteria[1][0].getElement().getName().getLocalName());
    }

    public void testSimpleKey() throws Exception {
        XSParser xsParser = this.newXSParser();
        this.testSimpleKey(xsParser);
        JAXBParser jaxbParser = this.newJAXBParser();
        this.testSimpleKey(jaxbParser);
    }

    private void testDocumentationChilds(XSParser pParser) throws Exception {
        String schemaSource = "<?xml version='1.0' encoding='UTF-8'?><xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' >\n  <xs:annotation>\n    <xs:documentation xmlns:cc='http://www.dummy-namespace.org/'>\n      <cc:foo/>\n    </xs:documentation>\n  </xs:annotation>\n</xs:schema>";
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0' encoding='UTF-8'?><xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' >\n  <xs:annotation>\n    <xs:documentation xmlns:cc='http://www.dummy-namespace.org/'>\n      <cc:foo/>\n    </xs:documentation>\n  </xs:annotation>\n</xs:schema>"));
        isource.setSystemId("testSimpleKey.xsd");
        pParser.parse(isource);
    }

    public void testDocumentationChilds() throws Exception {
        XSParser xsParser = this.newXSParser();
        this.testDocumentationChilds(xsParser);
        JAXBParser jaxbParser = this.newJAXBParser();
        this.testDocumentationChilds(jaxbParser);
    }

    private void testNamespaceLists(XSParser pParser) throws Exception {
        String schemaSource = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:complexType name='foo'>\n    <xs:sequence>\n      <xs:any namespace='http://purl.org/dc/elements/1.1/' processContents='strict' minOccurs='0' maxOccurs='unbounded'/>\n      <xs:any namespace='http://www.jeckle.de/rss' processContents='strict' minOccurs='0'/>\n    </xs:sequence>\n    <xs:anyAttribute namespace='http://www.w3.org/1999/02/22-rdf-syntax-ns#' processContents='strict'/>\n  </xs:complexType>\n</xs:schema>\n";
        InputSource isource = new InputSource(new StringReader("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:complexType name='foo'>\n    <xs:sequence>\n      <xs:any namespace='http://purl.org/dc/elements/1.1/' processContents='strict' minOccurs='0' maxOccurs='unbounded'/>\n      <xs:any namespace='http://www.jeckle.de/rss' processContents='strict' minOccurs='0'/>\n    </xs:sequence>\n    <xs:anyAttribute namespace='http://www.w3.org/1999/02/22-rdf-syntax-ns#' processContents='strict'/>\n  </xs:complexType>\n</xs:schema>\n"));
        isource.setSystemId("testNamespaceLists.xsd");
        XSSchema schema = pParser.parse(isource);
        XSParticle[] particles = this.assertGroup(this.assertComplexContent(this.assertComplexType(schema.getTypes()[0]))).getParticles();
        ParserTest.assertEquals((int)2, (int)particles.length);
        ParserTest.assertTrue((boolean)particles[0].isWildcard());
        XSWildcard wildcard = particles[0].getWildcard();
        XsNamespaceList namespaceList = wildcard.getNamespaceList();
        ParserTest.assertTrue((!namespaceList.isAny() ? 1 : 0) != 0);
        ParserTest.assertTrue((!namespaceList.isAny() ? 1 : 0) != 0);
        ParserTest.assertEquals((int)1, (int)namespaceList.getUris().length);
        ParserTest.assertEquals((String)"http://purl.org/dc/elements/1.1/", (String)namespaceList.getUris()[0].getURI());
        ParserTest.assertTrue((boolean)particles[1].isWildcard());
        wildcard = particles[1].getWildcard();
        namespaceList = wildcard.getNamespaceList();
        ParserTest.assertTrue((!namespaceList.isAny() ? 1 : 0) != 0);
        ParserTest.assertTrue((!namespaceList.isAny() ? 1 : 0) != 0);
        ParserTest.assertEquals((int)1, (int)namespaceList.getUris().length);
        ParserTest.assertEquals((String)"http://www.jeckle.de/rss", (String)namespaceList.getUris()[0].getURI());
        XSAttributable[] attributes = this.assertComplexType(schema.getTypes()[0]).getAttributes();
        ParserTest.assertEquals((int)1, (int)attributes.length);
        ParserTest.assertTrue((boolean)(attributes[0] instanceof XSWildcard));
        wildcard = (XSWildcard)attributes[0];
        namespaceList = wildcard.getNamespaceList();
        ParserTest.assertTrue((!namespaceList.isAny() ? 1 : 0) != 0);
        ParserTest.assertTrue((!namespaceList.isAny() ? 1 : 0) != 0);
        ParserTest.assertEquals((int)1, (int)namespaceList.getUris().length);
        ParserTest.assertEquals((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (String)namespaceList.getUris()[0].getURI());
    }

    public void testNamespaceLists() throws Exception {
        XSParser xsParser = this.newXSParser();
        this.testNamespaceLists(xsParser);
        JAXBParser jaxbParser = this.newJAXBParser();
        this.testNamespaceLists(jaxbParser);
    }

    private void testSimpleTypeRestriction2(XSParser pParser) throws Exception {
        String schemaSource = "<schema xmlns='http://www.w3.org/2001/XMLSchema'\n   targetNamespace='http://asi.sbc.com/cpsosasos/trouble/data'\n   xmlns:s='http://asi.sbc.com/cpsosasos/trouble/data'>\n  <element name='foo'>\n    <complexType>\n      <attribute name='bar' type='s:ServiceIDType'/>\n    </complexType>\n  </element>\n  <simpleType name='ServiceIDType'>\n    <restriction base='s:NameTypeType'/>\n  </simpleType>\n  <simpleType name='NameTypeType'>\n    <union memberTypes='integer string'/>\n  </simpleType>\n</schema>\n";
        InputSource isource = new InputSource(new StringReader("<schema xmlns='http://www.w3.org/2001/XMLSchema'\n   targetNamespace='http://asi.sbc.com/cpsosasos/trouble/data'\n   xmlns:s='http://asi.sbc.com/cpsosasos/trouble/data'>\n  <element name='foo'>\n    <complexType>\n      <attribute name='bar' type='s:ServiceIDType'/>\n    </complexType>\n  </element>\n  <simpleType name='ServiceIDType'>\n    <restriction base='s:NameTypeType'/>\n  </simpleType>\n  <simpleType name='NameTypeType'>\n    <union memberTypes='integer string'/>\n  </simpleType>\n</schema>\n"));
        isource.setSystemId("testSimpleTypeRestriction2.xsd");
        XSSchema schema = pParser.parse(isource);
        XSType[] types = schema.getTypes();
        ParserTest.assertEquals((int)2, (int)types.length);
        ParserTest.assertEquals((Object)new XsQName("http://asi.sbc.com/cpsosasos/trouble/data", "NameTypeType"), (Object)types[1].getName());
        XSSimpleType nameTypeType = this.assertSimpleType(types[1]);
        this.assertUnionType(nameTypeType);
        ParserTest.assertEquals((Object)new XsQName("http://asi.sbc.com/cpsosasos/trouble/data", "ServiceIDType"), (Object)types[0].getName());
        XSSimpleType serviceIDType = this.assertSimpleType(types[0]);
        this.assertUnionType(serviceIDType);
        ParserTest.assertTrue((boolean)serviceIDType.isRestriction());
    }

    public void testSimpleTypeRestriction2() throws Exception {
        this.testSimpleTypeRestriction2(this.newXSParser());
        this.testSimpleTypeRestriction2(this.newJAXBParser());
    }

    private void testAppInfoEmbeddedText(XSParser pParser) throws Exception {
        String schemaSource = "<schema xmlns='http://www.w3.org/2001/XMLSchema'>\n  <annotation><appinfo>foo</appinfo></annotation>\n</schema>\n";
        InputSource isource = new InputSource(new StringReader("<schema xmlns='http://www.w3.org/2001/XMLSchema'>\n  <annotation><appinfo>foo</appinfo></annotation>\n</schema>\n"));
        isource.setSystemId("testAppInfoEmbeddedText.xsd");
        XSSchema schema = pParser.parse(isource);
        XSAnnotation[] annotations = schema.getAnnotations();
        ParserTest.assertEquals((int)1, (int)annotations.length);
        XSAppinfo[] appinfos = annotations[0].getAppinfos();
        ParserTest.assertEquals((int)1, (int)appinfos.length);
        Object[] childs = appinfos[0].getChilds();
        ParserTest.assertEquals((int)1, (int)childs.length);
        ParserTest.assertEquals((String)"foo", (String)((String)childs[0]));
    }

    public void testAppInfoEmbeddedText() throws Exception {
        this.testAppInfoEmbeddedText(this.newXSParser());
        this.testAppInfoEmbeddedText(this.newJAXBParser());
    }

    private void testImportSchemaWithoutNamespace(XSParser pParser) throws Exception {
        String schemaSource = "<schema xmlns='http://www.w3.org/2001/XMLSchema'\t targetNamespace='xyz' xmlns:p='xyz'>\n  <include schemaLocation='abc.xsd'/>\n  <element name='a' type='string'/>\n  <element name='b'>\n    <complexType>\n      <sequence>\n        <element ref='p:a'/>\n      </sequence>\n    </complexType>\n  </element>\n</schema>\n";
        String importedSchema = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:element name='c' type='xs:string'/>\n  <xs:element name='d'>\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element ref='c'/>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n\n  <xs:element name='AnyAttribute'>\n    <xs:complexType>\n      <xs:anyAttribute namespace='##any'/>\n    </xs:complexType>\n  </xs:element>\n\n  <xs:element name='OtherAttribute'>\n    <xs:complexType>\n      <xs:anyAttribute namespace='##other'/>\n    </xs:complexType>\n  </xs:element>\n\n  <xs:element name='ListAttribute'>\n    <xs:complexType>\n      <xs:anyAttribute namespace='##targetNamespace http://ws.apache.org/jaxme/test/misc/wildcards/2'/>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>\n";
        EntityResolver resolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if ("abc.xsd".equals(systemId)) {
                    return new InputSource(new StringReader("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:element name='c' type='xs:string'/>\n  <xs:element name='d'>\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element ref='c'/>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n\n  <xs:element name='AnyAttribute'>\n    <xs:complexType>\n      <xs:anyAttribute namespace='##any'/>\n    </xs:complexType>\n  </xs:element>\n\n  <xs:element name='OtherAttribute'>\n    <xs:complexType>\n      <xs:anyAttribute namespace='##other'/>\n    </xs:complexType>\n  </xs:element>\n\n  <xs:element name='ListAttribute'>\n    <xs:complexType>\n      <xs:anyAttribute namespace='##targetNamespace http://ws.apache.org/jaxme/test/misc/wildcards/2'/>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>\n"));
                }
                throw new SAXException("Invalid systemId: " + systemId);
            }
        };
        pParser.getContext().setXsObjectFactory(this.getXsObjectFactoryProxy(pParser.getContext().getXsObjectFactory(), resolver));
        InputSource isource = new InputSource(new StringReader("<schema xmlns='http://www.w3.org/2001/XMLSchema'\t targetNamespace='xyz' xmlns:p='xyz'>\n  <include schemaLocation='abc.xsd'/>\n  <element name='a' type='string'/>\n  <element name='b'>\n    <complexType>\n      <sequence>\n        <element ref='p:a'/>\n      </sequence>\n    </complexType>\n  </element>\n</schema>\n"));
        isource.setSystemId("testImportSchemaWithoutNamespace.xsd");
        XSSchema schema = pParser.parse(isource);
        XSElement[] elements = schema.getElements();
        ParserTest.assertEquals((int)7, (int)elements.length);
        ParserTest.assertEquals((Object)new XsQName("xyz", "c"), (Object)elements[0].getName());
        ParserTest.assertEquals((Object)new XsQName("xyz", "d"), (Object)elements[1].getName());
        XSComplexType anyAttrElem = this.assertComplexType(elements[2].getType());
        XSAttributable[] attrs = anyAttrElem.getAttributes();
        ParserTest.assertEquals((int)1, (int)attrs.length);
        ParserTest.assertTrue((boolean)(attrs[0] instanceof XSWildcard));
        XSWildcard wc = (XSWildcard)attrs[0];
        XsNamespaceList nsl = wc.getNamespaceList();
        ParserTest.assertTrue((boolean)nsl.isAny());
        ParserTest.assertNull((Object)nsl.getUris());
        XSComplexType otherAttrElem = this.assertComplexType(elements[3].getType());
        attrs = otherAttrElem.getAttributes();
        ParserTest.assertEquals((int)1, (int)attrs.length);
        ParserTest.assertTrue((boolean)(attrs[0] instanceof XSWildcard));
        nsl = ((XSWildcard)attrs[0]).getNamespaceList();
        ParserTest.assertTrue((boolean)nsl.isOther());
        ParserTest.assertEquals((int)1, (int)nsl.getUris().length);
        ParserTest.assertEquals((String)"xyz", (String)nsl.getUris()[0].toString());
        XSComplexType listAttrElem = this.assertComplexType(elements[4].getType());
        attrs = listAttrElem.getAttributes();
        ParserTest.assertEquals((int)1, (int)attrs.length);
        ParserTest.assertTrue((boolean)(attrs[0] instanceof XSWildcard));
        nsl = ((XSWildcard)attrs[0]).getNamespaceList();
        ParserTest.assertTrue((!nsl.isOther() ? 1 : 0) != 0);
        ParserTest.assertTrue((!nsl.isAny() ? 1 : 0) != 0);
        ParserTest.assertEquals((int)2, (int)nsl.getUris().length);
        ParserTest.assertEquals((String)"xyz", (String)nsl.getUris()[0].toString());
        ParserTest.assertEquals((String)"http://ws.apache.org/jaxme/test/misc/wildcards/2", (String)nsl.getUris()[1].toString());
        ParserTest.assertEquals((Object)new XsQName("xyz", "a"), (Object)elements[5].getName());
        ParserTest.assertEquals((Object)new XsQName("xyz", "b"), (Object)elements[6].getName());
    }

    public void testImportSchemaWithoutNamespace() throws Exception {
        this.testImportSchemaWithoutNamespace(this.newXSParser());
        this.testImportSchemaWithoutNamespace(this.newJAXBParser());
    }

    private void testElementReferenceGlobal(XSParser pParser) throws Exception {
        String schemaSource = "<?xml version='1.0' encoding='UTF-8'?>\n<schema xmlns='http://www.w3.org/2001/XMLSchema'    xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'    targetNamespace='http://ws.apache.org/jaxme/test/recursion'    xmlns:rec='http://ws.apache.org/jaxme/test/recursion'    elementFormDefault='qualified' attributeFormDefault='unqualified'>\n  <element name='Attribute'>\n    <complexType>\n      <attribute name='id' type='string' use='required'/>\n      <attribute name='value' type='string' use='optional'/>\n    </complexType>\n  </element>\n\n  <element name='AttributeList'>\n    <complexType>\n      <sequence>\n        <element ref='rec:Attribute'/>\n        <element ref='rec:Attribute' minOccurs='0' maxOccurs='unbounded'/>\n      </sequence>\n    </complexType>\n  </element>\n</schema>\n";
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0' encoding='UTF-8'?>\n<schema xmlns='http://www.w3.org/2001/XMLSchema'    xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'    targetNamespace='http://ws.apache.org/jaxme/test/recursion'    xmlns:rec='http://ws.apache.org/jaxme/test/recursion'    elementFormDefault='qualified' attributeFormDefault='unqualified'>\n  <element name='Attribute'>\n    <complexType>\n      <attribute name='id' type='string' use='required'/>\n      <attribute name='value' type='string' use='optional'/>\n    </complexType>\n  </element>\n\n  <element name='AttributeList'>\n    <complexType>\n      <sequence>\n        <element ref='rec:Attribute'/>\n        <element ref='rec:Attribute' minOccurs='0' maxOccurs='unbounded'/>\n      </sequence>\n    </complexType>\n  </element>\n</schema>\n"));
        isource.setSystemId("testElementReferenceGlobal.xsd");
        XSSchema schema = pParser.parse(isource);
        XSElement[] elements = schema.getElements();
        ParserTest.assertEquals((int)2, (int)elements.length);
        ParserTest.assertEquals((Object)new XsQName("http://ws.apache.org/jaxme/test/recursion", "Attribute"), (Object)elements[0].getName());
        ParserTest.assertTrue((boolean)elements[0].isGlobal());
        ParserTest.assertEquals((Object)new XsQName("http://ws.apache.org/jaxme/test/recursion", "AttributeList"), (Object)elements[1].getName());
        ParserTest.assertTrue((boolean)elements[1].isGlobal());
        XSComplexType complexType = this.assertComplexType(elements[1].getType());
        XSParticle particle = this.assertComplexContent(complexType);
        XSGroup group = this.assertGroup(particle);
        XSParticle[] particles = group.getParticles();
        ParserTest.assertEquals((int)2, (int)particles.length);
        ParserTest.assertEquals((int)1, (int)particles[0].getMinOccurs());
        ParserTest.assertEquals((int)1, (int)particles[0].getMaxOccurs());
        XSElement refElement = this.assertElement(particles[0]);
        ParserTest.assertTrue((boolean)refElement.isGlobal());
        ParserTest.assertEquals((Object)refElement.getName(), (Object)elements[0].getName());
        ParserTest.assertEquals((int)0, (int)particles[1].getMinOccurs());
        ParserTest.assertEquals((int)-1, (int)particles[1].getMaxOccurs());
        refElement = this.assertElement(particles[1]);
        ParserTest.assertTrue((boolean)refElement.isGlobal());
        ParserTest.assertEquals((Object)refElement.getName(), (Object)elements[0].getName());
    }

    public void testElementReferenceGlobal() throws Exception {
        this.testElementReferenceGlobal(this.newXSParser());
        this.testElementReferenceGlobal(this.newJAXBParser());
    }

    private void checkMailTemplateGroup(String pURI, XSType pType) throws SAXException {
        XSComplexType ct = this.assertComplexType(pType);
        ParserTest.assertFalse((boolean)ct.isEmpty());
        XSParticle particle = this.assertComplexContent(ct);
        XSGroup group = this.assertGroup(particle);
        this.assertSequence(group);
        XSParticle[] particles = group.getParticles();
        ParserTest.assertEquals((int)2, (int)particles.length);
        this.assertElement(particles[0]);
        ParserTest.assertEquals((Object)new XsQName(pURI, "subject"), (Object)particles[0].getElement().getName());
        XSGroup choice = this.assertGroup(particles[1]);
        this.assertChoice(choice);
        XSParticle[] choiceParticles = choice.getParticles();
        ParserTest.assertEquals((int)2, (int)choiceParticles.length);
        XSGroup sequence = this.assertGroup(choiceParticles[0]);
        this.assertSequence(sequence);
        XSParticle[] sequenceParticles = sequence.getParticles();
        ParserTest.assertEquals((int)2, (int)sequenceParticles.length);
        ParserTest.assertEquals((Object)new XsQName(pURI, "prepend"), (Object)sequenceParticles[0].getElement().getName());
        ParserTest.assertEquals((Object)new XsQName(pURI, "append"), (Object)sequenceParticles[1].getElement().getName());
        ParserTest.assertEquals((Object)new XsQName(pURI, "body"), (Object)choiceParticles[1].getElement().getName());
    }

    private void testMailTemplateMixed(XSParser pParser) throws Exception {
        String uri = "http://ws.apache.org/jaxme/test/nestedGroups";
        String schemaSource = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'\n    xmlns:ng='http://ws.apache.org/jaxme/test/nestedGroups'\n    targetNamespace='http://ws.apache.org/jaxme/test/nestedGroups'\n    elementFormDefault='qualified'\n    attributeFormDefault='unqualified'>\n  <xs:group name='MailTemplateGroup'>\n    <xs:sequence>\n      <xs:element name='subject' type='xs:string'/>\n      <xs:choice>\n        <xs:sequence>\n          <xs:element name='prepend' type='xs:string'/>\n          <xs:element name='append' type='xs:string'/>\n        </xs:sequence>\n        <xs:element name='body' maxOccurs='unbounded'>\n          <xs:complexType>\n            <xs:simpleContent>\n              <xs:extension base='xs:string'>\n                <xs:attribute name='delivery' use='required'>\n                  <xs:simpleType>\n                    <xs:restriction base='xs:string'>\n                      <xs:enumeration value='dailyDigest'/>\n                      <xs:enumeration value='immediate'/>\n                    </xs:restriction>\n                  </xs:simpleType>\n                </xs:attribute>\n              </xs:extension>\n            </xs:simpleContent>\n          </xs:complexType>\n        </xs:element>\n      </xs:choice>\n    </xs:sequence>\n  </xs:group>\n\n  <xs:element name='MailTemplate'>\n    <xs:complexType>\n      <xs:group ref='ng:MailTemplateGroup'/>\n      <xs:attribute name='language' type='xs:string' use='optional' default='EN'/>\n      <xs:attribute name='name' type='xs:string' use='required'/>\n    </xs:complexType>\n  </xs:element>\n\n  <xs:element name='MailTemplateMixed'>\n    <xs:complexType mixed='true'>\n      <xs:group ref='ng:MailTemplateGroup'/>\n      <xs:attribute name='language' type='xs:string' use='optional' default='EN'/>\n      <xs:attribute name='name' type='xs:string' use='required'/>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>\n";
        InputSource isource = new InputSource(new StringReader("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'\n    xmlns:ng='http://ws.apache.org/jaxme/test/nestedGroups'\n    targetNamespace='http://ws.apache.org/jaxme/test/nestedGroups'\n    elementFormDefault='qualified'\n    attributeFormDefault='unqualified'>\n  <xs:group name='MailTemplateGroup'>\n    <xs:sequence>\n      <xs:element name='subject' type='xs:string'/>\n      <xs:choice>\n        <xs:sequence>\n          <xs:element name='prepend' type='xs:string'/>\n          <xs:element name='append' type='xs:string'/>\n        </xs:sequence>\n        <xs:element name='body' maxOccurs='unbounded'>\n          <xs:complexType>\n            <xs:simpleContent>\n              <xs:extension base='xs:string'>\n                <xs:attribute name='delivery' use='required'>\n                  <xs:simpleType>\n                    <xs:restriction base='xs:string'>\n                      <xs:enumeration value='dailyDigest'/>\n                      <xs:enumeration value='immediate'/>\n                    </xs:restriction>\n                  </xs:simpleType>\n                </xs:attribute>\n              </xs:extension>\n            </xs:simpleContent>\n          </xs:complexType>\n        </xs:element>\n      </xs:choice>\n    </xs:sequence>\n  </xs:group>\n\n  <xs:element name='MailTemplate'>\n    <xs:complexType>\n      <xs:group ref='ng:MailTemplateGroup'/>\n      <xs:attribute name='language' type='xs:string' use='optional' default='EN'/>\n      <xs:attribute name='name' type='xs:string' use='required'/>\n    </xs:complexType>\n  </xs:element>\n\n  <xs:element name='MailTemplateMixed'>\n    <xs:complexType mixed='true'>\n      <xs:group ref='ng:MailTemplateGroup'/>\n      <xs:attribute name='language' type='xs:string' use='optional' default='EN'/>\n      <xs:attribute name='name' type='xs:string' use='required'/>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>\n"));
        isource.setSystemId("testMailTemplateMixed.xsd");
        XSSchema schema = pParser.parse(isource);
        XSElement[] elements = schema.getElements();
        ParserTest.assertEquals((int)2, (int)elements.length);
        ParserTest.assertEquals((Object)new XsQName("http://ws.apache.org/jaxme/test/nestedGroups", "MailTemplate"), (Object)elements[0].getName());
        ParserTest.assertFalse((boolean)this.assertComplexType(elements[0].getType()).isMixed());
        this.checkMailTemplateGroup("http://ws.apache.org/jaxme/test/nestedGroups", elements[0].getType());
        ParserTest.assertEquals((Object)new XsQName("http://ws.apache.org/jaxme/test/nestedGroups", "MailTemplateMixed"), (Object)elements[1].getName());
        ParserTest.assertTrue((boolean)this.assertComplexType(elements[1].getType()).isMixed());
        this.checkMailTemplateGroup("http://ws.apache.org/jaxme/test/nestedGroups", elements[1].getType());
    }

    public void testMailTemplateMixed() throws Exception {
        this.testMailTemplateMixed(this.newXSParser());
        this.testMailTemplateMixed(this.newJAXBParser());
    }

    private XsObjectFactory getXsObjectFactoryProxy(final XsObjectFactory pFactory, final EntityResolver pResolver) {
        InvocationHandler h = new InvocationHandler(){

            public Object invoke(Object pProxy, Method pMethod, Object[] pArgs) throws Throwable {
                if ((class$java$lang$Object == null ? (class$java$lang$Object = ParserTest.class$("java.lang.Object")) : class$java$lang$Object).equals(pMethod.getDeclaringClass())) {
                    return pMethod.invoke(pProxy, pArgs);
                }
                Object result = pMethod.invoke((Object)pFactory, pArgs);
                if ("newXMLReader".equals(pMethod.getName()) && result instanceof XMLReader) {
                    XMLReader xr = (XMLReader)result;
                    xr.setEntityResolver(pResolver);
                }
                return result;
            }
        };
        Class[] classes = pFactory instanceof JAXBXsObjectFactory ? new Class[]{class$org$apache$ws$jaxme$xs$jaxb$JAXBXsObjectFactory == null ? (class$org$apache$ws$jaxme$xs$jaxb$JAXBXsObjectFactory = ParserTest.class$("org.apache.ws.jaxme.xs.jaxb.JAXBXsObjectFactory")) : class$org$apache$ws$jaxme$xs$jaxb$JAXBXsObjectFactory} : new Class[]{class$org$apache$ws$jaxme$xs$xml$XsObjectFactory == null ? (class$org$apache$ws$jaxme$xs$xml$XsObjectFactory = ParserTest.class$("org.apache.ws.jaxme.xs.xml.XsObjectFactory")) : class$org$apache$ws$jaxme$xs$xml$XsObjectFactory};
        return (XsObjectFactory)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), classes, h);
    }

    private void testRecursiveXsInclude(XSParser pParser) throws Exception {
        String a = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:include schemaLocation='b.xsd'/>\n  <xs:element name='a' type='xs:int'/>\n</xs:schema>\n";
        String b = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:include schemaLocation='a.xsd'/>\n  <xs:element name='b' type='xs:int'/>\n</xs:schema>\n";
        EntityResolver resolver = new EntityResolver(){

            public InputSource resolveEntity(String pPublicId, String pSystemId) throws SAXException, IOException {
                String xml;
                if ("a.xsd".equals(pSystemId)) {
                    xml = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:include schemaLocation='b.xsd'/>\n  <xs:element name='a' type='xs:int'/>\n</xs:schema>\n";
                } else if ("b.xsd".equals(pSystemId)) {
                    xml = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:include schemaLocation='a.xsd'/>\n  <xs:element name='b' type='xs:int'/>\n</xs:schema>\n";
                } else {
                    return null;
                }
                InputSource isource = new InputSource(new StringReader(xml));
                isource.setSystemId(pSystemId);
                return isource;
            }
        };
        pParser.getContext().setXsObjectFactory(this.getXsObjectFactoryProxy(pParser.getContext().getXsObjectFactory(), resolver));
        InputSource isource = new InputSource(new StringReader("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:include schemaLocation='b.xsd'/>\n  <xs:element name='a' type='xs:int'/>\n</xs:schema>\n"));
        isource.setSystemId("a.xsd");
        XSSchema schema = pParser.parse(isource);
        ParserTest.assertEquals((int)2, (int)schema.getElements().length);
        ParserTest.assertEquals((int)0, (int)schema.getTypes().length);
    }

    public void testRecursiveXsInclude() throws Exception {
        this.testRecursiveXsInclude(this.newXSParser());
        this.testRecursiveXsInclude(this.newJAXBParser());
    }

    private void testGroupMultiplicity(XSParser pParser) throws Exception {
        String schemaSource = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n<xs:element name='PARAMETERS'>\n  <xs:complexType>\n    <xs:choice maxOccurs='unbounded'>\n      <xs:element name='PARAMETER'/>\n      <xs:element name='SYSTEMPARAMETER'/>\n      <xs:element name='PREPREF'/>\n    </xs:choice>\n  </xs:complexType>\n</xs:element></xs:schema>\n";
        InputSource isource = new InputSource(new StringReader("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n<xs:element name='PARAMETERS'>\n  <xs:complexType>\n    <xs:choice maxOccurs='unbounded'>\n      <xs:element name='PARAMETER'/>\n      <xs:element name='SYSTEMPARAMETER'/>\n      <xs:element name='PREPREF'/>\n    </xs:choice>\n  </xs:complexType>\n</xs:element></xs:schema>\n"));
        isource.setSystemId("testElementReferenceGlobal.xsd");
        XSSchema schema = pParser.parse(isource);
        XSElement[] elements = schema.getElements();
        ParserTest.assertEquals((int)1, (int)elements.length);
        XSElement parameters = elements[0];
        XSParticle particle = this.assertComplexContent(this.assertComplexType(parameters.getType()));
        ParserTest.assertEquals((int)1, (int)particle.getMinOccurs());
        ParserTest.assertEquals((int)-1, (int)particle.getMaxOccurs());
    }

    public void testGroupMultiplicity() throws Exception {
        this.testGroupMultiplicity(this.newXSParser());
        this.testGroupMultiplicity(this.newJAXBParser());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

