/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.xml.impl;

import org.apache.ws.jaxme.xs.parser.XSContext;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.xml.XsESchema;
import org.apache.ws.jaxme.xs.xml.XsObject;
import org.apache.ws.jaxme.xs.xml.XsObjectFactory;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.apache.ws.jaxme.xs.xml.impl.XsESchemaImpl;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class XsObjectImpl
implements XsObject {
    private final XsObject parent;
    private boolean isValidated;
    private final Locator locator;

    protected XsObjectImpl(XsObject pParent) {
        Locator loc;
        if (pParent == null) {
            if (!(this instanceof XsESchema)) {
                throw new IllegalStateException("Only the schema may have a null parent.");
            }
        } else if (this instanceof XsESchema) {
            throw new IllegalStateException("The schema must have a null parent.");
        }
        this.parent = pParent;
        XSContext context = this.getContext();
        this.locator = context != null ? ((loc = context.getLocator()) == null ? null : new LocatorImpl(this.getContext().getLocator())) : null;
    }

    public XsESchema getXsESchema() {
        if (this.parent == null) {
            return (XsESchema)((Object)this);
        }
        return this.parent.getXsESchema();
    }

    public boolean isTopLevelObject() {
        return this.parent == null || this.parent instanceof XsESchema;
    }

    public XsObject getParentObject() {
        return this.parent;
    }

    public XsObjectFactory getObjectFactory() {
        return this.getContext().getXsObjectFactory();
    }

    public Locator getLocator() {
        return this.locator;
    }

    protected NamespaceSupport getNamespaceSupport() {
        return this.getContext().getNamespaceSupport();
    }

    protected XsQName asXsQName(String pName) throws SAXException {
        return XsObjectImpl.asXsQName(this.getXsESchema(), this.getLocator(), this.getNamespaceSupport(), pName);
    }

    protected static XsQName asXsQName(XsESchema pSchema, Locator pLocator, NamespaceSupport pNss, String pName) throws SAXException {
        String[] parts = pNss.processName(pName, new String[3], false);
        if (parts == null) {
            throw new LocSAXException("Undeclared namespace prefix: " + pName, pLocator);
        }
        if (pSchema instanceof XsESchemaImpl && pSchema.getTargetNamespace() == null && (parts[0] == null || "".equals(parts[0]))) {
            return ((XsESchemaImpl)pSchema).newXsQName(parts[1], XsQName.prefixOf(pName));
        }
        return new XsQName(parts[0], parts[1], XsQName.prefixOf(pName));
    }

    public XSContext getContext() {
        return this.getXsESchema().getContext();
    }

    protected final boolean isValidated() {
        return this.isValidated;
    }

    public void validate() throws SAXException {
        this.isValidated = true;
    }
}

