/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.Cursor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import unbbayes.controller.ConfigurationsController;
import unbbayes.controller.exception.InvalidFileNameException;
import unbbayes.controller.exception.NoObjectToBeSavedException;
import unbbayes.controller.resources.ControllerResources;
import unbbayes.example.TextModeRunner;
import unbbayes.gui.Configurations;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.SplashScreen;
import unbbayes.gui.UnBBayesFrame;
import unbbayes.io.BaseIO;
import unbbayes.io.configurations.ConfigurationsIOInputStream;
import unbbayes.io.exception.UBIOException;
import unbbayes.prs.Edge;
import unbbayes.prs.Graph;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;
import unbbayes.util.extension.UnBBayesModule;
import unbbayes.util.extension.builder.NetworkWindowBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainController {
    private UnBBayesFrame screen;
    private static boolean PRE_LOAD_PROTEGE;
    private static boolean PRE_LOAD_POWERLOOM;
    private static ResourceBundle resource;

    static {
        resource = ResourceController.newInstance().getBundle(ControllerResources.class.getName());
    }

    public MainController() {
        try {
            this.loadConfigurations();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.screen = new UnBBayesFrame(this);
    }

    public void loadConfigurations() throws IOException {
        ConfigurationsController configController = ConfigurationsController.getInstance();
        ConfigurationsIOInputStream configurationsIO = new ConfigurationsIOInputStream();
        try {
            Configurations configurations = configurationsIO.load(new File(configController.getFileConfigurationsPath()));
            configController.setConfigurations(configurations);
            configController.setFileOpenedSucessfull(true);
        }
        catch (IOException e) {
            configController.setFileOpenedSucessfull(false);
            throw e;
        }
    }

    public void saveConfigurations() throws IOException {
        ConfigurationsController configController = ConfigurationsController.getInstance();
        ConfigurationsIOInputStream configurationsIO = new ConfigurationsIOInputStream();
        configurationsIO.save(new File(configController.getFileConfigurationsPath()), configController.getConfigurations());
    }

    private void eagleLoader() {
        SplashScreen splashScreen = new SplashScreen();
        splashScreen.pack();
        splashScreen.setVisible(true);
        this.initializeLoadConfigurations();
        Debug.println("Init loader Protege");
        Debug.println("Finish loader");
        splashScreen.dispose();
    }

    private void initializeLoadConfigurations() {
        PRE_LOAD_POWERLOOM = true;
        PRE_LOAD_PROTEGE = true;
    }

    public void newPN() {
        NetworkWindowBuilder builder = new NetworkWindowBuilder();
        if (builder != null) {
            builder.setName(resource.getString("NewPNName"));
            if (this.screen != null) {
                UnBBayesModule module = builder.buildUnBBayesModule();
                this.screen.addWindow(module);
            }
        }
    }

    public boolean saveNet(File file, UnBBayesModule moduleToUse) throws NoObjectToBeSavedException, InvalidFileNameException, FileNotFoundException, IOException, Exception {
        try {
            if (!moduleToUse.getIO().supports(file, false)) {
                throw new InvalidFileNameException(resource.getString("cannotHandleFileFormat"));
            }
            moduleToUse.getIO().save(file, moduleToUse.getPersistingGraph());
        }
        catch (NullPointerException e) {
            throw new NoObjectToBeSavedException(resource.getString("cannotHandleFileFormat"), e);
        }
        return true;
    }

    public boolean saveNet(File file, BaseIO ioToUse, Graph graphToSave) throws IOException {
        try {
            if (!ioToUse.supports(file, false)) {
                throw new IOException(resource.getString("cannotHandleFileFormat"));
            }
            ioToUse.save(file, graphToSave);
        }
        catch (NullPointerException e) {
            throw new UBIOException(resource.getString("cannotHandleFileFormat"), e);
        }
        return true;
    }

    public UnBBayesModule loadNet(File file, UnBBayesModule moduleToUse) throws IOException {
        UnBBayesModule mod = null;
        mod = moduleToUse.openFile(file);
        return mod;
    }

    public ProbabilisticNetwork makeProbabilisticNetwork(ArrayList<Node> nodeList) {
        this.screen.setCursor(new Cursor(3));
        ProbabilisticNetwork net = new ProbabilisticNetwork("learned net");
        Node noFilho = null;
        Node noPai = null;
        Edge arcoAux = null;
        boolean direction = true;
        int i = 0;
        while (i < nodeList.size()) {
            noFilho = nodeList.get(i);
            net.addNode(noFilho);
            int j = 0;
            while (j < noFilho.getParents().size()) {
                noPai = noFilho.getParents().get(j);
                noPai.getChildren().add(noFilho);
                arcoAux = new Edge(noPai, noFilho);
                int k = 0;
                while (k < noPai.getParents().size() && direction) {
                    Node aux = noPai.getParents().get(k);
                    if (aux == noFilho) {
                        noPai.getParents().remove(k);
                        direction = false;
                    }
                    ++k;
                }
                arcoAux = new Edge(noPai, noFilho);
                arcoAux.setDirection(direction);
                direction = true;
                net.getEdges().add(arcoAux);
                ++j;
            }
            ++i;
        }
        return net;
    }

    public void showProbabilisticNetwork(ProbabilisticNetwork net) {
        NetworkWindow netWindow = new NetworkWindow(net);
        if (!netWindow.getNetworkController().compileNetwork()) {
            netWindow.changeToPNEditionPane();
        } else {
            netWindow.changeToPNCompilationPane();
        }
        this.screen.addWindow(netWindow);
        this.screen.setCursor(new Cursor(0));
    }

    public void handleCommandLineArguments(String[] args) {
        try {
            if (args == null) {
                return;
            }
            TextModeRunner argumentExtractor = TextModeRunner.newInstance(args);
            Map<String, String> argumentValues = argumentExtractor.extractArguments(args);
            String netFileName = argumentValues.get("n");
            if (netFileName != null) {
                File currentFile = new File(netFileName);
                UnBBayesModule mod = new NetworkWindowBuilder().buildUnBBayesModule();
                Thread.sleep(1L);
                mod = this.loadNet(currentFile, mod);
                Thread.sleep(1L);
                if (mod != null) {
                    mod.setFile(currentFile);
                    Thread.sleep(1L);
                    this.screen.addWindow(mod);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

