/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import unbbayes.controller.FileHistoryController;
import unbbayes.controller.INetworkMediator;
import unbbayes.controller.PrintMonitor;
import unbbayes.controller.PrintNet;
import unbbayes.controller.PrintPreviewer;
import unbbayes.controller.PrintTable;
import unbbayes.controller.PrintText;
import unbbayes.controller.SENController;
import unbbayes.controller.resources.ControllerResources;
import unbbayes.evaluation.controller.EvaluationController;
import unbbayes.gui.FileIcon;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.gui.util.TextAreaDialog;
import unbbayes.io.BaseIO;
import unbbayes.io.extension.jpf.PluginAwareFileExtensionIODelegator;
import unbbayes.prs.Edge;
import unbbayes.prs.Graph;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.hybridbn.ContinuousNode;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;
import unbbayes.util.extension.bn.inference.IInferenceAlgorithm;

public class NetworkController
implements KeyListener,
INetworkMediator {
    private NetworkWindow screen;
    private SingleEntityNetwork singleEntityNetwork;
    private Node selectedNode;
    private SENController senController;
    private BaseIO baseIO;
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(ControllerResources.class.getName());

    public IInferenceAlgorithm getInferenceAlgorithm() {
        if (this.senController != null) {
            return this.senController.getInferenceAlgorithm();
        }
        return null;
    }

    public void setInferenceAlgorithm(IInferenceAlgorithm inferenceAlgorithm) {
        if (this.senController != null) {
            this.senController.setInferenceAlgorithm(inferenceAlgorithm);
        }
    }

    protected NetworkController() {
    }

    public NetworkController(SingleEntityNetwork singleEntityNetwork, NetworkWindow screen) {
        this.singleEntityNetwork = singleEntityNetwork;
        this.screen = screen;
        this.senController = new SENController(singleEntityNetwork, screen);
        this.setBaseIO(PluginAwareFileExtensionIODelegator.newInstance());
    }

    public SENController getSENController() {
        return this.senController;
    }

    public SingleEntityNetwork getSingleEntityNetwork() {
        return this.singleEntityNetwork;
    }

    public Network getNetwork() {
        return this.singleEntityNetwork;
    }

    public Graph getGraph() {
        return this.singleEntityNetwork;
    }

    public void initialize() {
        if (this.senController != null) {
            this.senController.initialize();
        }
    }

    public void removeEvidence(Node node) {
        if (this.senController != null) {
            this.senController.removeEvidence(node);
        }
    }

    public void createTable(Node node) {
        if (node == null) {
            return;
        }
        if (node.getType() == 5) {
            this.createContinuousDistribution((ContinuousNode)node);
        } else {
            this.createDiscreteTable(node);
        }
    }

    public void createContinuousDistribution(ContinuousNode node) {
        if (this.senController != null) {
            this.senController.createContinuousDistribution(node);
        }
    }

    public void createDiscreteTable(Node node) {
        if (this.senController != null) {
            this.senController.createDiscreteTable(node);
        }
    }

    public JTable makeTable(Node node) {
        if (this.senController != null) {
            return this.senController.makeTable(node);
        }
        return null;
    }

    public void propagate() {
        if (this.senController != null) {
            this.senController.propagate();
        }
    }

    public boolean compileNetwork() {
        if (this.senController != null) {
            return this.senController.compileNetwork();
        }
        return false;
    }

    public void evaluateNetwork() {
        if (this.singleEntityNetwork != null && this.singleEntityNetwork instanceof ProbabilisticNetwork) {
            EvaluationController evaluationController = new EvaluationController((ProbabilisticNetwork)this.singleEntityNetwork);
            this.screen.changeToPNEvaluationPane(evaluationController.getView());
        } else {
            JOptionPane.showMessageDialog(this.screen, "Evaluation can only be done in probabilistic networks.", "Evaluation Error", 0);
        }
    }

    public Node insertNode(Node newNode) {
        if (this.senController != null) {
            return this.senController.insertNode(newNode);
        }
        return null;
    }

    public Node insertContinuousNode(double x, double y) {
        if (this.senController != null) {
            return this.senController.insertContinuousNode(x, y);
        }
        return null;
    }

    public Node insertProbabilisticNode(double x, double y) {
        if (this.senController != null) {
            return this.senController.insertProbabilisticNode(x, y);
        }
        return null;
    }

    public Node insertDecisionNode(double x, double y) {
        if (this.senController != null) {
            return this.senController.insertDecisionNode(x, y);
        }
        return null;
    }

    public Node insertUtilityNode(double x, double y) {
        if (this.senController != null) {
            return this.senController.insertUtilityNode(x, y);
        }
        return null;
    }

    public void showExplanationProperties(ProbabilisticNode node) {
        if (this.senController != null) {
            this.senController.showExplanationProperties(node);
        }
    }

    public boolean insertEdge(Edge edge) throws Exception {
        if (this.senController != null) {
            return this.senController.insertEdge(edge);
        }
        return false;
    }

    public void insertState(Node node) {
        if (this.senController != null) {
            this.senController.insertState(node);
        }
    }

    public void removeState(Node node) {
        if (this.senController != null) {
            this.senController.removeState(node);
        }
    }

    public void deleteSelected(Object selected) {
        if (this.senController != null) {
            this.senController.deleteSelected(selected);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public NetworkWindow getScreen() {
        return this.screen;
    }

    public void saveNetImage() {
        String[] images = new String[]{"PNG", "JPG", "GIF", "BMP"};
        JFileChooser chooser = new JFileChooser(FileHistoryController.getInstance().getCurrentDirectory());
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileView(new FileIcon(this.screen));
        chooser.addChoosableFileFilter(new SimpleFileFilter(images, resource.getString("imageFileFilter")));
        int opcao = chooser.showSaveDialog(this.screen);
        if (opcao == 0) {
            File file;
            Rectangle r = this.calculateNetRectangle();
            JViewport comp = this.screen.getGraphPane().getGraphViewport();
            boolean imageSaved = this.saveComponentAsImage(comp, r.width, r.height, file = new File(chooser.getSelectedFile().getPath()));
            if (imageSaved) {
                FileHistoryController.getInstance().setCurrentDirectory(chooser.getCurrentDirectory());
                JOptionPane.showMessageDialog(this.screen, resource.getString("saveSucess"));
            }
        }
    }

    protected boolean saveComponentAsImage(Component comp, int width, int height, File file) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        comp.paint(g2d);
        g2d.dispose();
        boolean wrongName = false;
        String fileName = file.getName();
        if (!fileName.contains(".")) {
            fileName = String.valueOf(file.getAbsolutePath()) + fileName + ".png";
            file = new File(fileName);
        }
        if (fileName.length() > 4) {
            String fileExt = fileName.substring(fileName.length() - 3);
            try {
                if (fileExt.equalsIgnoreCase("png")) {
                    ImageIO.write((RenderedImage)bufferedImage, "png", file);
                } else if (fileExt.equalsIgnoreCase("jpg")) {
                    ImageIO.write((RenderedImage)bufferedImage, "jpg", file);
                } else if (fileExt.equalsIgnoreCase("gif")) {
                    ImageIO.write((RenderedImage)bufferedImage, "gif", file);
                } else if (fileExt.equalsIgnoreCase("bmp")) {
                    ImageIO.write((RenderedImage)bufferedImage, "bmp", file);
                } else {
                    JOptionPane.showMessageDialog(this.screen, resource.getString("wrongImageFormat"), resource.getString("error"), 0);
                    return false;
                }
                return true;
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this.screen, resource.getString("saveImageError"), resource.getString("error"), 0);
                e1.printStackTrace();
                return false;
            }
        }
        JOptionPane.showMessageDialog(this.screen, resource.getString("invalidImageName"), resource.getString("error"), 0);
        return false;
    }

    public void saveTableImage() {
        String[] images = new String[]{"PNG", "JPG", "GIF", "BMP"};
        JFileChooser chooser = new JFileChooser(FileHistoryController.getInstance().getCurrentDirectory());
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileView(new FileIcon(this.screen));
        chooser.addChoosableFileFilter(new SimpleFileFilter(images, resource.getString("imageFileFilter")));
        int opcao = chooser.showSaveDialog(this.screen);
        if (opcao == 0) {
            JTable comp = this.screen.getTable();
            File file = new File(chooser.getSelectedFile().getPath());
            boolean imageSaved = this.saveComponentAsImage(comp, ((Component)comp).getWidth(), ((Component)comp).getHeight(), file);
            if (imageSaved) {
                FileHistoryController.getInstance().setCurrentDirectory(chooser.getCurrentDirectory());
                JOptionPane.showMessageDialog(this.screen, resource.getString("saveSucess"));
            }
        }
    }

    protected String getLogContent() {
        if (this.singleEntityNetwork != null) {
            return this.singleEntityNetwork.getLog();
        }
        return "";
    }

    public String getLog() {
        return this.getLogContent();
    }

    public JDialog showLog() {
        TextAreaDialog dialog = new TextAreaDialog((Frame)this.getScreen().getUnbbayesFrame(), false);
        dialog.setTextContent(this.getLog());
        return dialog;
    }

    public void openWarningDialog() {
        Debug.println("Not implemented yet");
    }

    public void closeWarningDialog() {
        Debug.println("Not implemented yet");
    }

    public void previewPrintLog(final JTextArea texto, final JDialog dialog) {
        this.screen.setCursor(new Cursor(3));
        Thread t = new Thread(new Runnable(){

            public void run() {
                PrintText it = new PrintText(texto, new PageFormat());
                PrintPreviewer pp = new PrintPreviewer(it, 0);
                JDialog dlg = new JDialog((Dialog)dialog, resource.getString("previewLogToolTip"));
                dlg.getContentPane().add(pp);
                dlg.setSize(640, 480);
                dlg.setVisible(true);
            }
        });
        t.start();
        this.screen.setCursor(new Cursor(0));
    }

    public void previewPrintTable() {
        this.screen.setCursor(new Cursor(3));
        Thread t = new Thread(new Runnable(){

            public void run() {
                ArrayList<JTable> tabelas = new ArrayList<JTable>();
                ArrayList<Object> donos = new ArrayList<Object>();
                List<Node> temp = NetworkController.this.screen.getGraphPane().getSelectedGroup();
                if (temp.size() == 0) {
                    tabelas.add(NetworkController.this.screen.getTable());
                    donos.add(NetworkController.this.screen.getTableOwner());
                } else {
                    int i = 0;
                    while (i < temp.size()) {
                        donos.add(temp.get(i).toString());
                        tabelas.add(NetworkController.this.makeTable(temp.get(i)));
                        ++i;
                    }
                }
                PrintTable tp = new PrintTable(tabelas, donos, new PageFormat());
                PrintPreviewer pp = new PrintPreviewer(tp, 0);
                JDialog dlg = new JDialog();
                dlg.getContentPane().add(pp);
                dlg.setSize(400, 300);
                dlg.setVisible(true);
            }
        });
        t.start();
        this.screen.setCursor(new Cursor(0));
    }

    public void previewPrintNet(final JComponent rede, final Rectangle retangulo) {
        this.screen.setCursor(new Cursor(3));
        Thread t = new Thread(new Runnable(){

            public void run() {
                String rotulo = JOptionPane.showInputDialog(NetworkController.this.screen, resource.getString("askTitle"), resource.getString("informationText"), 1);
                if (rotulo == null) {
                    rotulo = "";
                }
                PrintNet it = new PrintNet(rotulo, rede, retangulo, new PageFormat());
                PrintPreviewer pp = new PrintPreviewer(it, 0);
                JDialog dlg = new JDialog();
                dlg.getContentPane().add(pp);
                dlg.setSize(640, 480);
                dlg.setVisible(true);
            }
        });
        t.start();
        this.screen.setCursor(new Cursor(0));
    }

    public void printNet(final JComponent network, final Rectangle rectangle) {
        this.screen.setCursor(new Cursor(3));
        Thread t = new Thread(new Runnable(){

            public void run() {
                String rotulo = JOptionPane.showInputDialog(NetworkController.this.screen, resource.getString("askTitle"), resource.getString("informationText"), 1);
                if (rotulo == null) {
                    rotulo = "";
                }
                PrintNet it = new PrintNet(rotulo, network, rectangle, new PageFormat());
                PrintMonitor pm = new PrintMonitor(it);
                try {
                    pm.performPrint(true);
                }
                catch (PrinterException pe) {
                    JOptionPane.showMessageDialog(NetworkController.this.screen, String.valueOf(resource.getString("printException")) + pe.getMessage());
                }
            }
        });
        t.start();
        this.screen.setCursor(new Cursor(0));
    }

    public void printTable() {
        this.screen.setCursor(new Cursor(3));
        Thread t = new Thread(new Runnable(){

            public void run() {
                ArrayList<JTable> tabelas = new ArrayList<JTable>();
                ArrayList<Object> donos = new ArrayList<Object>();
                List<Node> temp = NetworkController.this.screen.getGraphPane().getSelectedGroup();
                if (temp.size() == 0) {
                    tabelas.add(NetworkController.this.screen.getTable());
                    donos.add(NetworkController.this.screen.getTableOwner());
                } else {
                    int i = 0;
                    while (i < temp.size()) {
                        donos.add(temp.get(i).toString());
                        tabelas.add(NetworkController.this.makeTable(temp.get(i)));
                        ++i;
                    }
                }
                PrintTable impressora = new PrintTable(tabelas, donos, new PageFormat());
                PrintMonitor pm = new PrintMonitor(impressora);
                try {
                    pm.performPrint(true);
                }
                catch (PrinterException pe) {
                    JOptionPane.showMessageDialog(NetworkController.this.screen, String.valueOf(resource.getString("printException")) + pe.getMessage());
                }
            }
        });
        t.start();
        this.screen.setCursor(new Cursor(0));
    }

    protected void printLog(final JTextArea textArea) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                PrintText it = new PrintText(textArea, new PageFormat());
                PrintMonitor pm = new PrintMonitor(it);
                try {
                    pm.performPrint(true);
                }
                catch (PrinterException pe) {
                    JOptionPane.showMessageDialog(NetworkController.this.screen, String.valueOf(resource.getString("printException")) + pe.getMessage());
                }
            }
        });
        t.start();
    }

    public Rectangle calculateNetRectangle() {
        return new Rectangle(0, 0, (int)this.screen.getGraphPane().getBiggestPoint().x, (int)this.screen.getGraphPane().getBiggestPoint().y);
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public void selectNode(Node node) {
        this.selectedNode = node;
    }

    public void unselectAll() {
        this.selectedNode = null;
    }

    public BaseIO getBaseIO() {
        return this.baseIO;
    }

    public void setBaseIO(BaseIO baseIO) {
        this.baseIO = baseIO;
    }

    public void setScreen(NetworkWindow screen) {
        this.screen = screen;
    }
}

