/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import unbbayes.controller.resources.ControllerResources;
import unbbayes.util.ResourceController;

public class PrintMonitor
implements Pageable {
    protected PrinterJob printerJob;
    protected Pageable pageable;
    protected JOptionPane optionPane;
    protected JDialog statusDialog;
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(ControllerResources.class.getName());

    public PrintMonitor(Pageable p) {
        this.pageable = p;
        this.printerJob = PrinterJob.getPrinterJob();
        Object[] options = new String[]{resource.getString("cancelOption")};
        this.optionPane = new JOptionPane("", 1, 2, null, options);
        this.statusDialog = this.optionPane.createDialog(null, resource.getString("printerStatus"));
    }

    public void performPrint(boolean showDialog) throws PrinterException {
        boolean isOk;
        this.printerJob.setPageable(this);
        if (showDialog && !(isOk = this.printerJob.printDialog())) {
            return;
        }
        this.optionPane.setMessage(resource.getString("initializingPrinter"));
        Thread t = new Thread(new Runnable(){

            public void run() {
                PrintMonitor.this.statusDialog.setVisible(true);
                if (PrintMonitor.this.optionPane.getValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    PrintMonitor.this.printerJob.cancel();
                }
            }
        });
        t.start();
        this.printerJob.print();
        this.statusDialog.setVisible(false);
    }

    public int getNumberOfPages() {
        return this.pageable.getNumberOfPages();
    }

    public Printable getPrintable(int index) {
        this.optionPane.setMessage(String.valueOf(resource.getString("printingPage")) + (index + 1));
        return this.pageable.getPrintable(index);
    }

    public PageFormat getPageFormat(int index) {
        return this.pageable.getPageFormat(index);
    }
}

