/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import javax.swing.JTextArea;

public class PrintText
implements Printable,
Pageable {
    protected JTextArea texto;
    protected PageFormat pageFormat;

    public PrintText(JTextArea texto, PageFormat pf) {
        this.texto = texto;
        this.pageFormat = pf;
    }

    public int print(Graphics g, PageFormat pf, int index) {
        Dimension size = new Dimension();
        if (this.texto.getWidth() == 0 || this.texto.getHeight() == 0) {
            this.texto.setSize(this.texto.getPreferredSize());
        }
        int textHeight = this.texto.getHeight();
        int positionX = 0;
        int positionY = 0;
        int pageIndex = 0;
        while (positionY < textHeight) {
            positionX = 0;
            size.setSize(this.getPrintSize(positionX, positionY));
            if (pageIndex == index) {
                this.paintText(g, positionX, positionY, size);
                return 0;
            }
            ++pageIndex;
            positionX += size.width;
            positionY += size.height;
        }
        return 1;
    }

    protected Dimension getPrintSize(int positionX, int positionY) {
        int maxWidth = (int)this.pageFormat.getImageableWidth();
        int maxHeight = (int)this.pageFormat.getImageableHeight();
        return new Dimension(maxWidth, maxHeight);
    }

    protected void paintText(Graphics g, int positionX, int positionY, Dimension size) {
        int offsetX = (int)this.pageFormat.getImageableX();
        int offsetY = (int)this.pageFormat.getImageableY();
        g.translate(offsetX - positionX, offsetY - positionY);
        g.clipRect(positionX, positionY, size.width, size.height);
        this.texto.paint(g);
    }

    public int getNumberOfPages() {
        Dimension size = new Dimension();
        int textHeight = this.texto.getHeight();
        int positionX = 0;
        int positionY = 0;
        int pageIndex = 0;
        while (positionY < textHeight) {
            positionX = 0;
            size.setSize(this.getPrintSize(positionX, positionY));
            positionX += size.width;
            ++pageIndex;
            positionY += size.height;
        }
        return pageIndex;
    }

    public Printable getPrintable(int index) {
        return this;
    }

    public PageFormat getPageFormat(int index) {
        return this.pageFormat;
    }
}

