/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import unbbayes.controller.IProgress;
import unbbayes.controller.LoadingActivity;
import unbbayes.controller.resources.ControllerResources;
import unbbayes.util.ResourceController;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = 0L;
    public final int NEED_DIALOG_VALUE = 1000;
    private IProgress progress;
    private Timer activityMonitor;
    private LoadingActivity activity;
    private JProgressBar progressBar;
    private int min;
    private int max;
    private ResourceBundle resource = ResourceController.newInstance().getBundle(ControllerResources.class.getName());

    public ProgressDialog(String message, IProgress progress) {
        this.setTitle(this.resource.getString("loading"));
        this.setSize(280, 130);
        this.setModal(true);
        this.setResizable(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        Container contentPane = this.getContentPane();
        JPanel panelLabel = new JPanel();
        contentPane.add((Component)panelLabel, "North");
        if (message != null) {
            JLabel label = new JLabel(String.valueOf(this.resource.getString("loading")) + message);
            panelLabel.add(label);
        }
        JPanel panelProgress = new JPanel();
        contentPane.add((Component)panelProgress, "Center");
        this.min = 0;
        this.max = progress.maxCount();
        this.progress = progress;
        this.progressBar = new JProgressBar(this.min, this.max);
        panelProgress.add(this.progressBar);
        JPanel panelButton = new JPanel();
        contentPane.add((Component)panelButton, "South");
        JButton cancelButton = new JButton(this.resource.getString("cancel"));
        panelButton.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProgressDialog.this.activity.requestCancel();
                ProgressDialog.this.activity.interrupt();
                ProgressDialog.this.activityMonitor.stop();
                ProgressDialog.this.hide();
            }
        });
        this.activity = new LoadingActivity(progress, this.max);
        this.activityMonitor = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int current = ProgressDialog.this.activity.getCurrent();
                ProgressDialog.this.progressBar.setValue(current);
                ProgressDialog.this.progressBar.setStringPainted(true);
                ProgressDialog.this.progressBar.setString(String.valueOf(current) + ProgressDialog.this.resource.getString("of") + ProgressDialog.this.max);
                if (current == ProgressDialog.this.activity.getTarget()) {
                    ProgressDialog.this.activityMonitor.stop();
                    ProgressDialog.this.hide();
                }
            }
        });
    }

    public boolean load() {
        if (this.max > 1000) {
            this.activity.start();
            this.activityMonitor.start();
            this.show();
            return !this.activity.wasActivityCancelled();
        }
        while (this.progress.next()) {
        }
        return true;
    }
}

