/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import unbbayes.draw.UCanvas;
import unbbayes.draw.UShapeFrame;
import unbbayes.draw.UShapeProbabilisticNode;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;

public class TestUGraphEditor
extends JFrame
implements WindowStateListener {
    private static final long serialVersionUID = 6193584247576527941L;
    protected UCanvas m_Canvas;

    public TestUGraphEditor() {
        super("TestUGraphEditor");
        this.addWindowStateListener(this);
        this.m_Canvas = new UCanvas();
        this.m_Canvas.setPreferredSize(new Dimension(800, 600));
        int v = 20;
        int h = 30;
        JScrollPane scrollPane = new JScrollPane(this.m_Canvas, v, h);
        this.getContentPane().add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel(new GridLayout());
        this.getContentPane().add((Component)buttonPanel, "North");
        double x1 = 10.0;
        double y1 = 10.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double newX = 5.0 * Math.cos(Math.atan2(y2 - y1, x2 - x1)) + x1;
        double newY = 5.0 * Math.sin(Math.atan2(y2 - y1, x2 - x1)) + y1;
        double x3 = (-x1 + newX) * Math.cos(1.5707963267948966) - (-y1 + newY) * Math.sin(1.5707963267948966) + x1;
        double y3 = (-x1 + newX) * Math.sin(1.5707963267948966) + (-y1 + newY) * Math.cos(1.5707963267948966) + y1;
        System.out.println(String.valueOf(x3) + " " + y3);
        JButton btn = this.addButton(buttonPanel, "Create MFrag");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UShapeFrame frame = new UShapeFrame(TestUGraphEditor.this.m_Canvas, new ProbabilisticNode(), 50, 50, 100, 100);
                ProbabilisticNode node = new ProbabilisticNode();
                node.setPosition(50.0, 50.0);
                node.appendState("State1");
                node.appendState("State2");
                node.appendState("State3");
                node.appendState("State4");
                node.setName("longname-longname-longname-longname-longname-longname-longname-longname");
                node.setDescription(node.getName());
                UShapeProbabilisticNode shape = new UShapeProbabilisticNode(TestUGraphEditor.this.m_Canvas, node, (int)node.getPosition().x - node.getWidth() / 2, (int)node.getPosition().y - node.getHeight() / 2, node.getWidth(), node.getHeight());
                frame.add(shape);
                ProbabilisticNode node2 = new ProbabilisticNode();
                node2.setPosition(160.0, 80.0);
                node2.appendState("firstStateProbabilisticName");
                node2.setName("123456789abcdefghijklmnopqrstuvwxyz");
                node2.setDescription(node2.getName());
                UShapeProbabilisticNode shape2 = new UShapeProbabilisticNode(TestUGraphEditor.this.m_Canvas, node2, (int)node2.getPosition().x - node2.getWidth() / 2, (int)node2.getPosition().y - node2.getHeight() / 2, node2.getWidth(), node2.getHeight());
                frame.add(shape2);
                TestUGraphEditor.this.m_Canvas.addShape(frame);
            }
        });
        btn = this.addButton(buttonPanel, "Create ProbabilisticNode");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProbabilisticNode node = new ProbabilisticNode();
                node.setPosition(50.0, 50.0);
                node.appendState("State1");
                node.appendState("State2");
                node.appendState("State3");
                node.appendState("State4");
                node.setName("longname-longname-longname-longname-longname-longname-longname-longname");
                node.setDescription(node.getName());
                PotentialTable auxTabProb = (PotentialTable)node.getProbabilityFunction();
                auxTabProb.addVariable(node);
                auxTabProb.setValue(0, 1.0f);
                UShapeProbabilisticNode shape = new UShapeProbabilisticNode(TestUGraphEditor.this.m_Canvas, node, (int)node.getPosition().x - node.getWidth() / 2, (int)node.getPosition().y - node.getHeight() / 2, node.getWidth(), node.getHeight());
                TestUGraphEditor.this.m_Canvas.addShape(shape);
                shape.setShapeType("Bar");
                ProbabilisticNode node2 = new ProbabilisticNode();
                node2.setPosition(160.0, 80.0);
                node2.appendState("firstStateProbabilisticName");
                node2.setName("123456789abcdefghijklmnopqrstuvwxyz");
                node2.setDescription(node2.getName());
                PotentialTable auxTabProb2 = (PotentialTable)node2.getProbabilityFunction();
                auxTabProb2.addVariable(node2);
                auxTabProb2.setValue(0, 1.0f);
                UShapeProbabilisticNode shape2 = new UShapeProbabilisticNode(TestUGraphEditor.this.m_Canvas, node2, (int)node2.getPosition().x - node2.getWidth() / 2, (int)node2.getPosition().y - node2.getHeight() / 2, node2.getWidth(), node2.getHeight());
                TestUGraphEditor.this.m_Canvas.addShape(shape2);
            }
        });
        btn = this.addButton(buttonPanel, "Create DLG");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestUGraphEditor.this.createColorChooser();
            }
        });
        btn = this.addButton(buttonPanel, "Create Frame");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < 100) {
                    TestUGraphEditor.this.m_Canvas.setFrame(110, 110, 220, 220);
                    ++i;
                }
            }
        });
        btn = this.addButton(buttonPanel, "Create Ellipse");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestUGraphEditor.this.m_Canvas.setEllipse(110, 110, 120, 120);
            }
        });
        btn = this.addButton(buttonPanel, "Create RoundRect");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestUGraphEditor.this.m_Canvas.setRoundRect(110, 110, 120, 120);
            }
        });
        btn = this.addButton(buttonPanel, "Create Trapezoid");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestUGraphEditor.this.m_Canvas.setTrapezoid(110, 110, 120, 120);
            }
        });
        btn = this.addButton(buttonPanel, "Select Node");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestUGraphEditor.this.m_Canvas.setState("None");
            }
        });
        btn = this.addButton(buttonPanel, "Connect Line");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestUGraphEditor.this.m_Canvas.setState("ConnectComponents");
            }
        });
    }

    public JButton addButton(JPanel buttonPanel, String Name) {
        JButton button = new JButton(Name);
        button.setEnabled(true);
        buttonPanel.add(button);
        return button;
    }

    public void createColorChooser() {
        final JColorChooser colorChooser = new JColorChooser();
        JLabel previewLabel = new JLabel("Color", 0);
        previewLabel.setFont(new Font("Serif", 3, 48));
        previewLabel.setSize(previewLabel.getPreferredSize());
        previewLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        colorChooser.setPreviewPanel(previewLabel);
        ActionListener okActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("OK Button");
                System.out.println(colorChooser.getColor().toString());
                TestUGraphEditor.this.repaint();
            }
        };
        ActionListener cancelActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("Cancel Button");
            }
        };
        JDialog dialog = JColorChooser.createDialog(null, "Change Button Background", true, colorChooser, okActionListener, cancelActionListener);
        dialog.setVisible(true);
    }

    public static void main(String[] argv) {
        TestUGraphEditor frame = new TestUGraphEditor();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        frame.setSize(800, 600);
    }

    public void windowStateChanged(WindowEvent arg0) {
    }
}

