/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLayeredPane;
import unbbayes.controller.NetworkController;
import unbbayes.draw.IEdgeHolderShape;
import unbbayes.draw.INodeHolderShape;
import unbbayes.draw.UShape;
import unbbayes.draw.UShapeBox;
import unbbayes.draw.UShapeDiamond;
import unbbayes.draw.UShapeEllipse;
import unbbayes.draw.UShapeFrame;
import unbbayes.draw.UShapeLine;
import unbbayes.draw.UShapePentagon;
import unbbayes.draw.UShapeRoundRect;
import unbbayes.draw.UShapeTrapezoid;
import unbbayes.prs.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UCanvas
extends JLayeredPane
implements MouseMotionListener,
MouseListener,
ComponentListener,
KeyListener {
    private static final long serialVersionUID = 3124079297866124183L;
    protected int layerID = 0;
    UShape rootShape;
    protected NetworkController controller;
    public static final String STATE_NONE = "None";
    public static final String STATE_RESIZE_COMP = "ResizeComponents";
    public static final String STATE_CONNECT_COMP = "ConnectComponents";
    public static final String STATE_UPDATE = "Update";
    public static final String STATE_CTRL = "Ctrl";
    public static final String NODE_ALIGN_BOTTOM = "NodeAlignBottom";
    public static final String NODE_ALIGN_TOP = "NodeAlignTop";
    public static final String NODE_ALIGN_LEFT = "NodeAlignLeft";
    public static final String NODE_ALIGN_RIGHT = "NodeAlignRight";
    public static final String NODE_ALIGN_VERTICAL = "NodeAlignVERTICAL";
    public static final String NODE_ALIGN_HORIZONTAL = "NodeAlignHORIZONTAL";
    public String m_state;
    public Rectangle resizeRect;
    public Rectangle dragRect;
    public Rectangle selectRect;
    public Point dragPoint;
    public String strTextOutputMode;
    public List<UShape> selectedShapes;
    public static final String TEXTOUTPUTMODEMODE_NONE = "None";
    public static final String TEXTOUTPUTMODEMODE_USE_NAME = "UseName";
    public static final String TEXTOUTPUTMODEMODE_USE_DESC = "UseDescription";
    public UShape shapeTest;
    protected int mouseX;
    protected int mouseY;

    public UCanvas() {
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addComponentListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.setState("None");
        this.selectedShapes = new ArrayList<UShape>();
        this.dragPoint = new Point(0, 0);
        this.dragRect = new Rectangle();
        this.selectRect = new Rectangle();
    }

    public void setTextOutputMode(String str) {
        this.strTextOutputMode = str;
    }

    public String getTextOutputMode() {
        return this.strTextOutputMode;
    }

    public void setState(String s) {
        this.m_state = s;
    }

    public String getState() {
        return this.m_state;
    }

    public UShape getNodeUShape(Node n) {
        int size = this.getComponentCount();
        int i = 0;
        while (i < size) {
            UShape shapeResult = null;
            UShape shape = (UShape)this.getComponent(i);
            shapeResult = this.getNodeUShape(shape, n);
            if (shapeResult != null) {
                return shapeResult;
            }
            if (shape.getNode() != null && (shape.getNode() == n || shape.getNode().equals(n))) {
                return shape;
            }
            ++i;
        }
        return null;
    }

    public UShape getNodeUShape(UShape parent, Node n) {
        if (parent == null) {
            return null;
        }
        int size = parent.getComponentCount();
        int i = 0;
        while (i < size) {
            UShape shape = (UShape)parent.getComponent(i);
            if (shape != null && shape.getNode() != null && (shape.getNode() == n || shape.getNode().equals(n))) {
                return shape;
            }
            ++i;
        }
        return null;
    }

    public void fitCanvasSizeToAllUShapes() {
        Dimension s = this.getSize();
        int size = this.getComponentCount();
        int i = 0;
        while (i < size) {
            UShape shape = (UShape)this.getComponent(i);
            Rectangle rc = shape.getBounds();
            s.width = Math.max(s.width, rc.x + rc.width);
            s.height = Math.max(s.height, rc.y + rc.height);
            ++i;
        }
        this.setPreferredSize(s);
        this.setSize(s);
    }

    public List<UShape> getSelectedShapes() {
        this.selectedShapes.clear();
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            if (shape.getState() == "Selected") {
                if (shape instanceof INodeHolderShape && ((INodeHolderShape)((Object)shape)).getNode() != null) {
                    this.selectedShapes.add(shape);
                }
                if (shape instanceof IEdgeHolderShape && ((IEdgeHolderShape)((Object)shape)).getEdge() != null) {
                    this.selectedShapes.add(shape);
                }
            }
            ++i;
        }
        return this.selectedShapes;
    }

    public void DeleteSelectedShape() {
        this.getSelectedShapes();
        int i = 0;
        while (i < this.selectedShapes.size()) {
            UShape shape = this.selectedShapes.get(i);
            if (shape instanceof UShape) {
                this.onShapeDeleted(shape);
                this.remove(shape);
            }
            ++i;
        }
        this.update();
    }

    public void update() {
    }

    public void onResized(UShape s) {
    }

    public void onPositionChanged(UShape s) {
        Dimension dim = this.getSize();
        if (!(s instanceof UShapeLine)) {
            if (s.getCenterX() + s.getWidth() > dim.width) {
                this.setPreferredSize(new Dimension(s.getCenterX() + s.getWidth(), dim.height));
                this.setSize(new Dimension(s.getCenterX() + s.getWidth(), dim.height));
            }
            if (s.getCenterY() + s.getHeight() > dim.height) {
                this.setPreferredSize(new Dimension(dim.width, s.getCenterY() + s.getHeight()));
                this.setSize(new Dimension(dim.width, s.getCenterY() + s.getHeight()));
            }
        }
    }

    public void onResizeToFitText() {
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            if (shape.getState() == "Selected") {
                shape.resizeToFitText();
                shape.repaint();
            }
            ++i;
        }
        this.updateLines();
    }

    public void onShapeColorChanged(Color c) {
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            if (shape.getState() == "Selected") {
                shape.setBackColor(c);
                shape.repaint();
            }
            ++i;
        }
    }

    public void onShapeTypeChanged(String s) {
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            if (shape.getState() == "Selected") {
                shape.shapeTypeChange(s);
                shape.repaint();
            }
            ++i;
        }
    }

    public void onShapeDeleted(UShape s) {
    }

    public void onShapeChanged(UShape s) {
    }

    public void onSelectionChanged() {
    }

    public void onAlignNodes(String str) {
        UShape shape;
        int left = 1000;
        int right = 0;
        int top = this.getBounds().height;
        int bottom = 0;
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            shape = (UShape)this.getComponent(i);
            if (shape.getState() == "Selected" && (str == NODE_ALIGN_LEFT || str == NODE_ALIGN_RIGHT || str == NODE_ALIGN_TOP || str == NODE_ALIGN_BOTTOM)) {
                left = Math.min(left, shape.getCenterX());
                right = Math.max(right, shape.getCenterX());
                top = Math.min(top, shape.getCenterY());
                bottom = Math.max(bottom, shape.getCenterY());
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            shape = (UShape)this.getComponent(i);
            if (shape.getState() == "Selected") {
                if (str == NODE_ALIGN_LEFT) {
                    shape.move(left - shape.getWidth() / 2, shape.getY());
                } else if (str == NODE_ALIGN_RIGHT) {
                    shape.move(right - shape.getWidth() / 2, shape.getY());
                } else if (str == NODE_ALIGN_TOP) {
                    shape.move(shape.getX(), top - shape.getHeight() / 2);
                } else if (str == NODE_ALIGN_BOTTOM) {
                    shape.move(shape.getX(), bottom - shape.getHeight() / 2);
                }
            }
            ++i;
        }
        this.onAlignNodes_HORIZONTAL(str);
        this.onAlignNodes_VERTICAL(str);
        this.updateLines();
    }

    public void onAlignNodes_VERTICAL(String str) {
        UShape shape;
        if (str != NODE_ALIGN_VERTICAL) {
            return;
        }
        int top = 0;
        int topOld = 0;
        int bottom = 0;
        int totalH = 0;
        int totalBoxH = 0;
        int totalGapH = 0;
        int GapH = 0;
        int moveH = 0;
        int n = this.getComponentCount();
        HashMap<Integer, UShape> ordered = new HashMap<Integer, UShape>();
        ArrayList<UShape> selected = new ArrayList<UShape>();
        int i = 0;
        while (i < n) {
            UShape shape2 = (UShape)this.getComponent(i);
            if (shape2.getState() == "Selected") {
                selected.add(shape2);
            }
            ++i;
        }
        i = 0;
        while (i < selected.size()) {
            top = Integer.MAX_VALUE;
            topOld = Integer.MAX_VALUE;
            for (UShape shape2 : selected) {
                if (ordered.containsValue(shape2)) continue;
                if (topOld != (top = Math.min(top, shape2.getY()))) {
                    ordered.put(i, shape2);
                }
                topOld = top;
            }
            ++i;
        }
        top = Integer.MAX_VALUE;
        bottom = Integer.MIN_VALUE;
        for (Integer i2 : ordered.keySet()) {
            shape = (UShape)ordered.get(i2);
            top = Math.min(top, shape.getCenterY() - shape.getHeight() / 2);
            bottom = Math.max(bottom, shape.getCenterY() + shape.getHeight() / 2);
            totalBoxH += shape.getHeight();
        }
        totalH = bottom - top;
        totalGapH = totalH - totalBoxH;
        GapH = totalGapH / (ordered.size() - 1);
        for (Integer i3 : ordered.keySet()) {
            shape = (UShape)ordered.get(i3);
            if (i3 == 0 || i3 == ordered.size() - 1) {
                moveH = shape.getCenterY() + shape.getHeight() / 2;
                continue;
            }
            shape.move(shape.getX(), moveH += GapH);
            moveH = shape.getCenterY() + shape.getHeight() / 2;
        }
    }

    public void onAlignNodes_HORIZONTAL(String str) {
        UShape shape;
        if (str != NODE_ALIGN_HORIZONTAL) {
            return;
        }
        int left = 0;
        int leftOld = 0;
        int right = 0;
        int totalW = 0;
        int totalBoxW = 0;
        int totalGapW = 0;
        int GapW = 0;
        int moveW = 0;
        int n = this.getComponentCount();
        HashMap<Integer, UShape> ordered = new HashMap<Integer, UShape>();
        ArrayList<UShape> selected = new ArrayList<UShape>();
        int i = 0;
        while (i < n) {
            UShape shape2 = (UShape)this.getComponent(i);
            if (shape2.getState() == "Selected") {
                selected.add(shape2);
            }
            ++i;
        }
        i = 0;
        while (i < selected.size()) {
            left = Integer.MAX_VALUE;
            leftOld = Integer.MAX_VALUE;
            for (UShape shape2 : selected) {
                if (ordered.containsValue(shape2)) continue;
                if (leftOld != (left = Math.min(left, shape2.getX()))) {
                    ordered.put(i, shape2);
                }
                leftOld = left;
            }
            ++i;
        }
        left = Integer.MAX_VALUE;
        right = Integer.MIN_VALUE;
        for (Integer i2 : ordered.keySet()) {
            shape = (UShape)ordered.get(i2);
            left = Math.min(left, shape.getCenterX() - shape.getWidth() / 2);
            right = Math.max(right, shape.getCenterX() + shape.getWidth() / 2);
            totalBoxW += shape.getWidth();
        }
        totalW = right - left;
        totalGapW = totalW - totalBoxW;
        GapW = totalGapW / (ordered.size() - 1);
        for (Integer i3 : ordered.keySet()) {
            shape = (UShape)ordered.get(i3);
            if (i3 == 0 || i3 == ordered.size() - 1) {
                moveW = shape.getCenterX() + shape.getWidth() / 2;
                continue;
            }
            shape.move(moveW += GapW, shape.getY());
            moveW = shape.getCenterX() + shape.getWidth() / 2;
        }
    }

    public Node getSelectedShapesNode() {
        UShape shape = this.getSelectedShape();
        if (shape != null) {
            return shape.getNode();
        }
        return null;
    }

    public UShape getSelectedShape() {
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            if (shape.getState() == "Selected") {
                return shape;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.getState() == STATE_UPDATE) {
            this.update();
            this.setState("None");
        } else if (this.getState() == STATE_RESIZE_COMP) {
            int n = this.getComponentCount();
            int i = 0;
            while (i < n) {
                UShape shape = (UShape)this.getComponent(i);
                if (shape.getState() == "Selected" && shape.checkLimitSize(this.resizeRect)) {
                    g.setColor(new Color(200, 200, 250));
                    g.fillRect(shape.getX() + this.resizeRect.x, shape.getY() + this.resizeRect.y, shape.getWidth() + this.resizeRect.width, shape.getHeight() + this.resizeRect.height);
                }
                ++i;
            }
        } else if (this.getState() == STATE_CONNECT_COMP) {
            int n = this.getComponentCount();
            int i = 0;
            while (i < n) {
                UShape shape = (UShape)this.getComponent(i);
                if (shape.getState() == "Selected" && this.dragPoint.x > 0 && this.dragPoint.x > 0) {
                    Line2D.Double line = new Line2D.Double(shape.getCenterX(), shape.getCenterY(), this.dragPoint.x, this.dragPoint.y);
                    g2.setStroke(UShape.dashed);
                    g2.setColor(new Color(200, 200, 250));
                    g2.draw(line);
                    g2.setStroke(UShape.stroke1);
                }
                ++i;
            }
        } else if (this.getState() == "None" && this.dragRect.x != 0 && this.dragRect.y != 0) {
            this.selectRect.setBounds((int)this.dragRect.getX(), (int)this.dragRect.getY(), (int)this.dragRect.getWidth(), (int)this.dragRect.getHeight());
            if (this.dragRect.getWidth() < 0.0) {
                this.selectRect.x = (int)(this.dragRect.getX() + this.dragRect.getWidth());
                this.selectRect.width = (int)Math.abs(this.dragRect.getWidth());
            }
            if (this.dragRect.getHeight() < 0.0) {
                this.selectRect.y = (int)(this.dragRect.getY() + this.dragRect.getHeight());
                this.selectRect.height = (int)Math.abs(this.dragRect.getHeight());
            }
            g.setColor(new Color(200, 200, 250));
            g.drawRect((int)this.selectRect.getX(), (int)this.selectRect.getY(), (int)this.selectRect.getWidth(), (int)this.selectRect.getHeight());
        }
    }

    public void setShapeStateAll(String s, Object o) {
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            shape.setState(s, o);
            this.setShapeStateAll(shape, s, o);
            ++i;
        }
        this.repaint();
    }

    public void setShapeStateAll(UShape parent, String s, Object o) {
        int n = parent.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)parent.getComponent(i);
            shape.setState(s, o);
            ++i;
        }
        this.repaint();
    }

    public void drawResizeRectEnter(Rectangle rc) {
        this.resizeRect = rc;
        this.setState(STATE_RESIZE_COMP);
        this.repaint();
    }

    public void drawResizeRectReleased(Rectangle rc) {
        this.resizeRect = rc;
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            if (shape.getState() == "Selected" && shape.checkLimitSize(this.resizeRect)) {
                shape.setNewSize(shape.getX() + this.resizeRect.x, shape.getY() + this.resizeRect.y, shape.getWidth() + this.resizeRect.width, shape.getHeight() + this.resizeRect.height);
            }
            ++i;
        }
        this.setState("None");
        this.repaint();
    }

    public void onShapeMoved(UShape shapeMoved, int x, int y) {
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            if (shape.getState() == "Selected" && shapeMoved != shape) {
                Point loc = shape.getLocation();
                shape.setNewSize(loc.x + x, loc.y + y, shape.getWidth(), shape.getHeight());
            }
            ++i;
        }
    }

    public void onDrawConnectLineEnter(int x, int y) {
        if (this.getState() == STATE_CONNECT_COMP) {
            this.dragPoint.x = x;
            this.dragPoint.y = y;
            this.repaint();
        }
    }

    public UShapeLine onDrawConnectLineReleased(UShape shapeParent, int x, int y) {
        UShapeLine line = null;
        if (this.getState() == STATE_CONNECT_COMP) {
            UShape shapeTarget = this.GetShape(x, y);
            if (shapeTarget != null) {
                line = this.connectLinesForAllSelectedShape(null, shapeTarget);
            }
            this.dragPoint.x = 0;
            this.dragPoint.y = 0;
        }
        this.repaint();
        return line;
    }

    public UShapeLine connectLinesForAllSelectedShape(UShape shapeParent, UShape shapeTarget) {
        UShapeLine line = null;
        int n = shapeParent != null ? shapeParent.getComponentCount() : this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = shapeParent != null ? (UShape)shapeParent.getComponent(i) : (UShape)this.getComponent(i);
            line = this.connectLinesForAllSelectedShape(shape, shapeTarget);
            if (line != null) {
                return line;
            }
            if (shape.getState() == "Selected") {
                line = new UShapeLine(this, shape, shapeTarget);
                this.addShape(line);
                return line;
            }
            ++i;
        }
        return line;
    }

    public UShape GetShape(int x, int y) {
        UShape shapeResult = this.GetShape(null, x, y);
        if (shapeResult != null) {
            return shapeResult;
        }
        return null;
    }

    public UShape GetShape(UShape parent, int x, int y) {
        int n = parent == null ? this.getComponentCount() : parent.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = parent == null ? (UShape)this.getComponent(i) : (UShape)parent.getComponent(i);
            UShape shapeChild = this.GetShape(shape, x, y);
            if (shapeChild != null) {
                return shapeChild;
            }
            if (shape.getState() == "None" && shape.contain(x, y)) {
                return shape;
            }
            ++i;
        }
        return null;
    }

    public void checkSelectArea() {
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            if (shape.getState() == "None" && shape.isContained(this.selectRect)) {
                shape.setState("Selected", null);
            }
            ++i;
        }
    }

    public UShape setRect(int x, int y, int width, int height) {
        UShapeBox shape = new UShapeBox(this, x, y, width, height);
        this.add((Component)shape, this.layerID++);
        return shape;
    }

    public UShape setEllipse(int x, int y, int width, int height) {
        UShapeEllipse shape = new UShapeEllipse(this, x, y, width, height);
        this.add((Component)shape, this.layerID++);
        return shape;
    }

    public UShape setFrame(int x, int y, int width, int height) {
        UShapeFrame shape = new UShapeFrame(this, null, x, y, width, height);
        this.add((Component)shape, this.layerID++);
        return shape;
    }

    public UShape setRoundRect(int x, int y, int width, int height) {
        UShapeRoundRect shape = new UShapeRoundRect(this, x, y, width, height);
        this.add((Component)shape, this.layerID++);
        return shape;
    }

    public UShape setTrapezoid(int x, int y, int width, int height) {
        UShapeTrapezoid shape = new UShapeTrapezoid(this, x, y, width, height);
        this.add((Component)shape, this.layerID++);
        return shape;
    }

    public UShape setPentagon(int x, int y, int width, int height) {
        UShapePentagon shape = new UShapePentagon(this, x, y, width, height);
        this.add((Component)shape, this.layerID++);
        return shape;
    }

    public UShape setDiamond(int x, int y, int width, int height) {
        UShapeDiamond shape = new UShapeDiamond(this, x, y, width, height);
        this.add((Component)shape, this.layerID++);
        return shape;
    }

    public void addShape(UShape shape) {
        this.add((Component)shape, this.layerID++);
    }

    public void delShape(UShape shape) {
        shape.finalize();
        this.remove(shape);
    }

    public void mouseDragged(int x, int y) {
        if (this.dragRect.x != 0 && this.dragRect.y != 0) {
            this.dragRect.width = x - this.dragRect.x;
            this.dragRect.height = y - this.dragRect.y;
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseDragged(e.getX(), e.getY());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.isFocusable();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(int x, int y) {
        if (this.dragRect.x == 0 && this.dragRect.y == 0) {
            this.dragRect.x = x;
            this.dragRect.y = y;
        }
        this.setShapeStateAll("None", null);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressed(e.getX(), e.getY());
    }

    public void mouseReleased(int x, int y) {
        if (this.dragRect.x != 0 && this.dragRect.y != 0) {
            this.checkSelectArea();
            this.dragRect.setBounds(0, 0, 0, 0);
            this.selectRect.setBounds(0, 0, 0, 0);
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseReleased(e.getX(), e.getY());
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
        this.setShapeStateAll("None", null);
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
        this.setShapeStateAll("None", null);
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
        this.setShapeStateAll("None", null);
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        if (arg0.isControlDown()) {
            this.setState(STATE_CTRL);
        }
        if (arg0.getKeyCode() == 127) {
            this.DeleteSelectedShape();
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        this.setState("None");
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public NetworkController getController() {
        return this.controller;
    }

    public void setController(NetworkController controller) {
        this.controller = controller;
    }

    protected void updateLines() {
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            if (shape instanceof UShapeLine) {
                shape.update();
                shape.repaint();
            }
            ++i;
        }
    }
}

