/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import unbbayes.draw.UCanvas;
import unbbayes.draw.UShapeFrame;
import unbbayes.draw.UShapeSizeBtn;
import unbbayes.gui.resources.GuiResources;
import unbbayes.prs.Node;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UShape
extends JComponent
implements ActionListener,
FocusListener,
MouseMotionListener,
MouseListener,
Cloneable,
ComponentListener {
    private static final long serialVersionUID = 2906022266659227068L;
    public Point pressedPoint;
    public String m_state;
    public String m_shapeType;
    public String m_label;
    public UCanvas m_canvas;
    protected Color backColor;
    protected Color lineColor;
    protected Color drawColor;
    protected int m_cursor;
    protected BasicStroke stroke;
    protected boolean bUseSelection;
    protected Node node = null;
    public static final int GAP = 10;
    public static final String STATE_NONE = "None";
    public static final String STATE_SELECTED = "Selected";
    public static final String STATE_WAIT_EDIT = "WaitEdit";
    public static final String STATE_RESIZED = "Resized";
    public static final String STATE_MOVE = "Move";
    public static final String STATE_UPDATE = "Update";
    public static final String STATE_CHANGECURSOR = "ChangeCursor";
    public static final String STYPE_NONE = "None";
    public static final String TTYPE_NONE = "None";
    public static final String TTYPE_CENTER = "Center Text";
    public static final String TTYPE_LEFT = "Left Text";
    public static final String TTYPE_RIGHT = "Right Texte";
    public static final String TTYPE_TOP = "Top Text";
    public static final String TTYPE_BOTTOM = "Bottom Text";
    protected UShapeSizeBtn shape1;
    protected UShapeSizeBtn shape2;
    protected UShapeSizeBtn shape3;
    protected UShapeSizeBtn shape4;
    protected UShapeSizeBtn shape5;
    protected UShapeSizeBtn shape6;
    protected UShapeSizeBtn shape7;
    protected UShapeSizeBtn shape8;
    protected JTextField textInput;
    protected Rectangle rectText;
    protected Rectangle rectTitle;
    public JPopupMenu popup = new JPopupMenu();
    protected String ID;
    protected static int nextId = 0;
    private List<UShape> friends;
    protected static Color m_tRed = new Color(255, 0, 0, 150);
    protected static Color m_tGreen = new Color(0, 255, 0, 150);
    protected static Color m_tBlue = new Color(0, 0, 255, 150);
    protected static Color m_tBlue2 = new Color(0, 0, 255, 50);
    protected static Color m_tYellow = new Color(255, 255, 50, 150);
    protected static Font m_biFont = new Font("Monospaced", 3, 36);
    protected static Font m_pFont = new Font("SanSerif", 0, 12);
    protected static Font m_bFont = new Font("Serif", 1, 24);
    static final BasicStroke stroke1 = new BasicStroke(1.0f);
    static final BasicStroke stroke2 = new BasicStroke(2.0f);
    static final BasicStroke stroke3 = new BasicStroke(3.0f);
    static final float[] dash1 = new float[]{10.0f};
    static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    static final float[] dash2 = new float[]{15.0f, 3.0f};
    static final BasicStroke dashed2 = new BasicStroke(1.0f, 0, 0, 10.0f, dash2, 0.0f);
    public static ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName());
    public static int iUpdate = 0;
    private Pattern nodeNamePattern = Node.DEFAULT_NODE_NAME_PATTERN;

    public UShape(UCanvas c, Node pNode, int x, int y, int w, int h) {
        this.createID();
        this.setName(this.ID);
        this.setLabel(this.ID);
        this.setCanvas(c);
        this.setState("None", null);
        this.setShapeType("None");
        this.setLineColor(Color.blue);
        this.setBackColor(Color.white);
        this.setStroke(stroke1);
        if (pNode != null) {
            this.setNode(pNode);
            this.updateNodeInformation();
        }
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addComponentListener(this);
        this.setUseSelection(true);
        this.setBounds(x, y, w, h);
        this.setOpaque(false);
        this.rectText = new Rectangle(0, 0, w, h);
        this.rectTitle = new Rectangle(0, 0, w, h);
        this.friends = new ArrayList<UShape>();
        this.pressedPoint = new Point();
    }

    public void finalize() {
    }

    public void updateNodeInformation() {
        if (this.getNode() != null) {
            this.setName(this.getNode().getName());
            if (this.getNode().getLabel() == null || this.getNode().getLabel().equals("")) {
                this.setLabel(this.getNode().getName());
            } else {
                this.setLabel(this.getNode().getLabel());
            }
            if (this.getCanvas().getTextOutputMode() == "UseName") {
                this.setLabel(this.getNode().getName());
            } else if (this.getCanvas().getTextOutputMode() == "UseDescription") {
                this.setLabel(this.getNode().getDescription());
            }
            this.setBackColor(this.getNode().getColor());
        }
    }

    public void update() {
    }

    public void shapeTypeChange(String s) {
    }

    public void createBasicPopupMenu() {
        this.popup.removeAll();
        JMenuItem item = new JMenuItem("Resize to fit text");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UShape.this.getCanvas().onResizeToFitText();
            }
        });
        JMenuItem item1 = new JMenuItem("Color Change");
        item1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UShape.this.createColorChooser();
            }
        });
        this.popup.add(item);
        this.popup.add(item1);
    }

    public void createPopupMenu() {
        this.createBasicPopupMenu();
        JMenuItem item2 = new JMenuItem("Node Align: Left");
        item2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UShape.this.getCanvas().onAlignNodes("NodeAlignLeft");
            }
        });
        JMenuItem item3 = new JMenuItem("Node Align: Right");
        item3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UShape.this.getCanvas().onAlignNodes("NodeAlignRight");
            }
        });
        JMenuItem item4 = new JMenuItem("Node Align: Top");
        item4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UShape.this.getCanvas().onAlignNodes("NodeAlignTop");
            }
        });
        JMenuItem item5 = new JMenuItem("Node Align: Bottom");
        item5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UShape.this.getCanvas().onAlignNodes("NodeAlignBottom");
            }
        });
        JMenuItem item6 = new JMenuItem("Node Distribution: Vertical ");
        item6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UShape.this.getCanvas().onAlignNodes("NodeAlignVERTICAL");
            }
        });
        JMenuItem item7 = new JMenuItem("Node Distribution: Horizontal");
        item7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UShape.this.getCanvas().onAlignNodes("NodeAlignHORIZONTAL");
            }
        });
        this.popup.add(item2);
        this.popup.add(item3);
        this.popup.add(item4);
        this.popup.add(item5);
        this.popup.add(item6);
        this.popup.add(item7);
    }

    public void createColorChooser() {
        final JColorChooser colorChooser = new JColorChooser();
        JLabel previewLabel = new JLabel("Color", 0);
        previewLabel.setFont(new Font("Serif", 3, 48));
        previewLabel.setSize(previewLabel.getPreferredSize());
        previewLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        colorChooser.setPreviewPanel(previewLabel);
        ActionListener okActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Debug.println(colorChooser.getColor().toString());
                UShape.this.getCanvas().onShapeColorChanged(colorChooser.getColor());
                UShape.this.repaint();
            }
        };
        ActionListener cancelActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        JDialog dialog = JColorChooser.createDialog(null, "Change Button Background", true, colorChooser, okActionListener, cancelActionListener);
        dialog.setVisible(true);
    }

    public void setLabel(String str) {
        this.m_label = str;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setUseSelection(boolean b) {
        this.bUseSelection = b;
    }

    public boolean getUseSelection() {
        return this.bUseSelection;
    }

    public void setState(String s, Object o) {
        this.m_state = s;
        if (this.getUseSelection()) {
            if (s == STATE_WAIT_EDIT) {
                this.createTextBox();
            } else if (s == STATE_UPDATE) {
                this.update();
                this.m_state = "None";
            } else if (s == STATE_SELECTED) {
                this.moveResizeBtn();
                this.removeTextBox();
                this.getCanvas().requestFocus();
            } else if (s == STATE_RESIZED) {
                this.moveResizeBtn();
                this.removeTextBox();
                this.update();
                this.m_state = STATE_SELECTED;
            } else if (s == STATE_CHANGECURSOR) {
                Cursor customCursor = (Cursor)o;
                this.setCursor(customCursor);
            } else if (s == "None") {
                this.hideResizeBtn();
                this.removeTextBox();
            }
        }
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color c) {
        this.lineColor = c;
        this.setDrawColor(c);
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color c) {
        if (this.node != null) {
            this.node.setColor(c);
        }
        this.backColor = c;
    }

    public void setBackColorWithoutNode(Color c) {
        this.backColor = c;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color c) {
        this.drawColor = c;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke c) {
        this.stroke = c;
    }

    public String getState() {
        return this.m_state;
    }

    public void setShapeType(String s) {
        this.m_shapeType = s;
    }

    public String getShapeType() {
        return this.m_shapeType;
    }

    public void setNode(Node n) {
        this.node = n;
    }

    public Node getNode() {
        return this.node;
    }

    public void setCanvas(UCanvas s) {
        this.m_canvas = s;
    }

    public UCanvas getCanvas() {
        return this.m_canvas;
    }

    public int getCursorStyle() {
        return this.m_cursor;
    }

    public void setCursor(int s) {
        this.m_cursor = s;
    }

    public void paint(Graphics2D graphics) {
        super.paintComponent(graphics);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getDrawColor());
    }

    public Rectangle getTextRect(String str) {
        int w = 30;
        int h = 20;
        if (str != null) {
            FontMetrics fm = this.getFontMetrics(m_pFont);
            w = fm.stringWidth(str);
            h = fm.getAscent();
        }
        Rectangle rect = new Rectangle(0, 0, w, h);
        return rect;
    }

    public void resizeToFitText() {
        String strName = this.getLabel();
        if (strName.equals("")) {
            strName = this.getName();
        }
        Rectangle rect = this.getTextRect(strName);
        this.setNewSize(this.getX(), this.getY(), (int)(rect.getWidth() + 50.0), Node.DEFAULT_SIZE.y);
    }

    public String checkLimitedTextSize(Graphics g, Rectangle rect, String str) {
        int w = 0;
        int h = 0;
        g.setFont(m_pFont);
        FontMetrics fm = g.getFontMetrics();
        w = fm.stringWidth(String.valueOf(str) + "#####");
        h = fm.getAscent();
        int l = str.length();
        if ((double)w > rect.getWidth()) {
            if (l - 1 <= 0) {
                return str;
            }
            str = str.substring(0, l - 1);
            str = this.checkLimitedTextSize(g, rect, str);
        }
        return str;
    }

    public String getLimitedTextSize(Graphics g, Rectangle rect, String str) {
        String strNew = this.checkLimitedTextSize(g, rect, str);
        if (strNew != str) {
            return String.valueOf(strNew) + "...";
        }
        return str;
    }

    public void drawText(Graphics g) {
        String strName = this.getLabel();
        if (strName.equals("")) {
            strName = this.getName();
        }
        this.drawText(g, new Rectangle(0, 0, this.getBounds().width, this.getBounds().height), strName, TTYPE_CENTER);
    }

    public void drawText(Graphics g, Rectangle rect) {
        String strName = this.getLabel();
        if (strName.equals("")) {
            strName = this.getName();
        }
        this.drawText(g, rect, strName, TTYPE_CENTER);
    }

    public void drawText(Graphics g, Rectangle rect, String strName, String strType) {
        if (!strName.equals("") && this.getState() != STATE_WAIT_EDIT) {
            String str = this.getLimitedTextSize(g, rect, strName);
            Rectangle rectStatic = this.getTextRect(str);
            int x = 0;
            int y = 0;
            int leftGap = 2;
            int topGap = 2;
            if (strType == TTYPE_CENTER) {
                x = (int)(rect.getWidth() / 2.0 - rectStatic.getWidth() / 2.0);
                y = (int)(rect.getHeight() / 2.0 - rectStatic.getHeight() / 2.0);
            } else if (strType == TTYPE_LEFT) {
                x = leftGap;
                y = (int)(rect.getHeight() / 2.0 - rectStatic.getHeight() / 2.0);
            } else if (strType == TTYPE_RIGHT) {
                x = (int)(rect.getWidth() - rectStatic.getWidth());
                y = topGap + (int)(rect.getHeight() / 2.0 - rectStatic.getHeight() / 2.0);
            }
            rectStatic.move((int)rect.getX() + x, (int)rect.getY() + y);
            g.drawString(str, (int)rectStatic.getX(), (int)rectStatic.getY() + (int)rectStatic.getHeight());
            this.rectText = rectStatic;
            if (this.getUseSelection() && this.getState() == STATE_SELECTED) {
                g.setColor(Color.blue);
                g.drawRoundRect(5, 5, this.getWidth() - 10 - 1, this.getHeight() - 10 - 1, 5, 5);
            }
        }
    }

    public void createTextBox() {
        if (this.textInput != null) {
            this.remove(this.textInput);
        }
        int widthGap = 20;
        Rectangle rect = this.getTextRect(this.getName());
        this.textInput = new JTextField(this.getName(), 10);
        this.textInput.setBounds(widthGap, (int)this.rectText.getY(), this.getWidth() - widthGap * 2, (int)this.rectText.getHeight() + 4);
        this.textInput.setBackground(Color.white);
        this.textInput.addActionListener(this);
        this.textInput.addFocusListener(this);
        this.add(this.textInput);
        this.textInput.requestFocusInWindow();
        this.repaint();
    }

    public void removeTextBox() {
        if (this.textInput != null) {
            boolean isValidName = true;
            this.setName(this.textInput.getText());
            if (this.node != null) {
                Matcher matcher = this.getNodeNamePattern().matcher(this.textInput.getText());
                if (matcher.matches()) {
                    this.node.setName(this.textInput.getText());
                } else {
                    this.textInput.setText(this.node.getName());
                    isValidName = false;
                }
                this.getCanvas().onShapeChanged(this);
            }
            this.remove(this.textInput);
            this.repaint();
            this.requestFocusInWindow();
            this.getCanvas().setState(STATE_UPDATE);
            this.getCanvas().onSelectionChanged();
            this.textInput = null;
            if (!isValidName) {
                JOptionPane.showMessageDialog(this.getParent(), resource.getString("nameError"), resource.getString("nameException"), 0);
            }
        }
    }

    public boolean createResizeBtn() {
        if (!this.getUseSelection()) {
            return false;
        }
        if (this.shape1 != null || this.shape2 != null || this.shape3 != null || this.shape4 != null || this.shape5 != null || this.shape6 != null || this.shape7 != null || this.shape8 != null) {
            this.removeResizeBtn();
        }
        this.shape1 = new UShapeSizeBtn(this, 0, 0, 6);
        this.shape2 = new UShapeSizeBtn(this, (this.getWidth() - 10) / 2, 0, 8);
        this.shape3 = new UShapeSizeBtn(this, this.getWidth() - 10, 0, 7);
        this.shape4 = new UShapeSizeBtn(this, 0, (this.getHeight() - 10) / 2, 11);
        this.shape5 = new UShapeSizeBtn(this, 0, this.getHeight() - 10, 4);
        this.shape6 = new UShapeSizeBtn(this, (this.getWidth() - 10) / 2, this.getHeight() - 10, 9);
        this.shape7 = new UShapeSizeBtn(this, this.getWidth() - 10, (this.getHeight() - 10) / 2, 10);
        this.shape8 = new UShapeSizeBtn(this, this.getWidth() - 10, this.getHeight() - 10, 5);
        return true;
    }

    public void moveResizeBtn() {
        if (this.shape1 == null) {
            this.createResizeBtn();
        }
        if (!this.shape1.isVisible()) {
            this.showResizeBtn();
        }
        this.shape1.move(0, 0);
        this.shape2.move((this.getWidth() - 10) / 2, 0);
        this.shape3.move(this.getWidth() - 10, 0);
        this.shape4.move(0, (this.getHeight() - 10) / 2);
        this.shape5.move(0, this.getHeight() - 10);
        this.shape6.move((this.getWidth() - 10) / 2, this.getHeight() - 10);
        this.shape7.move(this.getWidth() - 10, (this.getHeight() - 10) / 2);
        this.shape8.move(this.getWidth() - 10, this.getHeight() - 10);
    }

    public void showResizeBtn() {
        if (this.shape1 != null) {
            this.shape1.setVisible(true);
        }
        if (this.shape2 != null) {
            this.shape2.setVisible(true);
        }
        if (this.shape3 != null) {
            this.shape3.setVisible(true);
        }
        if (this.shape4 != null) {
            this.shape4.setVisible(true);
        }
        if (this.shape5 != null) {
            this.shape5.setVisible(true);
        }
        if (this.shape6 != null) {
            this.shape6.setVisible(true);
        }
        if (this.shape7 != null) {
            this.shape7.setVisible(true);
        }
        if (this.shape7 != null) {
            this.shape8.setVisible(true);
        }
    }

    public void hideResizeBtn() {
        if (this.shape1 != null) {
            this.shape1.setVisible(false);
        }
        if (this.shape2 != null) {
            this.shape2.setVisible(false);
        }
        if (this.shape3 != null) {
            this.shape3.setVisible(false);
        }
        if (this.shape4 != null) {
            this.shape4.setVisible(false);
        }
        if (this.shape5 != null) {
            this.shape5.setVisible(false);
        }
        if (this.shape6 != null) {
            this.shape6.setVisible(false);
        }
        if (this.shape7 != null) {
            this.shape7.setVisible(false);
        }
        if (this.shape7 != null) {
            this.shape8.setVisible(false);
        }
    }

    public void removeResizeBtn() {
        if (this.shape1 != null) {
            this.remove(this.shape1);
        }
        if (this.shape2 != null) {
            this.remove(this.shape2);
        }
        if (this.shape3 != null) {
            this.remove(this.shape3);
        }
        if (this.shape4 != null) {
            this.remove(this.shape4);
        }
        if (this.shape5 != null) {
            this.remove(this.shape5);
        }
        if (this.shape6 != null) {
            this.remove(this.shape6);
        }
        if (this.shape7 != null) {
            this.remove(this.shape7);
        }
        if (this.shape7 != null) {
            this.remove(this.shape8);
        }
    }

    public int getGlobalX() {
        int xParent = 0;
        if (this.getParent() instanceof UShapeFrame) {
            xParent = this.getParent().getX();
        }
        return xParent + this.getX();
    }

    public int getGlobalY() {
        int yParent = 0;
        if (this.getParent() instanceof UShapeFrame) {
            yParent = this.getParent().getY();
        }
        return yParent + this.getY();
    }

    public int getCenterX() {
        return this.getGlobalX() + this.getWidth() / 2;
    }

    public int getCenterY() {
        return this.getGlobalY() + this.getHeight() / 2;
    }

    public Rectangle getShapeRect() {
        Rectangle rc = this.getBounds();
        return new Rectangle(rc.x + 10, rc.y + 10, rc.width - 20, rc.height - 20);
    }

    public boolean checkLimitSize(Rectangle rc) {
        Rectangle rcCheck = new Rectangle(this.getX() + rc.x, this.getY() + rc.y, this.getWidth() + rc.width, this.getHeight() + rc.height);
        return rcCheck.height >= 15 && rcCheck.width >= 45;
    }

    public boolean contain(double x, double y) {
        return false;
    }

    public boolean isContained(Rectangle rc) {
        return rc.contains(this.getShapeRect());
    }

    public UShape checkContainer() {
        int n = this.getCanvas().getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getCanvas().getComponent(i);
            if (shape != this && shape instanceof UShapeFrame && this.isContained(shape.getBounds())) {
                return shape;
            }
            ++i;
        }
        return null;
    }

    public boolean checkExactEdge(Graphics g, UShape shapeDes, Point2D.Double pSrcResult, Point2D.Double pDesResult) {
        block43: {
            double yPrev;
            double xPrev;
            double y;
            double x;
            double ratio;
            double yOri;
            double xOri;
            double yDes;
            double xDes;
            double ySrc;
            double xSrc;
            block44: {
                block45: {
                    block41: {
                        block42: {
                            xSrc = this.getCenterX();
                            ySrc = this.getCenterY();
                            xDes = shapeDes.getCenterX();
                            yDes = shapeDes.getCenterY();
                            xOri = xSrc;
                            yOri = ySrc;
                            ratio = 0.0;
                            x = 0.0;
                            y = 0.0;
                            xPrev = 0.0;
                            yPrev = 0.0;
                            ySrc -= yOri;
                            yDes -= yOri;
                            if ((xSrc -= xOri) != (xDes -= xOri)) break block41;
                            if (!(ySrc > yDes)) break block42;
                            y = 0.0;
                            while (y > yDes) {
                                if (!this.contain(xOri + x, yOri + y) && pSrcResult.x == 0.0 && pSrcResult.y == 0.0) {
                                    pSrcResult.x = (int)(xOri + x);
                                    pSrcResult.y = (int)(yOri + y);
                                }
                                if (shapeDes.contain(xOri + x, yOri + y) && pDesResult.x == 0.0 && pDesResult.y == 0.0) {
                                    pDesResult.x = (int)(xOri + xPrev);
                                    pDesResult.y = (int)(yOri + yPrev);
                                }
                                xPrev = x;
                                yPrev = y;
                                y -= 1.0;
                            }
                            break block43;
                        }
                        if (!(ySrc < yDes)) break block43;
                        y = 0.0;
                        while (y < yDes) {
                            if (!this.contain(xOri + x, yOri + y) && pSrcResult.x == 0.0 && pSrcResult.y == 0.0) {
                                pSrcResult.x = (int)(xOri + x);
                                pSrcResult.y = (int)(yOri + y);
                            }
                            if (shapeDes.contain(xOri + x, yOri + y) && pDesResult.x == 0.0 && pDesResult.y == 0.0) {
                                pDesResult.x = (int)(xOri + xPrev);
                                pDesResult.y = (int)(yOri + yPrev);
                            }
                            xPrev = x;
                            yPrev = y;
                            y += 1.0;
                        }
                        break block43;
                    }
                    if (ySrc != yDes) break block44;
                    if (!(xSrc > xDes)) break block45;
                    x = 0.0;
                    while (x > xDes) {
                        if (!this.contain(xOri + x, yOri + y) && pSrcResult.x == 0.0 && pSrcResult.y == 0.0) {
                            pSrcResult.x = (int)(xOri + x);
                            pSrcResult.y = (int)(yOri + y);
                        }
                        if (shapeDes.contain(xOri + x, yOri + y) && pDesResult.x == 0.0 && pDesResult.y == 0.0) {
                            pDesResult.x = (int)(xOri + xPrev);
                            pDesResult.y = (int)(yOri + yPrev);
                        }
                        xPrev = x;
                        yPrev = y;
                        x -= 1.0;
                    }
                    break block43;
                }
                if (!(xSrc < xDes)) break block43;
                x = 0.0;
                while (x < xDes) {
                    if (!this.contain(xOri + x, yOri + y) && pSrcResult.x == 0.0 && pSrcResult.y == 0.0) {
                        pSrcResult.x = (int)(xOri + x);
                        pSrcResult.y = (int)(yOri + y);
                    }
                    if (shapeDes.contain(xOri + x, yOri + y) && pDesResult.x == 0.0 && pDesResult.y == 0.0) {
                        pDesResult.x = (int)(xOri + xPrev);
                        pDesResult.y = (int)(yOri + yPrev);
                    }
                    xPrev = x;
                    yPrev = y;
                    x += 1.0;
                }
                break block43;
            }
            if (xSrc > xDes) {
                ratio = (ySrc - yDes) / (xSrc - xDes);
                if (ratio > 1.0) {
                    ratio = (xSrc - xDes) / (ySrc - yDes);
                    x = 0.0;
                    y = 0.0;
                    while (y > yDes) {
                        if (!this.contain(xOri + x, yOri + y) && pSrcResult.x == 0.0 && pSrcResult.y == 0.0) {
                            pSrcResult.x = (int)(xOri + x);
                            pSrcResult.y = (int)(yOri + y);
                        }
                        if (shapeDes.contain(xOri + x, yOri + y) && pDesResult.x == 0.0 && pDesResult.y == 0.0) {
                            pDesResult.x = (int)(xOri + xPrev);
                            pDesResult.y = (int)(yOri + yPrev);
                        }
                        xPrev = x;
                        yPrev = y;
                        x = (int)(ratio * y);
                        y -= 1.0;
                    }
                } else if (ratio < -1.0) {
                    ratio = (xSrc - xDes) / (ySrc - yDes);
                    x = 0.0;
                    y = 0.0;
                    while (y < yDes) {
                        if (!this.contain(xOri + x, yOri + y) && pSrcResult.x == 0.0 && pSrcResult.y == 0.0) {
                            pSrcResult.x = (int)(xOri + x);
                            pSrcResult.y = (int)(yOri + y);
                        }
                        if (shapeDes.contain(xOri + x, yOri + y) && pDesResult.x == 0.0 && pDesResult.y == 0.0) {
                            pDesResult.x = (int)(xOri + xPrev);
                            pDesResult.y = (int)(yOri + yPrev);
                        }
                        xPrev = x;
                        yPrev = y;
                        x = (int)(ratio * y);
                        y += 1.0;
                    }
                } else {
                    x = 0.0;
                    y = 0.0;
                    while (x > xDes) {
                        if (!this.contain(xOri + x, yOri + y) && pSrcResult.x == 0.0 && pSrcResult.y == 0.0) {
                            pSrcResult.x = (int)(xOri + x);
                            pSrcResult.y = (int)(yOri + y);
                        }
                        if (shapeDes.contain(xOri + x, yOri + y) && pDesResult.x == 0.0 && pDesResult.y == 0.0) {
                            pDesResult.x = (int)(xOri + xPrev);
                            pDesResult.y = (int)(yOri + yPrev);
                        }
                        xPrev = x;
                        yPrev = y;
                        y = (int)(ratio * x);
                        x -= 1.0;
                    }
                }
            } else if (xSrc < xDes) {
                ratio = (yDes - ySrc) / (xDes - xSrc);
                if (ratio < -1.0) {
                    ratio = (xSrc - xDes) / (ySrc - yDes);
                    x = 0.0;
                    y = 0.0;
                    while (y > yDes) {
                        if (!this.contain(xOri + x, yOri + y) && pSrcResult.x == 0.0 && pSrcResult.y == 0.0) {
                            pSrcResult.x = (int)(xOri + x);
                            pSrcResult.y = (int)(yOri + y);
                        }
                        if (shapeDes.contain(xOri + x, yOri + y) && pDesResult.x == 0.0 && pDesResult.y == 0.0) {
                            pDesResult.x = (int)(xOri + xPrev);
                            pDesResult.y = (int)(yOri + yPrev);
                        }
                        xPrev = x;
                        yPrev = y;
                        x = (int)(ratio * y);
                        y -= 1.0;
                    }
                } else if (ratio > 1.0) {
                    ratio = (xSrc - xDes) / (ySrc - yDes);
                    x = 0.0;
                    y = 0.0;
                    while (y < yDes) {
                        if (!this.contain(xOri + x, yOri + y) && pSrcResult.x == 0.0 && pSrcResult.y == 0.0) {
                            pSrcResult.x = (int)(xOri + x);
                            pSrcResult.y = (int)(yOri + y);
                        }
                        if (shapeDes.contain(xOri + x, yOri + y) && pDesResult.x == 0.0 && pDesResult.y == 0.0) {
                            pDesResult.x = (int)(xOri + xPrev);
                            pDesResult.y = (int)(yOri + yPrev);
                        }
                        xPrev = x;
                        yPrev = y;
                        x = (int)(ratio * y);
                        y += 1.0;
                    }
                } else {
                    x = 0.0;
                    y = 0.0;
                    while (x < xDes) {
                        if (!this.contain(xOri + x, yOri + y) && pSrcResult.x == 0.0 && pSrcResult.y == 0.0) {
                            pSrcResult.x = (int)(xOri + x);
                            pSrcResult.y = (int)(yOri + y);
                        }
                        if (shapeDes.contain(xOri + x, yOri + y) && pDesResult.x == 0.0 && pDesResult.y == 0.0) {
                            pDesResult.x = (int)(xOri + xPrev);
                            pDesResult.y = (int)(yOri + yPrev);
                        }
                        xPrev = x;
                        yPrev = y;
                        y = (int)(ratio * x);
                        x += 1.0;
                    }
                }
            }
        }
        return (pSrcResult.x != 0.0 || pSrcResult.y != 0.0) && (pDesResult.x != 0.0 || pDesResult.y != 0.0);
    }

    public Object clone() {
        UShape clone = new UShape(this.m_canvas, null, 0, 0, 30, 30);
        return clone;
    }

    protected void createID() {
        this.ID = String.valueOf(nextId++);
    }

    protected void addFriend(UShape friend) {
        this.friends.add(friend);
    }

    protected void removeFriend(UShape friend) {
        this.friends.remove(friend);
    }

    public List<UShape> getFriends() {
        return this.friends;
    }

    public Object getChild(String id) {
        Object result = null;
        return result;
    }

    public void sendMessageToFriends(String Msg) {
        for (UShape shape : this.friends) {
            if (shape == null) continue;
            shape.receiveMessage(Msg);
        }
    }

    public void receiveMessage(String Msg) {
    }

    public void setNewSize(int x, int y, int w, int h) {
        this.setBounds(x, y, w, h);
        this.setState(STATE_RESIZED, null);
        this.sendMessageToFriends(STATE_MOVE);
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            shape.update();
            shape.sendMessageToFriends(STATE_MOVE);
            ++i;
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        super.setBounds(x, y, width, height);
    }

    public Object[] cloneChildren(Object[] children, boolean includeChildren) {
        Hashtable mapping = new Hashtable();
        Object[] clones = new Object[children.length];
        int i = 0;
        while (i < children.length) {
            ++i;
        }
        i = 0;
        while (i < children.length) {
            ++i;
        }
        return clones;
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        if (!this.getUseSelection()) {
            this.getCanvas().mouseDragged(arg0.getX() + this.getGlobalX(), arg0.getY() + this.getGlobalY());
        } else if (this.getUseSelection()) {
            Point loc = this.getLocation();
            Rectangle rc = this.getBounds();
            if (this.contain(this.pressedPoint.x + loc.x, this.pressedPoint.y + loc.y)) {
                if (this.m_canvas.getState() == "ResizeComponents" || this.m_canvas.getState() == "None") {
                    this.setNewSize(loc.x - this.pressedPoint.x + arg0.getX(), loc.y - this.pressedPoint.y + arg0.getY(), rc.width, rc.height);
                    this.getCanvas().onShapeMoved(this, -this.pressedPoint.x + arg0.getX(), -this.pressedPoint.y + arg0.getY());
                } else if (this.m_canvas.getState() == "ConnectComponents") {
                    this.getCanvas().onDrawConnectLineEnter(loc.x + arg0.getX(), loc.y + arg0.getY());
                }
                this.getCanvas().repaint();
            }
        }
    }

    public void changeToLocalPosition(Point2D.Double p) {
        p.x -= (double)this.getLocation().x;
        p.y -= (double)this.getLocation().y;
    }

    public void changeToGlobalPosition(Point2D.Double p) {
        p.x += (double)this.getLocation().x;
        p.y += (double)this.getLocation().y;
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        Point2D.Double p = new Point2D.Double(arg0.getX(), arg0.getY());
        this.changeToGlobalPosition(p);
        if (this.contain(p.x, p.y)) {
            this.setDrawColor(Color.red);
            this.repaint();
        } else {
            this.setDrawColor(this.getLineColor());
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        if (SwingUtilities.isLeftMouseButton(arg0) && arg0.getClickCount() == 2 && !arg0.isConsumed()) {
            arg0.consume();
            this.setState(STATE_WAIT_EDIT, null);
        }
        SwingUtilities.isMiddleMouseButton(arg0);
        if (SwingUtilities.isRightMouseButton(arg0)) {
            this.createPopupMenu();
            this.popup.setEnabled(true);
            this.popup.show(arg0.getComponent(), arg0.getX(), arg0.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        Point2D.Double p = new Point2D.Double(arg0.getX(), arg0.getY());
        this.changeToGlobalPosition(p);
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.setDrawColor(this.getLineColor());
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.pressedPoint.x = arg0.getX();
        this.pressedPoint.y = arg0.getY();
        UCanvas uCanvas = this.getCanvas();
        this.getCanvas();
        uCanvas.setLayer(this, UCanvas.DRAG_LAYER);
        if (this.getParent() instanceof UShapeFrame) {
            Point loc = this.getLocation();
            Point locFrame = this.getParent().getLocation();
            this.move(loc.x + locFrame.x, loc.y + locFrame.y);
            this.getCanvas().add(this);
        }
        if (this.getCanvas().getState() == "Ctrl") {
            if (this.getState() != STATE_SELECTED) {
                this.setState(STATE_SELECTED, null);
                this.getCanvas().onShapeChanged(this);
                this.getCanvas().onSelectionChanged();
            } else {
                this.setState("None", null);
                this.getCanvas().onShapeChanged(this);
                this.getCanvas().onSelectionChanged();
            }
        } else if (this.getState() != STATE_SELECTED) {
            Point2D.Double p = new Point2D.Double(arg0.getX(), arg0.getY());
            this.changeToGlobalPosition(p);
            if (this.contain(p.x, p.y)) {
                this.getCanvas().setShapeStateAll("None", null);
                this.setState(STATE_SELECTED, null);
                this.getCanvas().onShapeChanged(this);
                this.getCanvas().onSelectionChanged();
            }
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        Point loc = this.getLocation();
        Rectangle rc = this.getBounds();
        UShape shapeFrame = this.checkContainer();
        if (shapeFrame != null) {
            Point locFrame = shapeFrame.getLocation();
            this.move(loc.x - locFrame.x, loc.y - locFrame.y);
            shapeFrame.add(this);
        }
        if (this.getCanvas().getState() == "ConnectComponents") {
            this.getCanvas().onDrawConnectLineReleased(this, this.getGlobalX() + arg0.getX(), this.getGlobalY() + arg0.getY());
        }
        if (shapeFrame != null) {
            this.setState("None", null);
        }
        SwingUtilities.isRightMouseButton(arg0);
        if (!this.getUseSelection()) {
            this.getCanvas().mouseReleased(arg0.getX() + this.getGlobalX(), arg0.getY() + this.getGlobalY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.removeTextBox();
        this.setState(STATE_SELECTED, null);
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.removeTextBox();
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
        if (this.node != null) {
            this.node.setPosition(this.getX(), this.getY());
        }
        this.getCanvas().onPositionChanged(this);
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        if (this.node != null) {
            this.node.setSize(this.getWidth(), this.getHeight());
        }
        if (this.getCanvas() != null) {
            this.getCanvas().onResized(this);
        }
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    public Pattern getNodeNamePattern() {
        return this.nodeNamePattern;
    }

    public void setNodeNamePattern(Pattern nodeNamePattern) {
        this.nodeNamePattern = nodeNamePattern;
    }
}

