/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import unbbayes.draw.IEdgeHolderShape;
import unbbayes.draw.UCanvas;
import unbbayes.draw.UShape;
import unbbayes.draw.UShapeSizeBtn;
import unbbayes.prs.Edge;
import unbbayes.util.GeometricUtil;

public class UShapeLine
extends UShape
implements IEdgeHolderShape {
    private static final long serialVersionUID = -783952885037303240L;
    protected Line2D line;
    protected UShape shapeSource;
    protected UShape shapeTarget;
    protected Point2D.Double pSource;
    protected Point2D.Double pTarget;
    protected boolean learningLineSelection;
    private int direction = 0;
    protected Edge edge;
    protected JPopupMenu popupLine = new JPopupMenu();
    protected GeneralPath parallelogram;

    public UShapeLine(UCanvas c, UShape source, UShape target) {
        super(c, null, 0, 0, 0, 0);
        this.learningLineSelection = false;
        this.shapeSource = source;
        this.shapeTarget = target;
        source.addFriend(this);
        target.addFriend(this);
        this.pSource = new Point2D.Double(0.0, 0.0);
        this.pTarget = new Point2D.Double(0.0, 0.0);
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        this.update();
        JMenuItem item = new JMenuItem("Line Size: 1");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UShapeLine.this.setStroke(stroke1);
                UShapeLine.this.repaint();
            }
        });
        JMenuItem item1 = new JMenuItem("Line Size: 2");
        item1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UShapeLine.this.setStroke(stroke2);
                UShapeLine.this.repaint();
            }
        });
        JMenuItem item2 = new JMenuItem("Line Size: 3");
        item2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UShapeLine.this.setStroke(stroke3);
                UShapeLine.this.repaint();
            }
        });
        JMenuItem item4 = new JMenuItem("Line Shape: Dash");
        item4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UShapeLine.this.setStroke(dashed);
                UShapeLine.this.repaint();
            }
        });
        JMenuItem item5 = new JMenuItem("Line Shape: Dash2");
        item5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UShapeLine.this.setStroke(dashed2);
                UShapeLine.this.repaint();
            }
        });
        this.popupLine.add(item);
        this.popupLine.add(item1);
        this.popupLine.add(item2);
        this.popupLine.add(item4);
        this.popupLine.add(item5);
    }

    public void finalize() {
        this.shapeSource.removeFriend(this);
        this.shapeTarget.removeFriend(this);
    }

    public UShapeLine(UCanvas c, int x, int y, int w, int h) {
        super(c, null, x, y, w, h);
    }

    public void setEdge(Edge n) {
        this.edge = n;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public UShape getSource() {
        return this.shapeSource;
    }

    public UShape getTarget() {
        return this.shapeTarget;
    }

    public void update() {
        super.update();
        this.pSource.x = 0.0;
        this.pSource.y = 0.0;
        this.pTarget.x = 0.0;
        this.pTarget.y = 0.0;
        if (this.shapeSource.checkExactEdge(null, this.shapeTarget, this.pSource, this.pTarget)) {
            this.setBounds((int)Math.min(this.pSource.x, this.pTarget.x) - 10, (int)Math.min(this.pSource.y, this.pTarget.y) - 10, (int)Math.abs(this.pTarget.x - this.pSource.x) + 20, (int)Math.abs(this.pTarget.y - this.pSource.y) + 20);
            this.changeToLocalPosition(this.pSource);
            this.changeToLocalPosition(this.pTarget);
            double x1 = this.shapeSource.getCenterX() - this.getX();
            double y1 = this.shapeSource.getCenterY() - this.getY();
            double x2 = this.shapeTarget.getCenterX() - this.getX();
            double y2 = this.shapeTarget.getCenterY() - this.getY();
            double newX = 5.0 * Math.cos(Math.atan2(y2 - y1, x2 - x1)) + x1;
            double newY = 5.0 * Math.sin(Math.atan2(y2 - y1, x2 - x1)) + y1;
            double x4 = (-x1 + newX) * Math.cos(-1.5707963267948966) - (-y1 + newY) * Math.sin(-1.5707963267948966) + x1;
            double y4 = (-x1 + newX) * Math.sin(-1.5707963267948966) + (-y1 + newY) * Math.cos(-1.5707963267948966) + y1;
            double x5 = (-x1 + newX) * Math.cos(1.5707963267948966) - (-y1 + newY) * Math.sin(1.5707963267948966) + x1;
            double y5 = (-x1 + newX) * Math.sin(1.5707963267948966) + (-y1 + newY) * Math.cos(1.5707963267948966) + y1;
            newX = 5.0 * Math.cos(Math.atan2(y1 - y2, x1 - x2)) + x2;
            newY = 5.0 * Math.sin(Math.atan2(y1 - y2, x1 - x2)) + y2;
            double x6 = (-x2 + newX) * Math.cos(-1.5707963267948966) - (-y2 + newY) * Math.sin(-1.5707963267948966) + x2;
            double y6 = (-x2 + newX) * Math.sin(-1.5707963267948966) + (-y2 + newY) * Math.cos(-1.5707963267948966) + y2;
            double x7 = (-x2 + newX) * Math.cos(1.5707963267948966) - (-y2 + newY) * Math.sin(1.5707963267948966) + x2;
            double y7 = (-x2 + newX) * Math.sin(1.5707963267948966) + (-y2 + newY) * Math.cos(1.5707963267948966) + y2;
            this.parallelogram = new GeneralPath();
            this.parallelogram.moveTo((float)x4, (float)y4);
            this.parallelogram.lineTo((float)x5, (float)y5);
            this.parallelogram.lineTo((float)x6, (float)y6);
            this.parallelogram.lineTo((float)x7, (float)y7);
            this.parallelogram.closePath();
        }
        this.repaint();
    }

    public void receiveMessage(String Msg) {
        if (Msg == "Move") {
            this.update();
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.line.setLine(this.pSource.x, this.pSource.y, this.pTarget.x, this.pTarget.y);
        g2.setStroke(this.getStroke());
        g2.draw(this.line);
        if (this.getUseSelection()) {
            if (this.getDirection() != 0) {
                this.drawArrow(g2);
            }
        } else if (!this.getUseSelection()) {
            this.drawArrow(g2);
        }
    }

    public void drawArrow(Graphics2D g) {
        double y4;
        double x4;
        double y3;
        double x3;
        GeneralPath arrow = new GeneralPath();
        double x1 = this.pSource.x;
        double y1 = this.pSource.y;
        double x2 = this.pTarget.x;
        double y2 = this.pTarget.y;
        Point2D.Double size = new Point2D.Double(2.0, 2.0);
        Point2D.Double point1 = GeometricUtil.getCircunferenceTangentPoint(this.pTarget, this.pSource, 10.0);
        if (x1 > x2 && y1 > y2 || x1 < x2 && y1 < y2) {
            x3 = point1.x + 5.0 * Math.abs(Math.cos(Math.atan((x2 - x1) / (y1 - y2))));
            y3 = point1.y - 5.0 * Math.abs(Math.sin(Math.atan((x2 - x1) / (y1 - y2))));
            x4 = point1.x - 5.0 * Math.abs(Math.cos(Math.atan((x2 - x1) / (y1 - y2))));
            y4 = point1.y + 5.0 * Math.abs(Math.sin(Math.atan((x2 - x1) / (y1 - y2))));
        } else {
            x3 = point1.x + 5.0 * Math.cos(Math.atan((x1 - x2) / (y1 - y2)));
            y3 = point1.y - 5.0 * Math.sin(Math.atan((x1 - x2) / (y1 - y2)));
            x4 = point1.x - 5.0 * Math.cos(Math.atan((x1 - x2) / (y1 - y2)));
            y4 = point1.y + 5.0 * Math.sin(Math.atan((x1 - x2) / (y1 - y2)));
        }
        arrow.moveTo((float)x3, (float)y3);
        arrow.lineTo((float)x2, (float)y2);
        arrow.lineTo((float)x4, (float)y4);
        arrow.lineTo((float)x3, (float)y3);
        g.fill(arrow);
        g.setStroke(new BasicStroke(1.0f));
    }

    public boolean contain(double x, double y) {
        return this.parallelogram.contains(x - (double)this.getGlobalX(), y - (double)this.getGlobalY());
    }

    public void changeDirection() {
        UShape shapeTemp2;
        UShape shapeTemp1 = this.shapeSource;
        this.shapeSource = shapeTemp2 = this.shapeTarget;
        this.shapeTarget = shapeTemp1;
        this.update();
    }

    public void mousePressed(MouseEvent arg0) {
        super.mousePressed(arg0);
        this.getCanvas().setShapeStateAll("None", null);
        this.setState("Selected", null);
        this.getCanvas().onShapeChanged(this);
        this.getCanvas().onSelectionChanged();
    }

    public void mouseClicked(MouseEvent arg0) {
        if (SwingUtilities.isLeftMouseButton(arg0) && this.getLearningLineSelection() && this.edge != null) {
            if (this.getDirection() == 0 || this.getDirection() == 1) {
                this.setDirection(this.getDirection() + 1);
                this.edge.setDirection(true);
                this.edge.changeDirection();
                this.changeDirection();
            } else if (this.getDirection() == 2) {
                this.setDirection(0);
                this.edge.setDirection(false);
                this.update();
            }
        }
        if (SwingUtilities.isRightMouseButton(arg0)) {
            this.popupLine.setEnabled(true);
            this.popupLine.show(this.getCanvas(), arg0.getX(), arg0.getY());
        }
    }

    public int getDirection() {
        this.direction = this.edge == null || !this.edge.hasDirection() ? 0 : 1;
        return this.direction;
    }

    public boolean createResizeBtn() {
        if (!this.getUseSelection()) {
            return false;
        }
        if (this.shape1 != null || this.shape2 != null) {
            this.removeResizeBtn();
        }
        this.shape1 = new UShapeSizeBtn(this, (int)this.pSource.x - 5, (int)this.pSource.y - 5, 13);
        this.shape2 = new UShapeSizeBtn(this, (int)this.pTarget.x - 5, (int)this.pTarget.y - 5, 13);
        return true;
    }

    public void moveResizeBtn() {
        if (this.shape1 == null && !this.createResizeBtn()) {
            return;
        }
        if (!this.shape1.isVisible()) {
            this.showResizeBtn();
        }
        this.shape1.move((int)this.pSource.x - 5, (int)this.pSource.y - 5);
        this.shape2.move((int)this.pTarget.x - 5, (int)this.pTarget.y - 5);
    }

    public void setLearningLineSelection(boolean b) {
        this.learningLineSelection = b;
    }

    public boolean getLearningLineSelection() {
        return this.learningLineSelection;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }
}

