/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import unbbayes.draw.INodeHolderShape;
import unbbayes.draw.UCanvas;
import unbbayes.draw.UShape;
import unbbayes.draw.UShapeState;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.TreeVariable;

public class UShapeProbabilisticNode
extends UShape
implements INodeHolderShape {
    private static final long serialVersionUID = 1848727135580831185L;
    protected Ellipse2D ellipse;
    protected Rectangle2D rect;
    protected UShapeState stateShape;
    protected int stateHeight = 18;
    protected String finding;
    protected Color[] stateColor = new Color[]{Color.BLUE, Color.RED, Color.GREEN, Color.ORANGE, Color.CYAN, Color.DARK_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.YELLOW};
    public static final String STYPE_BAR = "Bar";

    public UShapeProbabilisticNode(UCanvas c, Node pNode, int x, int y, int w, int h) {
        super(c, pNode, x, y, w, h);
        if (pNode != null) {
            if (pNode.getDisplayMode() == "Display Mode Ellipse") {
                this.shapeTypeChange("None");
            } else if (pNode.getDisplayMode() == "Display Mode BAR") {
                this.shapeTypeChange(STYPE_BAR);
            }
        }
        this.InitShape();
    }

    public void InitShape() {
        this.rect = new Rectangle2D.Double(10.0, 10.0, this.getWidth() - 20 - 1, this.getHeight() - 20 - 1);
        this.ellipse = new Ellipse2D.Double(10.0, 10.0, this.getWidth() - 20 - 1, this.getHeight() - 20 - 1);
    }

    public void shapeTypeChange(String s) {
        super.setShapeType(s);
        if (s == "None") {
            this.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            this.node.setDisplayMode("Display Mode Ellipse");
        } else if (s == STYPE_BAR) {
            this.node.setDisplayMode("Display Mode BAR");
        }
        this.update();
    }

    public void removeShapeState() {
        ArrayList<UShape> temp = new ArrayList<UShape>();
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            if (shape instanceof UShapeState) {
                temp.add(shape);
            }
            ++i;
        }
        for (UShape shape : temp) {
            this.remove(shape);
        }
    }

    public void update(String strFinding) {
        this.finding = strFinding;
        this.update();
    }

    public void update() {
        super.update();
        this.updateNodeInformation();
        this.finding = this.node instanceof ProbabilisticNode && ((ProbabilisticNode)this.node).hasEvidence() ? this.node.getStateAt(((ProbabilisticNode)this.node).getEvidence()) : "";
        if (STYPE_BAR == this.getShapeType()) {
            this.removeShapeState();
            int size = this.node.getStatesSize();
            if (size > 0) {
                if (this.getWidth() < 250) {
                    this.setBounds(this.getX(), this.getY(), 250, 50 + size * this.stateHeight);
                } else {
                    this.setBounds(this.getX(), this.getY(), this.getWidth(), 50 + size * this.stateHeight);
                }
                this.InitShape();
                this.removeTextBox();
                TreeVariable treeVariable = (TreeVariable)this.node;
                this.setBackColor(this.getNode().getColor());
                int i = 0;
                while (i < size) {
                    this.stateShape = new UShapeState(this.getCanvas(), null, 11, this.getHeight() - 10 + this.stateHeight * i - this.stateHeight * size - 1, this.getWidth() - 20 - 2, this.stateHeight);
                    this.stateShape.setName(this.node.getStateAt(i));
                    this.stateShape.setMarginal(treeVariable.getMarginalAt(i));
                    if (this.finding == this.node.getStateAt(i)) {
                        this.setBackColorWithoutNode(Color.lightGray);
                        this.stateShape.setBackColor(this.stateColor[0]);
                    } else {
                        this.stateShape.setBackColor(this.stateColor[0]);
                    }
                    this.add(this.stateShape);
                    ++i;
                }
                this.rectTitle.width = this.getWidth();
                this.rectTitle.height = 50;
            }
        } else if ("None" == this.getShapeType()) {
            this.removeShapeState();
            this.InitShape();
            this.removeTextBox();
        }
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.InitShape();
        Graphics2D g2 = (Graphics2D)g;
        if ("None" == this.getShapeType()) {
            g2.setPaint(new GradientPaint(this.getWidth() / 2, this.getHeight(), this.getBackColor(), this.getWidth() / 2, 0.0f, Color.white, false));
            g2.fill(this.ellipse);
            g2.setColor(this.getDrawColor());
            g2.draw(this.ellipse);
            this.drawText(g);
        } else if (STYPE_BAR == this.getShapeType()) {
            g2.setPaint(new GradientPaint(this.getWidth() / 2, this.getHeight(), this.getBackColor(), this.getWidth() / 2, 0.0f, Color.white, false));
            g2.fillRect(10, 10, this.getWidth() - 20 - 1, this.getHeight() - 20 - 1);
            g2.setColor(this.getDrawColor());
            g2.draw(this.rect);
            this.drawText(g, this.rectTitle);
        }
    }

    public boolean contain(double x, double y) {
        if (STYPE_BAR == this.getShapeType() && this.rect != null) {
            return this.rect.contains(x - (double)this.getGlobalX(), y - (double)this.getGlobalY());
        }
        if (this.ellipse != null) {
            return this.ellipse.contains(x - (double)this.getGlobalX(), y - (double)this.getGlobalY());
        }
        return false;
    }

    public void mouseClicked(MouseEvent arg0) {
        if (SwingUtilities.isLeftMouseButton(arg0) && arg0.getClickCount() == 2 && !arg0.isConsumed() && "None" == this.getShapeType()) {
            arg0.consume();
            this.setState("WaitEdit", null);
        }
        SwingUtilities.isMiddleMouseButton(arg0);
        if (SwingUtilities.isRightMouseButton(arg0)) {
            JMenuItem item;
            this.createPopupMenu();
            if ("None" == this.getShapeType()) {
                item = new JMenuItem("Belief bar");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        UShapeProbabilisticNode.this.getCanvas().onShapeTypeChanged(UShapeProbabilisticNode.STYPE_BAR);
                        UShapeProbabilisticNode.this.node.setDisplayMode("Display Mode BAR");
                    }
                });
                this.popup.add(item);
            } else if (STYPE_BAR == this.getShapeType()) {
                item = new JMenuItem("Default Shape");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        UShapeProbabilisticNode.this.getCanvas().onShapeTypeChanged("None");
                        UShapeProbabilisticNode.this.node.setDisplayMode("Display Mode Ellipse");
                    }
                });
                this.popup.add(item);
            }
            if (this.getNode() instanceof ProbabilisticNode && this.getCanvas().controller != null) {
                item = new JMenuItem(resource.getString("properties"));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        UShapeProbabilisticNode.this.getCanvas().controller.showExplanationProperties((ProbabilisticNode)UShapeProbabilisticNode.this.getNode());
                    }
                });
                this.popup.add(item);
            }
            this.popup.setEnabled(true);
            this.popup.show(arg0.getComponent(), arg0.getX(), arg0.getY());
        }
    }
}

