/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import unbbayes.draw.UShape;

public class UShapeSizeBtn
extends UShape
implements MouseMotionListener,
MouseListener,
Cloneable {
    private static final long serialVersionUID = 5019421060606694321L;
    Ellipse2D ellipse;

    public UShapeSizeBtn(UShape s, int x, int y, int cursor) {
        super(s.getCanvas(), null, x, y, 10, 10);
        this.setOpaque(false);
        s.add(this);
        this.setCursor(cursor);
        this.InitShape();
    }

    public void InitShape() {
        this.ellipse = new Ellipse2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(new GradientPaint(this.getWidth() / 2, 0.0f, Color.white, this.getWidth() / 2, this.getHeight() - 1, Color.blue, false));
        if (this.ellipse != null) {
            g2.fill(this.ellipse);
        }
    }

    public Rectangle getDraggedRect(int x, int y) {
        Rectangle rc = new Rectangle(0, 0, 0, 0);
        if (this.m_cursor == 6) {
            rc.x = x;
            rc.y = y;
            rc.width -= x;
            rc.height -= y;
        } else if (this.m_cursor == 8) {
            rc.y = y;
            rc.height -= y;
        } else if (this.m_cursor == 7) {
            rc.width = x;
            rc.y = y;
            rc.height -= y;
        } else if (this.m_cursor == 11) {
            rc.x = x;
            rc.width -= x;
        } else if (this.m_cursor == 4) {
            rc.x = x;
            rc.height = y;
            rc.width -= x;
        } else if (this.m_cursor == 9) {
            rc.height = y;
        } else if (this.m_cursor == 10) {
            rc.width = x;
        } else if (this.m_cursor == 5) {
            rc.width = x;
            rc.height = y;
        }
        return rc;
    }

    public void mouseDragged(MouseEvent arg0) {
        Rectangle rc = this.getDraggedRect(arg0.getX(), arg0.getY());
        this.getCanvas().drawResizeRectEnter(rc);
    }

    public void mouseMoved(MouseEvent arg0) {
        this.setCursor(new Cursor(this.getCursorStyle()));
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
        this.setDrawColor(this.getLineColor());
        this.repaint();
        Rectangle rc = this.getDraggedRect(arg0.getX(), arg0.getY());
        this.getCanvas().drawResizeRectReleased(rc);
    }
}

