/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import unbbayes.draw.UCanvas;
import unbbayes.draw.UShape;
import unbbayes.prs.Node;

public class UShapeState
extends UShape
implements MouseMotionListener,
MouseListener,
Cloneable {
    private static final long serialVersionUID = -6856101647287130364L;
    protected Rectangle2D rect;
    protected Rectangle rectTextArea;
    protected float marginal;
    private NumberFormat nf;

    public UShapeState(UCanvas s, Node pNode, int x, int y, int w, int h) {
        super(s, pNode, x, y, w, h);
        this.setOpaque(false);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(2);
        this.rectTextArea = new Rectangle(0, 0, (int)((double)w * 0.7), h);
        this.InitShape();
    }

    public void setMarginal(float d) {
        this.marginal = d;
    }

    public void InitShape() {
        this.rect = new Rectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public void paintComponent(Graphics g) {
        this.InitShape();
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(new GradientPaint((int)this.rectTextArea.getWidth(), this.getHeight() / 2, Color.white, this.getWidth(), this.getHeight() / 2, this.getBackColor(), false));
        g2.fillRect((int)this.rectTextArea.getWidth(), 0, (int)(((double)this.getWidth() - this.rectTextArea.getWidth()) * (double)this.marginal), this.getHeight());
        g2.setPaint(Color.BLUE);
        g2.drawLine((int)this.rectTextArea.getWidth(), 0, (int)this.rectTextArea.getWidth(), this.getHeight());
        g2.drawLine(0, 0, (int)this.rect.getWidth(), 0);
        g2.setPaint(this.getDrawColor());
        this.drawText(g, this.rectTextArea, this.getName(), "Left Text");
        this.drawText(g, this.rectTextArea, String.valueOf(this.nf.format((double)this.marginal * 100.0)) + "%", "Right Texte");
    }

    public void mouseDragged(MouseEvent arg0) {
    }

    public void mouseMoved(MouseEvent arg0) {
        this.setCursor(new Cursor(this.getCursorStyle()));
    }

    public void mouseClicked(MouseEvent arg0) {
        this.getCanvas().onShapeChanged(this);
    }

    public void mousePressed(MouseEvent arg0) {
    }
}

