/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import unbbayes.draw.INodeHolderShape;
import unbbayes.draw.UCanvas;
import unbbayes.draw.UShape;
import unbbayes.prs.Node;

public class UShapeUtilityNode
extends UShape
implements INodeHolderShape {
    private static final long serialVersionUID = 6554173137402074445L;
    protected GeneralPath parallelogram;

    public UShapeUtilityNode(UCanvas c, Node pNode, int x, int y, int w, int h) {
        super(c, pNode, x, y, w, h);
        this.InitShape();
    }

    public void update() {
        super.update();
        this.updateNodeInformation();
        this.InitShape();
        this.repaint();
    }

    public void InitShape() {
        this.parallelogram = new GeneralPath();
        this.parallelogram.moveTo(this.getWidth() / 2, 10.0f);
        this.parallelogram.lineTo(-10 + this.getWidth(), this.getHeight() / 2);
        this.parallelogram.lineTo(this.getWidth() / 2, this.getHeight() - 10);
        this.parallelogram.lineTo(10.0f, this.getHeight() / 2);
        this.parallelogram.closePath();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.InitShape();
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(new GradientPaint(this.getWidth() / 2, this.getHeight(), this.getBackColor(), this.getWidth() / 2, 0.0f, Color.white, false));
        g2.fill(this.parallelogram);
        g2.setColor(this.getLineColor());
        g2.draw(this.parallelogram);
        this.drawText(g);
    }

    public boolean contain(double x, double y) {
        return this.parallelogram.contains(x - (double)this.getGlobalX(), y - (double)this.getGlobalY());
    }
}

