/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.evaluation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import unbbayes.evaluation.EvidenceEvaluation;
import unbbayes.evaluation.IEvaluation;
import unbbayes.evaluation.exception.EvaluationException;
import unbbayes.io.BaseIO;
import unbbayes.io.NetIO;
import unbbayes.io.XMLBIFIO;
import unbbayes.io.exception.LoadException;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.util.longtask.ILongTaskProgressObserver;
import unbbayes.util.longtask.LongTaskProgressChangedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AEvaluation
implements IEvaluation {
    protected ProbabilisticNetwork net;
    protected int targetStatesProduct;
    protected TreeVariable[] targetNodeList;
    public static final float UNSET_VALUE = Float.NEGATIVE_INFINITY;
    protected TreeVariable[] evidenceNodeList;
    protected int statesProduct;
    protected int evidenceStatesProduct;
    protected float[][] evidenceSetCM;
    protected float evidenceSetPCC = Float.NEGATIVE_INFINITY;
    protected List<EvidenceEvaluation> evidenceEvaluationList;
    protected int[] factors;
    private List<ILongTaskProgressObserver> observers = new ArrayList<ILongTaskProgressObserver>();
    protected int maxProgress = 100;
    protected int currentProgress = 0;
    protected String currentProgressStatus = "";
    protected int lastProgressUpdated = 0;

    @Override
    public List<EvidenceEvaluation> getEvidenceEvaluationList() {
        return this.evidenceEvaluationList;
    }

    @Override
    public float[][] getEvidenceSetCM() {
        return this.evidenceSetCM;
    }

    @Override
    public abstract float getError();

    @Override
    public float getEvidenceSetPCC() throws EvaluationException {
        if (this.evidenceSetPCC == Float.NEGATIVE_INFINITY) {
            if (this.evidenceSetCM == null) {
                throw new EvaluationException("Must calculate evidence set LCM before computing evidence set PCC.");
            }
            this.evidenceSetPCC = 0.0f;
            int i = 0;
            while (i < this.evidenceSetCM.length) {
                this.evidenceSetPCC += this.evidenceSetCM[i][i];
                ++i;
            }
            this.evidenceSetPCC /= (float)this.evidenceSetCM.length;
        }
        return this.evidenceSetPCC;
    }

    @Override
    public List<EvidenceEvaluation> getBestIndividualPCC() throws EvaluationException {
        ArrayList<EvidenceEvaluation> sortedList = new ArrayList<EvidenceEvaluation>();
        sortedList.addAll(this.evidenceEvaluationList);
        boolean change = true;
        while (change) {
            change = false;
            int i = 0;
            while (i < sortedList.size() - 1) {
                EvidenceEvaluation ev1 = (EvidenceEvaluation)sortedList.get(i);
                EvidenceEvaluation ev2 = (EvidenceEvaluation)sortedList.get(i + 1);
                if (ev1.getIndividualPCC() - ev2.getIndividualPCC() < 0.0f) {
                    sortedList.set(i + 1, ev1);
                    sortedList.set(i, ev2);
                    change = true;
                }
                ++i;
            }
        }
        return sortedList;
    }

    @Override
    public List<EvidenceEvaluation> getBestIndividualCostRate() throws EvaluationException {
        ArrayList<EvidenceEvaluation> sortedList = new ArrayList<EvidenceEvaluation>();
        sortedList.addAll(this.evidenceEvaluationList);
        boolean change = true;
        while (change) {
            change = false;
            int i = 0;
            while (i < sortedList.size() - 1) {
                EvidenceEvaluation ev1 = (EvidenceEvaluation)sortedList.get(i);
                EvidenceEvaluation ev2 = (EvidenceEvaluation)sortedList.get(i + 1);
                if (ev1.getMarginalCost() - ev2.getMarginalCost() < 0.0f) {
                    sortedList.set(i + 1, ev1);
                    sortedList.set(i, ev2);
                    change = true;
                }
                ++i;
            }
        }
        return sortedList;
    }

    @Override
    public List<EvidenceEvaluation> getBestMarginalImprovement() throws EvaluationException {
        ArrayList<EvidenceEvaluation> sortedList = new ArrayList<EvidenceEvaluation>();
        sortedList.addAll(this.evidenceEvaluationList);
        boolean change = true;
        while (change) {
            change = false;
            int i = 0;
            while (i < sortedList.size() - 1) {
                EvidenceEvaluation ev1 = (EvidenceEvaluation)sortedList.get(i);
                EvidenceEvaluation ev2 = (EvidenceEvaluation)sortedList.get(i + 1);
                if (ev1.getMarginalImprovement() - ev2.getMarginalImprovement() < 0.0f) {
                    sortedList.set(i + 1, ev1);
                    sortedList.set(i, ev2);
                    change = true;
                }
                ++i;
            }
        }
        return sortedList;
    }

    @Override
    public void evaluate(String netFileName, List<String> targetNodeNameList, List<String> evidenceNodeNameList, boolean onlyGCM) throws LoadException, IOException, JAXBException, EvaluationException {
        this.loadNetwork(netFileName);
        this.evaluate(targetNodeNameList, evidenceNodeNameList, onlyGCM);
    }

    @Override
    public void evaluate(ProbabilisticNetwork net, List<String> targetNodeNameList, List<String> evidenceNodeNameList, boolean onlyGCM) throws EvaluationException {
        this.net = net;
        this.evaluate(targetNodeNameList, evidenceNodeNameList, onlyGCM);
    }

    protected void evaluate(List<String> targetNodeNameList, List<String> evidenceNodeNameList, boolean onlyGCM) throws EvaluationException {
        this.evidenceSetCM = this.computeCM(targetNodeNameList, evidenceNodeNameList);
        this.evidenceSetPCC = Float.NEGATIVE_INFINITY;
        if (!onlyGCM) {
            this.evidenceEvaluationList = new ArrayList<EvidenceEvaluation>();
            for (String evidenceName : evidenceNodeNameList) {
                EvidenceEvaluation evidenceEvaluation = new EvidenceEvaluation(evidenceName, this.getEvidenceSetPCC());
                ArrayList<String> tempList = new ArrayList<String>();
                tempList.add(evidenceName);
                evidenceEvaluation.setLCM(this.computeCM(targetNodeNameList, tempList));
                tempList.clear();
                tempList.addAll(evidenceNodeNameList);
                tempList.remove(evidenceName);
                evidenceEvaluation.setMarginalCM(this.computeCM(targetNodeNameList, tempList));
                this.evidenceEvaluationList.add(evidenceEvaluation);
            }
        }
    }

    protected abstract float[][] computeCM(List<String> var1, List<String> var2) throws EvaluationException;

    protected void computeFactors() {
        int size = this.targetNodeList.length + this.evidenceNodeList.length;
        if (this.factors == null || this.factors.length != size) {
            this.factors = new int[size];
        }
        TreeVariable[] nodes = new TreeVariable[size];
        int nodeIndex = 0;
        int i = 0;
        while (i < this.targetNodeList.length) {
            nodes[nodeIndex++] = this.targetNodeList[i];
            ++i;
        }
        i = 0;
        while (i < this.evidenceNodeList.length) {
            nodes[nodeIndex++] = this.evidenceNodeList[i];
            ++i;
        }
        this.factors[0] = 1;
        int i2 = 1;
        while (i2 < size) {
            TreeVariable node = nodes[i2 - 1];
            this.factors[i2] = this.factors[i2 - 1] * node.getStatesSize();
            ++i2;
        }
    }

    protected int getLinearCoord(int[] multidimensionalCoord) {
        this.computeFactors();
        int coordLinear = 0;
        int size = this.targetNodeList.length + this.evidenceNodeList.length;
        int v = 0;
        while (v < size) {
            coordLinear += multidimensionalCoord[v] * this.factors[v];
            ++v;
        }
        return coordLinear;
    }

    protected int getEvidenceLinearCoord(int[] multidimensionalCoord) {
        this.computeFactors();
        int coordLinear = 0;
        int size = this.targetNodeList.length + this.evidenceNodeList.length;
        int v = 1;
        while (v < size) {
            coordLinear += multidimensionalCoord[v] * this.factors[v] / this.factors[1];
            ++v;
        }
        return coordLinear;
    }

    protected int[] getMultidimensionalCoord(int linearCoord) {
        this.computeFactors();
        int size = this.targetNodeList.length + this.evidenceNodeList.length;
        int[] multidimensionalCoord = new int[size];
        int i = size - 1;
        while (linearCoord != 0) {
            int factorI = this.factors[i];
            multidimensionalCoord[i--] = linearCoord / factorI;
            linearCoord %= factorI;
        }
        return multidimensionalCoord;
    }

    protected void init(List<String> targetNodeNameList, List<String> evidenceNodeNameList) {
        this.targetNodeList = new TreeVariable[targetNodeNameList.size()];
        this.evidenceNodeList = new TreeVariable[evidenceNodeNameList.size()];
        this.statesProduct = 1;
        this.targetStatesProduct = 1;
        this.evidenceStatesProduct = 1;
        int count = 0;
        for (String targetNodeName : targetNodeNameList) {
            Node targetNode = this.net.getNode(targetNodeName);
            this.targetNodeList[count] = (TreeVariable)targetNode;
            this.targetStatesProduct *= targetNode.getStatesSize();
            ++count;
        }
        count = 0;
        for (String evidenceNodeName : evidenceNodeNameList) {
            Node evidenceNode = this.net.getNode(evidenceNodeName);
            this.evidenceNodeList[count] = (TreeVariable)evidenceNode;
            this.evidenceStatesProduct *= evidenceNode.getStatesSize();
            ++count;
        }
        this.statesProduct = this.targetStatesProduct * this.evidenceStatesProduct;
    }

    protected void loadNetwork(String netFileName) throws LoadException, IOException {
        File netFile = new File(netFileName);
        String fileExt = netFileName.substring(netFileName.length() - 3);
        BaseIO io = null;
        if (fileExt.equalsIgnoreCase("xml")) {
            io = new XMLBIFIO();
        } else if (fileExt.equalsIgnoreCase("net")) {
            io = new NetIO();
        } else {
            throw new LoadException("The network must be in XMLBIF 0.5 or NET format!");
        }
        this.net = (ProbabilisticNetwork)io.load(netFile);
    }

    protected static void show(float[][] a) {
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[0].length) {
                System.out.printf("%6.4f ", Float.valueOf(a[i][j]));
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
    }

    @Override
    public void registerObserver(ILongTaskProgressObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(ILongTaskProgressObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void notityObservers(LongTaskProgressChangedEvent event) {
        for (ILongTaskProgressObserver observer : this.observers) {
            observer.update(event);
        }
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getPercentageDone() {
        return Math.round((float)this.currentProgress / (float)this.maxProgress * 10000.0f);
    }

    @Override
    public String getCurrentProgressStatus() {
        return this.currentProgressStatus;
    }

    protected void updateProgress(int progress, String progressStatus) {
        boolean update;
        this.currentProgress = progress;
        this.currentProgressStatus = progressStatus;
        int step = (int)((double)this.maxProgress * 0.01 / 3.0);
        boolean bl = update = progress - this.lastProgressUpdated > step || this.currentProgress % step == 0;
        if (update && this.getPercentageDone() < 9800) {
            this.lastProgressUpdated = this.currentProgress;
            LongTaskProgressChangedEvent event = new LongTaskProgressChangedEvent(this.getCurrentProgressStatus(), this.getPercentageDone());
            this.notityObservers(event);
        }
    }

    protected void updateProgress(int progress) {
        this.updateProgress(progress, "");
    }
}

