/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.evaluation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import unbbayes.evaluation.ExactEvaluation;
import unbbayes.evaluation.IEvaluation;
import unbbayes.evaluation.MemoryEfficientApproximateEvaluation;
import unbbayes.io.BaseIO;
import unbbayes.io.NetIO;
import unbbayes.io.XMLBIFIO;
import unbbayes.io.exception.LoadException;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationAnalysis {
    protected ProbabilisticNetwork net;
    protected int statesProduct;
    protected IEvaluation evaluation;

    public void computeErrorBySampleSize(String netFileName, List<String> targetNodeNameList, List<String> evidenceNodeNameList, float exactPcc) throws Exception {
        this.loadNetwork(netFileName);
        this.computeStatesProduct(targetNodeNameList, evidenceNodeNameList);
        this.statesProduct /= targetNodeNameList.get(0).length();
        int sampleSize = 0;
        if (evidenceNodeNameList.size() == 2) {
            sampleSize = 500;
        } else if (evidenceNodeNameList.size() == 3) {
            sampleSize = 5000;
        } else if (evidenceNodeNameList.size() == 4) {
            sampleSize = 50000;
        } else if (evidenceNodeNameList.size() == 5) {
            sampleSize = 500000;
        } else {
            return;
        }
        float[][][] approximatePcc = new float[3][3][100];
        int i = 0;
        while (i < approximatePcc.length) {
            if (i == 0) {
                sampleSize *= 5;
            } else if (i == 1) {
                sampleSize *= 10;
            } else if (i == 2) {
                sampleSize *= 50;
            }
            int j = 0;
            while (j < approximatePcc[0].length) {
                if (j == 0) {
                    sampleSize /= 10;
                } else if (j != 1 && j == 2) {
                    sampleSize *= 10;
                }
                Debug.setDebug(true);
                Debug.println("");
                int b = 0;
                while (b < 4 - evidenceNodeNameList.size()) {
                    Debug.print("%20s", "");
                    ++b;
                }
                for (String evidence : evidenceNodeNameList) {
                    Debug.print("%20s", evidence);
                }
                Debug.print(" , %20d", this.statesProduct);
                Debug.print(" , %1.19f", Float.valueOf(exactPcc));
                Debug.print(" , %20d , %1.19f", sampleSize, Float.valueOf((float)sampleSize / (float)this.statesProduct));
                long init = System.currentTimeMillis();
                int k = 0;
                while (k < approximatePcc[0][0].length && sampleSize < 10000000) {
                    Debug.setDebug(false);
                    this.evaluation = new MemoryEfficientApproximateEvaluation(sampleSize);
                    this.evaluation.evaluate(this.net, targetNodeNameList, evidenceNodeNameList, true);
                    approximatePcc[i][j][k] = this.evaluation.getEvidenceSetPCC();
                    System.gc();
                    Debug.setDebug(true);
                    ++k;
                }
                long end = System.currentTimeMillis();
                Debug.print(" , %1.19f , %1.19f", Float.valueOf(this.mean(approximatePcc[i][j]) - exactPcc), Float.valueOf(this.variance(approximatePcc[i][j])));
                Debug.print(" , %1.19f", Float.valueOf((float)(end - init) / 1000.0f));
                if (j == 0) {
                    sampleSize *= 10;
                } else if (j == 2) {
                    sampleSize /= 10;
                }
                ++j;
            }
            if (i == 0) {
                sampleSize /= 5;
            } else if (i == 1) {
                sampleSize /= 10;
            } else if (i == 2) {
                sampleSize /= 50;
            }
            ++i;
        }
        Debug.setDebug(false);
    }

    public float mean(float[] values) {
        float total = 0.0f;
        int i = 0;
        while (i < values.length) {
            total += values[i];
            ++i;
        }
        return total / (float)values.length;
    }

    public float variance(float[] values) {
        float total = 0.0f;
        float total2 = 0.0f;
        int i = 0;
        while (i < values.length) {
            total += values[i];
            total2 = (float)((double)total2 + Math.pow(values[i], 2.0));
            ++i;
        }
        return total2 / (float)values.length - (float)Math.pow(total / (float)values.length, 2.0);
    }

    public void computeSampleSizeByErrorVariance(String netFileName, List<String> targetNodeNameList, List<String> evidenceNodeNameList, float error, float exactPcc) throws Exception {
        long end;
        long init;
        float approximatePcc;
        this.loadNetwork(netFileName);
        this.computeStatesProduct(targetNodeNameList, evidenceNodeNameList);
        int times = 10;
        do {
            this.evaluation = new MemoryEfficientApproximateEvaluation(times * this.statesProduct);
            init = System.currentTimeMillis();
            this.evaluation.evaluate(this.net, targetNodeNameList, evidenceNodeNameList, true);
            end = System.currentTimeMillis();
            approximatePcc = this.evaluation.getEvidenceSetPCC();
            times *= 10;
            System.gc();
        } while (exactPcc + error < approximatePcc || approximatePcc < exactPcc - error);
        Debug.setDebug(true);
        Debug.println("Target: " + targetNodeNameList.get(0));
        Debug.print("Evidence: ");
        for (String evidence : evidenceNodeNameList) {
            Debug.print(String.valueOf(evidence) + " ");
        }
        Debug.println("");
        Debug.println("States product: " + this.statesProduct);
        Debug.println("Sample size: " + times / 10 + " * " + this.statesProduct + " = " + times / 10 * this.statesProduct);
        Debug.println("Time elapsed for evaluating: " + (float)(end - init) / 1000.0f + " seconds");
        Debug.println("Exact Pcc: " + exactPcc);
        Debug.println("Approximate Pcc: " + approximatePcc);
        Debug.println("Error Pcc: " + error);
        Debug.println("");
        Debug.setDebug(false);
    }

    public void computeExactSampleSize(String netFileName, List<String> targetNodeNameList, List<String> evidenceNodeNameList) throws Exception {
        this.loadNetwork(netFileName);
        this.computeStatesProduct(targetNodeNameList, evidenceNodeNameList);
        this.evaluation = new ExactEvaluation();
        long init = System.currentTimeMillis();
        this.evaluation.evaluate(this.net, targetNodeNameList, evidenceNodeNameList, true);
        long end = System.currentTimeMillis();
        float exactPcc = this.evaluation.getEvidenceSetPCC();
        System.gc();
        Debug.setDebug(true);
        Debug.println("Target: " + targetNodeNameList.get(0));
        Debug.print("Evidence: ");
        for (String evidence : evidenceNodeNameList) {
            Debug.print(String.valueOf(evidence) + " ");
        }
        Debug.println("");
        Debug.println("States product: " + this.statesProduct);
        Debug.println("Time elapsed for evaluating: " + (float)(end - init) / 1000.0f + " seconds");
        Debug.println("Exact Pcc: " + exactPcc);
        Debug.println("");
        Debug.setDebug(false);
    }

    protected void computeStatesProduct(List<String> targetNodeNameList, List<String> evidenceNodeNameList) {
        TreeVariable[] targetNodeList = new TreeVariable[targetNodeNameList.size()];
        TreeVariable[] evidenceNodeList = new TreeVariable[evidenceNodeNameList.size()];
        this.statesProduct = 1;
        int targetStatesProduct = 1;
        int evidenceStatesProduct = 1;
        int count = 0;
        for (String targetNodeName : targetNodeNameList) {
            Node targetNode = this.net.getNode(targetNodeName);
            targetNodeList[count] = (TreeVariable)targetNode;
            targetStatesProduct *= targetNode.getStatesSize();
            ++count;
        }
        count = 0;
        for (String evidenceNodeName : evidenceNodeNameList) {
            Node evidenceNode = this.net.getNode(evidenceNodeName);
            evidenceNodeList[count] = (TreeVariable)evidenceNode;
            evidenceStatesProduct *= evidenceNode.getStatesSize();
            ++count;
        }
        this.statesProduct = targetStatesProduct * evidenceStatesProduct;
    }

    protected void loadNetwork(String netFileName) throws LoadException, IOException {
        File netFile = new File(netFileName);
        String fileExt = netFileName.substring(netFileName.length() - 3);
        BaseIO io = null;
        if (fileExt.equalsIgnoreCase("xml")) {
            io = new XMLBIFIO();
        } else if (fileExt.equalsIgnoreCase("net")) {
            io = new NetIO();
        } else {
            throw new LoadException("The network must be in XMLBIF 0.5 or NET format!");
        }
        this.net = (ProbabilisticNetwork)io.load(netFile);
    }

    public static void runCorrectAirIDModel() throws Exception {
        String netFileName = "src/test/resources/testCases/evaluation/AirID.xml";
        ArrayList<String> targetNodeNameList = new ArrayList<String>();
        ArrayList<String> evidenceNodeNameList = new ArrayList<String>();
        targetNodeNameList = new ArrayList();
        targetNodeNameList.add("TargetType");
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("CenterFrequency");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.2228f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("PRF");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.2373f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("PRI");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.2382f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("ModulationFrequency");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.2867f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("UHRR_Confusion");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.6102f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("CenterFrequency");
        evidenceNodeNameList.add("PRI");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.2785f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("CenterFrequency");
        evidenceNodeNameList.add("PRF");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.2781f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("PRI");
        evidenceNodeNameList.add("PRF");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.2891f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("UHRR_Confusion");
        evidenceNodeNameList.add("ModulationFrequency");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.6548f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("CenterFrequency");
        evidenceNodeNameList.add("PRI");
        evidenceNodeNameList.add("PRF");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.3172f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("ModulationFrequency");
        evidenceNodeNameList.add("CenterFrequency");
        evidenceNodeNameList.add("PRI");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.3876f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("ModulationFrequency");
        evidenceNodeNameList.add("CenterFrequency");
        evidenceNodeNameList.add("PRF");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.3872f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("ModulationFrequency");
        evidenceNodeNameList.add("PRI");
        evidenceNodeNameList.add("PRF");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.3967f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("UHRR_Confusion");
        evidenceNodeNameList.add("CenterFrequency");
        evidenceNodeNameList.add("PRI");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.6561f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("UHRR_Confusion");
        evidenceNodeNameList.add("CenterFrequency");
        evidenceNodeNameList.add("PRF");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.6558f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("UHRR_Confusion");
        evidenceNodeNameList.add("PRI");
        evidenceNodeNameList.add("PRF");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.6616f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("ModulationFrequency");
        evidenceNodeNameList.add("CenterFrequency");
        evidenceNodeNameList.add("PRI");
        evidenceNodeNameList.add("PRF");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.4214f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("UHRR_Confusion");
        evidenceNodeNameList.add("CenterFrequency");
        evidenceNodeNameList.add("PRI");
        evidenceNodeNameList.add("PRF");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.6755f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("UHRR_Confusion");
        evidenceNodeNameList.add("ModulationFrequency");
        evidenceNodeNameList.add("CenterFrequency");
        evidenceNodeNameList.add("PRI");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.6932f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("UHRR_Confusion");
        evidenceNodeNameList.add("ModulationFrequency");
        evidenceNodeNameList.add("CenterFrequency");
        evidenceNodeNameList.add("PRF");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.6931f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("UHRR_Confusion");
        evidenceNodeNameList.add("ModulationFrequency");
        evidenceNodeNameList.add("PRI");
        evidenceNodeNameList.add("PRF");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.6978f, netFileName);
        evidenceNodeNameList = new ArrayList();
        evidenceNodeNameList.add("UHRR_Confusion");
        evidenceNodeNameList.add("ModulationFrequency");
        evidenceNodeNameList.add("CenterFrequency");
        evidenceNodeNameList.add("PRI");
        evidenceNodeNameList.add("PRF");
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, 0.7095f, netFileName);
    }

    public static void runWrongAirIDModel() throws Exception {
        ArrayList<String> targetNodeNameList = new ArrayList<String>();
        targetNodeNameList.add("TargetType");
        ArrayList<String> evidenceNodeNameList = new ArrayList<String>();
        evidenceNodeNameList.add("UHRR_Confusion");
        evidenceNodeNameList.add("ModulationFrequency");
        evidenceNodeNameList.add("CenterFrequency");
        evidenceNodeNameList.add("PRI");
        evidenceNodeNameList.add("PRF");
        ExactEvaluation evaluationExact = new ExactEvaluation();
        String netFileName = "src/test/resources/testCases/evaluation/AirID_05%.xml";
        evaluationExact.evaluate(netFileName, targetNodeNameList, evidenceNodeNameList, true);
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, evaluationExact.getEvidenceSetPCC(), netFileName);
        netFileName = "src/test/resources/testCases/evaluation/AirID_10%.xml";
        evaluationExact.evaluate(netFileName, targetNodeNameList, evidenceNodeNameList, true);
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, evaluationExact.getEvidenceSetPCC(), netFileName);
        netFileName = "src/test/resources/testCases/evaluation/AirID_20%.xml";
        evaluationExact.evaluate(netFileName, targetNodeNameList, evidenceNodeNameList, true);
        EvaluationAnalysis.run(targetNodeNameList, evidenceNodeNameList, evaluationExact.getEvidenceSetPCC(), netFileName);
    }

    public static void main(String[] args) throws Exception {
        Debug.setDebug(true);
        Debug.print("\n%80s , %20s , %20s , %20s , %20s , %20s , %20s , %20s", "Evidence", "States Size", "Exact Pcc", "Sample Size", "Sample / States", "Mean", "Variance", "Time");
        Debug.setDebug(false);
        EvaluationAnalysis.runWrongAirIDModel();
    }

    public static void run(List<String> targetNodeNameList, List<String> evidenceNodeNameList, float exactPcc, String netFileName) throws Exception {
        EvaluationAnalysis an = new EvaluationAnalysis();
        EvaluationAnalysisOption option = EvaluationAnalysisOption.ERROR;
        float error = 0.0025f;
        switch (option) {
            case EXACT: {
                an.computeExactSampleSize(netFileName, targetNodeNameList, evidenceNodeNameList);
                break;
            }
            case SAMPLE_SIZE: {
                an.computeSampleSizeByErrorVariance(netFileName, targetNodeNameList, evidenceNodeNameList, error, exactPcc);
                break;
            }
            case ERROR: {
                an.computeErrorBySampleSize(netFileName, targetNodeNameList, evidenceNodeNameList, exactPcc);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EvaluationAnalysisOption {
        EXACT,
        SAMPLE_SIZE,
        ERROR;

    }
}

