/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.evaluation;

import unbbayes.evaluation.exception.EvaluationException;

public class EvidenceEvaluation {
    private String name;
    private float cost = Float.NEGATIVE_INFINITY;
    private float individualPCC = Float.NEGATIVE_INFINITY;
    private float[][] LCM;
    private float marginalPCC = Float.NEGATIVE_INFINITY;
    private float[][] marginalCM;
    private float marginalImprovement = Float.NEGATIVE_INFINITY;
    private float marginalCost = Float.NEGATIVE_INFINITY;
    private float evidenceSetPcc;

    public EvidenceEvaluation(String name, float evidenceSetPcc) {
        this.name = name;
        this.evidenceSetPcc = evidenceSetPcc;
    }

    public EvidenceEvaluation(String name, float evidenceSetPcc, float cost) {
        this(name, evidenceSetPcc);
        this.cost = cost;
    }

    public float getIndividualPCC() throws EvaluationException {
        if (this.individualPCC == Float.NEGATIVE_INFINITY) {
            if (this.LCM == null) {
                throw new EvaluationException("Must calculate individual LCM before computing individual PCC.");
            }
            this.individualPCC = 0.0f;
            int i = 0;
            while (i < this.LCM.length) {
                this.individualPCC += this.LCM[i][i];
                ++i;
            }
            this.individualPCC /= (float)this.LCM.length;
        }
        return this.individualPCC;
    }

    public float getMarginalPCC() throws EvaluationException {
        if (this.marginalPCC == Float.NEGATIVE_INFINITY) {
            if (this.marginalCM == null) {
                throw new EvaluationException("Must calculate marginal LCM before computing marginal PCC.");
            }
            this.marginalPCC = 0.0f;
            int i = 0;
            while (i < this.marginalCM.length) {
                this.marginalPCC += this.marginalCM[i][i];
                ++i;
            }
            this.marginalPCC /= (float)this.marginalCM.length;
        }
        return this.marginalPCC;
    }

    public float getMarginalImprovement() throws EvaluationException {
        if (this.marginalImprovement == Float.NEGATIVE_INFINITY) {
            this.marginalImprovement = this.evidenceSetPcc - this.getMarginalPCC();
        }
        return this.marginalImprovement;
    }

    public float getMarginalCost() throws EvaluationException {
        if (this.marginalCost == Float.NEGATIVE_INFINITY) {
            if (this.cost == Float.NEGATIVE_INFINITY) {
                throw new EvaluationException("Must set cost before computing cost rate.");
            }
            try {
                this.marginalCost = this.cost / (this.getIndividualPCC() * 100.0f);
            }
            catch (EvaluationException e) {
                throw new EvaluationException("Must calculate individual Pcc before computing cost rate. " + e.getMessage());
            }
        }
        return this.marginalCost;
    }

    public float getCost() {
        return this.cost;
    }

    public void setCost(float cost) {
        this.cost = cost;
    }

    public float[][] getIndividualLCM() {
        return this.LCM;
    }

    public void setLCM(float[][] LCM) {
        this.LCM = LCM;
    }

    public float[][] getMarginalCM() {
        return this.marginalCM;
    }

    public void setMarginalCM(float[][] marginalCM) {
        this.marginalCM = marginalCM;
    }

    public String getName() {
        return this.name;
    }
}

