/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.evaluation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import unbbayes.evaluation.AEvaluation;
import unbbayes.evaluation.EvidenceEvaluation;
import unbbayes.evaluation.exception.EvaluationException;
import unbbayes.prs.Node;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.simulation.likelihoodweighting.ILikelihoodWeightingSampling;
import unbbayes.simulation.likelihoodweighting.sampling.LikelihoodWeightingSampling;
import unbbayes.util.longtask.ILongTaskProgressObserver;
import unbbayes.util.longtask.LongTaskProgressChangedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastLWApproximateEvaluation
extends AEvaluation
implements ILongTaskProgressObserver {
    protected int sampleSize;
    protected ILikelihoodWeightingSampling lw;
    protected TreeVariable targetNode;
    protected byte[][] sampleMatrix;
    protected float[] sampleWeight;
    protected List<Node> positionNodeList;
    protected int[] positionTargetNodeList;
    protected int[] positionEvidenceNodeList;
    private int previousSamplingProgress = 0;

    @Override
    public float getError() {
        return (float)(1.0 / Math.sqrt(this.sampleSize));
    }

    public FastLWApproximateEvaluation(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Override
    protected void evaluate(List<String> targetNodeNameList, List<String> evidenceNodeNameList, boolean onlyGCM) throws EvaluationException {
        this.setMaxProgress(evidenceNodeNameList.size());
        this.updateProgress((int)((double)this.maxProgress * 0.01));
        this.lw = new LikelihoodWeightingSampling();
        this.lw.registerObserver(this);
        this.lw.start(this.net, this.sampleSize);
        this.sampleMatrix = this.lw.getSampledStatesMatrix();
        this.sampleWeight = this.lw.getFullStatesSetWeight();
        super.evaluate(targetNodeNameList, evidenceNodeNameList, onlyGCM);
    }

    @Override
    protected float[][] computeCM(List<String> targetNodeNameList, List<String> evidenceNodeNameList) throws EvaluationException {
        this.init(targetNodeNameList, evidenceNodeNameList);
        long init = System.currentTimeMillis();
        this.targetNode = this.targetNodeList[0];
        if (this.targetNodeList.length != 1) {
            throw new EvaluationException("For now, just one target node is accepted!");
        }
        this.positionTargetNodeList = new int[this.targetNodeList.length];
        this.positionEvidenceNodeList = new int[this.evidenceNodeList.length];
        this.positionNodeList = this.lw.getSamplingNodeOrderQueue();
        int i = 0;
        while (i < this.positionTargetNodeList.length) {
            this.positionTargetNodeList[i] = this.positionNodeList.indexOf(this.targetNodeList[i]);
            ++i;
        }
        i = 0;
        while (i < this.positionEvidenceNodeList.length) {
            this.positionEvidenceNodeList[i] = this.positionNodeList.indexOf(this.evidenceNodeList[i]);
            ++i;
        }
        float[] weightEvidenceGivenTargetList = new float[this.statesProduct];
        float[] weightEvidenceList = new float[this.targetStatesProduct];
        int i2 = 0;
        while (i2 < this.sampleMatrix.length) {
            byte state;
            this.updateProgress(this.currentProgress + 1);
            int row = 0;
            int currentStatesProduct = this.evidenceStatesProduct;
            int j = this.positionTargetNodeList.length - 1;
            while (j >= 0) {
                state = this.sampleMatrix[i2][this.positionTargetNodeList[j]];
                row += state * currentStatesProduct;
                currentStatesProduct *= this.positionNodeList.get(this.positionTargetNodeList[j]).getStatesSize();
                --j;
            }
            int n = row / this.evidenceStatesProduct;
            weightEvidenceList[n] = weightEvidenceList[n] + this.sampleWeight[i2];
            currentStatesProduct = this.evidenceStatesProduct;
            j = 0;
            while (j < this.positionEvidenceNodeList.length) {
                state = this.sampleMatrix[i2][this.positionEvidenceNodeList[j]];
                row += state * (currentStatesProduct /= this.positionNodeList.get(this.positionEvidenceNodeList[j]).getStatesSize());
                ++j;
            }
            int n2 = row;
            weightEvidenceGivenTargetList[n2] = weightEvidenceGivenTargetList[n2] + this.sampleWeight[i2];
            ++i2;
        }
        float[] postProbEvidenceGivenTarget = new float[this.statesProduct];
        int i3 = 0;
        while (i3 < postProbEvidenceGivenTarget.length) {
            float n = weightEvidenceList[i3 / this.evidenceStatesProduct];
            if (n != 0.0f) {
                postProbEvidenceGivenTarget[i3] = weightEvidenceGivenTargetList[i3] / n;
            }
            ++i3;
        }
        float[] postProbTargetGivenEvidence = new float[this.statesProduct];
        int row = 0;
        float prob = 0.0f;
        float[] normalizationList = new float[this.evidenceStatesProduct];
        try {
            this.net.compile();
        }
        catch (Exception e) {
            throw new EvaluationException(e.getMessage());
        }
        int i4 = 0;
        while (i4 < this.targetNode.getStatesSize()) {
            int j = 0;
            while (j < this.evidenceStatesProduct) {
                row = j + i4 * this.evidenceStatesProduct;
                postProbTargetGivenEvidence[row] = prob = postProbEvidenceGivenTarget[row] * this.targetNode.getMarginalAt(i4);
                int n = j++;
                normalizationList[n] = normalizationList[n] + prob;
            }
            ++i4;
        }
        float norm = 0.0f;
        int i5 = 0;
        while (i5 < postProbTargetGivenEvidence.length) {
            norm = normalizationList[i5 % this.evidenceStatesProduct];
            if (norm != 0.0f) {
                int n = i5;
                postProbTargetGivenEvidence[n] = postProbTargetGivenEvidence[n] / norm;
            }
            ++i5;
        }
        float[] postProbTargetGivenTarget = new float[(int)Math.pow(this.targetNode.getStatesSize(), 2.0)];
        int statesSize = this.targetNode.getStatesSize();
        row = 0;
        int index = 0;
        int i6 = 0;
        while (i6 < this.statesProduct) {
            int j = 0;
            while (j < statesSize) {
                row = i6 / this.evidenceStatesProduct * statesSize + j;
                index = i6 % this.evidenceStatesProduct + j * this.evidenceStatesProduct;
                int n = row;
                postProbTargetGivenTarget[n] = postProbTargetGivenTarget[n] + postProbTargetGivenEvidence[i6] * postProbEvidenceGivenTarget[index];
                ++j;
            }
            ++i6;
        }
        float[][] CM = new float[statesSize][statesSize];
        int i7 = 0;
        while (i7 < statesSize) {
            int j = 0;
            while (j < statesSize) {
                CM[i7][j] = postProbTargetGivenTarget[i7 * statesSize + j];
                ++j;
            }
            ++i7;
        }
        long end = System.currentTimeMillis();
        System.out.println("Time elapsed for computing CM: " + (float)(end - init) / 1000.0f);
        return CM;
    }

    protected void setMaxProgress(int evidenceNodeListSize) {
        this.maxProgress = this.sampleSize * (2 * evidenceNodeListSize + 2);
    }

    @Override
    public void update(LongTaskProgressChangedEvent status) {
        int samplingProgress = (int)((float)status.getPercentageDone() / 10000.0f * (float)this.sampleSize);
        int delta = samplingProgress - this.previousSamplingProgress;
        if (delta > 0) {
            this.updateProgress(this.currentProgress + delta);
            this.previousSamplingProgress = samplingProgress;
        }
    }

    public static void main(String[] args) throws Exception {
        boolean runSmallTest = false;
        boolean onlyGCM = true;
        ArrayList<String> targetNodeNameList = new ArrayList<String>();
        ArrayList<String> evidenceNodeNameList = new ArrayList<String>();
        String netFileName = "";
        int sampleSize = 0;
        if (runSmallTest) {
            targetNodeNameList = new ArrayList();
            targetNodeNameList.add("Springler");
            evidenceNodeNameList = new ArrayList();
            evidenceNodeNameList.add("Cloudy");
            evidenceNodeNameList.add("Rain");
            evidenceNodeNameList.add("Wet");
            netFileName = "src/test/resources/testCases/evaluation/WetGrass.xml";
            sampleSize = 100000;
        } else {
            targetNodeNameList = new ArrayList();
            targetNodeNameList.add("TargetType");
            evidenceNodeNameList = new ArrayList();
            evidenceNodeNameList.add("UHRR_Confusion");
            evidenceNodeNameList.add("ModulationFrequency");
            evidenceNodeNameList.add("CenterFrequency");
            evidenceNodeNameList.add("PRI");
            evidenceNodeNameList.add("PRF");
            netFileName = "src/test/resources/testCases/evaluation/AirID.xml";
            sampleSize = 500000;
        }
        FastLWApproximateEvaluation evaluationApproximate = new FastLWApproximateEvaluation(sampleSize);
        evaluationApproximate.evaluate(netFileName, targetNodeNameList, evidenceNodeNameList, onlyGCM);
        System.out.println("----TOTAL------");
        System.out.println("LCM:\n");
        FastLWApproximateEvaluation.show(evaluationApproximate.getEvidenceSetCM());
        System.out.println("\n");
        System.out.println("PCC: ");
        System.out.printf("%2.2f\n", Float.valueOf(evaluationApproximate.getEvidenceSetPCC() * 100.0f));
        if (!onlyGCM) {
            System.out.println("\n\n\n");
            System.out.println("----MARGINAL------");
            System.out.println("\n\n");
            List<EvidenceEvaluation> list = evaluationApproximate.getBestMarginalImprovement();
            for (EvidenceEvaluation evidenceEvaluation : list) {
                System.out.println("-" + evidenceEvaluation.getName() + "-");
                System.out.println("\n\n");
                System.out.println("LCM:\n");
                FastLWApproximateEvaluation.show(evidenceEvaluation.getMarginalCM());
                System.out.println("\n");
                System.out.println("PCC: ");
                System.out.printf("%2.2f\n", Float.valueOf(evidenceEvaluation.getMarginalPCC() * 100.0f));
                System.out.println("\n");
                System.out.println("Marginal Improvement: ");
                System.out.printf("%2.2f\n", Float.valueOf(evidenceEvaluation.getMarginalImprovement() * 100.0f));
                System.out.println("\n\n");
            }
            System.out.println("\n");
            System.out.println("----INDIVIDUAL PCC------");
            System.out.println("\n\n");
            list = evaluationApproximate.getBestIndividualPCC();
            for (EvidenceEvaluation evidenceEvaluation : list) {
                System.out.println("-" + evidenceEvaluation.getName() + "-");
                System.out.println("\n\n");
                System.out.println("LCM:\n");
                FastLWApproximateEvaluation.show(evidenceEvaluation.getIndividualLCM());
                System.out.println("\n");
                System.out.println("PCC: ");
                System.out.printf("%2.2f\n", Float.valueOf(evidenceEvaluation.getIndividualPCC() * 100.0f));
                System.out.println("\n\n");
                evidenceEvaluation.setCost(new Random().nextFloat() * 1000.0f);
            }
            System.out.println("\n");
            System.out.println("----INDIVIDUAL PCC------");
            System.out.println("\n\n");
            list = evaluationApproximate.getBestIndividualCostRate();
            for (EvidenceEvaluation evidenceEvaluation : list) {
                System.out.println("-" + evidenceEvaluation.getName() + "-");
                System.out.println("\n\n");
                System.out.println("PCC: ");
                System.out.printf("%2.2f\n", Float.valueOf(evidenceEvaluation.getIndividualPCC() * 100.0f));
                System.out.println("\n");
                System.out.println("Cost: ");
                System.out.printf("%2.2f\n", Float.valueOf(evidenceEvaluation.getCost()));
                System.out.println("\n");
                System.out.println("Cost Rate: ");
                System.out.printf("%2.2f\n", Float.valueOf(evidenceEvaluation.getMarginalCost() * 100.0f));
                System.out.println("\n\n");
            }
        }
    }
}

