/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import unbbayes.evaluation.AEvaluation;
import unbbayes.evaluation.EvidenceEvaluation;
import unbbayes.evaluation.exception.EvaluationException;
import unbbayes.prs.Node;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.simulation.montecarlo.sampling.IMonteCarloSampling;
import unbbayes.simulation.montecarlo.sampling.MapMonteCarloSampling;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryEfficientApproximateEvaluation
extends AEvaluation {
    private int sampleSize;
    IMonteCarloSampling mc;
    Set<Map.Entry<Integer, Integer>> sampledSet;
    private TreeVariable targetNode;
    private List<Node> positionNodeList;
    private int[] positionTargetNodeList;
    private int[] positionEvidenceNodeList;

    @Override
    public float getError() {
        return (float)(1.0 / Math.sqrt(this.sampleSize));
    }

    public MemoryEfficientApproximateEvaluation(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Override
    protected void evaluate(List<String> targetNodeNameList, List<String> evidenceNodeNameList, boolean onlyGCM) throws EvaluationException {
        this.mc = new MapMonteCarloSampling();
        long init = System.currentTimeMillis();
        this.mc.start(this.net, this.sampleSize);
        long end = System.currentTimeMillis();
        Debug.println("Time elapsed for sampling: " + (float)(end - init) / 1000.0f);
        this.sampledSet = this.mc.getSampledStatesMap().entrySet();
        Debug.println("Sample size: " + this.sampleSize);
        Debug.println("Sample map size: " + this.sampledSet.size());
        super.evaluate(targetNodeNameList, evidenceNodeNameList, onlyGCM);
    }

    @Override
    protected float[][] computeCM(List<String> targetNodeNameList, List<String> evidenceNodeNameList) throws EvaluationException {
        this.init(targetNodeNameList, evidenceNodeNameList);
        long init = System.currentTimeMillis();
        this.targetNode = this.targetNodeList[0];
        if (this.targetNodeList.length != 1) {
            throw new EvaluationException("For now, just one target node is accepted!");
        }
        this.positionTargetNodeList = new int[this.targetNodeList.length];
        this.positionEvidenceNodeList = new int[this.evidenceNodeList.length];
        this.positionNodeList = this.mc.getSamplingNodeOrderQueue();
        int i = 0;
        while (i < this.positionTargetNodeList.length) {
            this.positionTargetNodeList[i] = this.positionNodeList.indexOf(this.targetNodeList[i]);
            ++i;
        }
        i = 0;
        while (i < this.positionEvidenceNodeList.length) {
            this.positionEvidenceNodeList[i] = this.positionNodeList.indexOf(this.evidenceNodeList[i]);
            ++i;
        }
        HashMap<Integer, Integer> frequencyEvidenceGivenTargetMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> frequencyTargetMap = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry : this.sampledSet) {
            int value = entry.getValue();
            int[] dim = this.getMultidimensionalCoord(this.mc.getMultidimensionalCoord(entry.getKey()));
            Object previousValue = (Integer)frequencyTargetMap.get(dim[0]);
            if (previousValue != null) {
                frequencyTargetMap.put(dim[0], (Integer)previousValue + value);
            } else {
                frequencyTargetMap.put(dim[0], value);
            }
            int key = this.getLinearCoord(dim);
            previousValue = (Integer)frequencyEvidenceGivenTargetMap.get(key);
            if (previousValue != null) {
                frequencyEvidenceGivenTargetMap.put(key, (Integer)previousValue + value);
                continue;
            }
            frequencyEvidenceGivenTargetMap.put(key, value);
        }
        HashMap<Integer, Float> postProbEvidenceGivenTargetMap = new HashMap<Integer, Float>();
        Set frequencyEvidenceGivenTargetSet = frequencyEvidenceGivenTargetMap.entrySet();
        float[][] postProbEvidenceGivenTarget = new float[this.evidenceStatesProduct][this.targetNode.getStatesSize()];
        for (Map.Entry entry : frequencyEvidenceGivenTargetSet) {
            float value = ((Integer)entry.getValue()).intValue();
            int n = (Integer)entry.getKey();
            Object dim = this.getMultidimensionalCoord(n);
            float f = value / (float)((Integer)frequencyTargetMap.get((int)dim[0])).intValue();
            postProbEvidenceGivenTargetMap.put(n, Float.valueOf(f));
            postProbEvidenceGivenTarget[this.getEvidenceLinearCoord((int[])dim)][dim[0]] = f;
        }
        HashMap<Integer, Float> postProbTargetGivenEvidenceMap = new HashMap<Integer, Float>();
        HashMap<Integer, Float> normalizationMap = new HashMap<Integer, Float>();
        Set postProbEvidenceGivenTargetSet = postProbEvidenceGivenTargetMap.entrySet();
        try {
            this.net.compile();
        }
        catch (Exception exception) {
            throw new EvaluationException(exception.getMessage());
        }
        for (Map.Entry entry : postProbEvidenceGivenTargetSet) {
            int n = (Integer)entry.getKey();
            Object dim = this.getMultidimensionalCoord(n);
            float prob = ((Float)entry.getValue()).floatValue() * this.targetNode.getMarginalAt((int)dim[0]);
            postProbTargetGivenEvidenceMap.put(this.getLinearCoord((int[])dim), Float.valueOf(prob));
            Float previousProb = (Float)normalizationMap.get(this.getEvidenceLinearCoord((int[])dim));
            if (previousProb != null) {
                normalizationMap.put(this.getEvidenceLinearCoord((int[])dim), Float.valueOf(previousProb.floatValue() + prob));
                continue;
            }
            normalizationMap.put(this.getEvidenceLinearCoord((int[])dim), Float.valueOf(prob));
        }
        Set set = postProbTargetGivenEvidenceMap.entrySet();
        float[][] postProbTargetGivenEvidence = new float[this.targetNode.getStatesSize()][this.evidenceStatesProduct];
        for (Map.Entry entry : set) {
            int key = (Integer)entry.getKey();
            int[] dim = this.getMultidimensionalCoord(key);
            float prob = ((Float)entry.getValue()).floatValue() / ((Float)normalizationMap.get(this.getEvidenceLinearCoord(dim))).floatValue();
            entry.setValue(Float.valueOf(prob));
            postProbTargetGivenEvidence[dim[0]][this.getEvidenceLinearCoord((int[])dim)] = prob;
        }
        int n = this.targetNode.getStatesSize();
        float[][] CM = new float[n][n];
        int i2 = 0;
        while (i2 < n) {
            float[] arowi = postProbTargetGivenEvidence[i2];
            float[] crowi = CM[i2];
            int k = 0;
            while (k < this.evidenceStatesProduct) {
                float[] browk = postProbEvidenceGivenTarget[k];
                float aik = arowi[k];
                int j = 0;
                while (j < n) {
                    int n2 = j;
                    crowi[n2] = crowi[n2] + aik * browk[j];
                    ++j;
                }
                ++k;
            }
            ++i2;
        }
        long end = System.currentTimeMillis();
        Debug.println("Time elapsed for computing CM: " + (float)(end - init) / 1000.0f);
        return CM;
    }

    protected int[] getMultidimensionalCoord(byte[] dim) {
        int size = this.targetNodeList.length + this.evidenceNodeList.length;
        int[] multidimensionalCoord = new int[size];
        int i = 0;
        while (i < this.positionTargetNodeList.length) {
            multidimensionalCoord[i] = dim[this.positionTargetNodeList[i]];
            ++i;
        }
        i = 0;
        while (i < this.positionEvidenceNodeList.length) {
            multidimensionalCoord[i + this.positionTargetNodeList.length] = dim[this.positionEvidenceNodeList[i]];
            ++i;
        }
        return multidimensionalCoord;
    }

    public static void main(String[] args) throws Exception {
        boolean runSmallTest = false;
        boolean onlyGCM = true;
        ArrayList<String> targetNodeNameList = new ArrayList<String>();
        ArrayList<String> evidenceNodeNameList = new ArrayList<String>();
        String netFileName = "";
        int sampleSize = 0;
        if (runSmallTest) {
            targetNodeNameList = new ArrayList();
            targetNodeNameList.add("Springler");
            evidenceNodeNameList = new ArrayList();
            evidenceNodeNameList.add("Cloudy");
            evidenceNodeNameList.add("Rain");
            evidenceNodeNameList.add("Wet");
            netFileName = "src/test/resources/testCases/evaluation/WetGrass.xml";
            sampleSize = 100000;
        } else {
            targetNodeNameList = new ArrayList();
            targetNodeNameList.add("TargetType");
            evidenceNodeNameList = new ArrayList();
            evidenceNodeNameList.add("UHRR_Confusion");
            evidenceNodeNameList.add("ModulationFrequency");
            evidenceNodeNameList.add("CenterFrequency");
            evidenceNodeNameList.add("PRI");
            evidenceNodeNameList.add("PRF");
            netFileName = "src/test/resources/testCases/evaluation/AirID.xml";
            sampleSize = 50000000;
        }
        MemoryEfficientApproximateEvaluation evaluationApproximate = new MemoryEfficientApproximateEvaluation(sampleSize);
        evaluationApproximate.evaluate(netFileName, targetNodeNameList, evidenceNodeNameList, onlyGCM);
        System.out.println("----TOTAL------");
        System.out.println("LCM:\n");
        MemoryEfficientApproximateEvaluation.show(evaluationApproximate.getEvidenceSetCM());
        System.out.println("\n");
        System.out.println("PCC: ");
        System.out.printf("%2.2f\n", Float.valueOf(evaluationApproximate.getEvidenceSetPCC() * 100.0f));
        if (!onlyGCM) {
            System.out.println("\n\n\n");
            System.out.println("----MARGINAL------");
            System.out.println("\n\n");
            List<EvidenceEvaluation> list = evaluationApproximate.getBestMarginalImprovement();
            for (EvidenceEvaluation evidenceEvaluation : list) {
                System.out.println("-" + evidenceEvaluation.getName() + "-");
                System.out.println("\n\n");
                System.out.println("LCM:\n");
                MemoryEfficientApproximateEvaluation.show(evidenceEvaluation.getMarginalCM());
                System.out.println("\n");
                System.out.println("PCC: ");
                System.out.printf("%2.2f\n", Float.valueOf(evidenceEvaluation.getMarginalPCC() * 100.0f));
                System.out.println("\n");
                System.out.println("Marginal Improvement: ");
                System.out.printf("%2.2f\n", Float.valueOf(evidenceEvaluation.getMarginalImprovement() * 100.0f));
                System.out.println("\n\n");
            }
            System.out.println("\n");
            System.out.println("----INDIVIDUAL PCC------");
            System.out.println("\n\n");
            list = evaluationApproximate.getBestIndividualPCC();
            for (EvidenceEvaluation evidenceEvaluation : list) {
                System.out.println("-" + evidenceEvaluation.getName() + "-");
                System.out.println("\n\n");
                System.out.println("LCM:\n");
                MemoryEfficientApproximateEvaluation.show(evidenceEvaluation.getIndividualLCM());
                System.out.println("\n");
                System.out.println("PCC: ");
                System.out.printf("%2.2f\n", Float.valueOf(evidenceEvaluation.getIndividualPCC() * 100.0f));
                System.out.println("\n\n");
                evidenceEvaluation.setCost(new Random().nextFloat() * 1000.0f);
            }
            System.out.println("\n");
            System.out.println("----INDIVIDUAL PCC------");
            System.out.println("\n\n");
            list = evaluationApproximate.getBestIndividualCostRate();
            for (EvidenceEvaluation evidenceEvaluation : list) {
                System.out.println("-" + evidenceEvaluation.getName() + "-");
                System.out.println("\n\n");
                System.out.println("PCC: ");
                System.out.printf("%2.2f\n", Float.valueOf(evidenceEvaluation.getIndividualPCC() * 100.0f));
                System.out.println("\n");
                System.out.println("Cost: ");
                System.out.printf("%2.2f\n", Float.valueOf(evidenceEvaluation.getCost()));
                System.out.println("\n");
                System.out.println("Cost Rate: ");
                System.out.printf("%2.2f\n", Float.valueOf(evidenceEvaluation.getMarginalCost() * 100.0f));
                System.out.println("\n\n");
            }
        }
    }
}

