/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.evaluation.controller;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import unbbayes.evaluation.EvidenceEvaluation;
import unbbayes.evaluation.FastLWApproximateEvaluation;
import unbbayes.evaluation.IEvaluation;
import unbbayes.evaluation.controller.EvaluationThread;
import unbbayes.evaluation.exception.EvaluationException;
import unbbayes.evaluation.gui.EvaluationPane;
import unbbayes.gui.LongTaskProgressBar;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;

public class EvaluationController {
    private EvaluationPane evaluationPane;
    private ProbabilisticNetwork network;
    private IEvaluation evaluation;

    public EvaluationController(ProbabilisticNetwork network) {
        this.network = network;
        this.evaluationPane = new EvaluationPane();
        this.setUpEvaluation();
    }

    public void setUpEvaluation() {
        List nodeList = this.network.getNodes();
        HashMap<String, List<String>> nodeFindingMap = new HashMap<String, List<String>>();
        for (Node node : nodeList) {
            ArrayList<String> findingList = new ArrayList<String>(node.getStatesSize());
            int i = 0;
            while (i < node.getStatesSize()) {
                findingList.add(node.getStateAt(i));
                ++i;
            }
            nodeFindingMap.put(node.getName(), findingList);
        }
        this.evaluationPane.addInputValues(nodeFindingMap);
        this.evaluationPane.setRunButtonActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                new EvaluationThread(EvaluationController.this);
            }
        });
    }

    private void validateData() throws EvaluationException {
        StringBuffer errorMsg = new StringBuffer();
        try {
            Integer sampleSize = this.evaluationPane.getSampleSizeValue();
            if (sampleSize <= 0) {
                errorMsg.append("Sample size has to be greater than 0. \n");
            }
        }
        catch (NumberFormatException e) {
            errorMsg.append("Sample size has to be greater than 0. \n");
        }
        if (this.evaluationPane.getTargetNodeNameList().size() == 0) {
            errorMsg.append("There must be at least one target node selected. \n");
        }
        if (this.evaluationPane.getEvidenceNodeNameList().size() == 0) {
            errorMsg.append("There must be at least one evidence node selected. \n");
        }
        if (errorMsg.toString().length() > 0) {
            throw new EvaluationException(errorMsg.toString());
        }
    }

    void runEvaluation() {
        ProbabilisticNode node;
        this.evaluationPane.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.validateData();
        }
        catch (EvaluationException e) {
            JOptionPane.showMessageDialog(this.evaluationPane, e.getMessage(), "Validation Error", 0);
            return;
        }
        List<String> targetNodeNameList = this.evaluationPane.getTargetNodeNameList();
        List<String> evidenceNodeNameList = this.evaluationPane.getEvidenceNodeNameList();
        int sampleSize = this.evaluationPane.getSampleSizeValue();
        this.evaluation = new FastLWApproximateEvaluation(sampleSize);
        LongTaskProgressBar progress = new LongTaskProgressBar(false);
        progress.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationController.this.finishEvaluation();
            }
        });
        this.evaluation.registerObserver(progress);
        progress.setThread(EvaluationThread.t);
        this.evaluationPane.updateProgressBarPane(progress);
        Map<String, String> nodeFindingMap = this.evaluationPane.getNodeConditionMap();
        for (String nodeName : nodeFindingMap.keySet()) {
            node = (ProbabilisticNode)this.network.getNode(nodeName);
            int i = 0;
            while (i < node.getStatesSize()) {
                if (nodeFindingMap.get(nodeName).equals(node.getStateAt(i))) {
                    node.initMarginalList();
                    node.addFinding(i);
                }
                ++i;
            }
        }
        try {
            this.evaluation.evaluate(this.network, targetNodeNameList, evidenceNodeNameList, false);
            progress.setProgressBar(10000);
            List<EvidenceEvaluation> evidenceEvaluationList = this.evaluation.getBestMarginalImprovement();
            for (EvidenceEvaluation evidenceEvaluation : evidenceEvaluationList) {
                evidenceEvaluation.setCost(this.evaluationPane.getCost(evidenceEvaluation.getName()));
            }
            this.evaluationPane.setPccValue(this.evaluation.getEvidenceSetPCC());
            this.evaluationPane.setErrorValue(this.evaluation.getError());
            this.evaluationPane.addOutputValues(evidenceEvaluationList);
            node = (ProbabilisticNode)this.network.getNode(targetNodeNameList.get(0));
            String[] header = new String[node.getStatesSize()];
            int i = 0;
            while (i < node.getStatesSize()) {
                header[i] = node.getStateAt(i);
                ++i;
            }
            float[][] data = this.evaluation.getEvidenceSetCM();
            Float[][] rowData = new Float[data.length][data[0].length];
            int i2 = 0;
            while (i2 < rowData.length) {
                int j = 0;
                while (j < rowData[0].length) {
                    rowData[i2][j] = Float.valueOf(data[i2][j]);
                    ++j;
                }
                ++i2;
            }
            this.evaluationPane.setUpOutputCM(rowData, header);
            this.evaluationPane.revalidate();
            this.evaluationPane.repaint();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.evaluationPane, e.getMessage(), "Evaluation Error", 0);
            return;
        }
        this.network.resetEvidences();
        this.finishEvaluation();
    }

    private void finishEvaluation() {
        this.evaluationPane.resetProgressBar();
        this.evaluationPane.setCursor(Cursor.getPredefinedCursor(0));
    }

    public JPanel getView() {
        return this.evaluationPane;
    }
}

