/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.evaluation.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import unbbayes.evaluation.EvidenceEvaluation;
import unbbayes.evaluation.exception.EvaluationException;
import unbbayes.gui.LongTaskProgressBar;
import unbbayes.gui.table.EachRowEditor;
import unbbayes.gui.table.NumberEditor;
import unbbayes.gui.table.NumberRenderer;
import unbbayes.gui.table.PercentRenderer;
import unbbayes.gui.table.RadioButtonCellEditor;
import unbbayes.gui.table.RadioButtonCellRenderer;
import unbbayes.gui.table.RowHeaderRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    public JPanel mainPane = new JPanel();
    private JTable inputTable;
    private JLabel sampleSizeLabel;
    private JFormattedTextField sampleSizeTextField;
    private JLabel errorLabel;
    private JFormattedTextField errorTextField;
    private JButton runButton;
    private JButton cancelButton;
    private JProgressBar progressBar;
    private JTable outputTable;
    private JScrollPane cmOutputTableScroll;
    private JLabel pccLabel;
    private JFormattedTextField pccValueTextField;
    private JPanel sampleSizePane;
    private JPanel progressBarPane;

    public EvaluationPane() {
        super(new GridLayout(1, 1));
        this.mainPane.setLayout(new BoxLayout(this.mainPane, 1));
        this.setUpInputPane();
        this.setUpOutputPane();
        this.add(this.mainPane);
    }

    private void setUpInputPane() {
        this.setUpInputTable();
        this.setUpSampleSizePane();
        this.setUpProgressBarPane();
    }

    private void setUpInputTable() {
        EvaluationInputTableModel dm = new EvaluationInputTableModel();
        this.inputTable = new JTable(dm);
        this.inputTable.setPreferredScrollableViewportSize(new Dimension(500, 80));
        JScrollPane scrollPane = new JScrollPane(this.inputTable);
        this.inputTable.getColumn("Target").setCellRenderer(new RadioButtonCellRenderer());
        this.inputTable.getColumn("Target").setCellEditor(new RadioButtonCellEditor());
        this.inputTable.setDefaultEditor(Float.class, new NumberEditor());
        this.inputTable.setDefaultRenderer(Float.class, new NumberRenderer());
        this.mainPane.add(scrollPane);
    }

    private void setUpSampleSizePane() {
        this.sampleSizePane = new JPanel(new FlowLayout(0));
        this.sampleSizeLabel = new JLabel("Sample Size:");
        this.sampleSizeTextField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.sampleSizeTextField.setColumns(10);
        this.errorLabel = new JLabel("Error:");
        DecimalFormat numberFormat = new DecimalFormat("0.###E0");
        this.errorTextField = new JFormattedTextField(numberFormat);
        this.errorTextField.setColumns(5);
        this.errorTextField.setEditable(false);
        this.sampleSizePane.add(this.sampleSizeLabel);
        this.sampleSizePane.add(this.sampleSizeTextField);
        this.sampleSizePane.add(this.errorLabel);
        this.sampleSizePane.add(this.errorTextField);
        this.mainPane.add(this.sampleSizePane);
    }

    private void setUpProgressBarPane() {
        this.progressBarPane = new JPanel(new FlowLayout(0));
        this.runButton = new JButton("Run");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setEnabled(false);
        this.progressBar = new JProgressBar();
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBarPane.add(this.runButton);
        this.progressBarPane.add(this.cancelButton);
        this.progressBarPane.add(this.progressBar);
        this.mainPane.add(this.progressBarPane);
    }

    public void updateProgressBarPane(LongTaskProgressBar ltProgressBar) {
        this.runButton.setEnabled(false);
        this.progressBarPane.remove(this.cancelButton);
        this.cancelButton = ltProgressBar.getCancelButton();
        this.progressBarPane.add(this.cancelButton);
        this.cancelButton.setEnabled(true);
        this.progressBarPane.remove(this.progressBar);
        this.progressBar = ltProgressBar.getProgressBar();
        this.progressBar.setBorder(null);
        this.progressBarPane.add(this.progressBar);
    }

    public void resetProgressBar() {
        this.runButton.setEnabled(true);
        this.cancelButton.setEnabled(false);
        this.progressBar.setValue(0);
    }

    private void setUpOutputPane() {
        this.setUpPccPane();
        this.setUpOutputTable();
        this.setUpOutputCM(new Float[0][0], new String[0]);
    }

    private void setUpPccPane() {
        JPanel pccPane = new JPanel(new FlowLayout(0));
        this.pccLabel = new JLabel("Probability of Correct Classification:");
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        this.pccValueTextField = new JFormattedTextField(numberFormat);
        this.pccValueTextField.setColumns(10);
        this.pccValueTextField.setEditable(false);
        pccPane.add(this.pccLabel);
        pccPane.add(this.pccValueTextField);
        this.mainPane.add(pccPane);
    }

    private void setUpOutputTable() {
        EvaluationOutputTableModel dm = new EvaluationOutputTableModel();
        this.outputTable = new JTable(dm){
            private static final long serialVersionUID = 1L;

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){
                    private static final long serialVersionUID = 1L;

                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return ((EvaluationOutputTableModel)this.getModel()).getColumnToolTip(realIndex);
                    }
                };
            }
        };
        this.outputTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane scrollPane = new JScrollPane(this.outputTable);
        this.outputTable.setDefaultRenderer(Float.class, new PercentRenderer());
        this.outputTable.getColumn("Cost").setCellRenderer(new NumberRenderer());
        this.outputTable.getColumn("Marginal Cost").setCellRenderer(new NumberRenderer(2, 6));
        this.mainPane.add(scrollPane);
    }

    public void setUpOutputCM(Float[][] rowData, String[] header) {
        if (this.cmOutputTableScroll != null) {
            this.mainPane.remove(this.cmOutputTableScroll);
        }
        AbstractListModel lm = new AbstractListModel(header){
            private static final long serialVersionUID = 1L;
            String[] headers;
            {
                this.headers = stringArray;
            }

            public int getSize() {
                return this.headers.length;
            }

            public Object getElementAt(int index) {
                return this.headers[index];
            }
        };
        CMOutputTableModel tm = new CMOutputTableModel(rowData, header);
        JTable table = new JTable(tm);
        JList rowHeader = new JList(lm);
        rowHeader.setCellRenderer(new RowHeaderRenderer(table));
        this.cmOutputTableScroll = new JScrollPane(table);
        this.cmOutputTableScroll.setRowHeaderView(rowHeader);
        table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        table.setDefaultRenderer(Float.class, new PercentRenderer());
        this.mainPane.add(this.cmOutputTableScroll);
    }

    public void setRunButtonActionListener(ActionListener actionListener) {
        this.runButton.addActionListener(actionListener);
    }

    public Integer getSampleSizeValue() {
        return ((Long)this.sampleSizeTextField.getValue()).intValue();
    }

    public List<String> getTargetNodeNameList() {
        ArrayList<String> targetNodeNameList = new ArrayList<String>();
        TableModel dm = this.inputTable.getModel();
        int i = 0;
        while (i < dm.getRowCount()) {
            if (((Boolean)dm.getValueAt(i, 1)).booleanValue()) {
                targetNodeNameList.add((String)dm.getValueAt(i, 0));
            }
            ++i;
        }
        return targetNodeNameList;
    }

    public List<String> getEvidenceNodeNameList() {
        ArrayList<String> evidenceNodeNameList = new ArrayList<String>();
        TableModel dm = this.inputTable.getModel();
        int i = 0;
        while (i < dm.getRowCount()) {
            if (((Boolean)dm.getValueAt(i, 2)).booleanValue()) {
                evidenceNodeNameList.add((String)dm.getValueAt(i, 0));
            }
            ++i;
        }
        return evidenceNodeNameList;
    }

    public float getCost(String nodeName) {
        TableModel dm = this.inputTable.getModel();
        int i = 0;
        while (i < dm.getRowCount()) {
            if (((Boolean)dm.getValueAt(i, 2)).booleanValue() && dm.getValueAt(i, 0).equals(nodeName)) {
                return ((Float)dm.getValueAt(i, 3)).floatValue();
            }
            ++i;
        }
        return 0.0f;
    }

    public Map<String, String> getNodeConditionMap() {
        HashMap<String, String> nodeConditionMap = new HashMap<String, String>();
        TableModel dm = this.inputTable.getModel();
        int i = 0;
        while (i < dm.getRowCount()) {
            String finding = (String)dm.getValueAt(i, 4);
            if (!finding.equals("")) {
                nodeConditionMap.put((String)dm.getValueAt(i, 0), finding);
            }
            ++i;
        }
        return nodeConditionMap;
    }

    public void setPccValue(float pccValue) {
        this.pccValueTextField.setValue(Float.valueOf(pccValue));
    }

    public void setErrorValue(float errorValue) {
        this.errorTextField.setValue(Float.valueOf(errorValue));
    }

    public void addOutputValues(List<EvidenceEvaluation> evidenceEvaluationList) throws EvaluationException {
        ((EvaluationOutputTableModel)this.outputTable.getModel()).addValues(evidenceEvaluationList);
        this.outputTable.revalidate();
    }

    public void addInputValues(Map<String, List<String>> nodeConditionMap) {
        Set<String> nodeNameList = nodeConditionMap.keySet();
        ((EvaluationInputTableModel)this.inputTable.getModel()).addValues(nodeNameList);
        int i = 0;
        EachRowEditor rowEditor = new EachRowEditor(this.inputTable);
        this.inputTable.getColumn("Condition").setCellEditor(rowEditor);
        for (String node : nodeNameList) {
            JComboBox comboBox = this.getComboBox(nodeConditionMap.get(node));
            rowEditor.setEditorAt(i++, new DefaultCellEditor(comboBox));
        }
        this.inputTable.revalidate();
    }

    private JComboBox getComboBox(List<String> findingList) {
        JComboBox<String> combo = new JComboBox<String>();
        combo.addItem("");
        for (String finding : findingList) {
            combo.addItem(finding);
        }
        return combo;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("TableRenderDemo");
        frame.setDefaultCloseOperation(3);
        EvaluationPane newContentPane = new EvaluationPane();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EvaluationPane.createAndShowGUI();
            }
        });
    }

    private class CMOutputTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnNames;
        private Object[][] data;

        public CMOutputTableModel(Float[][] data, String[] columnNames) {
            this.data = data;
            this.columnNames = columnNames;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return Float.class;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EvaluationInputTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = new String[]{"Node", "Target", "Evidence", "Cost", "Condition"};
        private Object[][] data = new Object[0][5];

        private EvaluationInputTableModel() {
        }

        public void addValues(Set<String> nodeNameSet) {
            this.data = new Object[nodeNameSet.size()][this.getColumnCount()];
            int i = 0;
            for (String node : nodeNameSet) {
                this.data[i][0] = node;
                this.data[i][1] = Boolean.FALSE;
                this.data[i][2] = Boolean.FALSE;
                this.data[i][3] = new Float(100.0);
                this.data[i++][4] = "";
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            if (c == 0 || c == 4) {
                return String.class;
            }
            if (c == 1 || c == 2) {
                return Boolean.class;
            }
            return Float.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
            if (col == 1 && value.equals(Boolean.TRUE)) {
                this.resetNonSelectedValues(row, col);
                this.setValueAt(Boolean.FALSE, row, 2);
                this.fireTableCellUpdated(row, 2);
                this.setValueAt("", row, 4);
                this.fireTableCellUpdated(row, 4);
            } else if (col == 2 && value.equals(Boolean.TRUE)) {
                this.setValueAt(Boolean.FALSE, row, 1);
                this.fireTableCellUpdated(row, 1);
                this.setValueAt("", row, 4);
                this.fireTableCellUpdated(row, 4);
            } else if (col == 4 && !value.equals("")) {
                this.setValueAt(Boolean.FALSE, row, 1);
                this.fireTableCellUpdated(row, 1);
                this.setValueAt(Boolean.FALSE, row, 2);
                this.fireTableCellUpdated(row, 2);
            }
        }

        private void resetNonSelectedValues(int newRow, int col) {
            int row = 0;
            while (row < this.data.length) {
                if (this.getValueAt(row, col).equals(Boolean.TRUE) && row != newRow) {
                    this.setValueAt(Boolean.FALSE, row, col);
                    this.fireTableCellUpdated(row, col);
                }
                ++row;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EvaluationOutputTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnToolTips = new String[]{"Node", "Marginal PCC (%)", "Marginal Improvement (%)", "Individual PCC (%)", "Cost", "Individual Marginal Cost"};
        private String[] columnNames = new String[]{"Node", "MPCC (%)", "MI (%)", "IPCC (%)", "Cost", "Marginal Cost"};
        private Object[][] data = new Object[0][6];

        public void addValues(List<EvidenceEvaluation> evidenceEvaluationList) throws EvaluationException {
            this.data = new Object[evidenceEvaluationList.size()][this.getColumnCount()];
            int i = 0;
            while (i < evidenceEvaluationList.size()) {
                EvidenceEvaluation evidenceEvaluation = evidenceEvaluationList.get(i);
                this.data[i][0] = evidenceEvaluation.getName();
                this.data[i][1] = Float.valueOf(evidenceEvaluation.getMarginalPCC());
                this.data[i][2] = Float.valueOf(evidenceEvaluation.getMarginalImprovement());
                this.data[i][3] = Float.valueOf(evidenceEvaluation.getIndividualPCC());
                this.data[i][4] = Float.valueOf(evidenceEvaluation.getCost());
                this.data[i][5] = Float.valueOf(evidenceEvaluation.getMarginalCost());
                ++i;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public String getColumnToolTip(int col) {
            return this.columnToolTips[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return String.class;
            }
            return Float.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

