/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.example;

import java.io.File;
import java.util.ArrayList;
import unbbayes.io.NetIO;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.JunctionTreeAlgorithm;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;

public class SimpleTextMode {
    public static void main(String[] args) throws Exception {
        ProbabilisticNetwork net = (ProbabilisticNetwork)new NetIO().load(new File("./examples/bn/net/asia.net"));
        ProbabilisticNode newNode = new ProbabilisticNode();
        newNode.setName("K");
        newNode.setDescription("A test node");
        newNode.appendState("State 0");
        newNode.appendState("State 1");
        PotentialTable auxCPT = newNode.getProbabilityFunction();
        auxCPT.addVariable(newNode);
        net.addNode(newNode);
        ProbabilisticNode asiaNode = (ProbabilisticNode)net.getNode("A");
        net.addEdge(new Edge(asiaNode, newNode));
        auxCPT.addValueAt(0, 0.99f);
        auxCPT.addValueAt(1, 0.01f);
        auxCPT.addValueAt(2, 0.1f);
        auxCPT.addValueAt(3, 0.9f);
        JunctionTreeAlgorithm alg = new JunctionTreeAlgorithm();
        alg.setNetwork(net);
        alg.run();
        for (Node node : net.getNodes()) {
            System.out.println(node.getDescription());
            int i = 0;
            while (i < node.getStatesSize()) {
                System.out.println(String.valueOf(node.getStateAt(i)) + " : " + ((ProbabilisticNode)node).getMarginalAt(i));
                ++i;
            }
        }
        ProbabilisticNode findingNode = (ProbabilisticNode)((ArrayList)net.getNodes()).get(0);
        findingNode.addFinding(0);
        float[] likelihood = new float[newNode.getStatesSize()];
        likelihood[0] = 1.0f;
        likelihood[1] = 0.8f;
        newNode.addLikeliHood(likelihood);
        net.updateEvidences();
        System.out.println("****Updated****");
        for (Node node : net.getNodes()) {
            System.out.println(node.getDescription());
            int i = 0;
            while (i < node.getStatesSize()) {
                System.out.println(String.valueOf(node.getStateAt(i)) + " : " + ((ProbabilisticNode)node).getMarginalAt(i));
                ++i;
            }
        }
    }
}

