/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.example;

import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import unbbayes.example.resources.ExampleResources;
import unbbayes.io.NetIO;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.JunctionTreeAlgorithm;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.util.ResourceController;

public class TextMode {
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(ExampleResources.class.getName());

    public static void main(String[] args) throws Exception {
        ProbabilisticNetwork net = null;
        try {
            NetIO io = new NetIO();
            net = (ProbabilisticNetwork)io.load(new File("./examples/bn/net/asia.net"));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        ProbabilisticNode auxProbVariable = new ProbabilisticNode();
        auxProbVariable.setName(resource.getString("nodeName1"));
        auxProbVariable.setDescription(resource.getString("nodeDescription"));
        auxProbVariable.appendState(resource.getString("stateName0"));
        auxProbVariable.appendState(resource.getString("stateName1"));
        PotentialTable auxCPT = auxProbVariable.getProbabilityFunction();
        auxCPT.addVariable(auxProbVariable);
        auxCPT.addValueAt(0, 0.99f);
        auxCPT.addValueAt(1, 0.01f);
        net.addNode(auxProbVariable);
        ProbabilisticNode auxProbVariable2 = (ProbabilisticNode)net.getNode(resource.getString("nodeName2"));
        Edge auxEdge = new Edge(auxProbVariable, auxProbVariable2);
        net.addEdge(auxEdge);
        JunctionTreeAlgorithm algorithm = new JunctionTreeAlgorithm();
        algorithm.setNetwork(net);
        algorithm.run();
        List nodeList = net.getNodes();
        for (Node node : nodeList) {
            System.out.println(node.getDescription());
            int i = 0;
            while (i < node.getStatesSize()) {
                System.out.println(String.valueOf(node.getStateAt(i)) + " : " + ((ProbabilisticNode)node).getMarginalAt(i));
                ++i;
            }
        }
        int indexFirstNode = 0;
        ProbabilisticNode findingNode = (ProbabilisticNode)nodeList.get(indexFirstNode);
        int indexFirstState = 0;
        findingNode.addFinding(indexFirstState);
        System.out.println();
        try {
            net.updateEvidences();
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
        }
        for (Node node : nodeList) {
            System.out.println(node.getDescription());
            int i = 0;
            while (i < node.getStatesSize()) {
                System.out.println(String.valueOf(node.getStateAt(i)) + " : " + ((ProbabilisticNode)node).getMarginalAt(i));
                ++i;
            }
        }
    }
}

