/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.example;

import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.JunctionTreeAlgorithm;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.prs.id.DecisionNode;
import unbbayes.prs.id.UtilityNode;

public class TextModeID {
    public static void main(String[] args) throws Exception {
        int i;
        ProbabilisticNetwork net = new ProbabilisticNetwork("IDSample");
        DecisionNode decision = new DecisionNode();
        decision.setName("MyDecision");
        decision.setDescription("A decision node");
        decision.appendState("Action 0");
        decision.appendState("Action 1");
        net.addNode(decision);
        ProbabilisticNode probNode = new ProbabilisticNode();
        probNode.setName("MyProbNode");
        probNode.setDescription("A probabilstic node");
        probNode.appendState("State 0");
        probNode.appendState("State 1");
        PotentialTable auxCPT = probNode.getProbabilityFunction();
        auxCPT.addVariable(probNode);
        net.addNode(probNode);
        net.addEdge(new Edge(decision, probNode));
        auxCPT.addValueAt(0, 0.9f);
        auxCPT.addValueAt(1, 0.1f);
        auxCPT.addValueAt(2, 0.2f);
        auxCPT.addValueAt(3, 0.8f);
        UtilityNode utility = new UtilityNode();
        utility.setName("MyUtilityNode");
        utility.setDescription("An utility node");
        utility.getProbabilityFunction().addVariable(utility);
        net.addNode(utility);
        net.addEdge(new Edge(probNode, utility));
        utility.getProbabilityFunction().setValue(0, 50.0f);
        utility.getProbabilityFunction().setValue(1, -100.0f);
        JunctionTreeAlgorithm alg = new JunctionTreeAlgorithm();
        alg.setNetwork(net);
        alg.run();
        for (Node node : net.getNodes()) {
            System.out.println(node.getDescription());
            i = 0;
            while (i < node.getStatesSize()) {
                if (node instanceof TreeVariable) {
                    System.out.println(String.valueOf(node.getStateAt(i)) + " : " + ((TreeVariable)node).getMarginalAt(i));
                }
                ++i;
            }
        }
        ((TreeVariable)net.getNode("MyDecision")).addFinding(0);
        net.updateEvidences();
        System.out.println("***Propagation***");
        for (Node node : net.getNodes()) {
            System.out.println(node.getDescription());
            i = 0;
            while (i < node.getStatesSize()) {
                if (node instanceof TreeVariable) {
                    System.out.println(String.valueOf(node.getStateAt(i)) + " : " + ((TreeVariable)node).getMarginalAt(i));
                }
                ++i;
            }
        }
    }
}

