/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.example;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import unbbayes.io.BaseIO;
import unbbayes.io.DneIO;
import unbbayes.io.EvidenceIO;
import unbbayes.io.FileExtensionIODelegator;
import unbbayes.io.IEvidenceIO;
import unbbayes.io.NetIO;
import unbbayes.io.XMLBIFIO;
import unbbayes.io.exception.LoadException;
import unbbayes.prs.Node;
import unbbayes.prs.bn.JunctionTreeAlgorithm;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.util.extension.bn.inference.IInferenceAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextModeRunner {
    public static final String NET_FILE_ARGUMENT = "n";
    public static final String INPUT_ARGUMENT = "i";
    public static final String OUT_ARGUMENT = "o";
    public static final String QUERY_ARGUMENT = "q";
    public static final String QUERY_STATE_ARGUMENT = "s";
    public static final String PREAMBLE_ARGUMENT = "p";
    public static final String HELP_ARGUMENT = "h";
    private Map<String, String> configuration = Collections.EMPTY_MAP;
    private BaseIO io;
    private IEvidenceIO evidenceIO;

    public static void main(String[] args) {
        block3: {
            TextModeRunner runner = null;
            try {
                runner = TextModeRunner.newInstance(args);
                if (runner.getConfiguration().containsKey(HELP_ARGUMENT)) {
                    runner.printHelp();
                    return;
                }
                runner.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (runner == null) break block3;
                runner.printHelp();
            }
        }
    }

    public static boolean hasTextModeCommandLineArgument(String[] args) {
        if (args == null) {
            return false;
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg != null) {
                if (arg.equals("-h")) {
                    return true;
                }
                if (arg.equals("-n")) {
                    return true;
                }
                if (arg.equals("-i")) {
                    return true;
                }
                if (arg.equals("-o")) {
                    return true;
                }
                if (arg.equals("-p")) {
                    return true;
                }
                if (arg.equals("-q")) {
                    return true;
                }
                if (arg.equals("-s")) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    protected TextModeRunner() {
    }

    public static TextModeRunner newInstance(String[] args) {
        TextModeRunner ret = new TextModeRunner();
        FileExtensionIODelegator io = FileExtensionIODelegator.newInstance();
        io.getDelegators().add(new NetIO());
        io.getDelegators().add(new DneIO());
        io.getDelegators().add(new XMLBIFIO());
        ret.setIO(io);
        ret.setEvidenceIO(new EvidenceIO());
        ret.setConfiguration(ret.extractArguments(args));
        return ret;
    }

    public void run() throws LoadException, IOException {
        ProbabilisticNetwork net = this.loadNetFromFile();
        if (net == null) {
            throw new IllegalArgumentException("Could not load network");
        }
        IInferenceAlgorithm algorithm = this.compileNet(net);
        this.insertEvidences(net, algorithm);
        this.printResults(net, algorithm);
    }

    protected ProbabilisticNetwork loadNetFromFile() throws LoadException, IOException {
        String netFileName = this.getConfiguration().get(NET_FILE_ARGUMENT);
        if (netFileName == null) {
            netFileName = "bn.net";
        }
        return (ProbabilisticNetwork)this.getIO().load(new File(netFileName));
    }

    public void printHelp() {
        System.out.println("Expected arguments: [-n NETWORK_FILE] [-i EVIDENCE_FILE] [-o OUTPUT_FILE] [-q NODE_TO_QUERY]* [-p] [-s INDEX] [-h]");
        System.out.println("\t -n NETWORK_FILE : the bayesian network to load. Can be a .net (Hugin NET) file, an .xml (XMLBIF) file, or .dne (Netica DNE) file. If not spefcified, then bn.net will be loaded from program's root folder.");
        System.out.println("\t -i EVIDENCE_FILE : text file to load evidences from. Comments in this file starts with \"#\". Each line must contain \"NODE_NAME: STATE_NAME\" or \"NODE_NAME: STATE_INDEX\" (without quotes), whose STATE_INDEX is a integer number greater or equal to 1.");
        System.out.println("\t -o OUTPUT_FILE : text file to print results. If not specified, results will be printed to console.");
        System.out.println("\t -q NODE_TO_QUERY : name of nodes to be included in OUTPUT_FILE. If not specified, all nodes will be included. Multiple nodes can be queried by offering multiple entries of the pair -q NODE_TO_QUERY.");
        System.out.println("\t -p : if present, a preamble will be included to output.");
        System.out.println("\t -s INDEX : if present, only the states at spefied index will be printed to output. INDEX is an integer greater or equal to 1.");
        System.out.println("\t -h : if present, this message will be printed to console.");
    }

    protected void printResults(ProbabilisticNetwork net, IInferenceAlgorithm algorithm) {
        if (net == null || net.getNodes() == null) {
            throw new IllegalArgumentException(net + " is an invalid network.");
        }
        String outputFileName = this.getConfiguration().get(OUT_ARGUMENT);
        if (outputFileName != null) {
            try {
                System.setOut(new PrintStream(new File(outputFileName)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (this.getConfiguration().containsKey(PREAMBLE_ARGUMENT)) {
            String inputFileName = this.getConfiguration().get(INPUT_ARGUMENT);
            if (inputFileName == null) {
                inputFileName = net.getName();
            }
            System.out.println("# " + net.getName() + " Results");
            System.out.println("# " + new Date().toString());
            System.out.println("#");
            System.out.println("#INPUT: #");
            System.out.println("#INPUT: # " + inputFileName + " input file");
            System.out.println("#INPUT: #");
            System.out.println("#INPUT:");
            System.out.println("#INPUT: ");
            System.out.println("#INPUT: ");
            System.out.println("#INPUT: ");
            System.out.println("#INPUT: ");
            System.out.println("#INPUT:");
            System.out.println("#INPUT:");
            System.out.println();
            System.out.println("# calculated parameters");
        }
        ArrayList<TreeVariable> nodesToPrint = new ArrayList<TreeVariable>();
        String queries = this.getConfiguration().get(QUERY_ARGUMENT);
        if (queries == null || queries.trim().isEmpty()) {
            for (Node node : net.getNodes()) {
                if (!(node instanceof TreeVariable)) continue;
                nodesToPrint.add((TreeVariable)node);
            }
        } else {
            String[] stringArray = queries.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeName = stringArray[n2];
                Node node = net.getNode(nodeName);
                if (node != null && node instanceof TreeVariable) {
                    nodesToPrint.add((TreeVariable)node);
                } else {
                    System.err.println(String.valueOf(nodeName) + " is an invalid node name.");
                }
                ++n2;
            }
        }
        int stateToPrint = -1;
        String queryStateArgument = this.getConfiguration().get(QUERY_STATE_ARGUMENT);
        if (queryStateArgument != null) {
            try {
                stateToPrint = Integer.parseInt(queryStateArgument);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid value for argument -s: " + queryStateArgument);
                stateToPrint = -1;
            }
        }
        for (TreeVariable node : nodesToPrint) {
            if (node.getStatesSize() <= 0) {
                System.err.println(node + " has no states.");
                continue;
            }
            if (stateToPrint - 1 >= node.getStatesSize()) {
                System.err.println(String.valueOf(stateToPrint) + " is not a valid state for node " + node);
                continue;
            }
            if (stateToPrint >= 0) {
                if (nodesToPrint.size() == 1) {
                    System.out.print("Prob=");
                } else {
                    System.out.print(String.valueOf(node.getName()) + "=");
                }
                System.out.print(node.getMarginalAt(stateToPrint == 0 ? 0 : stateToPrint - 1));
            } else {
                System.out.print(String.valueOf(node.getName()) + "=" + node.getMarginalAt(0));
                int i = 1;
                while (i < node.getStatesSize()) {
                    System.out.print("," + node.getMarginalAt(i));
                    ++i;
                }
            }
            if (nodesToPrint.size() <= 1) continue;
            System.out.println();
        }
    }

    protected void insertEvidences(ProbabilisticNetwork net, IInferenceAlgorithm algorithm) throws IOException {
        if (net == null || algorithm == null) {
            return;
        }
        String inputFileName = this.getConfiguration().get(INPUT_ARGUMENT);
        if (inputFileName == null) {
            return;
        }
        IEvidenceIO evidenceIO = this.getEvidenceIO();
        if (evidenceIO == null) {
            throw new IllegalStateException("I/O object for evidences was not set.");
        }
        evidenceIO.loadEvidences(new File(inputFileName), net);
        algorithm.propagate();
    }

    protected IInferenceAlgorithm compileNet(ProbabilisticNetwork net) {
        JunctionTreeAlgorithm algorithm = new JunctionTreeAlgorithm();
        algorithm.setNetwork(net);
        algorithm.run();
        return algorithm;
    }

    public Map<String, String> extractArguments(String[] args) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                String value;
                String arg = args[i];
                if (arg.equals("-h") || arg.equals("-p")) {
                    ret.put(arg.substring(1), "");
                } else if (arg.equals("-q")) {
                    if (++i >= args.length) {
                        return ret;
                    }
                    value = args[i];
                    if (!value.startsWith("-")) {
                        String nodeNames;
                        if (value.startsWith("\"") && value.endsWith("\"")) {
                            value = value.substring(1, value.length() - 1);
                        }
                        nodeNames = (nodeNames = (String)ret.get(QUERY_ARGUMENT)) == null ? value : String.valueOf(nodeNames) + "," + value;
                        ret.put(QUERY_ARGUMENT, nodeNames);
                    } else {
                        --i;
                    }
                } else if (arg.equals("-n") || arg.equals("-i") || arg.equals("-o") || arg.equals("-s")) {
                    if (++i >= args.length) {
                        return ret;
                    }
                    value = args[i];
                    if (!value.startsWith("-")) {
                        if (value.startsWith("\"") && value.endsWith("\"")) {
                            value = value.substring(1, value.length() - 1);
                        }
                        ret.put(arg.substring(1), value);
                    } else {
                        --i;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public BaseIO getIO() {
        return this.io;
    }

    public void setIO(BaseIO io) {
        this.io = io;
    }

    public IEvidenceIO getEvidenceIO() {
        return this.evidenceIO;
    }

    public void setEvidenceIO(IEvidenceIO evidenceIO) {
        this.evidenceIO = evidenceIO;
    }
}

