/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import unbbayes.gui.GUIUtils;
import unbbayes.gui.UnBBayesFrame;
import unbbayes.util.ApplicationPropertyHolder;
import unbbayes.util.ResourceController;

public class AboutPane
extends JDialog {
    private static final long serialVersionUID = -4899450284495188960L;
    private Color backgroundColor;
    private String version;
    private String buildID;
    private String stableStatus;
    private static final String COLABORATORS_PAGE = "/html/Colaborators.html";
    private static final String LOGO_PICTURE = "/img/logo_small.png";
    private static final String GNU_LICENCE_PREVIEW_PAGE = "/html/GNULicencePreview.html";
    private ResourceBundle resource = ResourceController.RS_GUI;

    public AboutPane() {
        super((Frame)UnBBayesFrame.getIUnBBayes(), true);
        this.initialize();
        this.setTitle(this.resource.getString("AboultPane"));
        this.setLocation(GUIUtils.getCenterPositionForComponent(400, 270));
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.add((Component)new MainPane(), "Center");
        this.add((Component)new LogoPane(), "Before");
        this.setMinimumSize(new Dimension(400, 270));
        this.setMaximumSize(new Dimension(400, 270));
        this.pack();
        this.backgroundColor = this.getBackground();
    }

    private void initialize() {
        this.version = ApplicationPropertyHolder.getProperty().getProperty("version", "");
        this.buildID = ApplicationPropertyHolder.getProperty().getProperty("buildId", "");
        this.stableStatus = ApplicationPropertyHolder.getProperty().getProperty("stableStatus", "");
    }

    private class CollaboratorPane
    extends JPanel {
        public CollaboratorPane() {
            this.setPreferredSize(new Dimension(100, 150));
            this.setLayout(new BorderLayout());
            JEditorPane editorPane = new JEditorPane();
            editorPane.setEditable(false);
            URL helpURL = AboutPane.class.getResource(AboutPane.COLABORATORS_PAGE);
            if (helpURL != null) {
                try {
                    editorPane.setPage(helpURL);
                }
                catch (IOException e) {
                    System.err.println("Attempted to read a bad URL: " + helpURL);
                }
            } else {
                System.err.println("Attempted to read a bad URL: " + helpURL);
            }
            editorPane.setBackground(AboutPane.this.backgroundColor);
            JScrollPane scrollPane = new JScrollPane(editorPane, 22, 31);
            scrollPane.setBorder(BorderFactory.createTitledBorder(AboutPane.this.resource.getString("Collaborators")));
            this.add((Component)scrollPane, "Center");
        }
    }

    private class InformationPane
    extends JPanel {
        JButton btnClose;
        JButton btnLicence;
        JButton btnFeatures;
        JButton btnHistoric;

        public InformationPane() {
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(100, 50));
            this.btnLicence = new JButton(AboutPane.this.resource.getString("ReadLicense"));
            this.btnLicence.setEnabled(false);
            this.btnFeatures = new JButton(AboutPane.this.resource.getString("Features"));
            this.btnFeatures.setEnabled(false);
            this.btnHistoric = new JButton(AboutPane.this.resource.getString("VersionHistory"));
            this.btnHistoric.setEnabled(false);
            this.btnClose = new JButton(AboutPane.this.resource.getString("CloseAboultPane"));
            JToolBar jtb = new JToolBar();
            jtb.setLayout(new FlowLayout(4));
            jtb.add(this.btnClose);
            jtb.setFloatable(false);
            this.add((Component)jtb, "North");
            this.addListeners();
        }

        private void addListeners() {
            this.btnClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AboutPane.this.dispose();
                }
            });
        }
    }

    private class LogoPane
    extends JPanel {
        ImageIcon imgLogo;

        public LogoPane() {
            super(new BorderLayout());
            this.imgLogo = new ImageIcon(this.getClass().getResource(AboutPane.LOGO_PICTURE));
            this.setPreferredSize(new Dimension(200, 300));
            JLabel labelImg = new JLabel(this.imgLogo);
            this.add((Component)labelImg, "Center");
            this.add((Component)new VersionPane(), "South");
        }
    }

    class MainPane
    extends JPanel {
        public MainPane() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.buildHelpPanel(), "North");
            this.setPreferredSize(new Dimension(400, 300));
            AboutPane.this.setResizable(false);
        }

        private JPanel buildHelpPanel() {
            JPanel helpPanel = new JPanel();
            helpPanel.setLayout(new BorderLayout());
            JEditorPane editorPane = new JEditorPane();
            editorPane.setEditable(false);
            URL helpURL = AboutPane.class.getResource(AboutPane.GNU_LICENCE_PREVIEW_PAGE);
            if (helpURL != null) {
                try {
                    editorPane.setPage(helpURL);
                }
                catch (IOException e) {
                    System.err.println("Attempted to read a bad URL: " + helpURL);
                }
            } else {
                System.err.println("Attempted to read a bad URL: " + helpURL);
            }
            editorPane.setBackground(AboutPane.this.backgroundColor);
            Border etched = BorderFactory.createLoweredBevelBorder();
            Border empty = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            CompoundBorder compound = BorderFactory.createCompoundBorder(empty, etched);
            editorPane.setBorder(compound);
            helpPanel.add((Component)editorPane, "North");
            helpPanel.add((Component)new CollaboratorPane(), "Center");
            helpPanel.add((Component)new InformationPane(), "South");
            return helpPanel;
        }
    }

    private class VersionPane
    extends JPanel {
        public VersionPane() {
            super(new GridLayout(4, 1));
            String status = AboutPane.this.stableStatus.equals("0") ? AboutPane.this.resource.getString("stableStatusAlpha") : (AboutPane.this.stableStatus.equals("1") ? AboutPane.this.resource.getString("stableStatusBeta") : (AboutPane.this.stableStatus.equals("2") ? AboutPane.this.resource.getString("stableStatusStable") : ""));
            JLabel labelVersion = new JLabel("   " + AboutPane.this.resource.getString("Version") + ": " + AboutPane.this.version + " (" + status + ")");
            JLabel labelBuildID = new JLabel("   " + AboutPane.this.resource.getString("Buildid") + ": " + AboutPane.this.buildID);
            this.add(labelVersion);
            this.add(labelBuildID);
            this.add(new JLabel());
            this.add(new JLabel());
        }
    }
}

