/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import unbbayes.controller.IconController;
import unbbayes.controller.NetworkController;
import unbbayes.gui.GraphAction;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.resources.GuiResources;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;

public class EditNet
extends JPanel {
    private static final long serialVersionUID = 0L;
    private final NetworkWindow netWindow;
    private final NetworkController controller;
    private final IconController iconController = IconController.getInstance();
    private final JSplitPane centerPanel;
    private final JPanel topPanel;
    private final JToolBar jtbEdition;
    private final JButton compile;
    private final JButton arc;
    private final JButton printNet;
    private final JButton previewNet;
    private final JButton saveNetImage;
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName());

    public EditNet(NetworkWindow _netWindow, NetworkController _controller) {
        this.netWindow = _netWindow;
        this.controller = _controller;
        this.setLayout(new BorderLayout());
        this.topPanel = new JPanel(new GridLayout(0, 1));
        this.jtbEdition = new JToolBar();
        this.centerPanel = new JSplitPane(0);
        this.compile = new JButton(this.iconController.getCompileIcon());
        this.arc = new JButton(this.iconController.getEdgeIcon());
        this.printNet = new JButton(this.iconController.getPrintNetIcon());
        this.previewNet = new JButton(this.iconController.getPrintPreviewNetIcon());
        this.saveNetImage = new JButton(this.iconController.getSaveNetIcon());
        this.compile.setToolTipText(resource.getString("compileToolTip"));
        this.arc.setToolTipText(resource.getString("arcToolTip"));
        this.printNet.setToolTipText(resource.getString("printNetToolTip"));
        this.previewNet.setToolTipText(resource.getString("previewNetToolTip"));
        this.saveNetImage.setToolTipText(resource.getString("saveNetImageToolTip"));
        this.compile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Debug.println("i came to edit net \n");
                if (!EditNet.this.controller.compileNetwork()) {
                    return;
                }
                EditNet.this.netWindow.changeToPNCompilationPane();
            }
        });
        this.arc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EditNet.this.netWindow.getGraphPane().setAction(GraphAction.CREATE_EDGE);
            }
        });
        this.printNet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EditNet.this.controller.printNet(EditNet.this.netWindow.getGraphPane(), EditNet.this.controller.calculateNetRectangle());
            }
        });
        this.previewNet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EditNet.this.controller.previewPrintNet(EditNet.this.netWindow.getGraphPane(), EditNet.this.controller.calculateNetRectangle());
            }
        });
        this.saveNetImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditNet.this.controller.saveNetImage();
            }
        });
        this.jtbEdition.add(this.printNet);
        this.jtbEdition.add(this.previewNet);
        this.jtbEdition.add(this.saveNetImage);
        this.jtbEdition.addSeparator();
        this.jtbEdition.add(this.arc);
        this.jtbEdition.add(this.compile);
        this.topPanel.add(this.jtbEdition);
        this.centerPanel.resetToPreferredSizes();
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.setVisible(true);
    }

    public JSplitPane getCenterPanel() {
        return this.centerPanel;
    }

    public JButton getArc() {
        return this.arc;
    }

    public JButton getCompile() {
        return this.compile;
    }

    public JButton getPreviewNet() {
        return this.previewNet;
    }

    public JButton getPrintNet() {
        return this.printNet;
    }

    public JButton getSaveNetImage() {
        return this.saveNetImage;
    }
}

