/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import unbbayes.controller.IconController;
import unbbayes.gui.ILikelihoodEvidenceDialogBuilder;
import unbbayes.gui.LikelihoodEvidenceDialogBuilder;
import unbbayes.gui.NetworkWindow;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.util.ArrayMap;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;

public class EvidenceTree
extends JTree {
    private static final long serialVersionUID = 0L;
    private SingleEntityNetwork net;
    private NumberFormat nf;
    private boolean[] expandedNodes;
    private ArrayMap<Object, Node> objectsMap = new ArrayMap();
    protected IconController iconController = IconController.getInstance();
    private final NetworkWindow netWindow;
    private ResourceBundle resource = ResourceController.RS_GUI;
    public String strTextOutputMode;
    public static final String TEXTOUTPUTMODEMODE_USE_NAME = "UseName";
    public static final String TEXTOUTPUTMODEMODE_USE_DESC = "UseDescription";
    private ILikelihoodEvidenceDialogBuilder likelihoodEvidenceDialogBuilder = new LikelihoodEvidenceDialogBuilder();

    public EvidenceTree(SingleEntityNetwork sen, final NetworkWindow netWindow) {
        this.net = sen;
        this.netWindow = netWindow;
        this.strTextOutputMode = TEXTOUTPUTMODEMODE_USE_NAME;
        this.nf = NumberFormat.getInstance(Locale.US);
        this.nf.setMaximumFractionDigits(2);
        this.setCellRenderer(new EvidenceTreeCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = EvidenceTree.this.getRowForLocation(e.getX(), e.getY());
                if (selRow == -1) {
                    return;
                }
                TreePath selPath = EvidenceTree.this.getPathForLocation(e.getX(), e.getY());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                if (node.isLeaf()) {
                    if (e.getModifiers() == 4) {
                        EvidenceTree.this.showLikelihood((DefaultMutableTreeNode)node.getParent());
                    } else if (e.getClickCount() == 2 && (e.getModifiers() & 0x10) != 0) {
                        if ((e.getModifiers() & 2) != 0 || (e.getModifiers() & 0x80) != 0) {
                            EvidenceTree.this.treeDoubleClick(node, true);
                        } else {
                            EvidenceTree.this.treeDoubleClick(node, false);
                        }
                        Node newNode = EvidenceTree.this.getNodeMap(node);
                        netWindow.getGraphPane().compiled(false, newNode);
                    }
                } else {
                    if (e.getModifiers() == 4) {
                        EvidenceTree.this.showLikelihood(node);
                    }
                    if (e.getClickCount() == 1) {
                        Node newNode = EvidenceTree.this.getNodeMap(node);
                        if (newNode != null) {
                            netWindow.getGraphPane().selectNode(newNode);
                            netWindow.getGraphPane().compiled(false, newNode);
                        }
                    } else if (e.getClickCount() == 2) {
                        DefaultMutableTreeNode root = (DefaultMutableTreeNode)EvidenceTree.this.getModel().getRoot();
                        int index = root.getIndex(node);
                        ((EvidenceTree)EvidenceTree.this).expandedNodes[index] = !EvidenceTree.this.expandedNodes[index];
                    }
                }
            }
        });
    }

    public void setTextOutputMode(String str) {
        this.strTextOutputMode = str;
        this.updateTree(false);
    }

    public String getTextOutputMode() {
        return this.strTextOutputMode;
    }

    public void collapseTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.collapseRow(i);
            ++i;
        }
        i = 0;
        while (i < this.expandedNodes.length) {
            this.expandedNodes[i] = false;
            ++i;
        }
    }

    public void expandTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i);
            ++i;
        }
        i = 0;
        while (i < this.expandedNodes.length) {
            this.expandedNodes[i] = true;
            ++i;
        }
    }

    private void restoreTree() {
        int i = this.expandedNodes.length - 1;
        while (i >= 0) {
            if (this.expandedNodes[i]) {
                this.expandRow(i);
            } else {
                this.collapseRow(i);
            }
            --i;
        }
    }

    public void resetTree() {
        this.expandedNodes = null;
    }

    public void updateTree(boolean reset) {
        if (this.expandedNodes == null) {
            this.expandedNodes = new boolean[this.net.getNodesCopy().size()];
            int i = 0;
            while (i < this.expandedNodes.length) {
                this.expandedNodes[i] = true;
                ++i;
            }
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        root.removeAllChildren();
        this.objectsMap.clear();
        DefaultTreeModel model = new DefaultTreeModel((DefaultMutableTreeNode)this.net.getHierarchicTree().copyTree().getModel().getRoot());
        this.setModel(model);
        root = (DefaultMutableTreeNode)this.getModel().getRoot();
        root.removeAllChildren();
        ArrayList<Node> nodes = this.net.getNodesCopy();
        int size = nodes.size();
        int i = 0;
        while (i < size) {
            Node node = nodes.get(i);
            TreeVariable treeVariable = (TreeVariable)node;
            DefaultMutableTreeNode treeNode = null;
            if (this.getTextOutputMode() == TEXTOUTPUTMODEMODE_USE_NAME) {
                treeNode = this.findUserObject(node.getName(), root);
            } else if (this.getTextOutputMode() == TEXTOUTPUTMODEMODE_USE_DESC) {
                treeNode = this.findUserObject(node.getDescription(), root);
            }
            if (treeNode == null) {
                if (this.getTextOutputMode() == TEXTOUTPUTMODEMODE_USE_NAME) {
                    treeNode = new DefaultMutableTreeNode(node.getName());
                } else if (this.getTextOutputMode() == TEXTOUTPUTMODEMODE_USE_DESC) {
                    treeNode = new DefaultMutableTreeNode(node.getDescription());
                }
                root.add(treeNode);
            }
            this.objectsMap.put(treeNode, node);
            int statesSize = node.getStatesSize();
            Debug.println("new tree node " + treeNode.toString());
            int j = 0;
            while (j < statesSize) {
                String label = treeVariable.getType() == 0 ? String.valueOf(node.getStateAt(j)) + ": " + this.nf.format((double)treeVariable.getMarginalAt(j) * 100.0) : String.valueOf(node.getStateAt(j)) + ": " + this.nf.format(treeVariable.getMarginalAt(j));
                treeNode.add(new DefaultMutableTreeNode(label));
                Debug.println("new tree node sub " + label);
                ++j;
            }
            ++i;
        }
        this.restoreTree();
        ((DefaultTreeModel)this.getModel()).reload(root);
        this.restoreTree();
        this.netWindow.getGraphPane().compiled(reset, null);
    }

    public void selectTreeItemByNode(Node n) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        DefaultMutableTreeNode treeNode = null;
        if (this.getTextOutputMode() == TEXTOUTPUTMODEMODE_USE_NAME) {
            treeNode = this.findUserObject(n.getName(), root);
        } else if (this.getTextOutputMode() == TEXTOUTPUTMODEMODE_USE_DESC) {
            treeNode = this.findUserObject(n.getDescription(), root);
        }
        if (treeNode != null) {
            TreePath tp = new TreePath(treeNode.getPath());
            this.expandPath(tp);
            this.scrollPathToVisible(tp);
            this.setSelectionPath(tp);
        }
    }

    public void selectTreeItemByState(Node node, String stateName) {
        DefaultMutableTreeNode parent = this.findUserObject(node);
        int i = 0;
        while (i < parent.getChildCount()) {
            DefaultMutableTreeNode auxNode = (DefaultMutableTreeNode)parent.getChildAt(i);
            int n = parent.getIndex(auxNode);
            if (node.getStateAt(n) == stateName) {
                this.treeDoubleClick(auxNode, false);
                return;
            }
            ++i;
        }
    }

    public void setNumberFormat(Locale local) {
        this.nf = NumberFormat.getInstance(local);
    }

    private DefaultMutableTreeNode findUserObject(Node node) {
        String name = null;
        if (this.getTextOutputMode() == TEXTOUTPUTMODEMODE_USE_NAME) {
            name = node.getName();
        } else if (this.getTextOutputMode() == TEXTOUTPUTMODEMODE_USE_DESC) {
            name = node.getDescription();
        }
        return this.findUserObject(name);
    }

    private DefaultMutableTreeNode findUserObject(String treeNode) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        return this.findUserObject(treeNode, root);
    }

    private DefaultMutableTreeNode findUserObject(String treeNode, DefaultMutableTreeNode root) {
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.getUserObject().toString().equals(treeNode)) continue;
            return node;
        }
        return null;
    }

    private void treeDoubleClick(DefaultMutableTreeNode treeNode, boolean isNegativeEvidence) {
        TreeVariable node;
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
        Node obj = this.objectsMap.get(parent);
        if (obj != null && ((node = (TreeVariable)obj).getInformationType() == 3 || node.getInformationType() == 4)) {
            int i = 0;
            while (i < parent.getChildCount()) {
                DefaultMutableTreeNode auxNode = (DefaultMutableTreeNode)parent.getChildAt(i);
                auxNode.setUserObject(String.valueOf(node.getStateAt(i)) + (isNegativeEvidence ? ": 100" : ": 0"));
                ++i;
            }
            if (node.getType() == 0) {
                treeNode.setUserObject(String.valueOf(node.getStateAt(parent.getIndex(treeNode))) + (isNegativeEvidence ? ": 0" : ": 100"));
            } else {
                treeNode.setUserObject(String.valueOf(node.getStateAt(parent.getIndex(treeNode))) + ": **");
            }
            node.addFinding(parent.getIndex(treeNode), isNegativeEvidence);
            ((DefaultTreeModel)this.getModel()).reload(parent);
            this.netWindow.getGraphPane().selectNode(node);
        }
    }

    private void showLikelihood(final DefaultMutableTreeNode node) {
        try {
            final ProbabilisticNode auxProbNode = (ProbabilisticNode)this.objectsMap.get(node);
            if (auxProbNode != null && auxProbNode.getInformationType() == 3) {
                JDialog likelihoodDialog = this.getLikelihoodEvidenceDialogBuilder().buildDialog(this.net, auxProbNode, this.netWindow.getGraphPane());
                likelihoodDialog.setLocationRelativeTo(null);
                likelihoodDialog.pack();
                likelihoodDialog.addComponentListener(new ComponentListener(){

                    public void componentShown(ComponentEvent e) {
                    }

                    public void componentResized(ComponentEvent e) {
                    }

                    public void componentMoved(ComponentEvent e) {
                    }

                    public void componentHidden(ComponentEvent e) {
                        if (auxProbNode.hasLikelihood()) {
                            if (auxProbNode.getLikelihood().length == node.getChildCount()) {
                                int i = 0;
                                while (i < node.getChildCount()) {
                                    DefaultMutableTreeNode auxNode = (DefaultMutableTreeNode)node.getChildAt(i);
                                    String str = (String)auxNode.getUserObject();
                                    auxNode.setUserObject(String.valueOf(str.substring(0, str.lastIndexOf(58) + 1)) + EvidenceTree.this.nf.format(auxProbNode.getLikelihood()[i] * 100.0f));
                                    ++i;
                                }
                            } else {
                                int i = 0;
                                while (i < node.getChildCount()) {
                                    DefaultMutableTreeNode auxNode = (DefaultMutableTreeNode)node.getChildAt(i);
                                    String str = (String)auxNode.getUserObject();
                                    auxNode.setUserObject(String.valueOf(str.substring(0, str.lastIndexOf(58) + 1)) + "*");
                                    ++i;
                                }
                            }
                            ((DefaultTreeModel)EvidenceTree.this.getModel()).reload(node);
                        }
                    }
                });
                likelihoodDialog.setVisible(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), this.resource.getString("error"), 2);
        }
    }

    public Node getNodeMap(DefaultMutableTreeNode node) {
        Node obj = this.objectsMap.get(node);
        if (obj != null) {
            return obj;
        }
        return null;
    }

    public void setLikelihoodEvidenceDialogBuilder(ILikelihoodEvidenceDialogBuilder likelihoodEvidenceDialogBuilder) {
        this.likelihoodEvidenceDialogBuilder = likelihoodEvidenceDialogBuilder;
    }

    public ILikelihoodEvidenceDialogBuilder getLikelihoodEvidenceDialogBuilder() {
        return this.likelihoodEvidenceDialogBuilder;
    }

    private class EvidenceTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 0L;
        private ImageIcon folderSmallIcon;
        private ImageIcon folderSmallDisabledIcon;
        private ImageIcon yellowBallIcon;
        private ImageIcon greenBallIcon;

        private EvidenceTreeCellRenderer() {
            this.folderSmallIcon = EvidenceTree.this.iconController.getFolderSmallIcon();
            this.folderSmallDisabledIcon = EvidenceTree.this.iconController.getFolderSmallDisabledIcon();
            this.yellowBallIcon = EvidenceTree.this.iconController.getYellowBallIcon();
            this.greenBallIcon = EvidenceTree.this.iconController.getGreenBallIcon();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)((DefaultMutableTreeNode)value).getParent();
                Object obj = EvidenceTree.this.objectsMap.get(parent);
                if (obj != null) {
                    Node node = (Node)obj;
                    if (node.getInformationType() == 3) {
                        this.setIcon(this.yellowBallIcon);
                    } else {
                        this.setIcon(this.greenBallIcon);
                    }
                } else {
                    this.setIcon(this.yellowBallIcon);
                }
            } else {
                Object obj = EvidenceTree.this.objectsMap.get((DefaultMutableTreeNode)value);
                if (obj != null) {
                    Node node = (Node)obj;
                    if (node.getInformationType() == 3) {
                        this.setOpenIcon(this.folderSmallIcon);
                        this.setClosedIcon(this.folderSmallIcon);
                        this.setIcon(this.folderSmallIcon);
                    } else {
                        this.setOpenIcon(this.folderSmallDisabledIcon);
                        this.setClosedIcon(this.folderSmallDisabledIcon);
                        this.setIcon(this.folderSmallDisabledIcon);
                    }
                } else {
                    this.setOpenIcon(this.folderSmallIcon);
                    this.setClosedIcon(this.folderSmallIcon);
                    this.setIcon(this.folderSmallIcon);
                }
            }
            return this;
        }
    }
}

