/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.resources.GuiResources;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ExplanationPhrase;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.util.ResourceController;

public class ExplanationProperties
extends JDialog {
    private static final long serialVersionUID = 0L;
    private JTabbedPane jTabbedPane = new JTabbedPane();
    private JPanel southPanel = new JPanel();
    private JPanel descriptionPanel = new JPanel();
    private JPanel explanationPanel = new JPanel();
    private JButton okButton = new JButton();
    private Border border1;
    private Border border2;
    private JPanel evidencePhrasePanel = new JPanel();
    private JPanel explanationTopPanel = new JPanel();
    private JPanel evidenceTypePanel = new JPanel();
    private JPanel evidenceNodePanel = new JPanel();
    private JPanel evidencePhraseBottomPanel = new JPanel();
    private JLabel evidenceNodeLabel = new JLabel();
    private JComboBox evidenceNodeComboBox = new JComboBox();
    private TitledBorder titledBorder1;
    private JPanel notUsedPanel = new JPanel();
    private JPanel exclusivePanel = new JPanel();
    private JPanel necessaryPanel = new JPanel();
    private JPanel naPanel = new JPanel();
    private JPanel complementaryPanel = new JPanel();
    private JPanel triggerPanel = new JPanel();
    private JRadioButton triggerRadioButton = new JRadioButton();
    private JRadioButton complementaryRadioButton = new JRadioButton();
    private JRadioButton naRadioButton = new JRadioButton();
    private JRadioButton necessaryRadioButton = new JRadioButton();
    private JRadioButton exclusiveRadioButton = new JRadioButton();
    private ButtonGroup buttonGroup1 = new ButtonGroup();
    private Border evidenceTypeBorder;
    private JPanel evidencePhraseTopPanel = new JPanel();
    private JLabel evidencePhraseLabel = new JLabel();
    private JScrollPane evidencePhraseScrollPane = new JScrollPane();
    private JTextArea evidencePhraseTextArea = new JTextArea();
    private NetworkWindow netWindow;
    private ProbabilisticNode node;
    private SingleEntityNetwork net;
    private JButton cancelButton = new JButton();
    private JLabel nodeNameLabel = new JLabel();
    private JScrollPane explanationNodeScrollPane = new JScrollPane();
    private JPanel descriptionTopPanel1 = new JPanel();
    private JPanel descriptionTopPanel2 = new JPanel();
    private JPanel descriptionTopPanel3 = new JPanel();
    private JPanel descriptionTopPanel = new JPanel();
    private JPanel descriptionBottomPanel = new JPanel();
    private JLabel explanationVariableLabel = new JLabel();
    private JLabel descriptionLabel = new JLabel();
    private JTextArea explanationNodeTextArea = new JTextArea();
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName(), Locale.getDefault(), ExplanationProperties.class.getClassLoader());

    public ExplanationProperties(NetworkWindow netWindow, SingleEntityNetwork net) {
        this.netWindow = netWindow;
        this.net = net;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(550, 470);
        this.setResizable(false);
        this.setTitle(resource.getString("properties"));
        this.border1 = BorderFactory.createEmptyBorder(0, 10, 0, 10);
        this.border2 = BorderFactory.createEmptyBorder(20, 20, 20, 20);
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), resource.getString("typeLabel"));
        this.evidenceTypeBorder = BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), resource.getString("typeLabel")), BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.okButton.setMaximumSize(new Dimension(85, 27));
        this.okButton.setMinimumSize(new Dimension(85, 27));
        this.okButton.setPreferredSize(new Dimension(85, 27));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExplanationProperties.this.okButton_actionPerformed(e);
            }
        });
        this.descriptionPanel.setLayout(new BorderLayout(0, 5));
        this.explanationPanel.setLayout(new GridLayout(2, 0, 0, 10));
        this.explanationTopPanel.setLayout(new BorderLayout(0, 10));
        this.evidencePhrasePanel.setLayout(new BorderLayout(0, 5));
        this.evidenceNodeLabel.setText(resource.getString("addConditionsSoftEvidence"));
        this.evidenceNodePanel.setLayout(new BorderLayout());
        this.evidenceTypePanel.setBorder(this.evidenceTypeBorder);
        this.evidenceTypePanel.setLayout(new GridLayout(2, 3, 10, 0));
        this.triggerRadioButton.setText("Trigger");
        this.triggerRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExplanationProperties.this.evidenceRadioButton_actionPerformed(e);
            }
        });
        this.complementaryRadioButton.setText("Complementar");
        this.complementaryRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExplanationProperties.this.evidenceRadioButton_actionPerformed(e);
            }
        });
        this.naRadioButton.setText("N/A");
        this.naRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExplanationProperties.this.evidenceRadioButton_actionPerformed(e);
            }
        });
        this.necessaryRadioButton.setText("Essential");
        this.necessaryRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExplanationProperties.this.evidenceRadioButton_actionPerformed(e);
            }
        });
        this.exclusiveRadioButton.setText("Excludent");
        this.exclusiveRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExplanationProperties.this.evidenceRadioButton_actionPerformed(e);
            }
        });
        this.triggerPanel.setLayout(new BorderLayout());
        this.complementaryPanel.setLayout(new BorderLayout());
        this.naPanel.setLayout(new BorderLayout());
        this.necessaryPanel.setLayout(new BorderLayout());
        this.exclusivePanel.setLayout(new BorderLayout());
        this.notUsedPanel.setLayout(new BorderLayout());
        this.evidencePhraseLabel.setText(String.valueOf(resource.getString("probabilisticExplanationNodeColorLabel")) + ": ");
        this.evidencePhraseTopPanel.setLayout(new BorderLayout());
        this.evidencePhraseBottomPanel.setLayout(new BorderLayout());
        this.cancelButton.setText(resource.getString("cancelLabel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExplanationProperties.this.cancelButton_actionPerformed(e);
            }
        });
        this.evidenceNodeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExplanationProperties.this.evidenceNodeComboBox_actionPerformed(e);
            }
        });
        this.evidencePhraseTextArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ExplanationProperties.this.evidencePhraseTextArea_focusLost(e);
            }
        });
        this.descriptionTopPanel2.setLayout(new BorderLayout());
        this.descriptionTopPanel3.setLayout(new BorderLayout());
        this.descriptionTopPanel.setLayout(new GridLayout(3, 0));
        this.descriptionBottomPanel.setLayout(new BorderLayout());
        this.explanationVariableLabel.setText(String.valueOf(resource.getString("probabilisticExplanationNodeColorLabel")) + " (" + resource.getString("nodeGraphName") + "): ");
        this.descriptionPanel.setBorder(this.border2);
        this.descriptionTopPanel1.setLayout(new BorderLayout());
        this.descriptionLabel.setText(String.valueOf(resource.getString("probabilisticDescriptionNodeColorLabel")) + ":");
        this.explanationPanel.setBorder(this.border2);
        this.getContentPane().add((Component)this.southPanel, "South");
        this.descriptionTopPanel.add((Component)this.descriptionTopPanel1, null);
        this.descriptionTopPanel1.add((Component)this.descriptionLabel, "Center");
        this.descriptionTopPanel.add((Component)this.descriptionTopPanel2, null);
        this.descriptionTopPanel.add((Component)this.descriptionTopPanel3, null);
        this.descriptionTopPanel3.add((Component)this.explanationVariableLabel, "West");
        this.descriptionTopPanel3.add((Component)this.nodeNameLabel, "Center");
        this.descriptionPanel.add((Component)this.descriptionBottomPanel, "Center");
        this.descriptionBottomPanel.add((Component)this.explanationNodeScrollPane, "Center");
        this.explanationNodeScrollPane.getViewport().add((Component)this.explanationNodeTextArea, null);
        this.descriptionPanel.add((Component)this.descriptionTopPanel, "North");
        this.southPanel.add((Component)this.okButton, null);
        this.southPanel.add((Component)this.cancelButton, null);
        this.explanationPanel.add((Component)this.explanationTopPanel, null);
        this.explanationPanel.add((Component)this.evidencePhrasePanel, null);
        this.explanationTopPanel.add((Component)this.evidenceTypePanel, "Center");
        this.evidenceTypePanel.add((Component)this.triggerPanel, null);
        this.triggerPanel.add((Component)this.triggerRadioButton, "Center");
        this.evidenceTypePanel.add((Component)this.complementaryPanel, null);
        this.complementaryPanel.add((Component)this.complementaryRadioButton, "Center");
        this.evidenceTypePanel.add((Component)this.naPanel, null);
        this.naPanel.add((Component)this.naRadioButton, "Center");
        this.evidenceTypePanel.add((Component)this.necessaryPanel, null);
        this.necessaryPanel.add((Component)this.necessaryRadioButton, "Center");
        this.evidenceTypePanel.add((Component)this.exclusivePanel, null);
        this.exclusivePanel.add((Component)this.exclusiveRadioButton, "Center");
        this.evidenceTypePanel.add((Component)this.notUsedPanel, null);
        this.explanationTopPanel.add((Component)this.evidenceNodePanel, "North");
        this.evidenceNodePanel.add((Component)this.evidenceNodeLabel, "West");
        this.evidenceNodePanel.add((Component)this.evidenceNodeComboBox, "Center");
        this.evidencePhrasePanel.add((Component)this.evidencePhraseBottomPanel, "Center");
        this.evidencePhraseBottomPanel.add((Component)this.evidencePhraseScrollPane, "Center");
        this.evidencePhraseScrollPane.getViewport().add((Component)this.evidencePhraseTextArea, null);
        this.evidencePhrasePanel.add((Component)this.evidencePhraseTopPanel, "North");
        this.evidencePhraseTopPanel.add((Component)this.evidencePhraseLabel, "Center");
        this.buttonGroup1.add(this.triggerRadioButton);
        this.buttonGroup1.add(this.complementaryRadioButton);
        this.buttonGroup1.add(this.naRadioButton);
        this.buttonGroup1.add(this.necessaryRadioButton);
        this.buttonGroup1.add(this.exclusiveRadioButton);
        this.jTabbedPane.setBorder(this.border1);
        this.jTabbedPane.add((Component)this.descriptionPanel, resource.getString("probabilisticDescriptionNodeColorLabel"));
        this.jTabbedPane.add((Component)this.explanationPanel, resource.getString("probabilisticExplanationNodeColorLabel"));
        this.getContentPane().add((Component)this.jTabbedPane, "Center");
        List nodes = this.net.getNodes();
        int size = ((ArrayList)nodes).size();
        Object[] stringNodes = new String[size];
        int i = 0;
        while (i < size) {
            stringNodes[i] = ((Node)((ArrayList)nodes).get(i)).getDescription();
            ++i;
        }
        Arrays.sort(stringNodes);
        i = 0;
        while (i < size) {
            this.evidenceNodeComboBox.addItem(stringNodes[i]);
            ++i;
        }
    }

    public void setProbabilisticNode(ProbabilisticNode node) {
        this.node = node;
        this.explanationNodeTextArea.setText(node.getExplanationDescription());
        if (this.evidenceNodeComboBox.getItemCount() != 0) {
            this.updateExplanationInformation(this.evidenceNodeComboBox.getItemAt(0).toString());
        }
        this.nodeNameLabel.setText(node.getName());
        this.descriptionLabel.setText(String.valueOf(resource.getString("probabilisticDescriptionNodeColorLabel")) + ": " + node.getDescription());
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.node.setExplanationDescription(this.explanationNodeTextArea.getText());
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void evidenceNodeComboBox_actionPerformed(ActionEvent evt) {
        JComboBox source = (JComboBox)evt.getSource();
        String item = (String)source.getSelectedItem();
        this.updateExplanationInformation(item);
    }

    private void updateExplanationInformation(String item) {
        try {
            ExplanationPhrase explanationPhrase = this.node.getExplanationPhrase(item);
            int evidenceType = explanationPhrase.getEvidenceType();
            switch (evidenceType) {
                case 0: {
                    this.triggerRadioButton.setSelected(true);
                    break;
                }
                case 1: {
                    this.necessaryRadioButton.setSelected(true);
                    break;
                }
                case 2: {
                    this.complementaryRadioButton.setSelected(true);
                    break;
                }
                case 3: {
                    this.exclusiveRadioButton.setSelected(true);
                    break;
                }
                default: {
                    this.naRadioButton.setSelected(true);
                }
            }
            this.evidencePhraseTextArea.setText(explanationPhrase.getPhrase());
        }
        catch (Exception e) {
            this.naRadioButton.setSelected(true);
            this.evidencePhraseTextArea.setText("");
        }
    }

    void evidenceRadioButton_actionPerformed(ActionEvent e) {
        this.addEvidence(e);
    }

    void evidencePhraseTextArea_focusLost(FocusEvent e) {
        this.addEvidence(e);
    }

    private void addEvidence(AWTEvent e) {
        ExplanationPhrase explanationPhrase = new ExplanationPhrase();
        explanationPhrase.setNode(this.evidenceNodeComboBox.getSelectedItem().toString());
        if (this.triggerRadioButton.isSelected()) {
            explanationPhrase.setEvidenceType(0);
        } else if (this.necessaryRadioButton.isSelected()) {
            explanationPhrase.setEvidenceType(1);
        } else if (this.complementaryRadioButton.isSelected()) {
            explanationPhrase.setEvidenceType(2);
        } else if (this.exclusiveRadioButton.isSelected()) {
            explanationPhrase.setEvidenceType(3);
        } else {
            explanationPhrase.setEvidenceType(4);
        }
        explanationPhrase.setPhrase(this.evidencePhraseTextArea.getText());
        this.node.addExplanationPhrase(explanationPhrase);
    }
}

