/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import unbbayes.controller.NetworkController;
import unbbayes.gui.option.JunctionTreeOptionPanel;
import unbbayes.gui.resources.GuiResources;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;
import unbbayes.util.extension.bn.inference.InferenceAlgorithmOptionPanel;
import unbbayes.util.extension.manager.UnBBayesPluginContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalOptionsDialog
extends JDialog {
    private static final long serialVersionUID = 0L;
    private NetworkController controller;
    private JTabbedPane jtp;
    private JPanel confirmationPanel;
    private JPanel miscellaneousPanel;
    private JComponent algorithmMainPanel;
    private JPanel algorithmRadioPanel;
    private JButton confirm;
    private JButton restore;
    private JButton cancel;
    private JCheckBox createLog;
    private boolean createLogBoolean;
    private ButtonGroup algorithmGroup;
    private JComponent algorithmOptionPane;
    private Map<JRadioButtonMenuItem, InferenceAlgorithmOptionPanel> algorithmToOptionMap = new HashMap<JRadioButtonMenuItem, InferenceAlgorithmOptionPanel>();
    private String pluginDirectory = "plugins";
    private String pluginCoreID = "unbbayes.util.extension.core";
    private String algorithmExtensionPoint = "InferenceAlgorithm";
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName());
    private UnBBayesPluginContextHolder unbbayesPluginContextHolder = UnBBayesPluginContextHolder.newInstance();
    private JCheckBox groupCPTHeader;
    private boolean groupCPTHeaderBoolean;
    private boolean isToUseFloatingCPTColumn;
    private JCheckBox useFloatingCPTColumnCheckBox;

    public GlobalOptionsDialog(NetworkController con) {
        super(new Frame(), resource.getString("globalOptionTitle"), true);
        Container contentPane = this.getContentPane();
        this.setSize(550, 470);
        this.setResizable(true);
        this.controller = con;
        this.createLog = new JCheckBox(resource.getString("createLogLabel"));
        this.algorithmGroup = new ButtonGroup();
        this.setAlgorithmToOptionMap(this.loadAlgorithmsAsPlugins());
        this.createLogBoolean = this.controller.getSingleEntityNetwork().isCreateLog();
        this.setGroupCPTHeaderBoolean(this.controller.getSENController().isToGroupCPTHeaders());
        this.setToUseFloatingCPTColumn(this.controller.getScreen().getNetWindowEdition().isUseFloatingColumn());
        this.jtp = new JTabbedPane();
        this.confirmationPanel = new JPanel(new FlowLayout(1));
        this.miscellaneousPanel = new JPanel(new GridLayout(0, 1, 10, 10));
        this.algorithmMainPanel = new JSplitPane(0);
        this.algorithmRadioPanel = new JPanel(new GridLayout(0, 3));
        this.algorithmRadioPanel.setBorder(new TitledBorder(resource.getString("availableAlgorithms")));
        this.algorithmOptionPane = new JPanel(new FlowLayout(3));
        this.algorithmOptionPane.setBorder(new TitledBorder(resource.getString("algorithmParameters")));
        this.confirm = new JButton(resource.getString("confirmLabel"));
        this.confirm.setToolTipText(resource.getString("confirmToolTip"));
        this.confirmationPanel.add(this.confirm);
        this.confirm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GlobalOptionsDialog.this.controller.getSingleEntityNetwork().setCreateLog(GlobalOptionsDialog.this.createLog.isSelected());
                GlobalOptionsDialog.this.controller.getSENController().setToGroupCPTHeaders(GlobalOptionsDialog.this.getGroupCPTHeader().isSelected());
                GlobalOptionsDialog.this.controller.getScreen().getNetWindowEdition().setUseFloatingColumn(GlobalOptionsDialog.this.getUseFloatingCPTColumnCheckBox().isSelected());
                InferenceAlgorithmOptionPanel currentPanel = GlobalOptionsDialog.this.getSelectedAlgorithmOptionPanel();
                if (currentPanel != null) {
                    try {
                        currentPanel.commitChanges();
                        GlobalOptionsDialog.this.controller.setInferenceAlgorithm(currentPanel.getInferenceAlgorithm());
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        JOptionPane.showMessageDialog(GlobalOptionsDialog.this, String.valueOf(resource.getString("operationFail")) + ": " + exc.getMessage(), resource.getString("error"), 0);
                    }
                }
                GlobalOptionsDialog.this.setVisible(false);
                GlobalOptionsDialog.this.dispose();
            }
        });
        this.restore = new JButton(resource.getString("resetLabel"));
        this.restore.setToolTipText(resource.getString("resetToolTip"));
        this.confirmationPanel.add(this.restore);
        this.restore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InferenceAlgorithmOptionPanel selectedAlgorithmOptionPanel = GlobalOptionsDialog.this.getSelectedAlgorithmOptionPanel();
                if (selectedAlgorithmOptionPanel != null) {
                    try {
                        selectedAlgorithmOptionPanel.revertChanges();
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        JOptionPane.showMessageDialog(GlobalOptionsDialog.this, String.valueOf(resource.getString("operationFail")) + ": " + exc.getMessage(), resource.getString("error"), 0);
                    }
                }
                GlobalOptionsDialog.this.controller.getSingleEntityNetwork().setCreateLog(GlobalOptionsDialog.this.createLogBoolean);
                GlobalOptionsDialog.this.createLog.setSelected(GlobalOptionsDialog.this.createLogBoolean);
                GlobalOptionsDialog.this.createLog.updateUI();
                GlobalOptionsDialog.this.createLog.repaint();
                GlobalOptionsDialog.this.controller.getSENController().setToGroupCPTHeaders(GlobalOptionsDialog.this.isGroupCPTHeaderBoolean());
                GlobalOptionsDialog.this.groupCPTHeader.setSelected(GlobalOptionsDialog.this.isGroupCPTHeaderBoolean());
                GlobalOptionsDialog.this.groupCPTHeader.updateUI();
                GlobalOptionsDialog.this.groupCPTHeader.repaint();
                GlobalOptionsDialog.this.controller.getScreen().getNetWindowEdition().setUseFloatingColumn(GlobalOptionsDialog.this.isToUseFloatingCPTColumn());
                GlobalOptionsDialog.this.useFloatingCPTColumnCheckBox.setSelected(GlobalOptionsDialog.this.isToUseFloatingCPTColumn());
                GlobalOptionsDialog.this.useFloatingCPTColumnCheckBox.updateUI();
                GlobalOptionsDialog.this.useFloatingCPTColumnCheckBox.repaint();
                GlobalOptionsDialog.this.repaint();
            }
        });
        this.cancel = new JButton(resource.getString("cancelLabel"));
        this.cancel.setToolTipText(resource.getString("cancelToolTip"));
        this.confirmationPanel.add(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InferenceAlgorithmOptionPanel selectedAlgorithmOptionPanel = GlobalOptionsDialog.this.getSelectedAlgorithmOptionPanel();
                if (selectedAlgorithmOptionPanel != null) {
                    try {
                        selectedAlgorithmOptionPanel.revertChanges();
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        JOptionPane.showMessageDialog(GlobalOptionsDialog.this, String.valueOf(resource.getString("operationFail")) + ": " + exc.getMessage(), resource.getString("error"), 0);
                    }
                }
                GlobalOptionsDialog.this.setVisible(false);
                GlobalOptionsDialog.this.dispose();
            }
        });
        this.miscellaneousPanel.add(this.createLog);
        this.groupCPTHeader = new JCheckBox(resource.getString("groupCPTHeaderLabel"), this.controller.getSENController().isToGroupCPTHeaders());
        this.miscellaneousPanel.add(this.groupCPTHeader);
        this.useFloatingCPTColumnCheckBox = new JCheckBox(resource.getString("floatingColumnLabel"), this.controller.getScreen().getNetWindowEdition().isUseFloatingColumn());
        this.miscellaneousPanel.add(this.useFloatingCPTColumnCheckBox);
        for (JRadioButtonMenuItem radioItem : this.getAlgorithmToOptionMap().keySet()) {
            this.algorithmGroup.add(radioItem);
            this.algorithmRadioPanel.add(radioItem);
        }
        this.algorithmMainPanel.add(this.algorithmRadioPanel);
        InferenceAlgorithmOptionPanel currentOptionPanel = this.getSelectedAlgorithmOptionPanel();
        if (currentOptionPanel != null) {
            this.algorithmOptionPane.add(currentOptionPanel);
        }
        this.algorithmMainPanel.add(this.algorithmOptionPane);
        UnBBayesPluginContextHolder.newInstance().addListener(new UnBBayesPluginContextHolder.OnReloadActionListener(){

            public void onReload(EventObject eventObject) {
                GlobalOptionsDialog.this.reloadPlugins();
            }
        });
        this.jtp.addTab(resource.getString("algorithmTab"), this.algorithmMainPanel);
        this.jtp.addTab(resource.getString("miscellaneousTab"), new JScrollPane(this.miscellaneousPanel));
        contentPane.add((Component)this.jtp, "Center");
        contentPane.add((Component)this.confirmationPanel, "South");
    }

    protected void reloadPlugins() {
        Map<JRadioButtonMenuItem, InferenceAlgorithmOptionPanel> newMap = this.loadAlgorithmsAsPlugins();
        for (JRadioButtonMenuItem radioItem : newMap.keySet()) {
            if (this.isAlreadyLoaded(newMap.get(radioItem))) continue;
            this.algorithmGroup.add(radioItem);
            this.getAlgorithmRadioPanel().add(radioItem);
        }
        this.getAlgorithmToOptionMap().putAll(newMap);
    }

    private boolean isAlreadyLoaded(InferenceAlgorithmOptionPanel optionPanel) {
        if (this.getAlgorithmToOptionMap().containsValue(optionPanel)) {
            return true;
        }
        for (InferenceAlgorithmOptionPanel loadedPanels : this.getAlgorithmToOptionMap().values()) {
            if (!loadedPanels.getClass().equals(optionPanel.getClass())) continue;
            return true;
        }
        return false;
    }

    protected void setCurrentAlgorithmOptionPanel(Component currentOptionPanel) {
        this.getAlgorithmOptionPane().removeAll();
        this.getAlgorithmOptionPane().add(currentOptionPanel);
        currentOptionPanel.setVisible(true);
        this.repaint();
    }

    protected Map<JRadioButtonMenuItem, InferenceAlgorithmOptionPanel> loadAlgorithmsAsPlugins() {
        HashMap<JRadioButtonMenuItem, InferenceAlgorithmOptionPanel> ret = new HashMap<JRadioButtonMenuItem, InferenceAlgorithmOptionPanel>();
        try {
            ret.putAll(this.getDefaultAlgorithms());
            PluginDescriptor core = this.getPluginManager().getRegistry().getPluginDescriptor(this.getPluginCoreID());
            ExtensionPoint point = this.getPluginManager().getRegistry().getExtensionPoint(core.getId(), this.getAlgorithmExtensionPoint());
            Iterator it = point.getConnectedExtensions().iterator();
            while (it.hasNext()) {
                try {
                    Extension ext = (Extension)it.next();
                    PluginDescriptor descr = ext.getDeclaringPluginDescriptor();
                    this.getPluginManager().activatePlugin(descr.getId());
                    Extension.Parameter classParam = ext.getParameter("class");
                    PluginClassLoader classLoader = this.getPluginManager().getPluginClassLoader(descr);
                    Class<?> pluginClass = null;
                    pluginClass = classLoader.loadClass(classParam.valueAsString());
                    InferenceAlgorithmOptionPanel algorithmOptionPanel = null;
                    algorithmOptionPanel = (InferenceAlgorithmOptionPanel)pluginClass.newInstance();
                    try {
                        algorithmOptionPanel.setMediator(this.controller);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        try {
                            Debug.println(this.getClass(), "Could not set mediator for " + algorithmOptionPanel, e);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    JRadioButtonMenuItem radio = new JRadioButtonMenuItem(algorithmOptionPanel.getInferenceAlgorithm().getName(), this.controller.getInferenceAlgorithm() != null && this.controller.getInferenceAlgorithm().getClass().equals(algorithmOptionPanel.getInferenceAlgorithm().getClass()));
                    radio.setToolTipText(algorithmOptionPanel.getInferenceAlgorithm().getDescription());
                    ret.put(radio, algorithmOptionPanel);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            for (JRadioButtonMenuItem radio : ret.keySet()) {
                radio.addActionListener(new PluginRadioButtonListener((Component)ret.get(radio)));
            }
        }
        catch (Throwable t) {
            Debug.println(this.getClass(), "Error filling Inference Algorithm's plugins", t);
        }
        return ret;
    }

    protected Map<JRadioButtonMenuItem, InferenceAlgorithmOptionPanel> getDefaultAlgorithms() {
        HashMap<JRadioButtonMenuItem, InferenceAlgorithmOptionPanel> ret = new HashMap<JRadioButtonMenuItem, InferenceAlgorithmOptionPanel>();
        JRadioButtonMenuItem radio = null;
        JunctionTreeOptionPanel algorithmOptionPanel = null;
        algorithmOptionPanel = new JunctionTreeOptionPanel();
        try {
            ((InferenceAlgorithmOptionPanel)algorithmOptionPanel).setMediator(this.controller);
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                Debug.println(this.getClass(), "Failed to set mediator for " + this.algorithmRadioPanel, e);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        radio = new JRadioButtonMenuItem(((InferenceAlgorithmOptionPanel)algorithmOptionPanel).getInferenceAlgorithm().getName(), this.controller.getInferenceAlgorithm() != null && this.controller.getInferenceAlgorithm().getClass().equals(((InferenceAlgorithmOptionPanel)algorithmOptionPanel).getInferenceAlgorithm().getClass()));
        radio.setToolTipText(((InferenceAlgorithmOptionPanel)algorithmOptionPanel).getInferenceAlgorithm().getDescription());
        ret.put(radio, algorithmOptionPanel);
        return ret;
    }

    private InferenceAlgorithmOptionPanel getSelectedAlgorithmOptionPanel() {
        if (this.getAlgorithmToOptionMap() == null) {
            return null;
        }
        for (JRadioButtonMenuItem option : this.getAlgorithmToOptionMap().keySet()) {
            if (!option.isSelected()) continue;
            return this.getAlgorithmToOptionMap().get(option);
        }
        return null;
    }

    public JPanel getAlgorithmRadioPanel() {
        return this.algorithmRadioPanel;
    }

    public void setAlgorithmRadioPanel(JPanel algorithmRadioPanel) {
        this.algorithmRadioPanel = algorithmRadioPanel;
    }

    public Map<JRadioButtonMenuItem, InferenceAlgorithmOptionPanel> getAlgorithmToOptionMap() {
        return this.algorithmToOptionMap;
    }

    public void setAlgorithmToOptionMap(Map<JRadioButtonMenuItem, InferenceAlgorithmOptionPanel> algorithmToOptionMap) {
        this.algorithmToOptionMap = algorithmToOptionMap;
    }

    public JComponent getAlgorithmOptionPane() {
        return this.algorithmOptionPane;
    }

    public void setAlgorithmOptionPane(JComponent algorithmOptionPane) {
        this.algorithmOptionPane = algorithmOptionPane;
    }

    public String getPluginDirectory() {
        return this.pluginDirectory;
    }

    public void setPluginDirectory(String pluginDirectory) {
        this.pluginDirectory = pluginDirectory;
    }

    public PluginManager getPluginManager() {
        return this.getUnBBayesPluginContextHolder().getPluginManager();
    }

    public String getPluginCoreID() {
        return this.pluginCoreID;
    }

    public void setPluginCoreID(String pluginCoreID) {
        this.pluginCoreID = pluginCoreID;
    }

    public String getAlgorithmExtensionPoint() {
        return this.algorithmExtensionPoint;
    }

    public void setAlgorithmExtensionPoint(String algorithmExtensionPoint) {
        this.algorithmExtensionPoint = algorithmExtensionPoint;
    }

    public UnBBayesPluginContextHolder getUnBBayesPluginContextHolder() {
        return this.unbbayesPluginContextHolder;
    }

    public void setUnBBayesPluginContextHolder(UnBBayesPluginContextHolder unbbayesPluginContextHolder) {
        this.unbbayesPluginContextHolder = unbbayesPluginContextHolder;
    }

    public JCheckBox getGroupCPTHeader() {
        return this.groupCPTHeader;
    }

    public void setGroupCPTHeader(JCheckBox groupCPTHeader) {
        this.groupCPTHeader = groupCPTHeader;
    }

    public boolean isGroupCPTHeaderBoolean() {
        return this.groupCPTHeaderBoolean;
    }

    public void setGroupCPTHeaderBoolean(boolean groupCPTHeaderBoolean) {
        this.groupCPTHeaderBoolean = groupCPTHeaderBoolean;
    }

    public boolean isToUseFloatingCPTColumn() {
        return this.isToUseFloatingCPTColumn;
    }

    public void setToUseFloatingCPTColumn(boolean isToUseFloatingCPTColumn) {
        this.isToUseFloatingCPTColumn = isToUseFloatingCPTColumn;
    }

    public JCheckBox getUseFloatingCPTColumnCheckBox() {
        return this.useFloatingCPTColumnCheckBox;
    }

    public void setUseFloatingCPTColumnCheckBox(JCheckBox useFloatingCPTColumnCheckBox) {
        this.useFloatingCPTColumnCheckBox = useFloatingCPTColumnCheckBox;
    }

    protected class PluginRadioButtonListener
    implements ActionListener {
        Component component;

        public PluginRadioButtonListener(Component component) {
            this.component = component;
        }

        public void actionPerformed(ActionEvent e) {
            GlobalOptionsDialog.this.setCurrentAlgorithmOptionPanel(this.component);
        }
    }
}

