/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import unbbayes.controller.IconController;
import unbbayes.controller.NetworkController;
import unbbayes.draw.IEdgeHolderShape;
import unbbayes.draw.INodeHolderShape;
import unbbayes.draw.UCanvas;
import unbbayes.draw.UShape;
import unbbayes.draw.UShapeDecisionNode;
import unbbayes.draw.UShapeLine;
import unbbayes.draw.UShapeProbabilisticNode;
import unbbayes.draw.UShapeState;
import unbbayes.draw.UShapeUtilityNode;
import unbbayes.draw.extension.IPluginUShape;
import unbbayes.gui.GraphAction;
import unbbayes.gui.resources.GuiResources;
import unbbayes.gui.table.extension.IProbabilityFunctionPanelBuilder;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.bn.cpt.IProbabilityFunctionAdapter;
import unbbayes.prs.extension.IPluginNode;
import unbbayes.prs.hybridbn.ContinuousNode;
import unbbayes.prs.id.DecisionNode;
import unbbayes.prs.id.UtilityNode;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;
import unbbayes.util.clipboard.InternalClipboard;
import unbbayes.util.extension.dto.INodeClassDataTransferObject;
import unbbayes.util.extension.manager.CorePluginNodeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphPane
extends UCanvas {
    private static final int DEFAULT_DIMENSION = 1500;
    private static final int DEFAULT_WIDTH = 600;
    private static final int DEFAULT_HEIGH = 800;
    private static final long serialVersionUID = 0L;
    public List<Edge> edgeList;
    public List<Node> nodeList;
    public GraphAction action;
    public static Color backgroundColor;
    public JViewport graphViewport;
    public Dimension visibleDimension;
    public Dimension graphDimension;
    public final IconController iconController = IconController.getInstance();
    public ProbabilisticNetwork net;
    private JPopupMenu popup = new JPopupMenu();
    public String PANEMODE_NONE = "None";
    public String PANEMODE_COMPILE = "Compile";
    public String strPaneMode = this.PANEMODE_NONE;
    private INodeClassDataTransferObject nodeClassDataTransferObject;
    private CorePluginNodeManager pluginNodeManager = CorePluginNodeManager.newInstance();
    private boolean toUseSelectionForLines = false;
    private static ResourceBundle resource;
    public static int iUpdate;

    static {
        resource = ResourceController.newInstance().getBundle(GuiResources.class.getName());
        iUpdate = 0;
    }

    public GraphPane(JDialog dlg, ProbabilisticNetwork n) {
        this.net = n;
        this.edgeList = this.net.getEdges();
        this.nodeList = this.net.getNodes();
        this.setSize(800, 600);
        this.graphDimension = new Dimension(1500, 1500);
        this.visibleDimension = new Dimension(0, 0);
        this.action = GraphAction.NONE;
        this.update();
        this.addKeyListener(new CopyPasteKeyManager());
    }

    public GraphPane(NetworkController controller, JViewport graphViewport) {
        this.controller = controller;
        this.graphViewport = graphViewport;
        this.setSize(800, 600);
        this.edgeList = controller.getGraph().getEdges();
        this.nodeList = controller.getGraph().getNodes();
        this.graphDimension = new Dimension(1500, 1500);
        this.visibleDimension = new Dimension(0, 0);
        this.action = GraphAction.NONE;
        graphViewport.setViewSize(this.visibleDimension);
        this.addKeyListener(new CopyPasteKeyManager());
    }

    protected Node addClonedNode(Node originalNode, int xPixelsToCopy, int yPixelsToCopy) {
        Debug.println("Cloning " + originalNode);
        Node clonedNode = null;
        double positionX = originalNode.getPosition().getX() + (double)xPixelsToCopy;
        double positionY = originalNode.getPosition().getY() + (double)yPixelsToCopy;
        if (originalNode instanceof ProbabilisticNode) {
            clonedNode = this.controller.insertProbabilisticNode(positionX, positionY);
        } else if (originalNode instanceof UtilityNode) {
            clonedNode = this.controller.insertUtilityNode(positionX, positionY);
        } else if (originalNode instanceof DecisionNode) {
            clonedNode = this.controller.insertDecisionNode(positionX, positionY);
        } else {
            return null;
        }
        String newName = String.valueOf(originalNode.getName()) + "_1";
        newName = this.getUniqueName(newName);
        clonedNode.setName(newName);
        Debug.println("newNome=" + newName);
        clonedNode.removeStates();
        int numStates = originalNode.getStatesSize();
        int i = 0;
        while (i < numStates) {
            clonedNode.appendState(originalNode.getStateAt(i));
            ++i;
        }
        this.createNode(clonedNode);
        this.selectNode(clonedNode);
        this.getNodeUShape(clonedNode).setState("Selected", null);
        return clonedNode;
    }

    public String getUniqueName(String newName) {
        List<Node> nodes = this.controller.getGraph().getNodes();
        for (Node node : nodes) {
            if (!newName.equals(node.getName())) continue;
            int tempNameIndex = newName.lastIndexOf("_") + 1;
            String copyCounter = newName.substring(tempNameIndex);
            int c = Integer.valueOf(copyCounter) + 1;
            newName = String.valueOf(newName.substring(0, tempNameIndex)) + c;
            return this.getUniqueName(newName);
        }
        return newName;
    }

    public void setGraphDimension(Dimension graphDimension) {
        this.graphDimension = graphDimension;
    }

    public Object getSelected() {
        UShape selectedShape = this.getSelectedShape();
        if (selectedShape instanceof IEdgeHolderShape) {
            return ((IEdgeHolderShape)((Object)selectedShape)).getEdge();
        }
        if (selectedShape instanceof INodeHolderShape) {
            return ((INodeHolderShape)((Object)selectedShape)).getNode();
        }
        return selectedShape;
    }

    public void updateSelectedNode() {
        this.getSelectedShape().update();
    }

    public void setPaneMode(String str) {
        this.strPaneMode = str;
    }

    public String getPaneMode() {
        return this.strPaneMode;
    }

    public List<Node> getSelectedGroup() {
        ArrayList<Node> selectedGroup = new ArrayList<Node>();
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            if (shape.getState() == "Selected" && shape.getNode() != null) {
                this.controller.selectNode(shape.getNode());
                selectedGroup.add(shape.getNode());
            }
            ++i;
        }
        return selectedGroup;
    }

    public Dimension getGraphDimension() {
        return this.graphDimension;
    }

    @Override
    public void setState(String s) {
        super.setState(s);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public JViewport getGraphViewport() {
        return this.graphViewport;
    }

    public Point2D.Double getBiggestPoint() {
        double maiorX = 0.0;
        double maiorY = 0.0;
        int i = 0;
        while (i < this.nodeList.size()) {
            Node noAux = this.nodeList.get(i);
            if (maiorX < noAux.getPosition().getX() + (double)noAux.getWidth()) {
                maiorX = noAux.getPosition().getX() + (double)noAux.getWidth();
            }
            if (maiorY < noAux.getPosition().getY() + (double)noAux.getHeight()) {
                maiorY = noAux.getPosition().getY() + (double)noAux.getHeight();
            }
            ++i;
        }
        if (maiorX < this.visibleDimension.getWidth()) {
            maiorX = this.graphViewport.getViewSize().getWidth();
        }
        if (maiorY < this.visibleDimension.getHeight()) {
            maiorY = this.graphViewport.getViewSize().getHeight();
        }
        return new Point2D.Double(maiorX, maiorY);
    }

    public void showCPT(Node newNode) {
        if (this.controller != null) {
            if (this.controller.getScreen() != null) {
                if (this.controller.getScreen().getTxtName() != null) {
                    this.controller.getScreen().getTxtName().setText(newNode.getName());
                }
                if (this.controller.getScreen().getTxtDescription() != null) {
                    this.controller.getScreen().getTxtDescription().setText(newNode.getDescription());
                }
            }
            if (this.controller.getGraph() instanceof SingleEntityNetwork) {
                this.controller.createTable(newNode);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            Node newNode = null;
            switch (this.getAction()) {
                case CREATE_CONTINUOUS_NODE: {
                    newNode = this.controller.insertContinuousNode(e.getX(), e.getY());
                    UShapeProbabilisticNode shape = new UShapeProbabilisticNode(this, newNode, (int)newNode.getPosition().x - newNode.getWidth() / 2, (int)newNode.getPosition().y - newNode.getHeight() / 2, newNode.getWidth(), newNode.getHeight());
                    this.addShape(shape);
                    shape.setState("Selected", null);
                    this.showCPT(newNode);
                    break;
                }
                case CREATE_PROBABILISTIC_NODE: {
                    newNode = this.controller.insertProbabilisticNode(e.getX(), e.getY());
                    UShapeProbabilisticNode shape = new UShapeProbabilisticNode(this, newNode, (int)newNode.getPosition().x - newNode.getWidth() / 2, (int)newNode.getPosition().y - newNode.getHeight() / 2, newNode.getWidth(), newNode.getHeight());
                    this.addShape(shape);
                    shape.setState("Selected", null);
                    this.showCPT(newNode);
                    break;
                }
                case CREATE_DECISION_NODE: {
                    newNode = this.controller.insertDecisionNode(e.getX(), e.getY());
                    UShapeDecisionNode shape = new UShapeDecisionNode(this, newNode, (int)newNode.getPosition().x - newNode.getWidth() / 2, (int)newNode.getPosition().y - newNode.getHeight() / 2, newNode.getWidth(), newNode.getHeight());
                    this.addShape(shape);
                    shape.setState("Selected", null);
                    this.showCPT(newNode);
                    break;
                }
                case CREATE_UTILITY_NODE: {
                    newNode = this.controller.insertUtilityNode(e.getX(), e.getY());
                    UShapeUtilityNode shape = new UShapeUtilityNode(this, newNode, (int)newNode.getPosition().x - newNode.getWidth() / 2, (int)newNode.getPosition().y - newNode.getHeight() / 2, newNode.getWidth(), newNode.getHeight());
                    this.addShape(shape);
                    shape.setState("Selected", null);
                    this.showCPT(newNode);
                    break;
                }
                case ADD_PLUGIN_NODE: {
                    newNode = this.getNodeDataTransferObject().getNodeBuilder().buildNode();
                    newNode.setPosition(e.getX(), e.getY());
                    this.controller.getNetwork().addNode(newNode);
                    UShape shape = null;
                    try {
                        shape = this.getNodeDataTransferObject().getShapeBuilder().build().getUShape(newNode, this);
                    }
                    catch (IllegalAccessException e1) {
                        throw new RuntimeException(e1);
                    }
                    catch (InstantiationException e1) {
                        throw new RuntimeException(e1);
                    }
                    this.addShape(shape);
                    shape.setState("Selected", null);
                    shape.update();
                    this.getNodeDataTransferObject().getProbabilityFunctionPanelBuilder().setProbabilityFunctionOwner(newNode);
                    this.controller.getScreen().showProbabilityDistributionPanel(this.getNodeDataTransferObject().getProbabilityFunctionPanelBuilder());
                    break;
                }
                case NONE: {
                    if (this.controller == null) break;
                    this.controller.unselectAll();
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        SwingUtilities.isLeftMouseButton(e);
        SwingUtilities.isMiddleMouseButton(e);
        if (SwingUtilities.isRightMouseButton(e) && this.getPaneMode() == this.PANEMODE_COMPILE) {
            this.resetPopup();
            this.popup.setEnabled(true);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void selectNode(Node n) {
        UShape shape = null;
        shape = this.getNodeUShape(n);
        shape.setState("Selected", null);
    }

    public boolean insertEdge(Edge edge) {
        try {
            return this.controller.insertEdge(edge);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setAction(GraphAction action, INodeClassDataTransferObject dto) {
        this.setNodeDataTransferObject(dto);
        this.setAction(action);
    }

    public void setAction(GraphAction action) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        switch (action) {
            case CREATE_CONTINUOUS_NODE: {
                Cursor customCursor = toolkit.createCustomCursor(this.iconController.getContinueNodeCursor().getImage(), new Point(0, 0), "Cursor");
                this.setCursor(customCursor);
                this.setState("None");
                this.setShapeStateAll("ChangeCursor", customCursor);
                break;
            }
            case CREATE_PROBABILISTIC_NODE: {
                Cursor customCursor = toolkit.createCustomCursor(this.iconController.getEllipsisNodeCursor().getImage(), new Point(0, 0), "Cursor");
                this.setCursor(customCursor);
                this.setState("None");
                this.setShapeStateAll("ChangeCursor", customCursor);
                break;
            }
            case CREATE_DECISION_NODE: {
                Cursor customCursor = toolkit.createCustomCursor(this.iconController.getDecisionNodeCursor().getImage(), new Point(0, 0), "Cursor");
                this.setCursor(customCursor);
                this.setState("None");
                this.setShapeStateAll("ChangeCursor", customCursor);
                break;
            }
            case CREATE_UTILITY_NODE: {
                Cursor customCursor = toolkit.createCustomCursor(this.iconController.getUtilityNodeCursor().getImage(), new Point(0, 0), "Cursor");
                this.setCursor(customCursor);
                this.setState("None");
                this.setShapeStateAll("ChangeCursor", customCursor);
                break;
            }
            case CREATE_CONTEXT_NODE: {
                Cursor customCursor = toolkit.createCustomCursor(this.iconController.getContextNodeCursor().getImage(), new Point(0, 0), "Cursor");
                this.setCursor(customCursor);
                this.setState("None");
                this.setShapeStateAll("ChangeCursor", customCursor);
                break;
            }
            case CREATE_INPUT_NODE: {
                Cursor customCursor = toolkit.createCustomCursor(this.iconController.getInputNodeCursor().getImage(), new Point(0, 0), "Cursor");
                this.setCursor(customCursor);
                this.setState("None");
                this.setShapeStateAll("ChangeCursor", customCursor);
                break;
            }
            case CREATE_RESIDENT_NODE: {
                Cursor customCursor = toolkit.createCustomCursor(this.iconController.getResidentNodeCursor().getImage(), new Point(0, 0), "Cursor");
                this.setCursor(customCursor);
                this.setState("None");
                this.setShapeStateAll("ChangeCursor", customCursor);
                break;
            }
            case CREATE_ORDINARYVARIABLE_NODE: {
                Cursor customCursor = toolkit.createCustomCursor(this.iconController.getOvariableNodeCursor().getImage(), new Point(0, 0), "Cursor");
                this.setCursor(customCursor);
                this.setState("None");
                this.setShapeStateAll("ChangeCursor", customCursor);
                break;
            }
            case CREATE_EDGE: {
                Cursor customCursor = toolkit.createCustomCursor(this.iconController.getLineCursor().getImage(), new Point(0, 0), "Cursor");
                this.setCursor(customCursor);
                this.setState("ConnectComponents");
                this.setShapeStateAll("ChangeCursor", customCursor);
                break;
            }
            case NONE: {
                this.setCursor(new Cursor(0));
                this.setState("None");
                this.setShapeStateAll("ChangeCursor", new Cursor(13));
                this.setShapeStateAll("None", null);
                break;
            }
            case ADD_PLUGIN_NODE: {
                Cursor customCursor = this.getNodeDataTransferObject() == null || this.getNodeDataTransferObject().getCursorIcon() == null ? new Cursor(1) : toolkit.createCustomCursor(this.getNodeDataTransferObject().getCursorIcon().getImage(), new Point(0, 0), "Cursor");
                this.setCursor(customCursor);
                this.setState("None");
                this.setShapeStateAll("ChangeCursor", customCursor);
                break;
            }
            default: {
                this.setCursor(new Cursor(0));
            }
        }
        this.action = action;
    }

    public GraphAction getAction() {
        return this.action;
    }

    public void createNode(Node newNode) {
        UShape shape = null;
        if (newNode instanceof IPluginNode) {
            try {
                shape = this.getPluginNodeManager().getPluginNodeInformation(newNode.getClass()).getShapeBuilder().build().getUShape(newNode, this);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        if (shape == null) {
            if (newNode instanceof ContinuousNode) {
                shape = new UShapeProbabilisticNode(this, newNode, (int)newNode.getPosition().x, (int)newNode.getPosition().y, newNode.getWidth(), newNode.getHeight());
            } else if (newNode instanceof ProbabilisticNode) {
                shape = new UShapeProbabilisticNode(this, newNode, (int)newNode.getPosition().x, (int)newNode.getPosition().y, newNode.getWidth(), newNode.getHeight());
            } else if (newNode instanceof DecisionNode) {
                shape = new UShapeDecisionNode(this, newNode, (int)newNode.getPosition().x, (int)newNode.getPosition().y, newNode.getWidth(), newNode.getHeight());
            } else if (newNode instanceof UtilityNode) {
                shape = new UShapeUtilityNode(this, newNode, (int)newNode.getPosition().x, (int)newNode.getPosition().y, newNode.getWidth(), newNode.getHeight());
            }
        }
        if (shape != null) {
            try {
                this.addShape(shape);
                shape.setState("Selected", null);
            }
            catch (NullPointerException e) {
                throw new RuntimeException("Could not find or set a shape for node: " + newNode.getName(), e);
            }
        }
    }

    public void resizeAllToFitText() {
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            shape.resizeToFitText();
            shape.repaint();
            ++i;
        }
        this.updateLines();
        this.setShapeStateAll("None", null);
    }

    public void compiled(boolean reset, Node selectedNode) {
        this.setPaneMode(this.PANEMODE_COMPILE);
        this.removeAll();
        UShape shape = null;
        int i = 0;
        while (i < this.nodeList.size()) {
            Node n = this.nodeList.get(i);
            this.createNode(n);
            if (reset && n instanceof ProbabilisticNode) {
                shape = this.getNodeUShape(n);
            }
            if (n instanceof ContinuousNode || n instanceof ProbabilisticNode) {
                shape = this.getNodeUShape(n);
                if (shape != null) {
                    shape.shapeTypeChange("Bar");
                    shape.setState("Resized", null);
                } else {
                    Debug.println(this.getClass(), "Warning. Could not extract shape from getNodeUShape(" + n + ")");
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.edgeList.size()) {
            Edge e = this.edgeList.get(i);
            if (this.getNodeUShape(e.getOriginNode()) != null && this.getNodeUShape(e.getDestinationNode()) != null) {
                UShapeLine line = new UShapeLine(this, this.getNodeUShape(e.getOriginNode()), this.getNodeUShape(e.getDestinationNode()));
                line.setEdge(e);
                line.setLearningLineSelection(false);
                this.addShape(line);
            }
            ++i;
        }
        this.setAction(GraphAction.NONE);
        this.setShapeStateAll("None", null);
        this.fitCanvasSizeToAllUShapes();
        if (selectedNode != null && (shape = this.getNodeUShape(selectedNode)) != null) {
            shape.setState("Selected", null);
        }
    }

    @Override
    public void update() {
        UShape selectedUshape;
        Node selectedNode;
        this.setPaneMode(this.PANEMODE_NONE);
        this.removeAll();
        UShape shape = null;
        int i = 0;
        while (i < this.nodeList.size()) {
            Node n = this.nodeList.get(i);
            n.updateLabel();
            this.createNode(n);
            if ((n instanceof ContinuousNode || n instanceof ProbabilisticNode || n instanceof IPluginNode) && (shape = this.getNodeUShape(n)) != null) {
                shape.shapeTypeChange("None");
                shape.setState("Resized", null);
            }
            ++i;
        }
        i = 0;
        while (i < this.edgeList.size()) {
            Edge e = this.edgeList.get(i);
            if (this.getNodeUShape(e.getOriginNode()) != null && this.getNodeUShape(e.getDestinationNode()) != null) {
                UShapeLine line = new UShapeLine(this, this.getNodeUShape(e.getOriginNode()), this.getNodeUShape(e.getDestinationNode()));
                line.setEdge(e);
                line.setLearningLineSelection(this.isToUseSelectionForLines());
                this.addShape(line);
            }
            ++i;
        }
        this.setAction(GraphAction.NONE);
        this.setShapeStateAll("None", null);
        this.fitCanvasSizeToAllUShapes();
        if (this.controller != null && (selectedNode = this.controller.getSelectedNode()) != null && (selectedUshape = this.getNodeUShape(selectedNode)) != null) {
            selectedUshape.setState("Selected", null);
        }
    }

    public void resetGraph() {
        if (this.controller == null) {
            return;
        }
        this.edgeList = this.controller.getGraph().getEdges();
        this.nodeList = this.controller.getGraph().getNodes();
        this.action = GraphAction.NONE;
        JMenuItem item = new JMenuItem(resource.getString("properties"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GraphPane.this.controller.showExplanationProperties((ProbabilisticNode)GraphPane.this.getSelected());
            }
        });
        this.popup.add(item);
        this.update();
        this.repaint();
    }

    public void updateAllNodesName() {
        if (this.getTextOutputMode() == "UseName") {
            this.useNameAllShape();
        } else if (this.getTextOutputMode() == "UseDescription") {
            this.useDescAllShape();
        }
    }

    public void useNameAllShape() {
        this.setTextOutputMode("UseName");
        this.controller.getScreen().getEvidenceTree().setTextOutputMode("UseName");
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            Node node = shape.getNode();
            if (node != null) {
                shape.setLabel(node.getName());
            }
            ++i;
        }
        this.repaint();
    }

    public void useDescAllShape() {
        this.setTextOutputMode("UseDescription");
        this.controller.getScreen().getEvidenceTree().setTextOutputMode("UseDescription");
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            Node node = shape.getNode();
            if (node != null) {
                shape.setLabel(node.getDescription());
            }
            ++i;
        }
        this.repaint();
    }

    public void resetPopup() {
        this.popup.removeAll();
        JMenuItem item1 = new JMenuItem("View Name");
        item1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GraphPane.this.useNameAllShape();
            }
        });
        JMenuItem item2 = new JMenuItem("View Description");
        item2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GraphPane.this.useDescAllShape();
            }
        });
        this.popup.add(item1);
        this.popup.add(item2);
    }

    @Override
    public UShapeLine onDrawConnectLineReleased(UShape shapeParent, int x, int y) {
        Edge e;
        UShapeLine line = super.onDrawConnectLineReleased(shapeParent, x, y);
        if (line != null && (e = new Edge(line.getSource().getNode(), line.getTarget().getNode())) != null) {
            if (this.insertEdge(e)) {
                line.setEdge(e);
                line.setLearningLineSelection(this.isToUseSelectionForLines());
            } else {
                this.delShape(line);
                this.repaint();
            }
        }
        return line;
    }

    @Override
    public void onShapeChanged(UShape s) {
        if (s instanceof UShapeState) {
            Node n = ((UShape)s.getParent()).getNode();
            this.controller.getScreen().getEvidenceTree().selectTreeItemByState(n, s.getName());
            ((UShapeProbabilisticNode)s.getParent()).update(s.getName());
        } else if (!(s instanceof UShapeLine)) {
            if (s instanceof IPluginUShape || s.getNode() instanceof IPluginNode) {
                IProbabilityFunctionPanelBuilder builder = null;
                try {
                    builder = this.getPluginNodeManager().getPluginNodeInformation(s.getNode().getClass()).getProbabilityFunctionPanelBuilder();
                }
                catch (Exception e) {
                    Debug.println(this.getClass(), "Could not restore the node panel builder for " + s.getNode().getName(), e);
                }
                if (builder != null) {
                    builder.setProbabilityFunctionOwner(s.getNode());
                    this.controller.getScreen().showProbabilityDistributionPanel(builder);
                }
            } else {
                this.showCPT(s.getNode());
            }
        }
    }

    @Override
    public void onShapeDeleted(UShape s) {
        if (this.controller != null) {
            if (s instanceof UShapeLine) {
                this.controller.deleteSelected(((UShapeLine)s).getEdge());
            } else {
                this.controller.deleteSelected(s.getNode());
            }
        } else if (this.net != null) {
            if (s instanceof UShapeLine) {
                this.net.removeEdge(((UShapeLine)s).getEdge());
            } else {
                this.net.removeNode(s.getNode());
            }
        }
    }

    @Override
    public void onSelectionChanged() {
        if (this.controller == null) {
            return;
        }
        this.controller.unselectAll();
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            UShape shape = (UShape)this.getComponent(i);
            if (shape.getState() == "Selected" && shape.getNode() != null) {
                this.controller.selectNode(shape.getNode());
                if (this.controller.getScreen().getEvidenceTree() != null) {
                    this.controller.getScreen().getEvidenceTree().selectTreeItemByNode(shape.getNode());
                }
            }
            ++i;
        }
    }

    public INodeClassDataTransferObject getNodeDataTransferObject() {
        return this.nodeClassDataTransferObject;
    }

    protected void setNodeDataTransferObject(INodeClassDataTransferObject nodeClassDataTransferObject) {
        this.nodeClassDataTransferObject = nodeClassDataTransferObject;
    }

    protected CorePluginNodeManager getPluginNodeManager() {
        return this.pluginNodeManager;
    }

    protected void setPluginNodeManager(CorePluginNodeManager pluginNodeManager) {
        this.pluginNodeManager = pluginNodeManager;
    }

    public boolean isToUseSelectionForLines() {
        return this.toUseSelectionForLines;
    }

    public void setToUseSelectionForLines(boolean toUseSelectionForLines) {
        this.toUseSelectionForLines = toUseSelectionForLines;
    }

    private void unselectAllNodes() {
        for (Node node : this.nodeList) {
            node.setSelected(false);
            this.getNodeUShape(node).setState("None", null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CopyPasteKeyManager
    implements KeyListener {
        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            List<Node> group;
            if (e.isControlDown() && e.getKeyCode() == 65) {
                List<Node> nodeList = GraphPane.this.controller.getGraph().getNodes();
                for (Node node : nodeList) {
                    GraphPane.this.getNodeUShape(node).setState("Selected", null);
                }
            }
            if (e.isControlDown() && e.getKeyCode() == 88) {
                Debug.println("Copy Delete");
                group = GraphPane.this.getSelectedGroup();
                InternalClipboard.getInstance().putToClipboard(group);
                GraphPane.super.DeleteSelectedShape();
            }
            if (e.isControlDown() && e.getKeyCode() == 67) {
                Debug.println("Copy");
                group = GraphPane.this.getSelectedGroup();
                InternalClipboard.getInstance().putToClipboard(group);
            } else if (e.isControlDown() && e.getKeyCode() == 86) {
                Debug.println("Paste");
                Object fromClipboard = InternalClipboard.getInstance().getFromClipboard();
                try {
                    List group2 = (List)fromClipboard;
                    this.pasteAndDrawNodes(group2);
                }
                catch (Exception ex) {
                    Debug.println(GraphPane.class, "Error pasting", ex);
                }
            }
        }

        private void pasteAndDrawNodes(List<Node> group) {
            int yPixelsToCopy = 100;
            int xPixelsToCopy = 100;
            if (group.size() > 0) {
                Node firstNode = group.get(0);
                xPixelsToCopy = (int)((double)GraphPane.this.mouseX - firstNode.getPosition().getX() - firstNode.getSize().getX() / 2.0);
                yPixelsToCopy = (int)((double)GraphPane.this.mouseY - firstNode.getPosition().getY() - firstNode.getSize().getY() / 2.0);
            }
            HashMap<Node, Node> originalClonedHash = new HashMap<Node, Node>();
            GraphPane.this.unselectAllNodes();
            for (Node node : group) {
                if (node == null) {
                    Debug.println("Root node not identified");
                    return;
                }
                Node clonedNode = GraphPane.this.addClonedNode(node, xPixelsToCopy, yPixelsToCopy);
                originalClonedHash.put(node, clonedNode);
            }
            for (Map.Entry entry : originalClonedHash.entrySet()) {
                Node fatherOriginal = (Node)entry.getKey();
                Node fatherCloned = (Node)entry.getValue();
                ArrayList<Node> originalChildNodes = fatherOriginal.getChildren();
                for (Node originalChildNode : originalChildNodes) {
                    Node childCloned = (Node)originalClonedHash.get(originalChildNode);
                    if (childCloned == null) continue;
                    UShapeLine line = new UShapeLine(GraphPane.this, GraphPane.this.getNodeUShape(fatherCloned), GraphPane.this.getNodeUShape(childCloned));
                    Edge edge = new Edge(fatherCloned, childCloned);
                    line.setEdge(edge);
                    line.setLearningLineSelection(false);
                    GraphPane.this.addShape(line);
                    GraphPane.this.insertEdge(edge);
                    GraphPane.this.onDrawConnectLineReleased(line, 0, 0);
                }
            }
            GraphPane.this.onSelectionChanged();
            for (Map.Entry entry : originalClonedHash.entrySet()) {
                Node original = (Node)entry.getKey();
                Node cloned = (Node)entry.getValue();
                if (!(cloned instanceof IProbabilityFunctionAdapter) || !(original instanceof IRandomVariable)) continue;
                ((IProbabilityFunctionAdapter)((Object)cloned)).loadProbabilityFunction(((IRandomVariable)((Object)original)).getProbabilityFunction());
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }
}

