/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import unbbayes.controller.IconController;
import unbbayes.gui.HierarchicTree;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.resources.GuiResources;
import unbbayes.prs.Node;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;

public class HierarchicDefinitionPane
extends JPanel {
    private static final long serialVersionUID = 0L;
    private JSplitPane centerPanel;
    private JScrollPane descriptionScrollPane;
    private JScrollPane explanationScrollPane;
    private HierarchicTree hierarchicTree;
    private DefaultTreeModel model;
    private SingleEntityNetwork net;
    private HierarchicTree explanationTree;
    private NetworkWindow netWindow;
    private JPanel bottomPanel;
    private JPanel topPanel;
    private JButton deleteButton;
    private JButton renameButton;
    private JButton addFolderButton;
    private JToolBar jToolBar;
    private JButton expand;
    private JButton edit;
    private JButton collapse;
    private JLabel statusBar;
    private DefaultMutableTreeNode selectedNode;
    protected IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName());

    public HierarchicDefinitionPane(SingleEntityNetwork net, NetworkWindow netWindow) {
        this.net = net;
        this.netWindow = netWindow;
        this.setLayout(new BorderLayout());
        this.jToolBar = new JToolBar();
        this.jToolBar.setBorder(null);
        this.jToolBar.setFloatable(false);
        this.topPanel = new JPanel(new GridLayout(0, 1));
        this.centerPanel = new JSplitPane(1);
        this.bottomPanel = new JPanel(new FlowLayout(0, 5, 1));
        this.statusBar = new JLabel("Definicao da hierarquia");
        this.hierarchicTree = net.getHierarchicTree();
        this.deleteButton = new JButton(this.iconController.getDeleteFolderIcon());
        this.renameButton = new JButton(this.iconController.getRenameFolderIcon());
        this.addFolderButton = new JButton(this.iconController.getAddFolderIcon());
        this.expand = new JButton(this.iconController.getExpandIcon());
        this.edit = new JButton(this.iconController.getEditIcon());
        this.collapse = new JButton(this.iconController.getColapseIcon());
        this.deleteButton.setToolTipText("Delete Folder");
        this.renameButton.setToolTipText("Rename Folder");
        this.addFolderButton.setToolTipText("Add Folder");
        this.expand.setToolTipText(resource.getString("expandToolTip"));
        this.edit.setToolTipText(resource.getString("editToolTip"));
        this.collapse.setToolTipText(resource.getString("collapseToolTip"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HierarchicDefinitionPane.this.deleteButton_actionPerformed(e);
            }
        });
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HierarchicDefinitionPane.this.renameButton_actionPerformed(e);
            }
        });
        this.addFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HierarchicDefinitionPane.this.addFolderButton_actionPerformed(e);
            }
        });
        this.expand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HierarchicDefinitionPane.this.hierarchicTree.expandTree();
            }
        });
        this.edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HierarchicDefinitionPane.this.edit_actionPerformed(e);
            }
        });
        this.collapse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HierarchicDefinitionPane.this.hierarchicTree.collapseTree();
            }
        });
        this.hierarchicTree.addMouseListener(new MouseAdapter(){
            private int oldRow = -1;

            public void mousePressed(MouseEvent e) {
                int selRow = HierarchicDefinitionPane.this.hierarchicTree.getRowForLocation(e.getX(), e.getY());
                HierarchicDefinitionPane.this.explanationTree.clearSelection();
                if (selRow == -1) {
                    return;
                }
                if (this.oldRow != -1 && selRow == this.oldRow) {
                    HierarchicDefinitionPane.this.hierarchicTree.clearSelection();
                    this.oldRow = -1;
                } else {
                    this.oldRow = selRow;
                }
            }
        });
        this.jToolBar.add(this.expand);
        this.jToolBar.add(this.collapse);
        this.jToolBar.addSeparator();
        this.jToolBar.add((Component)this.addFolderButton, null);
        this.jToolBar.addSeparator();
        this.jToolBar.add((Component)this.renameButton, null);
        this.jToolBar.add((Component)this.deleteButton, null);
        this.jToolBar.addSeparator();
        this.jToolBar.add((Component)this.edit, null);
        this.topPanel.add((Component)this.jToolBar, "Center");
        this.descriptionScrollPane = new JScrollPane();
        this.explanationScrollPane = new JScrollPane();
        this.centerPanel.add((Component)this.descriptionScrollPane, "top");
        this.centerPanel.add((Component)this.explanationScrollPane, "bottom");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        DefaultTreeModel explanationModel = new DefaultTreeModel(root);
        this.explanationTree = new HierarchicTree(explanationModel);
        this.explanationScrollPane.getViewport().add((Component)this.explanationTree, null);
        this.explanationTree.addMouseListener(new MouseAdapter(){
            private int oldRow = -1;

            public void mousePressed(MouseEvent e) {
                int selRow = HierarchicDefinitionPane.this.explanationTree.getRowForLocation(e.getX(), e.getY());
                HierarchicDefinitionPane.this.hierarchicTree.clearSelection();
                if (selRow == -1) {
                    return;
                }
                if (this.oldRow != -1 && selRow == this.oldRow) {
                    HierarchicDefinitionPane.this.explanationTree.clearSelection();
                    this.oldRow = -1;
                } else {
                    this.oldRow = selRow;
                }
            }
        });
        this.bottomPanel.add(this.statusBar);
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.setVisible(true);
        this.updateExplanationTree();
    }

    public void updateExplanationTree() {
        this.hierarchicTree = this.net.getHierarchicTree();
        this.hierarchicTree.setProbabilisticNetwork(this.net, false);
        this.model = (DefaultTreeModel)this.hierarchicTree.getModel();
        this.descriptionScrollPane.getViewport().removeAll();
        this.descriptionScrollPane.getViewport().add((Component)this.hierarchicTree, null);
        this.hierarchicTree.expandTree();
        this.explanationTree.setProbabilisticNetwork(this.net, true);
        this.explanationScrollPane.getViewport().removeAll();
        this.explanationScrollPane.getViewport().add((Component)this.explanationTree, null);
        this.centerPanel.setDividerLocation(0.5);
    }

    private void deleteButton_actionPerformed(ActionEvent e) {
        this.selectedNode = (DefaultMutableTreeNode)this.hierarchicTree.getLastSelectedPathComponent();
        if (this.selectedNode != null) {
            Enumeration<TreeNode> enumeration = this.selectedNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                Debug.println(treeNode.toString());
                Node node = this.hierarchicTree.getNodeInformation(treeNode);
                if (node == null) {
                    this.model.removeNodeFromParent(this.selectedNode);
                    continue;
                }
                node.setInformationType(4);
            }
            this.updateExplanationTree();
        }
    }

    private void renameButton_actionPerformed(ActionEvent e) {
        Node node;
        String newNodeName;
        this.selectedNode = (DefaultMutableTreeNode)this.hierarchicTree.getLastSelectedPathComponent();
        if (this.selectedNode != null) {
            this.disableButtons();
            newNodeName = JOptionPane.showInternalInputDialog(this, "", "New Folder Name", 3);
            this.enableButtons();
            node = this.hierarchicTree.getNodeInformation(this.selectedNode);
            if (node != null && newNodeName != null && !newNodeName.equals("")) {
                node.setDescription(newNodeName);
                this.selectedNode.setUserObject(newNodeName);
                this.model.reload(this.selectedNode);
            } else if (newNodeName != null && !newNodeName.equals("")) {
                this.selectedNode.setUserObject(newNodeName);
                this.model.reload(this.selectedNode);
            }
        }
        this.selectedNode = (DefaultMutableTreeNode)this.explanationTree.getLastSelectedPathComponent();
        if (this.selectedNode != null) {
            this.disableButtons();
            newNodeName = JOptionPane.showInternalInputDialog(this, "", "New Folder Name", 3);
            this.enableButtons();
            node = this.explanationTree.getNodeInformation(this.selectedNode);
            if (node != null && newNodeName != null && !newNodeName.equals("")) {
                node.setDescription(newNodeName);
                this.selectedNode.setUserObject(newNodeName);
                this.model.reload((TreeNode)this.model.getRoot());
            }
        }
    }

    private void addFolderButton_actionPerformed(ActionEvent e) {
        this.selectedNode = (DefaultMutableTreeNode)this.hierarchicTree.getLastSelectedPathComponent();
        Node node = this.hierarchicTree.getNodeInformation(this.selectedNode);
        if (node == null) {
            if (this.selectedNode == null) {
                this.disableButtons();
                String newNodeName = JOptionPane.showInternalInputDialog(this, "", "Add Top Folder", 3);
                this.enableButtons();
                if (newNodeName != null && newNodeName != null && !newNodeName.equals("")) {
                    DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.model.getRoot();
                    this.insertNewNode(root, newNodeName);
                }
            } else {
                this.disableButtons();
                String newNodeName = JOptionPane.showInternalInputDialog(this, "", "Add Child Folder", 3);
                this.enableButtons();
                if (newNodeName != null && newNodeName != null && !newNodeName.equals("")) {
                    this.insertNewNode(this.selectedNode, newNodeName);
                }
            }
        }
    }

    private void disableButtons() {
        this.deleteButton.setEnabled(false);
        this.renameButton.setEnabled(false);
        this.addFolderButton.setEnabled(false);
        this.expand.setEnabled(false);
        this.edit.setEnabled(false);
        this.collapse.setEnabled(false);
    }

    private void enableButtons() {
        this.deleteButton.setEnabled(true);
        this.renameButton.setEnabled(true);
        this.addFolderButton.setEnabled(true);
        this.expand.setEnabled(true);
        this.edit.setEnabled(true);
        this.collapse.setEnabled(true);
    }

    private void insertNewNode(DefaultMutableTreeNode node, String nodeName) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(nodeName);
        this.model.insertNodeInto(newNode, node, node.getChildCount());
        this.showNewNode(newNode);
    }

    private void showNewNode(DefaultMutableTreeNode newNode) {
        Object[] nodes = this.model.getPathToRoot(newNode);
        TreePath path = new TreePath(nodes);
        this.hierarchicTree.scrollPathToVisible(path);
    }

    private void edit_actionPerformed(ActionEvent e) {
        this.netWindow.changeToPNEditionPane();
    }
}

