/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import unbbayes.controller.IconController;
import unbbayes.prs.Node;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.util.ArrayMap;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicTree
extends JTree
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private static final long serialVersionUID = 0L;
    private SingleEntityNetwork net;
    private ArrayList<Node> nodes;
    private ArrayMap<DefaultMutableTreeNode, Node> objectsMap = new ArrayMap();
    public static final boolean EXPLANATION_TYPE = true;
    public static final boolean DESCRIPTION_TYPE = false;
    private DropTarget dropTarget = null;
    private DragSource dragSource = null;
    protected IconController iconController = IconController.getInstance();

    public HierarchicTree(DefaultTreeModel model) {
        super(model);
        this.setCellRenderer(new HierarchicTreeCellRenderer());
        try {
            this.dropTarget = new DropTarget(this, this);
            this.dragSource = new DragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        }
        catch (HeadlessException e) {
            Debug.println(this.getClass(), String.valueOf(e.getMessage()) + ": no GUI was found.", e);
        }
        this.setRootVisible(false);
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(1);
    }

    public void setProbabilisticNetwork(SingleEntityNetwork net, boolean nodeType) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (net != null) {
            this.net = net;
            this.objectsMap.clear();
            ArrayList<Node> nos = nodeType ? net.getExplanationNodes() : net.getDescriptionNodes();
            int size = nos.size();
            int i = 0;
            while (i < size) {
                Node node = nos.get(i);
                DefaultMutableTreeNode treeNode = this.findUserObject(node.getDescription(), root);
                if (treeNode != null) {
                    this.objectsMap.put(treeNode, node);
                } else {
                    DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(node.getDescription());
                    this.objectsMap.put(newNode, node);
                    root.add(newNode);
                }
                ++i;
            }
            ((DefaultTreeModel)this.getModel()).reload(root);
        }
    }

    private DefaultMutableTreeNode findUserObject(String treeNode, DefaultMutableTreeNode root) {
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.getUserObject().toString().equals(treeNode)) continue;
            return node;
        }
        return null;
    }

    public void expandTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i);
            ++i;
        }
    }

    public void collapseTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.collapseRow(i);
            ++i;
        }
    }

    public JTree copyTree() {
        Stack<TreeNode> stack = new Stack<TreeNode>();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        DefaultMutableTreeNode newRoot = new DefaultMutableTreeNode(root.toString());
        JTree jTree = new JTree(newRoot);
        stack.push(root);
        while (!stack.empty()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)stack.pop();
            int size = node.getChildCount();
            int i = 0;
            while (i < size) {
                TreeNode child = node.getChildAt(i);
                DefaultMutableTreeNode mutableTreeNode = this.findUserObject(node.toString(), newRoot);
                if (mutableTreeNode != null) {
                    ((DefaultTreeModel)jTree.getModel()).insertNodeInto(new DefaultMutableTreeNode(child.toString()), mutableTreeNode, mutableTreeNode.getChildCount());
                }
                stack.push(child);
                ++i;
            }
        }
        return jTree;
    }

    public Node getNodeInformation(DefaultMutableTreeNode treeNode) {
        return this.objectsMap.get(treeNode);
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        event.acceptDrag(2);
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        try {
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String s = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                Node draggedNode = this.net.getNode(s);
                if (draggedNode != null) {
                    DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
                    DefaultMutableTreeNode treeNode = this.findUserObject(draggedNode.getDescription(), root);
                    if (treeNode == null) {
                        event.acceptDrop(2);
                        int informationType = draggedNode.getInformationType();
                        if (informationType == 3) {
                            draggedNode.setInformationType(4);
                        } else {
                            draggedNode.setInformationType(3);
                        }
                        Point d = event.getLocation();
                        TreePath treePath = this.getPathForLocation((int)d.getX(), (int)d.getY());
                        if (treePath != null) {
                            root = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        }
                        Node dum = this.getNodeInformation(root);
                        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
                        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(draggedNode.getDescription());
                        this.objectsMap.put(newNode, draggedNode);
                        if (dum != null) {
                            root = (DefaultMutableTreeNode)root.getParent();
                        }
                        root.add(newNode);
                        model.reload(root);
                        event.getDropTargetContext().dropComplete(true);
                    }
                } else {
                    event.rejectDrop();
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("Exception" + ioe.getMessage());
            event.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
            System.err.println("Exception" + ufe.getMessage());
            event.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        Node node;
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (selectedNode != null && (node = this.getNodeInformation(selectedNode)) != null) {
            StringSelection text = new StringSelection(node.getName());
            this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, text, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        if (event.getDropSuccess()) {
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent((DefaultMutableTreeNode)this.getLastSelectedPathComponent());
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    public ArrayList<Node> getAllNodeInformations() {
        this.objectsMap.values().toArray();
        return new ArrayList<Node>(this.objectsMap.values());
    }

    private class HierarchicTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 0L;
        private ImageIcon folderSmallIcon;
        private ImageIcon yellowBallIcon;
        private ImageIcon greenBallIcon;

        private HierarchicTreeCellRenderer() {
            this.folderSmallIcon = HierarchicTree.this.iconController.getFolderSmallIcon();
            this.yellowBallIcon = HierarchicTree.this.iconController.getYellowBallIcon();
            this.greenBallIcon = HierarchicTree.this.iconController.getGreenBallIcon();
        }

        public Component getTreeCellRendererComponent(JTree tree, DefaultMutableTreeNode value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf) {
                Node node = (Node)HierarchicTree.this.objectsMap.get(value);
                if (node != null) {
                    if (node.getInformationType() == 3) {
                        this.setIcon(this.yellowBallIcon);
                    } else {
                        this.setIcon(this.greenBallIcon);
                    }
                } else {
                    this.setIcon(this.folderSmallIcon);
                }
            } else {
                this.setOpenIcon(this.folderSmallIcon);
                this.setClosedIcon(this.folderSmallIcon);
            }
            return this;
        }
    }
}

