/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import unbbayes.controller.IconController;
import unbbayes.gui.GraphPane;
import unbbayes.gui.LearningPNEditionPane;
import unbbayes.gui.resources.GuiResources;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.util.ResourceController;

public class LearningPNEditionDialog
extends JDialog {
    private static final long serialVersionUID = 0L;
    private JToolBar jtb;
    private JViewport view;
    private GraphPane rede;
    private JButton insereArco;
    private JButton reaprende;
    private JScrollPane jspView;
    private ProbabilisticNetwork net;
    protected IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName());
    WindowAdapter closeFunction = new WindowAdapter(){

        public void windowClosing(WindowEvent we) {
        }
    };

    public LearningPNEditionDialog(ProbabilisticNetwork _net) {
        super(new Frame(), resource.getString("aprendizagemTitle"), true);
        Container contentPane = this.getContentPane();
        this.net = _net;
        this.setSize(550, 470);
        this.setResizable(true);
        this.insereArco = new JButton(this.iconController.getEdgeIcon());
        this.reaprende = new JButton(this.iconController.getCompileIcon());
        this.view = new JViewport();
        this.jtb = new JToolBar();
        this.rede = new LearningPNEditionPane(this, this.net);
        this.jspView = new JScrollPane(this.view);
        this.view.setView(this.rede);
        this.insereArco.setToolTipText(resource.getString("arcToolTip"));
        this.reaprende.setToolTipText(resource.getString("calculateProbabilitiesFromLearningToEditMode"));
        this.jspView.setHorizontalScrollBar(this.jspView.createHorizontalScrollBar());
        this.jspView.setVerticalScrollBar(this.jspView.createVerticalScrollBar());
        this.jspView.setHorizontalScrollBarPolicy(32);
        this.jspView.setVerticalScrollBarPolicy(22);
        this.reaprende.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                List<Edge> edgeList = LearningPNEditionDialog.this.net.getEdges();
                boolean close = true;
                int i = 0;
                while (i < edgeList.size() && close) {
                    Edge edge = edgeList.get(i);
                    if (!edge.hasDirection()) {
                        JOptionPane.showMessageDialog(null, "Todos os arcos tem que ter uma direcao.", "ERROR", 0);
                        return;
                    }
                    ++i;
                }
                i = 0;
                while (i < LearningPNEditionDialog.this.net.getNodeCount() && close) {
                    Node node = LearningPNEditionDialog.this.net.getNodeAt(i);
                    if (node.getChildren().size() == 0 && node.getParents().size() == 0) {
                        JOptionPane.showMessageDialog(null, "Todo no deve tem que ter pelo menos um adjacente.", "ERROR", 0);
                        return;
                    }
                    ++i;
                }
                LearningPNEditionDialog.this.setVisible(false);
                LearningPNEditionDialog.this.dispose();
            }
        });
        this.insereArco.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                LearningPNEditionDialog.this.rede.setState("ConnectComponents");
            }
        });
        this.jtb.add(this.insereArco);
        this.jtb.add(this.reaprende);
        contentPane.add((Component)this.jtb, "North");
        contentPane.add((Component)this.jspView, "Center");
        this.setVisible(true);
        this.addWindowListener(this.closeFunction);
    }

    public JScrollPane getJspView() {
        return this.jspView;
    }

    public JViewport getView() {
        return this.view;
    }
}

