/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import unbbayes.draw.UShape;
import unbbayes.draw.UShapeLine;
import unbbayes.gui.GraphPane;
import unbbayes.gui.resources.GuiResources;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.hybridbn.ContinuousNode;
import unbbayes.util.ResourceController;

public class LearningPNEditionPane
extends GraphPane
implements MouseListener,
MouseMotionListener {
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName());

    public LearningPNEditionPane(JDialog dlg, ProbabilisticNetwork n) {
        super(dlg, n);
        this.setToUseSelectionForLines(true);
        this.update();
    }

    public boolean insertEdge(Edge edge) {
        try {
            this.net.addEdge(edge);
        }
        catch (InvalidParentException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), resource.getString("statusError"), 0);
            return false;
        }
        return true;
    }

    public void update() {
        this.removeAll();
        UShape shape = null;
        Point2D.Double defaultStartPos = new Point2D.Double(0.0, 0.0);
        int i = 0;
        while (i < this.nodeList.size()) {
            Node n = (Node)this.nodeList.get(i);
            n.updateLabel();
            n.setPosition(((Point2D)defaultStartPos).getX(), ((Point2D)defaultStartPos).getY());
            ((Point2D)defaultStartPos).setLocation(((Point2D)defaultStartPos).getX() + 120.0, i % 2 == 1 ? 10 : 100);
            this.createNode(n);
            if ((n instanceof ContinuousNode || n instanceof ProbabilisticNode) && (shape = this.getNodeUShape(n)) != null) {
                shape.shapeTypeChange("None");
                shape.setState("Resized", null);
            }
            ++i;
        }
        i = 0;
        while (i < this.edgeList.size()) {
            Edge e = (Edge)this.edgeList.get(i);
            if (this.getNodeUShape(e.getOriginNode()) != null && this.getNodeUShape(e.getDestinationNode()) != null) {
                UShapeLine line = new UShapeLine(this, this.getNodeUShape(e.getOriginNode()), this.getNodeUShape(e.getDestinationNode()));
                line.setEdge(e);
                line.setLearningLineSelection(this.isToUseSelectionForLines());
                this.addShape(line);
            }
            ++i;
        }
        this.setShapeStateAll("None", null);
        this.fitCanvasSizeToAllUShapes();
    }

    public UShapeLine onDrawConnectLineReleased(UShape shapeParent, int x, int y) {
        Edge e;
        UShapeLine line = super.onDrawConnectLineReleased(shapeParent, x, y);
        if (line != null && (e = new Edge(line.getSource().getNode(), line.getTarget().getNode())) != null) {
            if (this.insertEdge(e)) {
                line.setUseSelection(true);
                line.setEdge(e);
            } else {
                this.delShape(line);
                this.repaint();
            }
        }
        return line;
    }
}

