/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import unbbayes.gui.ILikelihoodEvidenceDialogBuilder;
import unbbayes.gui.resources.GuiResources;
import unbbayes.gui.table.GUIPotentialTable;
import unbbayes.prs.Graph;
import unbbayes.prs.INode;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.util.ResourceController;

public class LikelihoodEvidenceDialogBuilder
implements ILikelihoodEvidenceDialogBuilder {
    private NumberFormat numberFormat;
    private ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName(), Locale.getDefault(), LikelihoodEvidenceDialogBuilder.class.getClassLoader());

    public LikelihoodEvidenceDialogBuilder() {
        this.setNumberFormat(NumberFormat.getInstance(Locale.US));
        this.getNumberFormat().setMaximumFractionDigits(2);
    }

    public JDialog buildDialog(Graph graph, INode nodeToAddLikelihood, Component owner) {
        JTable table = this.buildMainTable(graph, nodeToAddLikelihood);
        JPanel mainPanel = this.buildMainPanel(graph, nodeToAddLikelihood, table);
        JOptionPane optPane = new JOptionPane(mainPanel, 3, 2);
        JDialog ret = optPane.createDialog(owner, this.getResource().getString("likelihoodName"));
        ret.setResizable(true);
        ret.addComponentListener(this.buildLikelihoodEvidenceDialogComponentListener(graph, nodeToAddLikelihood, table, optPane));
        ret.pack();
        return ret;
    }

    protected JPanel buildMainPanel(Graph graph, INode nodeToAddLikelihood, JTable table) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel(nodeToAddLikelihood.toString());
        panel.add(label);
        panel.add(table);
        return panel;
    }

    protected JTable buildMainTable(Graph graph, INode nodeToAddLikelihood) {
        ProbabilisticTable dummyTable = this.buildTableForLikelihoodEvidenceInput(graph, nodeToAddLikelihood);
        return new GUIPotentialTable(dummyTable).makeTable();
    }

    protected ProbabilisticTable buildTableForLikelihoodEvidenceInput(Graph graph, INode nodeToAddLikelihood) {
        ProbabilisticTable ret = new ProbabilisticTable();
        ret.addVariable(nodeToAddLikelihood);
        int i = 0;
        while (i < ret.tableSize()) {
            ret.setValue(i, 1.0f);
            ++i;
        }
        return ret;
    }

    protected ComponentListener buildLikelihoodEvidenceDialogComponentListener(Graph graph, INode nodeToAddLikelihood, JTable table, JOptionPane optPane) {
        return new LikelihoodEvidenceDialogComponentListener(nodeToAddLikelihood, table, optPane);
    }

    public ResourceBundle getResource() {
        return this.resource;
    }

    public void setResource(ResourceBundle resource) {
        this.resource = resource;
    }

    public void setNumberFormat(NumberFormat nuberFormat) {
        this.numberFormat = nuberFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public class LikelihoodEvidenceDialogComponentListener
    implements ComponentListener {
        private final INode nodeToAddLikelihood;
        private final JTable table;
        private final JOptionPane optPane;

        public LikelihoodEvidenceDialogComponentListener(INode nodeToAddLikelihood, JTable table, JOptionPane optPane) {
            this.nodeToAddLikelihood = nodeToAddLikelihood;
            this.table = table;
            this.optPane = optPane;
        }

        public void componentHidden(ComponentEvent e) {
            if (this.optPane.getValue() != null && this.optPane.getValue().equals(0)) {
                float[] stateProbabilities = new float[this.nodeToAddLikelihood.getStatesSize()];
                try {
                    int i = 0;
                    while (i < this.nodeToAddLikelihood.getStatesSize()) {
                        stateProbabilities[i] = LikelihoodEvidenceDialogBuilder.this.getNumberFormat().parse((String)this.table.getValueAt(i, 1)).floatValue();
                        ++i;
                    }
                }
                catch (ParseException pe) {
                    pe.printStackTrace();
                    JOptionPane.showMessageDialog(null, pe.getMessage());
                    return;
                }
                float totalProbability = 0.0f;
                int i = 0;
                while (i < this.nodeToAddLikelihood.getStatesSize()) {
                    totalProbability += stateProbabilities[i];
                    ++i;
                }
                if ((double)totalProbability == 0.0) {
                    JOptionPane.showMessageDialog(null, String.valueOf(LikelihoodEvidenceDialogBuilder.this.getResource().getString("likelihoodName")) + ": 0");
                    return;
                }
                i = 0;
                while (i < this.nodeToAddLikelihood.getStatesSize()) {
                    stateProbabilities[i] = stateProbabilities[i] / totalProbability;
                    ++i;
                }
                ((TreeVariable)this.nodeToAddLikelihood).addLikeliHood(stateProbabilities);
            }
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }
    }
}

