/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.border.TitledBorder;
import unbbayes.util.longtask.ILongTaskProgressObserver;
import unbbayes.util.longtask.LongTaskProgressChangedEvent;

public class LongTaskProgressBar
implements ILongTaskProgressObserver {
    private JButton cancelButton;
    private JProgressBar progressBar;
    private JFrame frm = new JFrame();
    private Container content;
    private Thread t;

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public LongTaskProgressBar(boolean showProgressBar) {
        this("Reading...", showProgressBar);
    }

    public LongTaskProgressBar(String title, boolean showProgressBar) {
        this.frm.setDefaultCloseOperation(2);
        this.cancelButton = new JButton("Cancel");
        this.content = this.frm.getContentPane();
        this.content.add(this.cancelButton);
        this.cancelButton.setBounds(100, 35, 100, 25);
        this.cancelButton.addActionListener(new CancelActionListener());
        this.progressBar = new JProgressBar(0, 10000);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        TitledBorder border = BorderFactory.createTitledBorder(title);
        this.progressBar.setBorder(border);
        this.content.add((Component)this.progressBar, "North");
        this.frm.setSize(300, 100);
        this.frm.setVisible(showProgressBar);
    }

    public void setThread(Thread t) {
        this.t = t;
    }

    public void setProgressBar(int n) {
        this.progressBar.setValue(n);
    }

    public void hideProgressBar() {
        this.frm.setVisible(false);
    }

    public void showProgressBar() {
        this.frm.setVisible(true);
    }

    public void update() {
        this.progressBar.paintImmediately(0, 0, this.progressBar.getWidth(), this.progressBar.getHeight());
    }

    public void update(LongTaskProgressChangedEvent status) {
        this.progressBar.setValue(status.getPercentageDone());
        this.update();
    }

    protected class CancelActionListener
    implements ActionListener {
        protected CancelActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            LongTaskProgressBar.this.frm.setVisible(false);
            LongTaskProgressBar.this.frm.dispose();
            LongTaskProgressBar.this.t.stop();
        }
    }
}

