/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import unbbayes.controller.ConfigurationsController;
import unbbayes.controller.IconController;
import unbbayes.controller.NetworkController;
import unbbayes.gui.EditNet;
import unbbayes.gui.EvidenceTree;
import unbbayes.gui.GraphAction;
import unbbayes.gui.GraphPane;
import unbbayes.gui.HierarchicDefinitionPane;
import unbbayes.gui.PNCompilationPane;
import unbbayes.gui.PNEditionPane;
import unbbayes.gui.resources.GuiResources;
import unbbayes.gui.table.extension.IProbabilityFunctionPanelBuilder;
import unbbayes.io.BaseIO;
import unbbayes.io.FileExtensionIODelegator;
import unbbayes.io.extension.jpf.PluginAwareFileExtensionIODelegator;
import unbbayes.prs.Graph;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.util.ResourceController;
import unbbayes.util.extension.UnBBayesModule;

public class NetworkWindow
extends UnBBayesModule {
    private static final long serialVersionUID = 0L;
    private JViewport graphViewport = null;
    private GraphPane graphPane = null;
    private NetworkController controller = null;
    private Network net = null;
    private String fileName = null;
    private JScrollPane jspGraph = null;
    private JLabel status = null;
    private boolean bCompiled = false;
    private CardLayout card;
    private PNEditionPane pnEditionPane = null;
    private PNCompilationPane pnCompilationPane = null;
    private HierarchicDefinitionPane hierarchyPanel = null;
    private EditNet editNet = null;
    public static final Integer PN_MODE = 0;
    private Integer mode = null;
    public static final String PN_PANE_PN_EDITION_PANE = "pnEditionPane";
    public static final String PN_PANE_PN_EDIT_NET = "editNet";
    public static final String PN_PANE_PN_COMPILATION_PANE = "pnCompilationPane";
    public static final String PN_PANE_HIERARCHY_PANE = "hierarchy";
    public static final String PN_PANE_EVALUATION_PANE = "pnEvaluation";
    private String moduleName;
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName());

    protected NetworkWindow() {
        super("");
        this.setModuleName(resource.getString("PNModuleName"));
        this.status = new JLabel(resource.getString("statusReadyLabel"));
    }

    public NetworkWindow(Network net) {
        super(net.getName());
        this.net = net;
        this.fileName = null;
        Container contentPane = this.getContentPane();
        this.card = new CardLayout();
        contentPane.setLayout(this.card);
        this.setDefaultCloseOperation(2);
        this.graphViewport = new JViewport();
        if (!(net instanceof SingleEntityNetwork)) {
            throw new IllegalArgumentException("net != SingleEntityNetwork");
        }
        this.controller = new NetworkController((SingleEntityNetwork)net, this);
        this.setModuleName(resource.getString("PNModuleName"));
        this.graphPane = new GraphPane(this.controller, this.graphViewport);
        this.jspGraph = new JScrollPane(this.graphViewport);
        this.status = new JLabel(resource.getString("statusReadyLabel"));
        this.bCompiled = false;
        long width = (long)Node.getDefaultSize().getX();
        long height = (long)Node.getDefaultSize().getY();
        this.graphPane.getGraphViewport().reshape(0, 0, (int)(this.graphPane.getBiggestPoint().getX() + (double)width), (int)(this.graphPane.getBiggestPoint().getY() + (double)height));
        this.graphPane.getGraphViewport().setViewSize(new Dimension((int)(this.graphPane.getBiggestPoint().getX() + (double)width), (int)(this.graphPane.getBiggestPoint().getY() + (double)height)));
        this.graphViewport.setView(this.graphPane);
        this.graphViewport.setSize(800, 600);
        this.jspGraph.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                NetworkWindow.this.graphPane.update();
            }
        });
        this.jspGraph.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                NetworkWindow.this.graphPane.update();
            }
        });
        this.jspGraph.setHorizontalScrollBar(this.jspGraph.createHorizontalScrollBar());
        this.jspGraph.setVerticalScrollBar(this.jspGraph.createVerticalScrollBar());
        this.jspGraph.setHorizontalScrollBarPolicy(32);
        this.jspGraph.setVerticalScrollBarPolicy(22);
        if (!(net instanceof SingleEntityNetwork)) {
            throw new IllegalArgumentException("net != SingleEntityNetwork");
        }
        this.mode = PN_MODE;
        this.pnEditionPane = new PNEditionPane(this, this.controller);
        this.editNet = new EditNet(this, this.controller);
        this.pnCompilationPane = new PNCompilationPane(this, this.controller);
        this.hierarchyPanel = new HierarchicDefinitionPane((SingleEntityNetwork)net, this);
        contentPane.add((Component)this.pnEditionPane, PN_PANE_PN_EDITION_PANE);
        contentPane.add((Component)this.editNet, PN_PANE_PN_EDIT_NET);
        contentPane.add((Component)this.pnCompilationPane, PN_PANE_PN_COMPILATION_PANE);
        contentPane.add((Component)this.hierarchyPanel, PN_PANE_HIERARCHY_PANE);
        this.pnEditionPane.getCenterPanel().setBottomComponent(this.jspGraph);
        this.card.show(this.getContentPane(), PN_PANE_PN_EDITION_PANE);
        this.setVisible(true);
        this.graphPane.update();
    }

    public void updateTitle() {
        super.setTitle(String.valueOf(this.net.getName()) + " " + "[" + this.fileName + "]");
    }

    public GraphPane getGraphPane() {
        return this.graphPane;
    }

    public EvidenceTree getEvidenceTree() {
        if (this.pnCompilationPane != null) {
            return this.pnCompilationPane.getEvidenceTree();
        }
        return null;
    }

    public JViewport getGraphViewport() {
        return this.graphViewport;
    }

    public JTable getTable() {
        return this.pnEditionPane.getTable();
    }

    public JTextField getTxtDescription() {
        if (this.pnEditionPane == null) {
            return null;
        }
        return this.pnEditionPane.getTxtDescription();
    }

    public JTextField getTxtName() {
        if (this.pnEditionPane == null) {
            return null;
        }
        return this.pnEditionPane.getTxtName();
    }

    public void setDistributionPane(JPanel distributionPane) {
        this.pnEditionPane.setDistributionPane(distributionPane);
        this.setAddRemoveStateButtonVisible(false);
    }

    public void setTable(JTable table, Node tableOwner) {
        this.pnEditionPane.setTable(table, tableOwner);
    }

    public JScrollPane getJspGraph() {
        return this.jspGraph;
    }

    public JScrollPane getJspTree() {
        return this.pnCompilationPane.getJspTree();
    }

    public Node getTableOwner() {
        return this.pnEditionPane.getTableOwner();
    }

    public void setTableOwner(Node node) {
        this.pnEditionPane.setTableOwner(node);
    }

    public SingleEntityNetwork getSingleEntityNetwork() {
        return (SingleEntityNetwork)this.controller.getNetwork();
    }

    public void setStatus(String status) {
        if (this.pnCompilationPane != null) {
            this.pnCompilationPane.setStatus(status);
        }
        if (this.pnEditionPane != null) {
            this.pnEditionPane.setStatus(status);
        }
        this.status.setText(status);
    }

    public void changeToPNCompilationPane() {
        if (this.mode == PN_MODE) {
            this.graphPane.setAction(GraphAction.NONE);
            this.graphPane.removeKeyListener(this.controller);
            this.pnCompilationPane.getCenterPanel().setRightComponent(this.jspGraph);
            this.pnCompilationPane.setStatus(this.status.getText());
            this.pnCompilationPane.getEvidenceTree().setRootVisible(true);
            this.pnCompilationPane.getEvidenceTree().expandRow(0);
            this.pnCompilationPane.getEvidenceTree().setRootVisible(false);
            this.bCompiled = true;
            this.controller.getSingleEntityNetwork().setFirstInitialization(true);
            this.card.show(this.getContentPane(), PN_PANE_PN_COMPILATION_PANE);
            this.pnCompilationPane.getEvidenceTree().updateTree(false);
            this.pnCompilationPane.updateToPreferredSize();
        }
    }

    public void changeToPNEvaluationPane(JPanel evaluationPane) {
        if (this.mode == PN_MODE) {
            this.graphPane.setAction(GraphAction.NONE);
            this.graphPane.removeKeyListener(this.controller);
            JPanel leftPane = new JPanel(new BorderLayout());
            JToolBar toolBar = new JToolBar();
            JButton editMode = new JButton(IconController.getInstance().getEditIcon());
            editMode.setToolTipText(resource.getString("editToolTip"));
            editMode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    NetworkWindow.this.changeToPNEditionPane();
                }
            });
            toolBar.add(editMode);
            leftPane.add((Component)toolBar, "North");
            leftPane.add((Component)evaluationPane, "Center");
            JSplitPane mainPane = new JSplitPane(1, leftPane, this.jspGraph);
            mainPane.setDividerLocation(500);
            this.getContentPane().add((Component)mainPane, PN_PANE_EVALUATION_PANE);
            this.card.show(this.getContentPane(), PN_PANE_EVALUATION_PANE);
        }
    }

    public void changeToPNEditionPane() {
        if (this.mode == PN_MODE) {
            this.graphPane.addKeyListener(this.controller);
            this.pnEditionPane.getCenterPanel().setBottomComponent(this.jspGraph);
            this.pnEditionPane.setStatus(this.status.getText());
            this.bCompiled = false;
            this.controller.getSingleEntityNetwork().setFirstInitialization(true);
            this.graphPane.update();
            this.graphPane.resizeAllToFitText();
            this.card.show(this.getContentPane(), PN_PANE_PN_EDITION_PANE);
        }
    }

    public void changeToHierarchy() {
        this.hierarchyPanel.updateExplanationTree();
        this.card.show(this.getContentPane(), PN_PANE_HIERARCHY_PANE);
    }

    public void changeToEditNet() {
        this.card.show(this.getContentPane(), PN_PANE_PN_EDIT_NET);
    }

    public boolean isCompiled() {
        return this.bCompiled;
    }

    public PNEditionPane getNetWindowEdition() {
        return this.pnEditionPane;
    }

    public PNCompilationPane getNetWindowCompilation() {
        return this.pnCompilationPane;
    }

    public HierarchicDefinitionPane getHierarchicDefinitionPanel() {
        return this.hierarchyPanel;
    }

    public NetworkController getNetworkController() {
        return this.controller;
    }

    public EditNet getEditNet() {
        return this.editNet;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.updateTitle();
    }

    public void setAddRemoveStateButtonVisible(boolean visible) {
        this.pnEditionPane.getBtnAddState().setVisible(visible);
        this.pnEditionPane.getBtnRemoveState().setVisible(visible);
    }

    public Integer getMode() {
        return this.mode;
    }

    public void setMode(Integer mode) {
        this.mode = mode;
    }

    public String getSavingMessage() {
        return resource.getString("saveTitle");
    }

    public NetworkController getController() {
        return this.controller;
    }

    public void setController(NetworkController controller) {
        this.controller = controller;
    }

    public JInternalFrame getInternalFrame() {
        return this;
    }

    public BaseIO getIO() {
        return this.getController().getBaseIO();
    }

    public Graph getPersistingGraph() {
        return this.getController().getNetwork();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public UnBBayesModule openFile(File file) throws IOException {
        Graph g = null;
        PluginAwareFileExtensionIODelegator ioDelegator = PluginAwareFileExtensionIODelegator.newInstance();
        try {
            g = ioDelegator.load(file);
        }
        catch (FileExtensionIODelegator.MoreThanOneCompatibleIOException e) {
            Object[] possibleValues = FileExtensionIODelegator.getNamesFromIOs(e.getIOs());
            String selectedValue = (String)JOptionPane.showInputDialog(this, resource.getString("IOConflictMessage"), resource.getString("IOConflictTitle"), 1, null, possibleValues, possibleValues[0]);
            if (selectedValue != null) {
                g = FileExtensionIODelegator.findIOByName(e.getIOs(), selectedValue).load(file);
            }
            this.dispose();
            return null;
        }
        NetworkWindow window = null;
        try {
            ConfigurationsController.getInstance().addFileToListRecentFiles(file);
            window = new NetworkWindow((Network)g);
            window.setFileName(file.getName().toLowerCase());
        }
        catch (Exception e) {
            throw new RuntimeException(resource.getString("unsupportedGraphFormat"), e);
        }
        this.dispose();
        return window;
    }

    public void showProbabilityDistributionPanel(IProbabilityFunctionPanelBuilder builder) {
        this.setDistributionPane(builder.buildProbabilityFunctionEditionPanel());
        this.setTableOwner(builder.getProbabilityFunctionOwner());
        this.getTxtDescription().setText(builder.getProbabilityFunctionOwner().getDescription());
        this.getTxtName().setText(builder.getProbabilityFunctionOwner().getName());
    }

    public Network getNet() {
        return this.net;
    }

    public void setNet(Network net) {
        this.net = net;
    }

    public CardLayout getCardLayout() {
        return this.card;
    }

    public void setCardLayout(CardLayout card) {
        this.card = card;
    }

    public void setGraphViewport(JViewport graphViewport) {
        this.graphViewport = graphViewport;
    }

    public void setGraphPane(GraphPane graphPane) {
        this.graphPane = graphPane;
    }

    public void setJspGraph(JScrollPane jspGraph) {
        this.jspGraph = jspGraph;
    }

    public boolean isBCompiled() {
        return this.bCompiled;
    }

    public void setBCompiled(boolean compiled) {
        this.bCompiled = compiled;
    }

    public JLabel getStatus() {
        return this.status;
    }

    public void setStatus(JLabel status) {
        this.status = status;
    }
}

