/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import unbbayes.controller.IconController;
import unbbayes.controller.NetworkController;
import unbbayes.gui.EvidenceTree;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.resources.GuiResources;
import unbbayes.gui.util.TextAreaDialog;
import unbbayes.util.ResourceController;

public class PNCompilationPane
extends JPanel {
    private static final long serialVersionUID = 0L;
    private final NetworkWindow netWindow;
    private EvidenceTree evidenceTree;
    private final NetworkController controller;
    private final JScrollPane jspTree;
    private final JSplitPane centerPanel;
    private final JLabel status;
    private final JPanel bottomPanel;
    private final JPanel topPanel;
    private final JToolBar jtbCompilation;
    private final JButton propagate;
    private final JButton expand;
    private final JButton collapse;
    private final JButton editMode;
    private final JButton log;
    private final JButton reset;
    private final JButton removeEvidence;
    private final JButton printNet;
    private final JButton previewNet;
    private final JButton saveNetImage;
    private final IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName());

    public PNCompilationPane(NetworkWindow _netWindow, NetworkController _controller) {
        this.netWindow = _netWindow;
        this.controller = _controller;
        this.setLayout(new BorderLayout());
        this.topPanel = new JPanel(new GridLayout(0, 1));
        this.jtbCompilation = new JToolBar();
        this.centerPanel = new JSplitPane(1);
        this.evidenceTree = new EvidenceTree(this.netWindow.getSingleEntityNetwork(), this.netWindow);
        this.jspTree = new JScrollPane(this.evidenceTree);
        this.bottomPanel = new JPanel(new FlowLayout(0, 5, 1));
        this.status = new JLabel(resource.getString("statusReadyLabel"));
        this.propagate = new JButton(this.iconController.getPropagateIcon());
        this.expand = new JButton(this.iconController.getExpandIcon());
        this.collapse = new JButton(this.iconController.getColapseIcon());
        this.editMode = new JButton(this.iconController.getEditIcon());
        this.log = new JButton(this.iconController.getInformationIcon());
        this.reset = new JButton(this.iconController.getInitializeIcon());
        this.removeEvidence = new JButton(this.iconController.getRemoveEvidenceIcon());
        this.printNet = new JButton(this.iconController.getPrintNetIcon());
        this.previewNet = new JButton(this.iconController.getPrintPreviewNetIcon());
        this.saveNetImage = new JButton(this.iconController.getSaveNetIcon());
        this.propagate.setToolTipText(resource.getString("propagateToolTip"));
        this.expand.setToolTipText(resource.getString("expandToolTip"));
        this.collapse.setToolTipText(resource.getString("collapseToolTip"));
        this.editMode.setToolTipText(resource.getString("editToolTip"));
        this.log.setToolTipText(resource.getString("logToolTip"));
        this.reset.setToolTipText(resource.getString("resetBeliefsToolTip"));
        this.removeEvidence.setToolTipText(resource.getString("resetBeliefsToolTip"));
        this.printNet.setToolTipText(resource.getString("printNetToolTip"));
        this.previewNet.setToolTipText(resource.getString("previewNetToolTip"));
        this.saveNetImage.setToolTipText(resource.getString("saveNetImageToolTip"));
        this.log.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNCompilationPane.this.netWindow.getGraphPane().compiled(false, null);
                TextAreaDialog jd = new TextAreaDialog((Frame)PNCompilationPane.this.netWindow.getUnbbayesFrame(), false);
                jd.setTextContent(PNCompilationPane.this.controller.getLog());
                jd.pack();
                jd.setLocationRelativeTo(PNCompilationPane.this);
                jd.setVisible(true);
            }
        });
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PNCompilationPane.this.controller.initialize();
            }
        });
        this.removeEvidence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PNCompilationPane.this.controller.removeEvidence(PNCompilationPane.this.controller.getSelectedNode());
            }
        });
        this.editMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNCompilationPane.this.netWindow.changeToPNEditionPane();
            }
        });
        this.propagate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNCompilationPane.this.controller.propagate();
            }
        });
        this.collapse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNCompilationPane.this.setCursor(new Cursor(3));
                PNCompilationPane.this.evidenceTree.collapseTree();
                PNCompilationPane.this.setCursor(new Cursor(0));
            }
        });
        this.expand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNCompilationPane.this.setCursor(new Cursor(3));
                PNCompilationPane.this.evidenceTree.expandTree();
                PNCompilationPane.this.setCursor(new Cursor(0));
            }
        });
        this.printNet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNCompilationPane.this.controller.printNet(PNCompilationPane.this.netWindow.getGraphPane(), PNCompilationPane.this.controller.calculateNetRectangle());
            }
        });
        this.previewNet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNCompilationPane.this.controller.previewPrintNet(PNCompilationPane.this.netWindow.getGraphPane(), PNCompilationPane.this.controller.calculateNetRectangle());
            }
        });
        this.saveNetImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PNCompilationPane.this.controller.saveNetImage();
            }
        });
        this.jtbCompilation.add(this.printNet);
        this.jtbCompilation.add(this.previewNet);
        this.jtbCompilation.add(this.saveNetImage);
        this.jtbCompilation.addSeparator();
        this.jtbCompilation.add(this.collapse);
        this.jtbCompilation.add(this.expand);
        this.jtbCompilation.add(this.propagate);
        this.jtbCompilation.addSeparator();
        this.jtbCompilation.add(this.editMode);
        this.jtbCompilation.add(this.log);
        this.jtbCompilation.add(this.reset);
        this.jtbCompilation.add(this.removeEvidence);
        this.topPanel.add(this.jtbCompilation);
        this.centerPanel.setLeftComponent(this.jspTree);
        this.centerPanel.setDividerSize(7);
        this.bottomPanel.add(this.status);
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.setVisible(true);
    }

    public void updateToPreferredSize() {
        int width = this.evidenceTree.getPreferredSize().width + this.centerPanel.getDividerSize() + 20;
        if (width < 200) {
            width = 200;
        }
        this.centerPanel.setDividerLocation(width);
    }

    public JScrollPane getJspTree() {
        return this.jspTree;
    }

    public void setStatus(String status) {
        this.status.setText(status);
    }

    public EvidenceTree getEvidenceTree() {
        return this.evidenceTree;
    }

    public JSplitPane getCenterPanel() {
        return this.centerPanel;
    }

    public JButton getCollapse() {
        return this.collapse;
    }

    public JButton getEditMode() {
        return this.editMode;
    }

    public JButton getExpand() {
        return this.expand;
    }

    public JButton getLog() {
        return this.log;
    }

    public JButton getPreviewNet() {
        return this.previewNet;
    }

    public JButton getPrintNet() {
        return this.printNet;
    }

    public JButton getPropagate() {
        return this.propagate;
    }

    public JButton getReset() {
        return this.reset;
    }

    public JButton getSaveNetImage() {
        return this.saveNetImage;
    }

    public JToolBar getJtbCompilation() {
        return this.jtbCompilation;
    }

    public JPanel getTopPanel() {
        return this.topPanel;
    }
}

