/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import unbbayes.controller.CompilationThread;
import unbbayes.controller.IconController;
import unbbayes.controller.NetworkController;
import unbbayes.gui.GlobalOptionsDialog;
import unbbayes.gui.GraphAction;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.resources.GuiResources;
import unbbayes.gui.table.ColumnGroup;
import unbbayes.gui.table.GroupableTableCellRenderer;
import unbbayes.gui.table.GroupableTableColumnModel;
import unbbayes.gui.table.ReplaceTextCellEditor;
import unbbayes.gui.table.extension.IProbabilityFunctionPanelBuilder;
import unbbayes.gui.util.SplitToggleButton;
import unbbayes.prs.Node;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.bn.cpt.ITableFunction;
import unbbayes.prs.bn.cpt.impl.FillUniformTableFunction;
import unbbayes.prs.bn.cpt.impl.NormalizeTableFunction;
import unbbayes.prs.bn.cpt.impl.UniformTableFunction;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;
import unbbayes.util.extension.dto.INodeClassDataTransferObject;
import unbbayes.util.extension.manager.CoreCPFPluginManager;
import unbbayes.util.extension.manager.UnBBayesPluginContextHolder;

public class PNEditionPane
extends JPanel {
    private static final long serialVersionUID = 0L;
    private final NetworkWindow netWindow;
    private GlobalOptionsDialog go = null;
    private JTable table;
    private final JTextField txtName;
    private final JTextField txtDescription;
    private final NetworkController controller;
    private final JScrollPane jspTable;
    private final JSplitPane centerPanel;
    private Node tableOwner;
    private final JLabel status;
    private final JPanel bottomPanel;
    private final JPanel topPanel;
    private final JToolBar jtbState;
    private final JToolBar jtbEdition;
    private final JLabel lblName;
    private final JLabel lblDescription;
    private final JButton btnEvaluate;
    private final JButton btnCompile;
    private final JButton btnAddState;
    private final JButton btnRemoveState;
    private final ToolBarEdition tbEdition;
    private final JButton btnPrintNet;
    private final JButton btnPrintTable;
    private final JButton btnPreviewNet;
    private final JButton btnPreviewTable;
    private final JButton btnSaveNetImage;
    private final JButton btnSaveTableImage;
    private final JButton btnGlobalOption;
    private final JButton btnHierarchy;
    private final Pattern wordPattern = Node.DEFAULT_NODE_NAME_PATTERN;
    private final Pattern descriptionPattern = Pattern.compile("[ a-zA-Z_0-9\u00e1\u00e9\u00ed\u00f3\u00fa\u00e3\u00f5\u00e7\u00e2\u00ea\u00ee\u00f4\u00fb\u00fc\u00e0(),]*");
    private Matcher matcher;
    private final IconController iconController = IconController.getInstance();
    private JComponent cpfPane;
    private boolean useFloatingColumn = false;
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName());
    private int selectedFunction = 0;

    public PNEditionPane(NetworkWindow _netWindow, NetworkController _controller) {
        this.netWindow = _netWindow;
        this.controller = _controller;
        this.setLayout(new BorderLayout());
        this.table = new JTable();
        this.jspTable = new JScrollPane(this.table);
        this.topPanel = new JPanel(new GridLayout(0, 1));
        this.jtbState = new JToolBar();
        this.jtbEdition = new JToolBar();
        this.centerPanel = new JSplitPane(0);
        this.bottomPanel = new JPanel(new FlowLayout(0, 5, 1));
        this.status = new JLabel(resource.getString("statusReadyLabel"));
        this.lblName = new JLabel(String.valueOf(resource.getString("nameLabel")) + " ");
        this.lblDescription = new JLabel(String.valueOf(resource.getString("descriptionLabel")) + " ");
        this.txtName = new JTextField(10);
        this.txtDescription = new JTextField(15);
        this.btnEvaluate = new JButton(this.iconController.getEvaluateIcon());
        this.btnCompile = new JButton(this.iconController.getCompileIcon());
        this.btnAddState = new JButton(this.iconController.getMoreIcon());
        this.btnRemoveState = new JButton(this.iconController.getLessIcon());
        this.btnPrintNet = new JButton(this.iconController.getPrintNetIcon());
        this.btnPrintTable = new JButton(this.iconController.getPrintTableIcon());
        this.btnPreviewNet = new JButton(this.iconController.getPrintPreviewNetIcon());
        this.btnPreviewTable = new JButton(this.iconController.getPrintPreviewTableIcon());
        this.btnSaveNetImage = new JButton(this.iconController.getSaveNetIcon());
        this.btnSaveTableImage = new JButton(this.iconController.getSaveTableIcon());
        this.btnGlobalOption = new JButton(this.iconController.getGlobalOptionIcon());
        this.btnHierarchy = new JButton(this.iconController.getHierarchyIcon());
        this.setTooltips();
        this.addListeners();
        this.jtbEdition.add(this.btnPrintNet);
        this.jtbEdition.add(this.btnPreviewNet);
        this.jtbEdition.add(this.btnSaveNetImage);
        this.jtbEdition.add(this.btnPrintTable);
        this.jtbEdition.add(this.btnPreviewTable);
        this.jtbEdition.add(this.btnSaveTableImage);
        this.jtbEdition.addSeparator();
        this.tbEdition = new ToolBarEdition();
        this.jtbEdition.add(this.tbEdition);
        this.jtbEdition.addSeparator();
        this.jtbEdition.add(this.btnCompile);
        this.jtbEdition.add(this.btnEvaluate);
        this.jtbEdition.addSeparator();
        this.jtbEdition.add(this.btnGlobalOption);
        this.jtbEdition.add(this.btnHierarchy);
        this.topPanel.add(this.jtbEdition);
        this.jtbState.add(this.lblName);
        this.jtbState.add(this.txtName);
        this.jtbState.addSeparator();
        this.jtbState.addSeparator();
        this.jtbState.add(this.btnAddState);
        this.jtbState.add(this.btnRemoveState);
        this.jtbState.addSeparator();
        this.jtbState.addSeparator();
        this.jtbState.add(this.lblDescription);
        this.jtbState.add(this.txtDescription);
        this.topPanel.add(this.jtbState);
        this.jspTable.setPreferredSize(new Dimension(150, 50));
        this.table.setAutoResizeMode(0);
        this.centerPanel.setTopComponent(this.jspTable);
        this.centerPanel.setDividerSize(7);
        this.centerPanel.resetToPreferredSizes();
        this.bottomPanel.add(this.status);
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.setVisible(true);
    }

    private void setTooltips() {
        this.btnEvaluate.setToolTipText(resource.getString("evaluateToolTip"));
        this.btnCompile.setToolTipText(resource.getString("compileToolTip"));
        this.btnAddState.setToolTipText(resource.getString("moreToolTip"));
        this.btnRemoveState.setToolTipText(resource.getString("lessToolTip"));
        this.btnPrintNet.setToolTipText(resource.getString("printNetToolTip"));
        this.btnPrintTable.setToolTipText(resource.getString("printTableToolTip"));
        this.btnPreviewNet.setToolTipText(resource.getString("previewNetToolTip"));
        this.btnPreviewTable.setToolTipText(resource.getString("previewTableToolTip"));
        this.btnSaveNetImage.setToolTipText(resource.getString("saveNetImageToolTip"));
        this.btnSaveTableImage.setToolTipText(resource.getString("saveTableImageToolTip"));
        this.btnGlobalOption.setToolTipText(resource.getString("globalOptionTitle"));
        this.btnHierarchy.setToolTipText(resource.getString("hierarchyToolTip"));
    }

    private void addListeners() {
        this.btnGlobalOption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.setCursor(new Cursor(3));
                if (PNEditionPane.this.go == null) {
                    PNEditionPane.this.go = new GlobalOptionsDialog(PNEditionPane.this.controller);
                }
                PNEditionPane.this.go.setVisible(true);
                PNEditionPane.this.netWindow.getGraphPane().update();
                PNEditionPane.this.setCursor(new Cursor(0));
            }
        });
        this.btnHierarchy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.netWindow.changeToHierarchy();
            }
        });
        this.btnCompile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                new CompilationThread(PNEditionPane.this.controller, PNEditionPane.this.netWindow);
            }
        });
        this.btnEvaluate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.controller.evaluateNetwork();
            }
        });
        this.txtName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Object selected = PNEditionPane.this.netWindow.getGraphPane().getSelected();
                if (selected instanceof Node) {
                    Node nodeAux = (Node)selected;
                    if (e.getKeyCode() == 10 && PNEditionPane.this.txtName.getText().length() > 0) {
                        try {
                            String name = PNEditionPane.this.txtName.getText(0, PNEditionPane.this.txtName.getText().length());
                            PNEditionPane.this.matcher = PNEditionPane.this.wordPattern.matcher(name);
                            if (PNEditionPane.this.matcher.matches()) {
                                nodeAux.setName(name);
                                PNEditionPane.this.netWindow.getGraphPane().updateSelectedNode();
                            } else {
                                JOptionPane.showMessageDialog(PNEditionPane.this.netWindow, resource.getString("nameError"), resource.getString("nameException"), 0);
                                PNEditionPane.this.txtName.selectAll();
                            }
                        }
                        catch (BadLocationException ble) {
                            ble.printStackTrace();
                        }
                    }
                }
            }
        });
        this.txtDescription.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Object selected = PNEditionPane.this.netWindow.getGraphPane().getSelected();
                if (selected instanceof Node) {
                    Node nodeAux = (Node)selected;
                    if (e.getKeyCode() == 10 && PNEditionPane.this.txtDescription.getText().length() > 0) {
                        try {
                            String name = PNEditionPane.this.txtDescription.getText(0, PNEditionPane.this.txtDescription.getText().length());
                            PNEditionPane.this.matcher = PNEditionPane.this.descriptionPattern.matcher(name);
                            if (PNEditionPane.this.matcher.matches()) {
                                nodeAux.setDescription(name);
                                PNEditionPane.this.netWindow.getGraphPane().updateSelectedNode();
                                PNEditionPane.this.repaint();
                            } else {
                                JOptionPane.showMessageDialog(PNEditionPane.this.netWindow, resource.getString("descriptionError"), resource.getString("nameException"), 0);
                                PNEditionPane.this.txtDescription.selectAll();
                            }
                        }
                        catch (BadLocationException ble) {
                            ble.printStackTrace();
                        }
                    }
                }
            }
        });
        this.btnRemoveState.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (PNEditionPane.this.netWindow.getGraphPane().getSelected() instanceof Node) {
                    PNEditionPane.this.controller.removeState((Node)PNEditionPane.this.netWindow.getGraphPane().getSelected());
                }
            }
        });
        this.btnAddState.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (PNEditionPane.this.netWindow.getGraphPane().getSelected() instanceof Node) {
                    PNEditionPane.this.controller.insertState((Node)PNEditionPane.this.netWindow.getGraphPane().getSelected());
                }
            }
        });
        this.btnPrintNet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.controller.printNet(PNEditionPane.this.netWindow.getGraphPane(), PNEditionPane.this.controller.calculateNetRectangle());
            }
        });
        this.btnPrintTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.controller.printTable();
            }
        });
        this.btnPreviewTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.controller.previewPrintTable();
            }
        });
        this.btnPreviewNet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.controller.previewPrintNet(PNEditionPane.this.netWindow.getGraphPane(), PNEditionPane.this.controller.calculateNetRectangle());
            }
        });
        this.btnSaveNetImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PNEditionPane.this.controller.saveNetImage();
            }
        });
        this.btnSaveTableImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PNEditionPane.this.controller.saveTableImage();
            }
        });
    }

    public JTable getTable() {
        return this.table;
    }

    public JTextField getTxtDescription() {
        return this.txtDescription;
    }

    public JTextField getTxtName() {
        return this.txtName;
    }

    public void setDistributionPane(JPanel distributionPane) {
        JScrollPane scrollPane = new JScrollPane(distributionPane);
        this.centerPanel.setTopComponent(scrollPane);
        this.fitCPFDividerLocationToComponent(distributionPane);
    }

    protected void fitCPFDividerLocationToComponent(JComponent distributionPane) {
        int location = 60;
        if (distributionPane != null) {
            location += distributionPane.getPreferredSize().height + this.centerPanel.getDividerSize();
        }
        if (distributionPane instanceof JTable) {
            if (((JTable)distributionPane).getTableHeader() != null) {
                location += ((JTable)distributionPane).getTableHeader().getPreferredSize().height;
            }
            if (this.jspTable.getVisibleRect().width < distributionPane.getPreferredSize().width) {
                this.jspTable.createHorizontalScrollBar();
                location += this.jspTable.getHorizontalScrollBar().getHeight() - 10;
            }
        }
        if (location >= this.netWindow.getHeight() / 3) {
            location = this.netWindow.getHeight() / 3;
        }
        this.centerPanel.setDividerLocation(location);
    }

    public void setTable(final JTable table, Node tableOwner) {
        this.table = table;
        this.setTableOwner(tableOwner);
        if (this.isUseFloatingColumn() && table.getColumnModel() instanceof GroupableTableColumnModel) {
            final DefaultTableModel frozenModel = new DefaultTableModel(table.getRowCount(), 1);
            int i = 0;
            while (i < table.getRowCount()) {
                String value = (String)table.getValueAt(i, 0);
                frozenModel.setValueAt(value, i, 0);
                ++i;
            }
            frozenModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    table.setValueAt(frozenModel.getValueAt(e.getLastRow(), e.getColumn()), e.getFirstRow(), e.getColumn());
                }
            });
            JTable frozenTable = new JTable(frozenModel);
            GroupableTableColumnModel cm = (GroupableTableColumnModel)table.getColumnModel();
            TableColumn tableColumn = cm.getColumns().nextElement();
            DefaultTableModel header = new DefaultTableModel(tableOwner.getParents().size(), 1);
            if (tableOwner.getParents().size() == 0) {
                header.addRow(new Object[0]);
            }
            Iterator iterator = cm.getColumnGroups(tableColumn);
            int i2 = 0;
            while (iterator != null && iterator.hasNext()) {
                ColumnGroup group = (ColumnGroup)iterator.next();
                header.setValueAt(group.getHeaderValue(), i2, 0);
                ++i2;
            }
            header.setValueAt(tableColumn.getHeaderValue(), i2, 0);
            JTable cornerTable = new JTable(header);
            cornerTable.getColumnModel().getColumn(0).setCellRenderer(new GroupableTableCellRenderer());
            cornerTable.setRowHeight((int)table.prepareRenderer(table.getCellRenderer(0, 0), 0, 0).getPreferredSize().getHeight());
            cornerTable.setAutoResizeMode(0);
            cornerTable.setEnabled(false);
            frozenTable.addMouseMotionListener(new ColumnResizedListener(frozenTable));
            cornerTable.addMouseMotionListener(new HeaderResizedListener(cornerTable, frozenTable));
            frozenTable.getColumnModel().getColumn(0).setCellRenderer(new GroupableTableCellRenderer(Color.BLACK, Color.YELLOW));
            frozenTable.getColumnModel().getColumn(0).setCellEditor(new ReplaceTextCellEditor());
            frozenTable.setSurrendersFocusOnKeystroke(true);
            frozenTable.setAutoResizeMode(0);
            frozenTable.setEnabled(true);
            table.getColumnModel().getColumn(0).setMinWidth(0);
            table.getColumnModel().getColumn(0).setPreferredWidth(0);
            table.getColumnModel().getColumn(0).setResizable(false);
            JViewport frozenViewport = new JViewport();
            frozenViewport.setView(frozenTable);
            frozenViewport.setPreferredSize(frozenTable.getPreferredSize());
            this.jspTable.setViewportView(table);
            this.jspTable.setRowHeaderView(frozenViewport);
            this.jspTable.setCorner("UPPER_LEFT_CORNER", cornerTable);
            this.jspTable.getRowHeader().setPreferredSize(new Dimension(frozenTable.getColumnModel().getColumn(0).getWidth(), (int)this.jspTable.getColumnHeader().getSize().getHeight()));
            this.jspTable.setAlignmentX(0.0f);
            this.jspTable.validate();
            this.jspTable.repaint();
        } else {
            this.jspTable.setRowHeaderView(null);
            this.jspTable.setCorner("UPPER_LEFT_CORNER", null);
            this.jspTable.getRowHeader().setPreferredSize(new Dimension(0, 0));
            this.jspTable.setViewportView(table);
            this.jspTable.setAlignmentX(0.0f);
        }
        this.cpfPane = this.buildCPFPaneFromPlugin(tableOwner);
        this.centerPanel.setTopComponent(this.cpfPane);
        this.fitCPFDividerLocationToComponent(table);
    }

    protected JComponent buildCPFPaneFromPlugin(Node tableOwner) {
        JTabbedPane ret = new JTabbedPane(1, 1);
        this.resetCPFTabbedPane(ret, tableOwner);
        this.resetCPTTabbedPaneChangeListeners(ret, tableOwner);
        return ret;
    }

    protected void resetCPFTabbedPane(JTabbedPane tabs, Node node) {
        if (node == null || tabs == null) {
            return;
        }
        ChangeListener[] changeListenerArray = tabs.getChangeListeners();
        int n = changeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeListener cl = changeListenerArray[n2];
            tabs.removeChangeListener(cl);
            ++n2;
        }
        tabs.removeAll();
        JTabbedPane ret = tabs;
        Node tableOwner = node;
        ret.addTab(resource.getString("CPFTableTitle"), this.iconController.getTableIcon(), this.getCPTPane(), resource.getString("CPFTableToolTip"));
        CoreCPFPluginManager cpfManager = CoreCPFPluginManager.newInstance();
        try {
            cpfManager.loadPlugin();
        }
        catch (IOException e) {
            e.printStackTrace();
            Debug.println(this.getClass(), "Could not load plugin for CPF pane");
        }
        for (INodeClassDataTransferObject dto : cpfManager.getPluginInformation(tableOwner.getClass().getName())) {
            IProbabilityFunctionPanelBuilder builder = dto.getProbabilityFunctionPanelBuilder();
            if (builder == null) {
                Debug.println(this.getClass(), "A DTO with no panel builder was found for " + tableOwner.toString());
                continue;
            }
            builder.setProbabilityFunctionOwner(tableOwner);
            try {
                ret.addTab(dto.getName(), dto.getIcon(), new JScrollPane(builder.buildProbabilityFunctionEditionPanel()), dto.getDescription());
            }
            catch (Exception e) {
                e.printStackTrace();
                Debug.println(this.getClass(), "A panel builder is not building panel for " + tableOwner.toString());
            }
        }
    }

    protected void resetCPTTabbedPaneChangeListeners(final JTabbedPane ret, final Node tableOwner) {
        ret.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                try {
                    int selectedIndex;
                    if (e.getSource().equals(ret) && (selectedIndex = ret.getSelectedIndex()) >= 0) {
                        ChangeListener[] changeListenerArray = ret.getChangeListeners();
                        int n = changeListenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ChangeListener changeListener = changeListenerArray[n2];
                            ret.removeChangeListener(changeListener);
                            ++n2;
                        }
                        ret.removeAll();
                        PNEditionPane.this.controller.createTable(tableOwner);
                        if (PNEditionPane.this.getCpfPane() instanceof JTabbedPane) {
                            ChangeListener[] listeners;
                            JTabbedPane tabs = (JTabbedPane)PNEditionPane.this.getCpfPane();
                            ChangeListener[] changeListenerArray2 = listeners = tabs.getChangeListeners();
                            int n3 = listeners.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ChangeListener changeListener = changeListenerArray2[n4];
                                tabs.removeChangeListener(changeListener);
                                ++n4;
                            }
                            tabs.setSelectedIndex(selectedIndex);
                            changeListenerArray2 = listeners;
                            n3 = listeners.length;
                            n4 = 0;
                            while (n4 < n3) {
                                ChangeListener changeListener = changeListenerArray2[n4];
                                tabs.addChangeListener(changeListener);
                                ++n4;
                            }
                        }
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
    }

    public JPanel getCPTPane() {
        JPanel pane = new JPanel(new BorderLayout());
        if (this.getTableOwner() instanceof IRandomVariable && ((IRandomVariable)((Object)this.getTableOwner())).getProbabilityFunction() instanceof ProbabilisticTable) {
            final ProbabilisticTable table = (ProbabilisticTable)((IRandomVariable)((Object)this.getTableOwner())).getProbabilityFunction();
            TreeSet<NormalizeTableFunction> functions = new TreeSet<NormalizeTableFunction>();
            ITableFunction function = new NormalizeTableFunction();
            functions.add((NormalizeTableFunction)function);
            function = new UniformTableFunction();
            functions.add((NormalizeTableFunction)function);
            function = new FillUniformTableFunction();
            functions.add((NormalizeTableFunction)function);
            final JComboBox<Object> cmbFunction = new JComboBox<Object>(functions.toArray());
            cmbFunction.setSelectedIndex(this.selectedFunction);
            JButton btnRun = new JButton(resource.getString("apply"));
            btnRun.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PNEditionPane.this.selectedFunction = cmbFunction.getSelectedIndex();
                    ((ITableFunction)cmbFunction.getSelectedItem()).applyFunction(table);
                    PNEditionPane.this.netWindow.getController().createTable(PNEditionPane.this.getTableOwner());
                }
            });
            JPanel functionPane = new JPanel();
            functionPane.add(cmbFunction);
            functionPane.add(btnRun);
            pane.add((Component)functionPane, "West");
        }
        pane.add((Component)this.getJspTable(), "Center");
        return pane;
    }

    public Node getTableOwner() {
        return this.tableOwner;
    }

    public void setTableOwner(Node node) {
        this.tableOwner = node;
    }

    public void setStatus(String status) {
        this.status.setText(status);
    }

    public JSplitPane getCenterPanel() {
        return this.centerPanel;
    }

    public JButton getBtnCompile() {
        return this.btnCompile;
    }

    public JLabel getLblDescription() {
        return this.lblDescription;
    }

    public JButton getBtnGlobalOption() {
        return this.btnGlobalOption;
    }

    public JButton getBtnRemoveState() {
        return this.btnRemoveState;
    }

    public JButton getBtnAddState() {
        return this.btnAddState;
    }

    public JButton getBtnPreviewNet() {
        return this.btnPreviewNet;
    }

    public JButton getBtnPreviewTable() {
        return this.btnPreviewTable;
    }

    public JButton getBtnPrintNet() {
        return this.btnPrintNet;
    }

    public JButton getBtnPrintTable() {
        return this.btnPrintTable;
    }

    public JButton getBtnSaveNetImage() {
        return this.btnSaveNetImage;
    }

    public JButton getBtnSaveTableImage() {
        return this.btnSaveTableImage;
    }

    public JLabel getLblName() {
        return this.lblName;
    }

    public JButton getBtnHierarchy() {
        return this.btnHierarchy;
    }

    public ToolBarEdition getTbEdition() {
        return this.tbEdition;
    }

    public JButton getBtnEvaluate() {
        return this.btnEvaluate;
    }

    public JToolBar getJtbState() {
        return this.jtbState;
    }

    public JScrollPane getJspTable() {
        return this.jspTable;
    }

    public JComponent getCpfPane() {
        return this.cpfPane;
    }

    public void setCpfPane(JComponent cpfPane) {
        this.cpfPane = cpfPane;
    }

    public boolean isUseFloatingColumn() {
        return this.useFloatingColumn;
    }

    public void setUseFloatingColumn(boolean useFloatingColumn) {
        this.useFloatingColumn = useFloatingColumn;
    }

    private class ColumnResizedListener
    implements MouseMotionListener {
        JTable rows;

        public ColumnResizedListener(JTable rows) {
            this.rows = rows;
        }

        public void mouseDragged(MouseEvent e) {
            this.rows.getColumnModel().getColumn(0).setPreferredWidth(e.getX());
            PNEditionPane.this.jspTable.getRowHeader().setPreferredSize(new Dimension(e.getX(), (int)PNEditionPane.this.jspTable.getColumnHeader().getSize().getHeight()));
            PNEditionPane.this.jspTable.getCorner("UPPER_LEFT_CORNER").setPreferredSize(new Dimension(e.getX(), (int)PNEditionPane.this.jspTable.getColumnHeader().getSize().getHeight()));
            PNEditionPane.this.jspTable.validate();
            PNEditionPane.this.jspTable.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            if (e.getX() >= this.rows.getColumnModel().getColumn(0).getWidth() - 5 && e.getX() <= this.rows.getColumnModel().getColumn(0).getWidth()) {
                this.rows.setCursor(new Cursor(11));
            } else {
                this.rows.setCursor(new Cursor(0));
            }
        }
    }

    private class HeaderResizedListener
    implements MouseMotionListener {
        JTable header;
        JTable rows;

        public HeaderResizedListener(JTable header, JTable rows) {
            this.rows = rows;
            this.header = header;
        }

        public void mouseDragged(MouseEvent e) {
            this.rows.getColumnModel().getColumn(0).setPreferredWidth(e.getX());
            PNEditionPane.this.jspTable.getRowHeader().setPreferredSize(new Dimension(e.getX(), (int)PNEditionPane.this.jspTable.getColumnHeader().getSize().getHeight()));
            PNEditionPane.this.jspTable.getCorner("UPPER_LEFT_CORNER").setPreferredSize(new Dimension(e.getX(), (int)PNEditionPane.this.jspTable.getColumnHeader().getSize().getHeight()));
            PNEditionPane.this.jspTable.validate();
            PNEditionPane.this.jspTable.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            if (e.getX() >= this.header.getColumnModel().getColumn(0).getWidth() - 5 && e.getX() <= this.header.getColumnModel().getColumn(0).getWidth()) {
                this.header.setCursor(new Cursor(11));
            } else {
                this.header.setCursor(new Cursor(0));
            }
        }
    }

    public class ToolBarEdition
    extends JToolBar {
        private static final long serialVersionUID = 1L;
        private final JToggleButton btnResetCursor;
        private final JToggleButton btnAddEdge;
        private final JToggleButton btnAddProbabilisticNode;
        private final JToggleButton btnAddDecisionNode;
        private final JToggleButton btnAddUtilityNode;
        private final JToggleButton btnDeleteSelectedItem;
        private final ButtonGroup groupEditionButtons;
        private SplitToggleButton btnAddPluginButton;

        public ToolBarEdition() {
            this.setFloatable(false);
            this.btnAddProbabilisticNode = new JToggleButton(PNEditionPane.this.iconController.getEllipsisIcon());
            this.btnAddDecisionNode = new JToggleButton(PNEditionPane.this.iconController.getDecisionNodeIcon());
            this.btnAddUtilityNode = new JToggleButton(PNEditionPane.this.iconController.getUtilityNodeIcon());
            this.btnAddEdge = new JToggleButton(PNEditionPane.this.iconController.getEdgeIcon());
            this.btnResetCursor = new JToggleButton(PNEditionPane.this.iconController.getArrowIcon());
            this.btnDeleteSelectedItem = new JToggleButton(PNEditionPane.this.iconController.getEditDelete());
            this.btnAddEdge.setToolTipText(resource.getString("arcToolTip"));
            this.btnAddProbabilisticNode.setToolTipText(resource.getString("probabilisticNodeInsertToolTip"));
            this.btnAddDecisionNode.setToolTipText(resource.getString("decisionNodeInsertToolTip"));
            this.btnAddUtilityNode.setToolTipText(resource.getString("utilityNodeInsertToolTip"));
            this.btnResetCursor.setToolTipText(resource.getString("resetToolTip"));
            this.btnDeleteSelectedItem.setToolTipText(resource.getString("deleteSelectedItemToolTip"));
            this.setBtnAddPluginButton(new SplitToggleButton());
            this.getBtnAddPluginButton().setMenu(this.buildAddPluginSplitButtonMenu());
            this.ajustPluginButtonSize();
            UnBBayesPluginContextHolder.newInstance().addListener(new UnBBayesPluginContextHolder.OnReloadActionListener(){

                public void onReload(EventObject eventObject) {
                    ToolBarEdition.this.getBtnAddPluginButton().setMenu(ToolBarEdition.this.buildAddPluginSplitButtonMenu());
                }
            });
            this.getBtnAddPluginButton().setVisible(this.getBtnAddPluginButton().getMenu().getComponentCount() > 0);
            this.groupEditionButtons = new ButtonGroup();
            this.groupEditionButtons.add(this.btnResetCursor);
            this.groupEditionButtons.add(this.btnAddEdge);
            this.groupEditionButtons.add(this.getBtnAddPluginButton().getMainButton());
            this.groupEditionButtons.add(this.btnAddProbabilisticNode);
            this.groupEditionButtons.add(this.btnAddDecisionNode);
            this.groupEditionButtons.add(this.btnAddUtilityNode);
            this.groupEditionButtons.add(this.btnDeleteSelectedItem);
            this.add(this.btnResetCursor);
            this.add(this.btnAddProbabilisticNode);
            this.add(this.btnAddDecisionNode);
            this.add(this.btnAddUtilityNode);
            this.add(this.getBtnAddPluginButton());
            this.add(this.btnAddEdge);
            this.add(this.btnDeleteSelectedItem);
            this.btnResetCursor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.NONE);
                }
            });
            this.btnAddEdge.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.CREATE_EDGE);
                }
            });
            this.btnAddProbabilisticNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.CREATE_PROBABILISTIC_NODE);
                }
            });
            this.btnAddDecisionNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.CREATE_DECISION_NODE);
                }
            });
            this.btnAddUtilityNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.CREATE_UTILITY_NODE);
                }
            });
            this.btnDeleteSelectedItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.controller.getSENController().deleteSelectedItem();
                }
            });
        }

        protected void ajustPluginButtonSize() {
            this.getBtnAddPluginButton().setPreferredSize(new Dimension(55, this.getBtnAddPluginButton().getHeight()));
            this.getBtnAddPluginButton().setSize(this.getBtnAddPluginButton().getPreferredSize());
            this.getBtnAddPluginButton().setMaximumSize(this.getBtnAddPluginButton().getPreferredSize());
            this.getBtnAddPluginButton().setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        }

        public JPopupMenu buildAddPluginSplitButtonMenu() {
            JPopupMenu ret = new JPopupMenu(resource.getString("selectNodeType"));
            for (INodeClassDataTransferObject dto : PNEditionPane.this.netWindow.getGraphPane().getPluginNodeManager().getAllLoadedPluginNodes()) {
                JMenuItem stubItem = new JMenuItem(dto.getName(), dto.getIcon() == null ? PNEditionPane.this.iconController.getChangeNodeTypeIcon() : dto.getIcon());
                stubItem.setToolTipText(dto.getDescription());
                stubItem.addActionListener(new DtoAwareListItemActionListener(dto));
                ret.add(stubItem);
            }
            return ret;
        }

        public JToggleButton getBtnAddEdge() {
            return this.btnAddEdge;
        }

        public JToggleButton getBtnAddProbabilisticNode() {
            return this.btnAddProbabilisticNode;
        }

        public JToggleButton getBtnAddDecisionNode() {
            return this.btnAddDecisionNode;
        }

        public JToggleButton getBtnAddUtilityNode() {
            return this.btnAddUtilityNode;
        }

        public JToggleButton getBtnResetCursor() {
            return this.btnResetCursor;
        }

        public JToggleButton getBtnDeleteSelectedItem() {
            return this.btnDeleteSelectedItem;
        }

        public ButtonGroup getGroupEditionButtons() {
            return this.groupEditionButtons;
        }

        public SplitToggleButton getBtnAddPluginButton() {
            return this.btnAddPluginButton;
        }

        public void setBtnAddPluginButton(SplitToggleButton btnAddPluginButton) {
            this.btnAddPluginButton = btnAddPluginButton;
        }

        protected class DtoAwareListItemActionListener
        implements ActionListener {
            private INodeClassDataTransferObject dto;

            public DtoAwareListItemActionListener(INodeClassDataTransferObject dto) {
                this.dto = dto;
            }

            public void actionPerformed(ActionEvent e) {
                JToggleButton button = new JToggleButton(this.dto.getIcon() == null ? PNEditionPane.this.iconController.getChangeNodeTypeIcon() : this.dto.getIcon());
                button.setToolTipText(this.dto.getDescription());
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.ADD_PLUGIN_NODE, DtoAwareListItemActionListener.this.dto);
                    }
                });
                ToolBarEdition.this.groupEditionButtons.remove(button);
                ToolBarEdition.this.groupEditionButtons.add(button);
                ToolBarEdition.this.getBtnAddPluginButton().setMainButton(button);
                ToolBarEdition.this.getBtnAddPluginButton().getMenu().setVisible(false);
                ToolBarEdition.this.updateUI();
                ToolBarEdition.this.getBtnAddPluginButton().getMainButton().doClick();
                Debug.println(this.getClass(), "Plugin button set to " + ToolBarEdition.this.getBtnAddPluginButton().getMainButton().getToolTipText());
            }
        }
    }
}

