/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import unbbayes.controller.IconController;
import unbbayes.gui.LikelihoodEvidenceDialogBuilder;
import unbbayes.prs.Graph;
import unbbayes.prs.INode;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.prs.bn.cpt.IArbitraryConditionalProbabilityExtractor;
import unbbayes.prs.bn.cpt.impl.InCliqueConditionalProbabilityExtractor;
import unbbayes.prs.bn.cpt.impl.NormalizeTableFunction;
import unbbayes.util.Debug;

public class SoftEvidenceDialogBuilder
extends LikelihoodEvidenceDialogBuilder {
    private JTable potentialJTable;
    private IArbitraryConditionalProbabilityExtractor conditionalProbabilityExtractor = InCliqueConditionalProbabilityExtractor.newInstance();
    private JButton addNodeButton;
    private JButton removeNodeButton;
    private JTable table;
    private ProbabilisticTable lastProbabilisticTable;
    private JButton okButton;
    private JButton cancelButton;

    public void setPotentialJTable(JTable guiPotentialTable) {
        this.potentialJTable = guiPotentialTable;
    }

    public JTable getPotentialJTable() {
        return this.potentialJTable;
    }

    protected JPanel buildMainPanel(Graph graph, INode nodeToAddLikelihood, JTable table) {
        JPanel ret = new JPanel(new BorderLayout());
        JScrollPane jsp = new JScrollPane(table);
        jsp.getViewport().getView().setSize(table.getSize());
        jsp.getViewport().setViewSize(table.getSize());
        jsp.setBorder(new TitledBorder(this.getResource().getString("softEvidence")));
        ret.add((Component)jsp, "Center");
        return ret;
    }

    public JDialog buildDialog(Graph graph, INode nodeToAddLikelihood, Component owner) {
        TreeVariable treeVariable;
        SingleEntityNetwork singleEntityNetwork;
        if (graph instanceof SingleEntityNetwork && (singleEntityNetwork = (SingleEntityNetwork)graph).isID()) {
            throw new IllegalArgumentException("Soft evidence for Influence Diagram is not supported yet.");
        }
        JDialog ret = null;
        Component window = owner;
        while (window != null) {
            if (window instanceof Frame) {
                ret = new JDialog((Frame)window, nodeToAddLikelihood.toString(), true);
                break;
            }
            if (window instanceof Dialog) {
                ret = new JDialog((Dialog)window, nodeToAddLikelihood.toString(), true);
                break;
            }
            window = window.getParent();
        }
        if (ret == null) {
            ret = new JDialog(null, nodeToAddLikelihood.toString(), true);
        }
        if (nodeToAddLikelihood instanceof TreeVariable && !(treeVariable = (TreeVariable)nodeToAddLikelihood).hasLikelihood()) {
            treeVariable.resetLikelihood();
        }
        this.fillDialog(ret, graph, nodeToAddLikelihood);
        this.fillDialogActionListeners(ret, graph, nodeToAddLikelihood);
        return ret;
    }

    protected void fillDialog(JDialog dialog, Graph graph, INode nodeToAddLikelihood) {
        this.setTable(this.buildMainTable(graph, nodeToAddLikelihood));
        dialog.getContentPane().removeAll();
        JPanel mainPanel = this.buildMainPanel(graph, nodeToAddLikelihood, this.getTable());
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.setResizable(true);
        dialog.getContentPane().add((Component)mainPanel, "Center");
        JToolBar toolBar = new JToolBar(this.getResource().getString("addFindingTip"), 0);
        toolBar.add(new JLabel(this.getResource().getString("addConditionsSoftEvidence")));
        this.setAddNodeButton(new JButton(IconController.getInstance().getMoreIcon()));
        this.getAddNodeButton().setToolTipText(this.getResource().getString("addNodeInConditionalEvidence"));
        toolBar.add(this.getAddNodeButton());
        this.setRemoveNodeButton(new JButton(IconController.getInstance().getLessIcon()));
        this.getRemoveNodeButton().setToolTipText(this.getResource().getString("removeNodeInConditionalEvidence"));
        toolBar.add(this.getRemoveNodeButton());
        dialog.getContentPane().add((Component)toolBar, "North");
        JPanel okCancelPanel = new JPanel(new FlowLayout(1));
        this.setOkButton(new JButton(this.getResource().getString("confirmLabel")));
        this.getOkButton().setToolTipText(this.getResource().getString("confirmToolTip"));
        okCancelPanel.add(this.getOkButton());
        this.setCancelButton(new JButton(this.getResource().getString("cancelLabel")));
        this.getCancelButton().setToolTipText(this.getResource().getString("cancelToolTip"));
        okCancelPanel.add(this.getCancelButton());
        dialog.getContentPane().add((Component)okCancelPanel, "South");
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
    }

    protected void fillDialogActionListeners(final JDialog dialog, final Graph graph, final INode nodeToAddLikelihood) {
        this.getAddNodeButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Node option = (Node)JOptionPane.showInputDialog(dialog, SoftEvidenceDialogBuilder.this.getResource().getString("nodeName"), SoftEvidenceDialogBuilder.this.getResource().getString("selectOneVariable"), 3, IconController.getInstance().getYellowBallIcon(), graph.getNodes().toArray(), graph.getNodes().get(0));
                if (option != null && nodeToAddLikelihood instanceof TreeVariable) {
                    Debug.println(this.getClass(), "New parent for " + nodeToAddLikelihood + " is " + option);
                    TreeVariable node = (TreeVariable)nodeToAddLikelihood;
                    if (!node.getLikelihoodParents().contains(option)) {
                        node.getLikelihoodParents().add(option);
                        try {
                            SoftEvidenceDialogBuilder.this.fillDialog(dialog, graph, nodeToAddLikelihood);
                            SoftEvidenceDialogBuilder.this.fillDialogActionListeners(dialog, graph, nodeToAddLikelihood);
                            dialog.repaint();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            JOptionPane.showMessageDialog(dialog, e2.getMessage(), SoftEvidenceDialogBuilder.this.getResource().getString("error"), 2);
                            node.getLikelihoodParents().remove(option);
                            SoftEvidenceDialogBuilder.this.fillDialog(dialog, graph, nodeToAddLikelihood);
                            SoftEvidenceDialogBuilder.this.fillDialogActionListeners(dialog, graph, nodeToAddLikelihood);
                            dialog.repaint();
                        }
                    }
                }
            }
        });
        this.getRemoveNodeButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    TreeVariable node;
                    if (nodeToAddLikelihood instanceof TreeVariable && !(node = (TreeVariable)nodeToAddLikelihood).getLikelihoodParents().isEmpty()) {
                        node.getLikelihoodParents().remove(node.getLikelihoodParents().size() - 1);
                        SoftEvidenceDialogBuilder.this.fillDialog(dialog, graph, nodeToAddLikelihood);
                        SoftEvidenceDialogBuilder.this.fillDialogActionListeners(dialog, graph, nodeToAddLikelihood);
                        dialog.repaint();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    JOptionPane.showMessageDialog(dialog, e2.getMessage(), SoftEvidenceDialogBuilder.this.getResource().getString("error"), 2);
                }
            }
        });
        dialog.addComponentListener(this.buildLikelihoodEvidenceDialogComponentListener(graph, nodeToAddLikelihood, this.getTable(), null));
        this.getOkButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (nodeToAddLikelihood instanceof TreeVariable) {
                    TreeVariable node = (TreeVariable)nodeToAddLikelihood;
                    new NormalizeTableFunction().applyFunction(SoftEvidenceDialogBuilder.this.getLastProbabilisticTable());
                    float[] likelihood = new float[SoftEvidenceDialogBuilder.this.getLastProbabilisticTable().tableSize()];
                    int i = 0;
                    while (i < likelihood.length) {
                        likelihood[i] = SoftEvidenceDialogBuilder.this.getLastProbabilisticTable().getValue(i);
                        ++i;
                    }
                    node.addLikeliHood(likelihood, node.getLikelihoodParents());
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            }
        });
        this.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
    }

    protected ProbabilisticTable buildTableForLikelihoodEvidenceInput(Graph graph, INode nodeToAddLikelihood) {
        if (nodeToAddLikelihood instanceof TreeVariable) {
            TreeVariable treeVariable = (TreeVariable)nodeToAddLikelihood;
            this.setLastProbabilisticTable((ProbabilisticTable)this.getConditionalProbabilityExtractor().buildCondicionalProbability(nodeToAddLikelihood, treeVariable.getLikelihoodParents(), graph, null));
            return this.getLastProbabilisticTable();
        }
        this.setLastProbabilisticTable((ProbabilisticTable)this.getConditionalProbabilityExtractor().buildCondicionalProbability(nodeToAddLikelihood, null, graph, null));
        return this.getLastProbabilisticTable();
    }

    public void setConditionalProbabilityExtractor(IArbitraryConditionalProbabilityExtractor conditionalProbabilityExtractor) {
        this.conditionalProbabilityExtractor = conditionalProbabilityExtractor;
    }

    public IArbitraryConditionalProbabilityExtractor getConditionalProbabilityExtractor() {
        return this.conditionalProbabilityExtractor;
    }

    public void setAddNodeButton(JButton addNodeButton) {
        this.addNodeButton = addNodeButton;
    }

    public JButton getAddNodeButton() {
        return this.addNodeButton;
    }

    public void setRemoveNodeButton(JButton removeNodeButton) {
        this.removeNodeButton = removeNodeButton;
    }

    public JButton getRemoveNodeButton() {
        return this.removeNodeButton;
    }

    protected ComponentListener buildLikelihoodEvidenceDialogComponentListener(Graph graph, final INode nodeToAddLikelihood, JTable table, JOptionPane optPane) {
        return new ComponentListener(){

            public void componentShown(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
                TreeVariable treeVariable;
                if (nodeToAddLikelihood instanceof TreeVariable && !(treeVariable = (TreeVariable)nodeToAddLikelihood).hasLikelihood()) {
                    treeVariable.resetLikelihood();
                }
            }
        };
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setLastProbabilisticTable(ProbabilisticTable lastProbabilisticTable) {
        this.lastProbabilisticTable = lastProbabilisticTable;
    }

    public ProbabilisticTable getLastProbabilisticTable() {
        return this.lastProbabilisticTable;
    }

    public void setOkButton(JButton okButton) {
        this.okButton = okButton;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }
}

