/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import unbbayes.gui.resources.GuiResources;
import unbbayes.util.ResourceController;

public class SplashScreen
extends JWindow {
    private JPanel painelPrincipal = null;
    private JPanel picturePane = null;
    private JPanel titlePane = null;
    private JPanel subtitlePane = null;
    private JPanel loadingPane = null;
    private Dimension dimension1 = new Dimension(400, 270);
    private Dimension dimension2 = new Dimension(620, 415);
    private boolean isHigthResolution = true;
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName());

    public SplashScreen() {
        this.initialize();
    }

    private void initialize() {
        this.isHigthResolution = Toolkit.getDefaultToolkit().getScreenSize().height > 600;
        if (this.isHigthResolution) {
            this.setSize(this.dimension2);
            this.setPreferredSize(this.dimension2);
        } else {
            this.setSize(this.dimension1);
            this.setPreferredSize(this.dimension1);
        }
        this.setContentPane(this.getJContentPane1());
        this.setLocationByPlatform(true);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private JPanel getJContentPane1() {
        if (this.painelPrincipal == null) {
            this.painelPrincipal = new JPanel();
            this.painelPrincipal.setLayout(new BorderLayout());
            this.painelPrincipal.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.painelPrincipal.add((Component)this.getTitlePane(), "North");
            this.painelPrincipal.add((Component)this.getPicturePanel(), "Center");
            this.painelPrincipal.add((Component)this.getLoadingPane(), "South");
        }
        return this.painelPrincipal;
    }

    public JPanel getPicturePanel() {
        if (this.picturePane == null) {
            ImageIcon splashImg = null;
            splashImg = this.isHigthResolution ? new ImageIcon(SplashScreen.class.getResource("/img/splashPane_big.jpg")) : new ImageIcon(SplashScreen.class.getResource("/img/splashPane_small.jpg"));
            JLabel labelImg = new JLabel(splashImg);
            this.picturePane = new JPanel(new BorderLayout());
            this.picturePane.add((Component)labelImg, "Center");
            this.picturePane.add((Component)this.getSubtitlePane(), "After");
            this.picturePane.setBackground(new Color(121, 187, 187));
        }
        return this.picturePane;
    }

    public static void main(String ... args) {
        SplashScreen splash = new SplashScreen();
        splash.setVisible(true);
        splash.pack();
    }

    public JPanel getTitlePane() {
        if (this.titlePane == null) {
            this.titlePane = new JPanel(new BorderLayout());
            JLabel jLabel1 = null;
            jLabel1 = new JLabel();
            jLabel1.setText("UnBBayes 3");
            if (this.isHigthResolution) {
                jLabel1.setFont(new Font("Verdana", 1, 35));
            } else {
                jLabel1.setFont(new Font("Verdana", 1, 25));
            }
            this.titlePane.add((Component)jLabel1, "After");
            this.titlePane.setBackground(new Color(121, 187, 187));
        }
        return this.titlePane;
    }

    public JPanel getSubtitlePane() {
        if (this.subtitlePane == null) {
            JLabel jLabel1 = null;
            jLabel1 = new JLabel();
            jLabel1.setText("MEBN");
            if (this.isHigthResolution) {
                jLabel1.setFont(new Font("Verdana", 0, 20));
            } else {
                jLabel1.setFont(new Font("Verdana", 0, 15));
            }
            this.subtitlePane = new JPanel(new BorderLayout());
            this.subtitlePane.add((Component)jLabel1, "North");
            this.subtitlePane.setBackground(new Color(121, 187, 187));
        }
        return this.subtitlePane;
    }

    public JPanel getLoadingPane() {
        if (this.loadingPane == null) {
            JLabel jLabel1 = null;
            jLabel1 = new JLabel();
            jLabel1.setText("..." + resource.getString("loading") + " ");
            if (this.isHigthResolution) {
                jLabel1.setFont(new Font("Verdana", 2, 17));
            } else {
                jLabel1.setFont(new Font("Verdana", 2, 10));
            }
            this.loadingPane = new JPanel(new BorderLayout());
            this.loadingPane.add((Component)jLabel1, "After");
            this.loadingPane.setBackground(new Color(121, 187, 187));
        }
        return this.loadingPane;
    }
}

